/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.PositiveDigitsFilter;
import main.java.guru.vfrflight.util.UnitUtil;

public class MeteoDownloadDialog
extends JDialog {
    private static final long serialVersionUID = 261098667475621581L;
    private JTextField stepDistanceTextField;
    private JCheckBox findAtWpsCheckbox;
    private JCheckBox findInTheMiddleCheckbox;
    private JCheckBox findEveryXNmCheckBox;

    public MeteoDownloadDialog(JFrame frame) {
        super(frame);
        this.setType(Window.Type.UTILITY);
        this.setResizable(false);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MeteoDownloadDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("meteo_download_frame_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        this.stepDistanceTextField = new JTextField();
        this.stepDistanceTextField.setEnabled(false);
        this.stepDistanceTextField.setText("20");
        this.stepDistanceTextField.setHorizontalAlignment(0);
        this.stepDistanceTextField.setBounds(219, 87, 40, 23);
        this.stepDistanceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    MeteoDownloadDialog.this.searchAction();
                }
            }
        });
        ((AbstractDocument)this.stepDistanceTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter(2));
        panel_3.setLayout(null);
        panel_3.add(this.stepDistanceTextField);
        this.stepDistanceTextField.setColumns(45);
        JButton searchButton = new JButton(Messages.getInstance().get("search_button"));
        searchButton.setBounds(99, 121, 98, 23);
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                MeteoDownloadDialog.this.searchAction();
            }
        });
        panel_3.add(searchButton);
        this.findAtWpsCheckbox = new JCheckBox(Messages.getInstance().get("meteo_download_frame_find_at_wps"));
        this.findAtWpsCheckbox.setSelected(true);
        this.findAtWpsCheckbox.setBounds(28, 34, 231, 23);
        panel_3.add(this.findAtWpsCheckbox);
        this.findInTheMiddleCheckbox = new JCheckBox(Messages.getInstance().get("meteo_download_frame_find_in_the_middle"));
        this.findInTheMiddleCheckbox.setSelected(true);
        this.findInTheMiddleCheckbox.setBounds(28, 60, 231, 23);
        panel_3.add(this.findInTheMiddleCheckbox);
        this.findEveryXNmCheckBox = new JCheckBox(Messages.getInstance().get("meteo_download_frame_find_every_x", UnitUtil.getDistanceUnit()));
        this.findEveryXNmCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MeteoDownloadDialog.this.findEveryXToggleAction();
            }
        });
        this.findEveryXNmCheckBox.setBounds(28, 87, 185, 23);
        panel_3.add(this.findEveryXNmCheckBox);
        JLabel lblFindMeteoReports = new JLabel(Messages.getInstance().get("meteo_download_frame_label"));
        lblFindMeteoReports.setBounds(44, 11, 215, 14);
        panel_3.add(lblFindMeteoReports);
        this.setSize(298, 179);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void findEveryXToggleAction() {
        this.stepDistanceTextField.setEnabled(this.findEveryXNmCheckBox.isSelected());
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void searchAction() {
        if (this.doValidate()) {
            Integer stepDistance = null;
            if (this.findEveryXNmCheckBox.isSelected()) {
                try {
                    stepDistance = Integer.parseInt(this.stepDistanceTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                stepDistance = (int)Math.round(UnitUtil.recalculateDistance(stepDistance.intValue(), SettingsBean.getInstance().getParamUnitsDistance(), "nm", false));
            }
            MapFrame.getInstance().getUIPanel().getMeteoWeatherActionStart(this.findAtWpsCheckbox.isSelected(), this.findInTheMiddleCheckbox.isSelected(), stepDistance);
            this.closeWindowAction();
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.stepDistanceTextField.getText().trim().length() == 0) {
            errors.add(Messages.getInstance().get("meteo_download_frame_step_distance_empty"));
        } else {
            try {
                Integer stepDistance = Integer.parseInt(this.stepDistanceTextField.getText());
                stepDistance = (int)Math.round(UnitUtil.recalculateDistance(stepDistance.intValue(), SettingsBean.getInstance().getParamUnitsDistance(), "nm", false));
                if (stepDistance < 10) {
                    errors.add(Messages.getInstance().get("meteo_download_frame_step_distance_range_min"));
                }
            }
            catch (NumberFormatException stepDistance) {
                // empty catch block
            }
        }
        if (!(this.findAtWpsCheckbox.isSelected() || this.findInTheMiddleCheckbox.isSelected() || this.findEveryXNmCheckBox.isSelected())) {
            errors.add(Messages.getInstance().get("meteo_download_frame_nothing_selected"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }
}

