/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.list.MapPriorityListModel;

public class MapPriorityDialog
extends JDialog {
    private static final long serialVersionUID = -8687311844912996256L;
    private JList<String> list;

    public MapPriorityDialog(JFrame frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MapPriorityDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle(Messages.getInstance().get("map_priority_dialog_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel vorSelectionPanel = new JPanel();
        vorSelectionPanel.setBorder(new EmptyBorder(0, 30, 0, 30));
        panel_3.add((Component)vorSelectionPanel, "Center");
        vorSelectionPanel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        this.list = new JList();
        this.list.setModel(new MapPriorityListModel(SettingsBean.getInstance().getMapPriority()));
        this.list.setSelectionMode(0);
        scrollPane.setViewportView(this.list);
        vorSelectionPanel.add((Component)scrollPane, "Center");
        JPanel panel_1 = new JPanel();
        vorSelectionPanel.add((Component)panel_1, "North");
        JLabel lblSelectVors = new JLabel(Messages.getInstance().get("map_priority_dialog_label"));
        panel_1.add(lblSelectVors);
        lblSelectVors.setHorizontalAlignment(0);
        JPanel namePanel = new JPanel();
        namePanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)namePanel, "South");
        JButton btnMoveUp = new JButton(Messages.getInstance().get("map_priority_dialog_move_up_button"));
        btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPriorityDialog.this.moveUpAction();
            }
        });
        namePanel.add(btnMoveUp);
        JButton btnMoveDown = new JButton(Messages.getInstance().get("map_priority_dialog_move_down_button"));
        btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPriorityDialog.this.moveDownAction();
            }
        });
        namePanel.add(btnMoveDown);
        this.setModal(true);
        this.setSize(239, 336);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void moveUpAction() {
        int index = this.list.getSelectedIndex();
        if (index > 0) {
            MapPriorityListModel model = (MapPriorityListModel)this.list.getModel();
            model.moveUp(index);
            this.list.setSelectedIndex(index - 1);
            this.list.repaint();
            SettingsBean.getInstance().setMapPriority(model.getValues());
            MapFrame.getInstance().updateMap();
        }
    }

    private void moveDownAction() {
        MapPriorityListModel model = (MapPriorityListModel)this.list.getModel();
        int index = this.list.getSelectedIndex();
        if (index >= 0 && index < model.getValues().length - 1) {
            model.moveDown(index);
            this.list.setSelectedIndex(index + 1);
            this.list.repaint();
            SettingsBean.getInstance().setMapPriority(model.getValues());
            MapFrame.getInstance().updateMap();
        }
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }
}

