/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.ExtensionFileFilter;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SceneryConfigPathsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.bean.combo.item.NumericComboBoxItem;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.bean.theme.ColorTheme;
import main.java.guru.vfrflight.bean.theme.DefaultColorTheme;
import main.java.guru.vfrflight.core.MapRadials;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.core.map.MapMode;
import main.java.guru.vfrflight.gui.flightplan.AddMapRadialsDialog;
import main.java.guru.vfrflight.gui.flightplan.AddRouteDialog;
import main.java.guru.vfrflight.gui.flightplan.DownloadMapToHddDialog;
import main.java.guru.vfrflight.gui.flightplan.DropboxConnectionDialog;
import main.java.guru.vfrflight.gui.flightplan.DropboxFilesDialog;
import main.java.guru.vfrflight.gui.flightplan.FlightPlanMainPanel;
import main.java.guru.vfrflight.gui.flightplan.MapObjectsUserSelectionDialog;
import main.java.guru.vfrflight.gui.flightplan.MapPriorityDialog;
import main.java.guru.vfrflight.gui.flightplan.PdfRegionDialog;
import main.java.guru.vfrflight.gui.flightplan.TerrainLayerDialog;
import main.java.guru.vfrflight.gui.flightplan.VerticalProfileMainDialog;
import main.java.guru.vfrflight.gui.flightplan.WeightAndBalanceDialog;
import main.java.guru.vfrflight.gui.flightplan.creator.RouteCreatorDialog;
import main.java.guru.vfrflight.gui.flightplan.map.GpsMap;
import main.java.guru.vfrflight.gui.flightplan.map.MapTypesDialog;
import main.java.guru.vfrflight.gui.flightplan.menu.DownloadDropboxFileActionListener;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.flightplan.xplane.XplaneImportDataStep1Dialog;
import main.java.guru.vfrflight.gui.map.VfrMapPopupClickListener;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.gui.map.gui.FullscreenButton;
import main.java.guru.vfrflight.gui.map.painter.MapFramePainter;
import main.java.guru.vfrflight.gui.map.tilefactory.NoMapTileFactory;
import main.java.guru.vfrflight.gui.map.tilefactory.TileFactoryInfoType;
import main.java.guru.vfrflight.gui.map.tilefactory.util.TileFactoryInfoUtil;
import main.java.guru.vfrflight.gui.swing.button.ToggleUIPButton;
import main.java.guru.vfrflight.gui.swing.button.ToolbarButton;
import main.java.guru.vfrflight.gui.swing.button.ToolbarStateButton;
import main.java.guru.vfrflight.gui.task.ExportMapPdfTask;
import main.java.guru.vfrflight.gui.task.ExportMapPngTask;
import main.java.guru.vfrflight.gui.task.RefreshAirportsTask;
import main.java.guru.vfrflight.gui.task.RefreshAllTask;
import main.java.guru.vfrflight.gui.task.RefreshCitiesTask;
import main.java.guru.vfrflight.gui.task.RefreshElevationsTask;
import main.java.guru.vfrflight.gui.task.RefreshIfrPointsTask;
import main.java.guru.vfrflight.gui.task.RefreshIfrRoutesTask;
import main.java.guru.vfrflight.gui.task.RefreshIlsTask;
import main.java.guru.vfrflight.gui.task.RefreshMagneticDeclinationsTask;
import main.java.guru.vfrflight.gui.task.RefreshMeteoImageTask;
import main.java.guru.vfrflight.gui.task.RefreshNdbsTask;
import main.java.guru.vfrflight.gui.task.RefreshObstaclesTask;
import main.java.guru.vfrflight.gui.task.RefreshRadialsFromVorsTask;
import main.java.guru.vfrflight.gui.task.RefreshRunwaysExtensionsTask;
import main.java.guru.vfrflight.gui.task.RefreshTaxiwaysTask;
import main.java.guru.vfrflight.gui.task.RefreshTerrainElevationsTask;
import main.java.guru.vfrflight.gui.task.RefreshUserPointsTask;
import main.java.guru.vfrflight.gui.task.RefreshVfrPointsTask;
import main.java.guru.vfrflight.gui.task.RefreshVorsTask;
import main.java.guru.vfrflight.gui.task.VfrShutdownTask;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.AirspaceFacade;
import main.java.guru.vfrflight.sql.facade.CityFacade;
import main.java.guru.vfrflight.sql.facade.ElevationFacade;
import main.java.guru.vfrflight.sql.facade.IfrRouteFacade;
import main.java.guru.vfrflight.sql.facade.ObstacleFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.RouteUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.org.jdesktop.swingx.mapviewer.DefaultTileFactory;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import main.java.org.jdesktop.swingx.mapviewer.TileFactory;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import main.java.org.jdesktop.swingx.mapviewer.empty.EmptyTileFactory;
import org.apache.log4j.Logger;

public class MapFrame
extends JFrame {
    private static final long serialVersionUID = -6423864841685424964L;
    private static final Logger log = Logger.getLogger(MapFrame.class);
    private boolean popupEnabled = true;
    private boolean showUIPanel = true;
    private boolean suppressUpdateMapType = false;
    private List<TileFactoryInfo> tileFactoriesInfo;
    private List<ColorTheme> tileFactoriesThemes;
    private JComboBox<StringComboBoxItem> connectionCombo;
    private final FlightPlanMainPanel UIPanel;
    private static final String TITLE_DELIMITER = "     ";
    private JPanel mapSouthPanel;
    private GpsMap gpsMap = null;
    private static volatile MapFrame instance = null;
    private VfrMapViewer mapViewer;
    private JComboBox<NumericComboBoxItem> mapTypeComboBox;
    private JComboBox<StringComboBoxItem> measurementDistanceCombo;
    private JCheckBox underCursorTextCheckBox;
    private JButton connectButton;
    public static final int TAB_MAIN = 0;
    public static final int TAB_POINTS = 1;
    public static final int TAB_VOR = 2;
    public static final int TAB_WEATHER = 3;
    public static final int TAB_WIND = 4;
    private JMenu recentLoadedFilesMenu;
    private JMenu fileMenu;
    private JMenu planMenu;
    private JMenu toolsMenu;
    private JMenu viewMenu;
    private JMenu helpMenu;
    private JMenu dropboxFilesMenu;
    private JMenuItem simConnectMenuItem;
    private ToggleUIPButton toggleUIPanelButton;
    private JPanel mapPanel;
    private JPanel toolbarWrapperPanel;
    private JPanel centerPanel;
    private JPanel toggleUIButtonPanel;
    private String previousTitle = null;
    private JButton newButton;
    private JButton loadButton;
    private JButton saveButton;
    private JButton exportButton;
    private JButton importButton;
    private JButton searchButton;
    private JButton calculateButton;
    private JButton userPointsButton;
    private JButton settingsButton;
    private JButton contactButton;
    private JButton aboutButton;
    private JButton exportPdfButton;
    private JButton facebookButton;
    private JButton youtubeButton;
    private JButton weatherButton;
    private JButton weatherMeteoButton;
    private JButton wnbButton;
    private JButton terrailLayerButton;
    private JButton removeTerrainLayerButton;
    private JButton verticalProfileButton;
    private JButton addRouteButton;
    private JButton editMapTypes;
    private JButton prevRouteButton;
    private JButton nextRouteButton;
    private ToolbarButton downloadMapButton;
    private JMenuBar mainMenuBar;
    private ToolbarStateButton showTextButton;
    private ToolbarStateButton showVorButton;
    private ToolbarStateButton showNdbButton;
    private ToolbarStateButton showAirportsButton;
    private ToolbarStateButton showRunwayExtensionsButton;
    private ToolbarStateButton showTaxiwaysButton;
    private ToolbarStateButton showIlsButton;
    private ToolbarStateButton showMsaButton;
    private ToolbarStateButton showTerrainButton;
    private ToolbarStateButton showObstacleButton;
    private ToolbarStateButton showAirspacesButton;
    private ToolbarStateButton showVfrPtButton;
    private ToolbarStateButton showAIfrPtButton;
    private ToolbarStateButton showIfrRteButton;
    private ToolbarStateButton showWeatherButton;
    private ToolbarStateButton showUserPointsButton;
    private ToolbarStateButton showCitiesButton;
    private ToolbarStateButton showUserTrackButton;
    private ToolbarStateButton showMapGridButton;
    private ToolbarStateButton showMagVarButton;
    private ToolbarStateButton showLegInfo;
    private ToolbarStateButton touchScreenButton;
    private ToolbarStateButton gpsModeButton;
    private ToolbarStateButton distanceCirclesButton;
    private ToolbarStateButton drawClosestVorRadialsButton;
    private ToolbarStateButton alwaysOnTopButton;
    private ToolbarStateButton calculateInRealTimeButton;
    private ToolbarStateButton magnifyingGlassButton;
    private ToolbarStateButton coordsCursorButton;
    private ToolbarStateButton compassButton;
    private ToolbarStateButton enableMeasurementLineButton;
    private ToolbarStateButton multipleRulersButton;
    private ToolbarButton legInfoInc;
    private ToolbarButton legInfoDec;
    private ToolbarButton fullscreenButton;
    private ToolbarButton layersOrderButton;
    private ToolbarStateButton showLandmarkLabels;
    private ToolbarStateButton showMapRadials;
    private ToolbarStateButton showWindInformation;
    private ToolbarStateButton showRouteDirectionArrows;
    private JComboBox<NumericComboBoxItem> regionsComboBox;
    private boolean suppressRegionsSelectionAction = true;
    private JPanel middlePanel;
    private Rectangle prevMapBounds = null;
    private GpsArea prevVisibleArea = null;
    private Rectangle tempRect = null;
    private boolean showUIPanelBeforeFullScreen = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MapFrame getInstance() {
        if (instance != null) return instance;
        Class<MapFrame> clazz = MapFrame.class;
        synchronized (MapFrame.class) {
            if (instance != null) return instance;
            instance = new MapFrame();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshInstance() {
        if (instance == null) return;
        Class<MapFrame> clazz = MapFrame.class;
        synchronized (MapFrame.class) {
            SettingsBean.getInstance().setInitMapFrameFullScreen(this.isFullScreen());
            SettingsBean.getInstance().setInitMapFramePosition(this.getLocation());
            SettingsBean.getInstance().setInitMapFrameSize(this.getSize());
            SettingsBean.getInstance().setInitMapType(this.getMapTypeIndex());
            SettingsBean.getInstance().setInitMapZoom(this.getMapViewer().getZoom());
            SettingsBean.getInstance().setInitMapPosition(this.getMapViewer().getCenterPosition());
            this.setVisible(false);
            instance.dispose();
            instance = null;
            MapFrame.getInstance().setVisible(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private MapFrame() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MapFrame.this.closeAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.updateTitle();
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.mapViewer = new VfrMapViewer(this);
        JPanel contentPanel = new JPanel();
        this.getContentPane().add(contentPanel);
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel bottomPanel = new JPanel();
        contentPanel.add((Component)bottomPanel, "South");
        bottomPanel.setLayout(new BorderLayout(0, 0));
        this.centerPanel = new JPanel();
        this.centerPanel.setBorder(new EtchedBorder(1, null, null));
        bottomPanel.add((Component)this.centerPanel, "Center");
        this.centerPanel.setLayout(new FlowLayout(1, 5, 5));
        this.createBottomToolbar(this.centerPanel);
        this.mapPanel = new JPanel();
        contentPanel.add((Component)this.mapPanel, "Center");
        this.mapPanel.setLayout(new BorderLayout(0, 0));
        JPanel UIPanelWrapper = new JPanel();
        this.mapPanel.add((Component)UIPanelWrapper, "East");
        UIPanelWrapper.setLayout(new BorderLayout(0, 0));
        this.UIPanel = new FlightPlanMainPanel(this);
        UIPanelWrapper.add((Component)this.UIPanel, "Center");
        this.toggleUIButtonPanel = new JPanel();
        this.toggleUIButtonPanel.setBorder(new EtchedBorder(1, null, null));
        UIPanelWrapper.add((Component)this.toggleUIButtonPanel, "West");
        this.toggleUIButtonPanel.setLayout(new BorderLayout(0, 0));
        this.toggleUIPanelButton = new ToggleUIPButton(this.isShowUIPanel() ? "img/gui/hide.png" : "img/gui/show.png", SettingsBean.getInstance().isTouchScreenMode());
        this.toggleUIButtonPanel.add((Component)this.toggleUIPanelButton, "Center");
        this.toggleUIPanelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.toggleUIPanelAction();
            }
        });
        this.toggleUIPanelButton.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        JPanel middleWrapperPanel = new JPanel();
        this.mapPanel.add((Component)middleWrapperPanel, "Center");
        middleWrapperPanel.setLayout(new BorderLayout(0, 0));
        this.mapViewer.addMouseListener(new VfrMapPopupClickListener(this));
        this.middlePanel = new JPanel();
        this.middlePanel.setLayout(new BorderLayout(0, 0));
        this.addMapViewerToMiddlePanel();
        middleWrapperPanel.setLayout(new BorderLayout(0, 0));
        middleWrapperPanel.add((Component)this.middlePanel, "Center");
        this.toolbarWrapperPanel = new JPanel();
        this.toolbarWrapperPanel.setLayout(new BorderLayout(0, 0));
        this.toolbarWrapperPanel.setBorder(new EtchedBorder(1, null, null));
        middleWrapperPanel.add((Component)this.toolbarWrapperPanel, "North");
        if (SettingsBean.getInstance().isParamThreeRowsLayout()) {
            this.toolbarWrapperPanel.add((Component)this.createToolbar(false), "North");
            this.toolbarWrapperPanel.add((Component)this.createMapLayersToolbar(), "Center");
            this.toolbarWrapperPanel.add((Component)this.createSouthToolbar(), "South");
        } else {
            JPanel wrapper = new JPanel();
            wrapper.setLayout(new BorderLayout(0, 0));
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            panel.add(this.createToolbar(true));
            panel.add(this.createUnderCursorTextPanel());
            JPanel panelWrapper = new JPanel();
            panelWrapper.setLayout(new BorderLayout(0, 0));
            panelWrapper.add((Component)panel, "West");
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            panel2.add(this.createRegionsComboBoxPanel());
            panel2.add(this.createLayersToolbar());
            JPanel panel2Wrapper = new JPanel();
            panel2Wrapper.setLayout(new BorderLayout(0, 0));
            panel2Wrapper.add((Component)panel2, "West");
            wrapper.add((Component)panelWrapper, "Center");
            wrapper.add((Component)panel2Wrapper, "South");
            this.toolbarWrapperPanel.add((Component)wrapper, "West");
            JPanel panel3 = new JPanel();
            panel3.setLayout(new BorderLayout(0, 0));
            panel3.add((Component)this.createMapModesPanel(), "South");
            this.toolbarWrapperPanel.add((Component)panel3, "East");
        }
        this.mapSouthPanel = new JPanel();
        middleWrapperPanel.add((Component)this.mapSouthPanel, "South");
        this.mapSouthPanel.setLayout(new BorderLayout(0, 0));
        this.setJMenuBar(this.createMenuBar());
        this.centerMap();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (SettingsBean.getInstance().getInitMapFrameSize() == null) {
            this.setSize((int)Math.round((double)dim.width * 0.8), (int)Math.round((double)dim.height * 0.8));
        } else {
            this.setSize((int)SettingsBean.getInstance().getInitMapFrameSize().getWidth(), (int)SettingsBean.getInstance().getInitMapFrameSize().getHeight());
        }
        if (SettingsBean.getInstance().getInitMapFramePosition() == null) {
            this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        } else {
            int x = (int)SettingsBean.getInstance().getInitMapFramePosition().getX();
            int y = (int)SettingsBean.getInstance().getInitMapFramePosition().getY();
            if (x > (int)((double)dim.width - this.getSize().getWidth())) {
                x = (int)((double)dim.width - this.getSize().getWidth());
            }
            if (y > (int)((double)dim.height - this.getSize().getHeight())) {
                y = (int)((double)dim.height - this.getSize().getHeight());
            }
            this.setLocation(x, y);
        }
        if (SettingsBean.getInstance().isInitMapFrameFullScreen()) {
            this.setExtendedState(6);
        }
        if (SettingsBean.getInstance().getInitMapPosition() != null) {
            this.centerOnPoint(SettingsBean.getInstance().getInitMapPosition().gpsPlace());
        }
        if (SettingsBean.getInstance().getInitMapZoom() != null) {
            this.setZoom(SettingsBean.getInstance().getInitMapZoom());
        }
        if (SettingsBean.getInstance().getInitMapType() != null) {
            this.setMapTypeIndex(SettingsBean.getInstance().getInitMapType());
        }
        this.setMapViewerBounds();
        if (SettingsBean.getInstance().isOfflineMode()) {
            this.mapTypeComboBox.setSelectedIndex(0);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MapFrame.this.setMapViewerBounds();
            }
        });
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.suppressRegionsSelectionAction = false;
    }

    public void addMapViewerToMiddlePanel() {
        this.middlePanel.removeAll();
        this.middlePanel.add((Component)this.mapViewer, "Center");
        this.revalidate();
    }

    public void addToMiddlePanel(JPanel panel) {
        this.middlePanel.removeAll();
        this.middlePanel.add((Component)panel, "Center");
        this.revalidate();
    }

    public void updateMapTypeComboValues() {
        this.suppressUpdateMapType = true;
        this.mapTypeComboBox.removeAllItems();
        this.mapTypeComboBox.addItem(new NumericComboBoxItem(Messages.getInstance().get("map_frame_map_type_empty"), null));
        for (int i = 0; i < this.getTileFactoriesInfo().size(); ++i) {
            this.mapTypeComboBox.addItem(new NumericComboBoxItem(this.tileFactoriesInfo.get(i).getName(), i));
            this.getTileFactoriesThemes().add(this.tileFactoriesInfo.get(i).getColorTheme());
        }
        this.mapTypeComboBox.setSelectedIndex(this.getTileFactoriesInfo().size() > 1 ? 1 : 0);
        if (this.mapTypeComboBox.getSelectedItem() != null && !SettingsBean.getInstance().isOfflineMode()) {
            NumericComboBoxItem sel = (NumericComboBoxItem)this.mapTypeComboBox.getSelectedItem();
            if (sel.getValue() != null) {
                this.mapViewer.setTileFactory(new DefaultTileFactory(this.getTileFactoriesInfo().get(sel.getValue())));
            } else {
                this.mapViewer.setTileFactory(new EmptyTileFactory());
            }
        } else {
            this.mapViewer.setTileFactory(new EmptyTileFactory());
        }
        this.suppressUpdateMapType = false;
    }

    private void createMapTypeCombo(JPanel mainPanel) {
        mainPanel.add(new JLabel(Messages.getInstance().get("map_frame_type") + " "));
        this.setTileFactoriesInfo(TileFactoryInfoUtil.load("data/maps.dat"));
        this.mapTypeComboBox = new JComboBox();
        this.mapTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.mapTypeChangedAction();
            }
        });
        mainPanel.add(this.mapTypeComboBox);
        this.updateMapTypeComboValues();
        this.editMapTypes = new JButton("...");
        this.editMapTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapTypesDialog dialog = new MapTypesDialog((Window)MapFrame.this);
                dialog.setVisible(true);
            }
        });
        mainPanel.add(this.editMapTypes);
        this.downloadMapButton = new ToolbarButton("img/gui/drive_disk.png", Messages.getInstance().get("map_frame_download_map_to_hdd"), SettingsBean.getInstance().isTouchScreenMode());
        this.downloadMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.exportMapToHdd();
            }
        });
        mainPanel.add(this.downloadMapButton);
    }

    private void toggleGpsMapConnection() {
        if (this.gpsMap == null) {
            if (!SettingsBean.getInstance().isConnectedToSim()) {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("gps_map_no_connection_error"), "", 0);
                this.gpsModeButton.toggle();
            } else {
                this.gpsMap = new GpsMap(SettingsBean.getInstance().isParamGpsMapOverlay());
                this.gpsMap.start();
            }
        } else {
            this.gpsMap.stop();
            this.gpsMap = null;
        }
    }

    private void alwaysOnTopAction() {
        this.setAlwaysOnTop(this.alwaysOnTopButton.isSelected());
    }

    public boolean isFullScreen() {
        return 6 == this.getExtendedState();
    }

    public void setMapTypeIndex(int type) {
        if (this.mapTypeComboBox != null) {
            if (type > this.mapTypeComboBox.getItemCount() - 1) {
                type = 0;
            }
            this.mapTypeComboBox.setSelectedIndex(type);
            this.mapTypeChangedAction();
        }
    }

    public int getMapTypeIndex() {
        return this.mapTypeComboBox.getSelectedIndex();
    }

    public Integer getMapType() {
        NumericComboBoxItem value = (NumericComboBoxItem)this.mapTypeComboBox.getSelectedItem();
        return value != null ? value.getValue() : null;
    }

    public void mapTypeChangedAction() {
        if (!this.suppressUpdateMapType) {
            Integer mapType = this.getMapType();
            GeoPosition center = this.getCenterPosition();
            if (mapType != null && mapType < this.getTileFactoriesInfo().size()) {
                TileFactoryInfo info = this.getTileFactoriesInfo().get(mapType);
                SettingsBean.getInstance().setColorTheme(this.getTileFactoriesThemes().get(mapType));
                if (this.mapViewer.getZoom() > info.getMaximumZoomLevel()) {
                    this.mapViewer.setZoom(info.getMaximumZoomLevel());
                } else if (this.mapViewer.getZoom() < info.getMinimumZoomLevel()) {
                    this.mapViewer.setZoom(info.getMinimumZoomLevel());
                }
                this.mapViewer.setTileFactory(new DefaultTileFactory(info));
                this.syncUIWithData();
            } else {
                SettingsBean.getInstance().setColorTheme(new DefaultColorTheme());
                this.mapViewer.setTileFactory(new NoMapTileFactory(this.getContentPane().getBackground()));
                this.mapViewer.updateUI();
            }
            if (center != null) {
                this.setCenterPosition(center);
            }
        }
    }

    public void setMapViewerBounds() {
        int w = this.getUIPanel().isVisible() ? this.mapPanel.getWidth() - SettingsBean.getInstance().getParamSidePanelWidth() : this.mapPanel.getWidth();
        this.mapViewer.setBounds(0, 0, w, this.mapPanel.getHeight());
    }

    public GpsArea getVisibleArea() {
        this.tempRect = this.mapViewer.getViewportBounds();
        if (this.prevVisibleArea == null || this.prevMapBounds == null || this.tempRect.getX() != this.prevMapBounds.getX() || this.tempRect.getY() != this.prevMapBounds.getY() || this.tempRect.getWidth() != this.prevMapBounds.getWidth() || this.tempRect.getHeight() != this.prevMapBounds.getHeight()) {
            this.prevMapBounds = new Rectangle(this.tempRect.x, this.tempRect.y, this.tempRect.width, this.tempRect.height);
            this.prevVisibleArea = new GpsArea(this.getGpsPlaceAtMapPosition(0.0, 0.0), this.getGpsPlaceAtMapPosition(this.tempRect.getWidth() - 1.0, this.tempRect.getHeight() - 1.0));
        }
        return this.prevVisibleArea;
    }

    public void updateMap() {
        this.mapViewer.setOverlayPainter(new MapFramePainter(this.mapViewer, this.getVisibleArea(), false));
    }

    public void centerMap() {
        if (!FlightPlanBean.getInstance().isEmpty() && FlightPlanBean.getInstance().getRoute().getPoints().size() > 0) {
            this.mapViewer.center(FlightPlanBean.getInstance().getRoute().getPoints());
        } else {
            this.mapViewer.setCenterPosition(new GeoPosition(30.75127777625911, 26.3671875));
            this.mapViewer.setZoom(17);
        }
    }

    public void centerOnPoint(GpsPlace point, int zoomLevel) {
        this.setZoom(zoomLevel);
        this.centerOnPoint(point, false);
    }

    public void centerOnPoint(GpsPlace point) {
        this.centerOnPoint(point, true);
    }

    public void centerOnPoint(double lat, double lon, boolean setZoom) {
        if (setZoom) {
            this.mapViewer.setZoom(9);
        }
        this.mapViewer.setCenterPosition(new GeoPosition(lat, lon));
    }

    public void centerOnPoint(GpsPlace point, boolean setZoom) {
        if (point != null) {
            this.centerOnPoint(point.getLat().getValue(), point.getLon().getValue(), setZoom);
        }
    }

    public VfrMapViewer getMapViewer() {
        return this.mapViewer;
    }

    public void setMapViewer(VfrMapViewer mapViewer) {
        this.mapViewer = mapViewer;
    }

    public void lock() {
        this.lockPoints();
        this.setPopupEnabled(false);
    }

    public void unlock() {
        this.unlockPoints();
        this.setPopupEnabled(true);
    }

    public void lockPoints() {
        this.mapViewer.setPointsLocked(true);
    }

    public void unlockPoints() {
        this.mapViewer.setPointsLocked(false);
    }

    public boolean isOnCalculatedFrame() {
        return this.mapViewer.isOnCalculatedFrame();
    }

    public void setOnCalculatedFrame(boolean onCalculatedFrame) {
        this.mapViewer.setOnCalculatedFrame(onCalculatedFrame);
    }

    public boolean savePng(String fileName) {
        return this.mapViewer.savePng(fileName);
    }

    public boolean isLandmarkAtPosition(int x, int y) {
        return this.mapViewer.getLandmarkIndexAtPixelPos(x, y) >= 0;
    }

    public boolean isSegmentAtPosition(int x, int y) {
        return this.mapViewer.getSegmentClicked(x, y) != null;
    }

    public Integer getMapRadialsAtPosition(int x, int y) {
        GpsPoint point = MapUtil.getPixelPositionOnMap(this.mapViewer, x, y);
        for (int i = 0; i < FlightPlanBean.getInstance().getRoute().getMapRadials().size(); ++i) {
            MapRadials mapRadials = FlightPlanBean.getInstance().getRoute().getMapRadials().get(i);
            Point2D mapRadialPoint = this.mapViewer.getTileFactory().geoToPixel(mapRadials.getPos().geoPosition(), this.getZoom());
            if (!(mapRadialPoint.distance(point) <= 12.0)) continue;
            return i;
        }
        return null;
    }

    public AirportDTO getAirportAtPosition(int x, int y) {
        return this.mapViewer.getAirportClicked(x, y);
    }

    public boolean isWpAtPosition(int x, int y) {
        return this.mapViewer.getWpIndexAtPixelPos(x, y) >= 0;
    }

    public boolean isVorAtPosition(int x, int y) {
        return this.mapViewer.getVorIndexAtPixelPos(x, y) >= 0;
    }

    public void setPaintZoomBar(boolean paintZoomBar) {
        this.mapViewer.setPaintZoomBar(paintZoomBar);
    }

    public void setPaintMeteoPoints(boolean paintMeteoPoints) {
        this.mapViewer.setPaintMeteoPoints(paintMeteoPoints);
    }

    public void deleteSelected() {
        if (FlightPlanBean.getInstance().getSelectedPoint() >= 0) {
            this.getUIPanel().delPtsAction();
        } else if (FlightPlanBean.getInstance().getSelectedVor() >= 0) {
            this.getUIPanel().delVorAction();
        } else if (FlightPlanBean.getInstance().getSelectedLandmark() >= 0) {
            FlightPlanBean.getInstance().removeSelectedLandmark();
            this.updateMap();
        } else if (FlightPlanBean.getInstance().getSelectedMapRadial() >= 0) {
            FlightPlanBean.getInstance().getRoute().getMapRadials().remove(FlightPlanBean.getInstance().getSelectedMapRadial());
            this.updateMap();
        }
    }

    public boolean isPaintVorRadials() {
        return this.mapViewer.isPaintVorRadials();
    }

    public void setPaintVorRadials(boolean paintVorRadials) {
        this.mapViewer.setPaintVorRadials(paintVorRadials);
    }

    public boolean isPaintVorDistances() {
        return this.mapViewer.isPaintVorDistances();
    }

    public void setPaintVorDistances(boolean paintVorDistances) {
        this.mapViewer.setPaintVorDistances(paintVorDistances);
    }

    public GpsPlace getPointOnSegment(LineSegment segment, double distance) {
        return MapUtil.getPointOnSegment(this.mapViewer, segment, distance);
    }

    public boolean isVorsMouseDrag() {
        return this.mapViewer.isVorsMouseDrag();
    }

    public void setVorsMouseDrag(boolean vorsMouseDrag) {
        this.mapViewer.setVorsMouseDrag(vorsMouseDrag);
    }

    public int getZoom() {
        return this.mapViewer.getZoom();
    }

    public void setZoom(int zoom) {
        this.mapViewer.setZoom(zoom);
    }

    public GeoPosition getCenterPosition() {
        return this.mapViewer.getCenterPosition();
    }

    public void setCenterPosition(GeoPosition geoPosition) {
        this.mapViewer.setCenterPosition(geoPosition);
    }

    public boolean isPointsLocked() {
        return this.mapViewer.isPointsLocked();
    }

    public void setPointsLocked(boolean pointsLocked) {
        this.mapViewer.setPointsLocked(pointsLocked);
    }

    public void togglePointsLock() {
        this.setPointsLocked(!this.isPointsLocked());
    }

    public GpsPlace getGpsPlaceAtMapPosition(double x, double y) {
        return this.mapViewer.getGpsPlaceAtMapPosition(x, y);
    }

    public boolean isPopupEnabled() {
        return this.popupEnabled;
    }

    public void setPopupEnabled(boolean popupEnabled) {
        this.popupEnabled = popupEnabled;
    }

    public void calculateInRealTimeAction() {
        SettingsBean.getInstance().setCalculateRouteInRealTime(this.calculateInRealTimeButton.isSelected());
        this.getUIPanel().updateRoutePointsInfoLabel();
        this.updateMap();
    }

    public void underCursorTextAction() {
        SettingsBean.getInstance().setDrawMapObjectsListUnderCursor(this.underCursorTextCheckBox.isSelected());
        SettingsBean.getInstance().setDrawAirspacesListUnderCursor(this.underCursorTextCheckBox.isSelected());
        this.updateMap();
    }

    public void changeMeasurementLineUnitAction() {
        SettingsBean.getInstance().setMeasurementLineDistanceUnit(((StringComboBoxItem)this.measurementDistanceCombo.getSelectedItem()).getValue());
        this.mapViewer.repaint();
    }

    public TileFactory getTileFactiory() {
        return this.mapViewer.getTileFactory();
    }

    public void setTileFactory(TileFactory tileFactory) {
        this.mapViewer.setTileFactory(tileFactory);
    }

    public void refreshAllObjects(boolean showWaitDialog) {
        if (showWaitDialog) {
            PleaseWaitDialog.getInstance(this).start(true);
        }
        try {
            VfrUtil.executeTaskInFixedSinglePool(new RefreshAllTask());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.updateMap();
        if (showWaitDialog) {
            PleaseWaitDialog.getInstance(this).stop();
        }
    }

    public void setDrawAllNdbsAction(boolean value) {
        SettingsBean.getInstance().setDrawAllNdbs(value);
        VfrUtil.setLayerVisibilityAction(new RefreshNdbsTask());
    }

    public void setDrawRadialsFromVorsAction(boolean value, double rangeNm) {
        SettingsBean.getInstance().setDrawRadialsFromVors(value);
        VfrUtil.setLayerVisibilityAction(new RefreshRadialsFromVorsTask(rangeNm));
    }

    public void toggleDrawAllIfrRoutes() {
        SettingsBean.getInstance().setDrawAllIfrRoutes(!SettingsBean.getInstance().isDrawAllIfrRoutes());
        VfrUtil.setLayerVisibilityAction(new RefreshIfrRoutesTask());
    }

    public void toggleDrawAllIfrPoints() {
        SettingsBean.getInstance().setDrawAllIfrPoints(!SettingsBean.getInstance().isDrawAllIfrPoints());
        VfrUtil.setLayerVisibilityAction(new RefreshIfrPointsTask());
    }

    public Thread refreshMeteoImage(boolean updateMap) {
        Thread t = new Thread(new RefreshMeteoImageTask(updateMap));
        t.start();
        return t;
    }

    public void setDrawCitiesAction(boolean value) {
        SettingsBean.getInstance().setDrawCities(value);
        VfrUtil.setLayerVisibilityAction(new RefreshCitiesTask());
    }

    public void setDrawMagVarAction(boolean value) {
        SettingsBean.getInstance().setDrawMagneticDeclinations(value);
        VfrUtil.setLayerVisibilityAction(new RefreshMagneticDeclinationsTask(SettingsBean.getInstance().getDeclinationCalculator()));
    }

    public void setDrawMagneticDeclinationsAction(boolean value) {
        SettingsBean.getInstance().setDrawMagneticDeclinations(value);
        VfrUtil.setLayerVisibilityAction(new RefreshMagneticDeclinationsTask(SettingsBean.getInstance().getDeclinationCalculator()));
    }

    public void setDrawElevationsAction(boolean value) {
        SettingsBean.getInstance().setDrawElevations(value);
        VfrUtil.setLayerVisibilityAction(new RefreshElevationsTask());
    }

    public void setDrawTerrainElevationsAction(boolean value) {
        SettingsBean.getInstance().setDrawTerrainElevations(value);
        VfrUtil.setLayerVisibilityAction(new RefreshTerrainElevationsTask());
    }

    public void setDrawObstaclesAction(boolean value) {
        SettingsBean.getInstance().setDrawObstacles(value);
        VfrUtil.setLayerVisibilityAction(new RefreshObstaclesTask());
    }

    public void setDrawMeteoImageAction(boolean value) {
        SettingsBean.getInstance().setDrawMeteoImageMesh(value);
        this.refreshMeteoImage(true);
    }

    public void setDrawIfrPoints(boolean value) {
        SettingsBean.getInstance().setDrawAllIfrPoints(value);
        VfrUtil.setLayerVisibilityAction(new RefreshIfrPointsTask());
    }

    public void setDrawVfrPoints(boolean value) {
        SettingsBean.getInstance().setDrawVfrPoints(value);
        VfrUtil.setLayerVisibilityAction(new RefreshVfrPointsTask());
    }

    public void setDrawIfrRoutes(boolean value) {
        SettingsBean.getInstance().setDrawAllIfrRoutes(value);
        VfrUtil.setLayerVisibilityAction(new RefreshIfrRoutesTask());
    }

    public void setDrawTextLabels(boolean value) {
        SettingsBean.getInstance().setDrawTextLabels(value);
        this.updateMap();
    }

    public void setDrawAllVorsAction(boolean value) {
        SettingsBean.getInstance().setDrawAllVors(value);
        VfrUtil.setLayerVisibilityAction(new RefreshVorsTask());
    }

    public void setDrawAllIlsAction(boolean value) {
        SettingsBean.getInstance().setDrawAllIls(value);
        VfrUtil.setLayerVisibilityAction(new RefreshIlsTask());
    }

    public void setDrawAllAirportsAction(boolean value) {
        SettingsBean.getInstance().setDrawAllAirports(value);
        VfrUtil.setLayerVisibilityAction(new RefreshAirportsTask());
    }

    public void setDrawRunwayExtensionsAction(boolean value) {
        SettingsBean.getInstance().setDrawRunwayExtensions(value);
        VfrUtil.setLayerVisibilityAction(new RefreshRunwaysExtensionsTask());
    }

    public void setDrawAirportsTaxiwaysAction(boolean value) {
        SettingsBean.getInstance().setDrawAirportTaxiways(value);
        VfrUtil.setLayerVisibilityAction(new RefreshTaxiwaysTask());
    }

    public void setDrawAllUserPointsAction(boolean value) {
        SettingsBean.getInstance().setDrawAllUserPoints(value);
        VfrUtil.setLayerVisibilityAction(new RefreshUserPointsTask());
    }

    public void setDrawMapGridAction(boolean value) {
        SettingsBean.getInstance().setDrawMapGrid(value);
        this.updateMap();
    }

    public void setDrawWeatherAction(boolean value) {
        SettingsBean.getInstance().setDrawWeather(value);
        this.updateMap();
    }

    public void exportMapAsPdf() {
        PdfRegionDialog dialog = new PdfRegionDialog(this, null, null, 1);
        dialog.setVisible(true);
    }

    public void exportMapAsPdfFinish(RotatedGpsArea area, int zoom, boolean withCompassRose, int compassRoseLocation) {
        int returnVal;
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("save_as_pdf"), Messages.getInstance().get("save"));
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("pdf_files"), new String[]{"PDF"}));
        if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getRoute().getName())) {
            chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getRoute().getName() + ".pdf"));
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
            FlightPlanBean.getInstance().unselectAll();
            this.updateMap();
            String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "pdf");
            if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("save_as_pdf"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                Thread t = new Thread(new ExportMapPdfTask(fileName, area, zoom, withCompassRose, VfrUtil.getMagneticDeclination(area.getCenter()), compassRoseLocation));
                t.start();
            }
        }
    }

    public void exportMapAsPng() {
        PdfRegionDialog dialog = new PdfRegionDialog(this, null, null, 2);
        dialog.setVisible(true);
    }

    public void exportMapToHdd() {
        DownloadMapToHddDialog dialog = new DownloadMapToHddDialog(this, this.getMapViewer().getZoom());
        dialog.setVisible(true);
    }

    public void exportMapAsPngFinish(RotatedGpsArea area, int zoom, boolean withCompassRose, int compassRoseLocation) {
        int returnVal;
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("map_frame_export_to_png"), Messages.getInstance().get("save"));
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("png_files"), new String[]{"PNG"}));
        if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getRoute().getName())) {
            chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getRoute().getName() + ".png"));
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
            FlightPlanBean.getInstance().unselectAll();
            this.updateMap();
            String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "png");
            if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("map_frame_export_to_png"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                Thread t = new Thread(new ExportMapPngTask(fileName, area, zoom, withCompassRose, VfrUtil.getMagneticDeclination(area.getCenter()), compassRoseLocation));
                t.start();
            }
        }
    }

    public void addMapRadialsAtPosition(int mouseX, int mouseY) {
        int routePointIdx;
        GpsPlace point = this.mapViewer.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(this.mapViewer, mouseX, mouseY), this.getZoom()).gpsPlace();
        if (SettingsBean.getInstance().isStickyMode() && (routePointIdx = this.getMapViewer().getWpIndexAtPixelPos(mouseX, mouseY)) >= 0) {
            point = FlightPlanBean.getInstance().getRoute().getPoints().get(routePointIdx).clone();
        }
        AddMapRadialsDialog radialsDialog = new AddMapRadialsDialog(this, new MapRadials(point), null);
        radialsDialog.setVisible(true);
    }

    private void toggleMeasurementLineAction() {
        SettingsBean.getInstance().setParamMapMouseGoogleStyle(!this.enableMeasurementLineButton.isSelected());
    }

    private void toggleMultipleRulersAction() {
        this.getMapViewer().setMultipleRulersMode(this.multipleRulersButton.isSelected());
        if (!this.multipleRulersButton.isSelected()) {
            this.getMapViewer().getMeasurementLines().clear();
            this.getMapViewer().repaint();
        }
    }

    public void setMeasurementLineButton(boolean value) {
        this.enableMeasurementLineButton.setSelected(value);
    }

    public boolean isPaintVorNames() {
        return this.mapViewer.isPaintVorNames();
    }

    public void setPaintVorNames(boolean paintVorNames) {
        this.mapViewer.setPaintVorNames(paintVorNames);
    }

    public GpsPlace getMarkerPlace() {
        return this.mapViewer.getMarkerPlace();
    }

    public void setMarkerPlace(GpsPlace markerPlace) {
        this.mapViewer.setMarkerPlace(markerPlace);
    }

    public void updateTitle() {
        this.updateTitle(null);
    }

    public void updateTitle(String txt) {
        StringBuilder sb = new StringBuilder();
        sb.append("VfrFlight ");
        sb.append(VfrUtil.getVersion());
        if (!StringUtil.isEmpty(txt)) {
            sb.append(TITLE_DELIMITER);
            sb.append(txt);
        }
        this.setTitle(sb.toString());
    }

    public void toggleFollowUserPosition() {
        SettingsBean.getInstance().setFollowUserPosition(!SettingsBean.getInstance().isFollowUserPosition());
        if (SettingsBean.getInstance().isFollowUserPosition()) {
            ExtConnectBean bean = SimConnectUtil.getInstance().getExtConnectBean();
            this.centerOnPoint(bean.getUserLat().floatValue(), bean.getUserLon().floatValue(), false);
            this.updateMap();
        }
    }

    public void closeAction() {
        if (GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("exit"), Messages.getInstance().get("are_you_sure"))) {
            PleaseWaitDialog.getInstance(this).start();
            Thread t = new Thread(new VfrShutdownTask());
            t.start();
        }
    }

    public void setDialogTitle(String title) {
        this.previousTitle = this.getTitle();
        if (SettingsBean.getInstance().isConnectedToSimAndHasData()) {
            this.setTitle(title + " " + Messages.getInstance().get("main_frame_connected_to_sim"));
        } else {
            this.setTitle(title);
        }
    }

    private void createBottomToolbar(JPanel parentPanel) {
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(new EtchedBorder(1, null, null));
        toolBar.setFloatable(false);
        JPanel centerPanel_3 = new JPanel();
        centerPanel_3.setBorder(new EtchedBorder(1, null, null));
        this.alwaysOnTopButton = new ToolbarStateButton("img/gui/always_on_top.png", Messages.getInstance().get("map_frame_always_on_top"), this.isAlwaysOnTop(), SettingsBean.getInstance().isTouchScreenMode());
        this.alwaysOnTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.alwaysOnTopAction();
            }
        });
        centerPanel_3.add(this.alwaysOnTopButton);
        this.calculateInRealTimeButton = new ToolbarStateButton("img/gui/real_time.png", Messages.getInstance().get("map_frame_calculate_in_real_time"), SettingsBean.getInstance().isCalculateRouteInRealTime(), SettingsBean.getInstance().isTouchScreenMode());
        this.calculateInRealTimeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.calculateInRealTimeAction();
            }
        });
        centerPanel_3.add(this.calculateInRealTimeButton);
        toolBar.add(centerPanel_3);
        this.coordsCursorButton = new ToolbarStateButton("img/gui/draw_coords.png", Messages.getInstance().get("map_frame_coords_cursor"), this.mapViewer.isCoordsCursor(), SettingsBean.getInstance().isTouchScreenMode());
        this.coordsCursorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.mapViewer.setCoordsCursor(!MapFrame.this.mapViewer.isCoordsCursor());
                MapFrame.this.updateMap();
            }
        });
        centerPanel_3.add(this.coordsCursorButton);
        toolBar.add(centerPanel_3);
        this.magnifyingGlassButton = new ToolbarStateButton("img/gui/magnifier.png", Messages.getInstance().get("map_frame_magnifier_glass"), this.mapViewer.isMagnifyingGlass(), SettingsBean.getInstance().isTouchScreenMode());
        this.magnifyingGlassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.mapViewer.setMagnifyingGlass(!MapFrame.this.mapViewer.isMagnifyingGlass());
                MapFrame.this.updateMap();
            }
        });
        centerPanel_3.add(this.magnifyingGlassButton);
        toolBar.add(centerPanel_3);
        this.compassButton = new ToolbarStateButton("img/gui/compass.png", Messages.getInstance().get("map_frame_compass"), this.mapViewer.isDrawCompass(), SettingsBean.getInstance().isTouchScreenMode());
        this.compassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.mapViewer.setDrawCompass(!MapFrame.this.mapViewer.isDrawCompass());
                MapFrame.this.updateMap();
            }
        });
        centerPanel_3.add(this.compassButton);
        toolBar.add(centerPanel_3);
        this.distanceCirclesButton = new ToolbarStateButton("img/gui/dist_circles.png", Messages.getInstance().get("map_frame_distance_circles"), this.mapViewer.isDrawDistanceCircles(), SettingsBean.getInstance().isTouchScreenMode());
        this.distanceCirclesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.mapViewer.setDrawDistanceCircles(!MapFrame.this.mapViewer.isDrawDistanceCircles());
                MapFrame.this.updateMap();
            }
        });
        centerPanel_3.add(this.distanceCirclesButton);
        this.drawClosestVorRadialsButton = new ToolbarStateButton("img/gui/closest_vor_rad.png", Messages.getInstance().get("map_frame_closest_vor_radials"), this.mapViewer.isDrawClosestVorRadials(), SettingsBean.getInstance().isTouchScreenMode());
        this.drawClosestVorRadialsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.mapViewer.setDrawClosestVorRadials(!MapFrame.this.mapViewer.isDrawClosestVorRadials());
                MapFrame.this.updateMap();
            }
        });
        centerPanel_3.add(this.drawClosestVorRadialsButton);
        toolBar.add(centerPanel_3);
        JPanel centerPanel_1 = new JPanel();
        centerPanel_1.setBorder(new EtchedBorder(1, null, null));
        this.enableMeasurementLineButton = new ToolbarStateButton("img/gui/ruler.png", Messages.getInstance().get("map_frame_ruler_enable"), !SettingsBean.getInstance().isParamMapMouseGoogleStyle(), SettingsBean.getInstance().isTouchScreenMode());
        this.enableMeasurementLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.toggleMeasurementLineAction();
            }
        });
        centerPanel_1.add(this.enableMeasurementLineButton);
        this.multipleRulersButton = new ToolbarStateButton("img/gui/multiple_rulers.png", Messages.getInstance().get("map_frame_multiple_rulers"), this.getMapViewer().isMultipleRulersMode(), SettingsBean.getInstance().isTouchScreenMode());
        this.multipleRulersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.toggleMultipleRulersAction();
            }
        });
        centerPanel_1.add(this.multipleRulersButton);
        this.measurementDistanceCombo = new JComboBox();
        this.measurementDistanceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.changeMeasurementLineUnitAction();
            }
        });
        this.measurementDistanceCombo.setModel(new DefaultComboBoxModel<StringComboBoxItem>(SettingsBean.getInstance().getDistanceValuesCombo()));
        centerPanel_1.add(this.measurementDistanceCombo);
        toolBar.add(centerPanel_1);
        JPanel centerPanel_2 = new JPanel();
        centerPanel_2.setBorder(new EtchedBorder(1, null, null));
        this.createMapTypeCombo(centerPanel_2);
        toolBar.add(centerPanel_2);
        parentPanel.add((Component)toolBar, "Center");
        if (SettingsBean.getInstance().isOfflineMode()) {
            JPanel leftPanel = new JPanel();
            parentPanel.add((Component)leftPanel, "West");
            JLabel offlineModeLabel = new JLabel(Messages.getInstance().get("map_frame_offline_mode"));
            offlineModeLabel.setFont(new Font("Tahoma", 1, 15));
            offlineModeLabel.setForeground(Color.RED);
            leftPanel.add(offlineModeLabel);
        }
    }

    private JToolBar createLayersToolbar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(new EtchedBorder(1, null, null));
        toolBar.setFloatable(false);
        this.showTextButton = new ToolbarStateButton("img/gui/layer_text.png", Messages.getInstance().get("popup_menu_show_text_labels"), SettingsBean.getInstance().isDrawTextLabels(), SettingsBean.getInstance().isTouchScreenMode());
        this.showTextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawTextLabels(!MapFrame.this.showTextButton.isPressed());
            }
        });
        toolBar.add(this.showTextButton);
        this.showVorButton = new ToolbarStateButton("img/gui/layer_vor.png", Messages.getInstance().get("popup_menu_show_all_vors"), SettingsBean.getInstance().isDrawAllVors(), SettingsBean.getInstance().isTouchScreenMode());
        this.showVorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawAllVorsAction(!MapFrame.this.showVorButton.isPressed());
            }
        });
        toolBar.add(this.showVorButton);
        this.showNdbButton = new ToolbarStateButton("img/gui/layer_ndb.png", Messages.getInstance().get("popup_menu_show_all_ndbs"), SettingsBean.getInstance().isDrawAllNdbs(), SettingsBean.getInstance().isTouchScreenMode());
        this.showNdbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawAllNdbsAction(!MapFrame.this.showNdbButton.isPressed());
            }
        });
        toolBar.add(this.showNdbButton);
        this.showAirportsButton = new ToolbarStateButton("img/gui/layer_airports.png", Messages.getInstance().get("popup_menu_show_all_airports"), SettingsBean.getInstance().isDrawAllAirports(), SettingsBean.getInstance().isTouchScreenMode());
        this.showAirportsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawAllAirportsAction(!MapFrame.this.showAirportsButton.isPressed());
            }
        });
        toolBar.add(this.showAirportsButton);
        this.showRunwayExtensionsButton = new ToolbarStateButton("img/gui/rwy_ext.png", Messages.getInstance().get("popup_menu_show_runway_extensions"), SettingsBean.getInstance().isDrawRunwayExtensions(), SettingsBean.getInstance().isTouchScreenMode());
        this.showRunwayExtensionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawRunwayExtensionsAction(!MapFrame.this.showRunwayExtensionsButton.isPressed());
            }
        });
        toolBar.add(this.showRunwayExtensionsButton);
        this.showTaxiwaysButton = new ToolbarStateButton("img/gui/layer_taxi.png", Messages.getInstance().get("popup_menu_show_airports_details"), SettingsBean.getInstance().isDrawAirportTaxiways(), SettingsBean.getInstance().isTouchScreenMode());
        this.showTaxiwaysButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawAirportsTaxiwaysAction(!MapFrame.this.showTaxiwaysButton.isPressed());
            }
        });
        toolBar.add(this.showTaxiwaysButton);
        this.showIlsButton = new ToolbarStateButton("img/gui/layer_ils.png", Messages.getInstance().get("popup_menu_show_all_ils"), SettingsBean.getInstance().isDrawAllIls(), SettingsBean.getInstance().isTouchScreenMode());
        this.showIlsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawAllIlsAction(!MapFrame.this.showIlsButton.isPressed());
            }
        });
        toolBar.add(this.showIlsButton);
        this.showMsaButton = new ToolbarStateButton("img/gui/layer_msa.png", Messages.getInstance().get("popup_menu_show_elevations"), SettingsBean.getInstance().isDrawElevations(), SettingsBean.getInstance().isTouchScreenMode());
        this.showMsaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawElevationsAction(!MapFrame.this.showMsaButton.isPressed());
            }
        });
        toolBar.add(this.showMsaButton);
        this.showTerrainButton = new ToolbarStateButton("img/gui/terrain_layer.png", Messages.getInstance().get("popup_menu_show_terrain_elevations"), SettingsBean.getInstance().isDrawTerrainElevations(), SettingsBean.getInstance().isTouchScreenMode());
        this.showTerrainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawTerrainElevationsAction(!MapFrame.this.showTerrainButton.isPressed());
            }
        });
        toolBar.add(this.showTerrainButton);
        this.showObstacleButton = new ToolbarStateButton("img/gui/layer_obstacle.png", Messages.getInstance().get("popup_menu_show_obstacles"), SettingsBean.getInstance().isDrawObstacles(), SettingsBean.getInstance().isTouchScreenMode());
        this.showObstacleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawObstaclesAction(!MapFrame.this.showObstacleButton.isPressed());
            }
        });
        toolBar.add(this.showObstacleButton);
        this.showAirspacesButton = new ToolbarStateButton("img/gui/layer_airspace.png", Messages.getInstance().get("popup_menu_show_airspaces"), SettingsBean.getInstance().isDrawAirspaces(), SettingsBean.getInstance().isTouchScreenMode());
        this.showAirspacesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().getAirspacesFilterCollapsablePanel().setDrawAirspacesAction(!MapFrame.this.showAirspacesButton.isPressed());
            }
        });
        toolBar.add(this.showAirspacesButton);
        this.showVfrPtButton = new ToolbarStateButton("img/gui/layer_vfr_pt.png", Messages.getInstance().get("popup_menu_show_vfr_points"), SettingsBean.getInstance().isDrawVfrPoints(), SettingsBean.getInstance().isTouchScreenMode());
        this.showVfrPtButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawVfrPoints(!MapFrame.this.showVfrPtButton.isPressed());
            }
        });
        toolBar.add(this.showVfrPtButton);
        this.showAIfrPtButton = new ToolbarStateButton("img/gui/layer_ifr_pt.png", Messages.getInstance().get("popup_menu_show_ifr_points"), SettingsBean.getInstance().isDrawAllIfrPoints(), SettingsBean.getInstance().isTouchScreenMode());
        this.showAIfrPtButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawIfrPoints(!MapFrame.this.showAIfrPtButton.isPressed());
            }
        });
        toolBar.add(this.showAIfrPtButton);
        this.showIfrRteButton = new ToolbarStateButton("img/gui/layer_ifr_rte.png", Messages.getInstance().get("popup_menu_show_ifr_routes"), SettingsBean.getInstance().isDrawAllIfrRoutes(), SettingsBean.getInstance().isTouchScreenMode());
        this.showIfrRteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawIfrRoutes(!MapFrame.this.showIfrRteButton.isPressed());
            }
        });
        toolBar.add(this.showIfrRteButton);
        this.showWeatherButton = new ToolbarStateButton("img/gui/layer_weather.png", Messages.getInstance().get("popup_menu_show_weather"), SettingsBean.getInstance().isDrawWeather(), SettingsBean.getInstance().isTouchScreenMode());
        this.showWeatherButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawWeatherAction(!MapFrame.this.showWeatherButton.isPressed());
            }
        });
        toolBar.add(this.showWeatherButton);
        this.showUserPointsButton = new ToolbarStateButton("img/gui/layer_user.png", Messages.getInstance().get("popup_menu_show_all_user_points"), SettingsBean.getInstance().isDrawAllUserPoints(), SettingsBean.getInstance().isTouchScreenMode());
        this.showUserPointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().getUserPointsFilterCollapsablePanel().setDrawUserPointsAction(!MapFrame.this.showUserPointsButton.isPressed());
            }
        });
        toolBar.add(this.showUserPointsButton);
        this.showCitiesButton = new ToolbarStateButton("img/gui/layer_city.png", Messages.getInstance().get("popup_menu_show_cities"), SettingsBean.getInstance().isDrawCities(), SettingsBean.getInstance().isTouchScreenMode());
        this.showCitiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawCitiesAction(!MapFrame.this.showCitiesButton.isPressed());
            }
        });
        toolBar.add(this.showCitiesButton);
        this.showUserTrackButton = new ToolbarStateButton("img/gui/layer_user_track.png", Messages.getInstance().get("popup_menu_show_user_track"), SettingsBean.getInstance().isDrawUserTrack(), SettingsBean.getInstance().isTouchScreenMode());
        this.showUserTrackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettingsBean.getInstance().setDrawUserTrack(!MapFrame.this.showUserTrackButton.isPressed());
                MapFrame.this.updateMap();
            }
        });
        toolBar.add(this.showUserTrackButton);
        this.showMagVarButton = new ToolbarStateButton("img/gui/layer_magvar.png", Messages.getInstance().get("popup_menu_show_magnetic_declinations"), SettingsBean.getInstance().isDrawMagneticDeclinations(), SettingsBean.getInstance().isTouchScreenMode());
        this.showMagVarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawMagVarAction(!MapFrame.this.showMagVarButton.isPressed());
            }
        });
        toolBar.add(this.showMagVarButton);
        this.showMapGridButton = new ToolbarStateButton("img/gui/layer_map_grid.png", Messages.getInstance().get("popup_menu_show_map_grid"), SettingsBean.getInstance().isDrawMapGrid(), SettingsBean.getInstance().isTouchScreenMode());
        this.showMapGridButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.setDrawMapGridAction(!MapFrame.this.showMapGridButton.isPressed());
            }
        });
        toolBar.add(this.showMapGridButton);
        toolBar.addSeparator();
        this.showLegInfo = new ToolbarStateButton("img/gui/leg_info.png", Messages.getInstance().get("popup_menu_show_course_and_distance"), SettingsBean.getInstance().isShowCrsAndDist(), SettingsBean.getInstance().isTouchScreenMode());
        this.showLegInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsBean.getInstance().setShowCrsAndDist(!MapFrame.this.showLegInfo.isPressed());
                MapFrame.this.legInfoDec.setVisible(!MapFrame.this.showLegInfo.isPressed());
                MapFrame.this.legInfoInc.setVisible(!MapFrame.this.showLegInfo.isPressed());
                MapFrame.this.updateMap();
            }
        });
        toolBar.add(this.showLegInfo);
        this.legInfoDec = new ToolbarButton("img/gui/leg_info_dec.png", Messages.getInstance().get("decrease"), SettingsBean.getInstance().isTouchScreenMode());
        this.legInfoDec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsBean.getInstance().setRouteFontSizeModificator(SettingsBean.getInstance().getRouteFontSizeModificator() - 1);
                MapFrame.this.updateMap();
            }
        });
        toolBar.add(this.legInfoDec);
        this.legInfoInc = new ToolbarButton("img/gui/leg_info_inc.png", Messages.getInstance().get("increase"), SettingsBean.getInstance().isTouchScreenMode());
        this.legInfoInc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsBean.getInstance().setRouteFontSizeModificator(SettingsBean.getInstance().getRouteFontSizeModificator() + 1);
                MapFrame.this.updateMap();
            }
        });
        toolBar.add(this.legInfoInc);
        this.showLandmarkLabels = new ToolbarStateButton("img/gui/landmarks.png", Messages.getInstance().get("popup_menu_show_landmark_labels"), SettingsBean.getInstance().isDrawLandmarkLabels(), SettingsBean.getInstance().isTouchScreenMode());
        this.showLandmarkLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsBean.getInstance().setDrawLandmarkLabels(!MapFrame.this.showLandmarkLabels.isPressed());
                MapFrame.this.updateMap();
            }
        });
        toolBar.add(this.showLandmarkLabels);
        this.showMapRadials = new ToolbarStateButton("img/gui/map_radials.png", Messages.getInstance().get("popup_menu_show_map_radials"), SettingsBean.getInstance().isShowMapRadials(), SettingsBean.getInstance().isTouchScreenMode());
        this.showMapRadials.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsBean.getInstance().setShowMapRadials(!MapFrame.this.showMapRadials.isPressed());
                MapFrame.this.updateMap();
            }
        });
        toolBar.add(this.showMapRadials);
        this.showWindInformation = new ToolbarStateButton("img/gui/wind_info.png", Messages.getInstance().get("popup_menu_show_wind_information"), SettingsBean.getInstance().isShowWindSock(), SettingsBean.getInstance().isTouchScreenMode());
        this.showWindInformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsBean.getInstance().setShowWindSock(!MapFrame.this.showWindInformation.isPressed());
                MapFrame.this.updateMap();
            }
        });
        toolBar.add(this.showWindInformation);
        this.showRouteDirectionArrows = new ToolbarStateButton("img/gui/dir_arrows.png", Messages.getInstance().get("popup_menu_show_route_direction_arrows"), SettingsBean.getInstance().isDrawDirectionArrows(), SettingsBean.getInstance().isTouchScreenMode());
        this.showRouteDirectionArrows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsBean.getInstance().setDrawDirectionArrows(!MapFrame.this.showRouteDirectionArrows.isPressed());
                MapFrame.this.updateMap();
            }
        });
        toolBar.add(this.showRouteDirectionArrows);
        return toolBar;
    }

    private JPanel createMapModesPanel() {
        JPanel toolBarEastWrapper = new JPanel();
        JPanel newRoutePanel = new JPanel();
        this.prevRouteButton = new JButton("<<");
        this.prevRouteButton.setVisible(false);
        this.prevRouteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SettingsBean.getInstance().getRouteCreatorBean().anyCreatedRoutes()) {
                    int index = SettingsBean.getInstance().getRouteCreatorBean().getLastRouteIndex();
                    if (--index < 0) {
                        index = SettingsBean.getInstance().getRouteCreatorBean().getDepartureAirports().length - 1;
                    }
                    SettingsBean.getInstance().getRouteCreatorBean().setLastRouteIndex(index);
                    GpsPlace from = SettingsBean.getInstance().getRouteCreatorBean().getDepartureAirports()[index];
                    GpsPlace to = SettingsBean.getInstance().getRouteCreatorBean().getArrivalAirports()[index];
                    ArrayList<GpsPlace> newRoute = new ArrayList<GpsPlace>();
                    newRoute.add(from);
                    newRoute.add(to);
                    RouteUtil.findRouteAction(newRoute, SettingsBean.getInstance().getRouteCreatorBean().getSelectedCriteria().isVorToVor(), null, null, true);
                }
            }
        });
        newRoutePanel.add(this.prevRouteButton);
        JButton routeCreatorButton = new JButton(Messages.getInstance().get("route_creator_dialog_button"));
        routeCreatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RouteCreatorDialog dialog = new RouteCreatorDialog();
                dialog.setVisible(true);
            }
        });
        newRoutePanel.add(routeCreatorButton);
        this.nextRouteButton = new JButton(">>");
        this.nextRouteButton.setVisible(false);
        this.nextRouteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SettingsBean.getInstance().getRouteCreatorBean().anyCreatedRoutes()) {
                    int index = SettingsBean.getInstance().getRouteCreatorBean().getLastRouteIndex();
                    if (++index >= SettingsBean.getInstance().getRouteCreatorBean().getArrivalAirports().length) {
                        index = 0;
                    }
                    SettingsBean.getInstance().getRouteCreatorBean().setLastRouteIndex(index);
                    GpsPlace from = SettingsBean.getInstance().getRouteCreatorBean().getDepartureAirports()[index];
                    GpsPlace to = SettingsBean.getInstance().getRouteCreatorBean().getArrivalAirports()[index];
                    ArrayList<GpsPlace> newRoute = new ArrayList<GpsPlace>();
                    newRoute.add(from);
                    newRoute.add(to);
                    RouteUtil.findRouteAction(newRoute, SettingsBean.getInstance().getRouteCreatorBean().getSelectedCriteria().isVorToVor(), null, null, true);
                }
            }
        });
        newRoutePanel.add(this.nextRouteButton);
        toolBarEastWrapper.add(newRoutePanel);
        JToolBar toolBarEast = new JToolBar();
        toolBarEast.setBorder(new EtchedBorder(1, null, null));
        toolBarEastWrapper.add(toolBarEast);
        this.gpsModeButton = new ToolbarStateButton("img/gui/gps_mode.png", Messages.getInstance().get("gps_mode_button"), this.gpsMap != null, SettingsBean.getInstance().isTouchScreenMode());
        this.gpsModeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.toggleGpsMapConnection();
            }
        });
        toolBarEast.add(this.gpsModeButton);
        this.touchScreenButton = new ToolbarStateButton("img/gui/touch_screen.png", Messages.getInstance().get("toggle_touch_screen_mode"), SettingsBean.getInstance().isTouchScreenMode(), SettingsBean.getInstance().isTouchScreenMode());
        this.touchScreenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.toggleTouchScreenMode();
            }
        });
        toolBarEast.add(this.touchScreenButton);
        this.fullscreenButton = new ToolbarButton("img/gui/fullscreen.png", Messages.getInstance().get("switch_to_fullscreen_mode"), SettingsBean.getInstance().isTouchScreenMode());
        this.fullscreenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.switchToFullScreenMode();
            }
        });
        toolBarEast.add(this.fullscreenButton);
        toolBarEast.setFloatable(false);
        return toolBarEastWrapper;
    }

    private JPanel createSouthToolbar() {
        JPanel toolbarWrapper = new JPanel();
        toolbarWrapper.setLayout(new BorderLayout(0, 0));
        toolbarWrapper.add((Component)this.createLayersToolbar(), "West");
        toolbarWrapper.add((Component)this.createMapModesPanel(), "East");
        return toolbarWrapper;
    }

    private JPanel createMapLayersToolbar() {
        JPanel toolbarWrapper = new JPanel();
        toolbarWrapper.setLayout(new BorderLayout(0, 0));
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(new EtchedBorder(1, null, null));
        toolBar.setFloatable(false);
        toolbarWrapper.add((Component)toolBar, "West");
        toolBar.add(this.createRegionsComboBoxPanel());
        this.layersOrderButton = new ToolbarButton("img/gui/layers.png", Messages.getInstance().get("popup_menu_set_map_priority"), SettingsBean.getInstance().isTouchScreenMode());
        this.layersOrderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.mapPriorityAction();
            }
        });
        toolBar.add(this.layersOrderButton);
        toolBar.addSeparator();
        this.createMiscToolbarButtons(toolBar);
        toolBar.add(this.createUnderCursorTextPanel());
        return toolbarWrapper;
    }

    private void createMiscToolbarButtons(JToolBar toolBar) {
        if (!SettingsBean.getInstance().isOfflineMode()) {
            this.facebookButton = new ToolbarButton("img/gui/facebook.png", Messages.getInstance().get("main_frame_menu_help_facebook"), SettingsBean.getInstance().isTouchScreenMode());
            this.facebookButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MapFrame.this.getUIPanel().facebookAction();
                }
            });
            toolBar.add(this.facebookButton);
            this.youtubeButton = new ToolbarButton("img/gui/youtube.gif", Messages.getInstance().get("main_frame_menu_help_youtube"), SettingsBean.getInstance().isTouchScreenMode());
            this.youtubeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MapFrame.this.getUIPanel().youtubeAction();
                }
            });
            toolBar.add(this.youtubeButton);
            this.contactButton = new ToolbarButton("img/gui/comment.png", Messages.getInstance().get("main_frame_menu_help_feedback"), SettingsBean.getInstance().isTouchScreenMode());
            this.contactButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MapFrame.this.getUIPanel().feedbackAction();
                }
            });
            toolBar.add(this.contactButton);
        }
        this.aboutButton = new ToolbarButton("img/gui/smile.png", Messages.getInstance().get("main_frame_menu_help_about"), SettingsBean.getInstance().isTouchScreenMode());
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().aboutAction();
            }
        });
        toolBar.add(this.aboutButton);
    }

    private JPanel createRegionsComboBoxPanel() {
        JPanel restrictComboWrapper = new JPanel();
        restrictComboWrapper.setBorder(new EtchedBorder(1, null, null));
        this.regionsComboBox = new JComboBox();
        for (int i = 0; i < Constants.REGIONS_MESSAGES.length; ++i) {
            this.regionsComboBox.addItem(new NumericComboBoxItem(Messages.getInstance().get(Constants.REGIONS_MESSAGES[i]), i));
        }
        this.regionsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.selectRegionAction();
            }
        });
        restrictComboWrapper.add(this.regionsComboBox);
        this.setSelectedRegion(SettingsBean.getInstance().getParamMapRegionSelected());
        this.layersOrderButton = new ToolbarButton("img/gui/layers.png", Messages.getInstance().get("popup_menu_set_map_priority"), SettingsBean.getInstance().isTouchScreenMode());
        this.layersOrderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.mapPriorityAction();
            }
        });
        restrictComboWrapper.add(this.layersOrderButton);
        return restrictComboWrapper;
    }

    private JPanel createUnderCursorTextPanel() {
        JPanel underCursorTextPanel = new JPanel();
        underCursorTextPanel.setBorder(new EtchedBorder(1, null, null));
        this.underCursorTextCheckBox = new JCheckBox(Messages.getInstance().get("map_frame_under_cursor_text"), SettingsBean.getInstance().isDrawMapObjectsListUnderCursor());
        this.underCursorTextCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.underCursorTextAction();
            }
        });
        underCursorTextPanel.add(this.underCursorTextCheckBox);
        return underCursorTextPanel;
    }

    private void toggleTouchScreenMode() {
        SettingsBean.getInstance().setTouchScreenMode(!SettingsBean.getInstance().isTouchScreenMode());
        VfrUtil.refreshUI();
    }

    private void switchToFullScreenMode() {
        this.dispose();
        this.setUndecorated(true);
        this.setVisible(true);
        this.toolbarWrapperPanel.setVisible(false);
        this.centerPanel.setVisible(false);
        this.toggleUIButtonPanel.setVisible(false);
        this.mainMenuBar.setVisible(false);
        FullscreenButton button = new FullscreenButton(40, 40);
        button.setBackgroundColor(this.getBackground());
        if (this.gpsMap == null) {
            this.mapViewer.setFullScreenButton(button);
            this.mapViewer.setFullScreenMode(true);
            this.showUIPanelBeforeFullScreen = this.isShowUIPanel();
            if (this.isShowUIPanel()) {
                this.toggleUIPanelAction();
            }
        } else {
            this.gpsMap.getImagePanel().setFullScreenButton(button);
        }
    }

    public void leaveFullscreenMode() {
        this.dispose();
        this.setUndecorated(false);
        this.setVisible(true);
        this.toolbarWrapperPanel.setVisible(true);
        this.centerPanel.setVisible(true);
        this.mainMenuBar.setVisible(true);
        this.toggleUIButtonPanel.setVisible(true);
        if (this.gpsMap == null) {
            this.mapViewer.setFullScreenMode(false);
            this.mapViewer.setFullScreenButton(null);
            if (this.showUIPanelBeforeFullScreen && !this.isShowUIPanel()) {
                this.toggleUIPanelAction();
            }
        } else {
            this.gpsMap.getImagePanel().setFullScreenButton(null);
        }
    }

    public void setSelectedRegion(int region) {
        this.setSelectedRegion(region, true);
    }

    public void setSelectedRegion(int region, boolean triggerAction) {
        if (this.regionsComboBox != null) {
            for (int i = 0; i < this.regionsComboBox.getItemCount(); ++i) {
                NumericComboBoxItem value = this.regionsComboBox.getItemAt(i);
                if (region != value.getValue()) continue;
                if (!triggerAction) {
                    this.suppressRegionsSelectionAction = true;
                }
                this.regionsComboBox.setSelectedIndex(i);
                if (triggerAction) break;
                this.suppressRegionsSelectionAction = false;
                break;
            }
        }
    }

    private void selectRegionAction() {
        if (!this.suppressRegionsSelectionAction) {
            NumericComboBoxItem value = (NumericComboBoxItem)this.regionsComboBox.getSelectedItem();
            if (value.getValue() != 1) {
                SettingsBean.getInstance().setParamMapRegionSelected(value.getValue());
                VfrUtil.setLayerVisibilityAction(new RefreshAllTask());
            } else {
                if (this.gpsMap != null) {
                    this.toggleGpsMapConnection();
                }
                MapObjectsUserSelectionDialog dialog = new MapObjectsUserSelectionDialog(this);
                dialog.setVisible(true);
            }
        }
    }

    private JPanel createToolbar(boolean withMiscButtons) {
        JPanel toolbarWrapper = new JPanel();
        toolbarWrapper.setLayout(new BorderLayout(0, 0));
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(new EtchedBorder(1, null, null));
        toolBar.setFloatable(false);
        toolbarWrapper.add((Component)toolBar, "West");
        this.newButton = new ToolbarButton("img/gui/page.png", Messages.getInstance().get("main_frame_menu_file_new"), SettingsBean.getInstance().isTouchScreenMode());
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().newAction();
            }
        });
        toolBar.add(this.newButton);
        this.loadButton = new ToolbarButton("img/gui/folder.png", Messages.getInstance().get("main_frame_menu_file_open"), SettingsBean.getInstance().isTouchScreenMode());
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().loadAction();
            }
        });
        toolBar.add(this.loadButton);
        this.saveButton = new ToolbarButton("img/gui/disk.png", Messages.getInstance().get("main_frame_menu_file_save"), SettingsBean.getInstance().isTouchScreenMode());
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().saveAction();
            }
        });
        toolBar.add(this.saveButton);
        this.exportPdfButton = new ToolbarButton("img/gui/pdf.png", Messages.getInstance().get("toolbar_tooltip_export_pdf"), SettingsBean.getInstance().isTouchScreenMode());
        this.exportPdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().exportPdfAction();
            }
        });
        toolBar.add(this.exportPdfButton);
        toolBar.addSeparator();
        this.exportButton = new ToolbarButton("img/gui/export.png", Messages.getInstance().get("main_frame_menu_export_to_fsx"), SettingsBean.getInstance().isTouchScreenMode());
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().fsxExportAction();
            }
        });
        toolBar.add(this.exportButton);
        this.importButton = new ToolbarButton("img/gui/import.png", Messages.getInstance().get("main_frame_menu_import_from_fsx"), SettingsBean.getInstance().isTouchScreenMode());
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().fsxImportAction();
            }
        });
        toolBar.add(this.importButton);
        toolBar.addSeparator();
        this.searchButton = new ToolbarButton("img/gui/magnifier.png", Messages.getInstance().get("popup_menu_search"), SettingsBean.getInstance().isTouchScreenMode());
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().search();
            }
        });
        toolBar.add(this.searchButton);
        this.addRouteButton = new ToolbarButton("img/gui/add_route.png", Messages.getInstance().get("popup_menu_add_route"), SettingsBean.getInstance().isTouchScreenMode());
        this.addRouteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.addRouteAction();
            }
        });
        toolBar.add(this.addRouteButton);
        if (!SettingsBean.getInstance().isOfflineMode()) {
            toolBar.addSeparator();
            this.weatherButton = new ToolbarButton("img/gui/weather.png", Messages.getInstance().get("toolbar_tooltip_weather_update"), SettingsBean.getInstance().isTouchScreenMode());
            this.weatherButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (MapFrame.this.getUIPanel().updateWeatherStationsActionStart() && MapFrame.this.getUIPanel().getWeatherCollapsablePanel() != null) {
                        MapFrame.this.getUIPanel().getWeatherCollapsablePanel().setExpanded(true);
                    }
                }
            });
            toolBar.add(this.weatherButton);
            this.weatherMeteoButton = new ToolbarButton("img/gui/weather_meteo.png", Messages.getInstance().get("toolbar_tooltip_weather_meteo"), SettingsBean.getInstance().isTouchScreenMode());
            this.weatherMeteoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MapFrame.this.getUIPanel().getMeteoWeatherAction();
                }
            });
            toolBar.add(this.weatherMeteoButton);
        }
        toolBar.addSeparator();
        this.terrailLayerButton = new ToolbarButton("img/gui/terrain_layer.png", Messages.getInstance().get("popup_menu_add_terrain_layer"), SettingsBean.getInstance().isTouchScreenMode());
        this.terrailLayerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.terrainLayerDialogAction();
            }
        });
        toolBar.add(this.terrailLayerButton);
        this.removeTerrainLayerButton = new ToolbarButton("img/gui/remove_layer.png", Messages.getInstance().get("popup_menu_remove_terrain_layer"), SettingsBean.getInstance().isTouchScreenMode());
        this.removeTerrainLayerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.removeTerrainLayerAction();
            }
        });
        toolBar.add(this.removeTerrainLayerButton);
        this.verticalProfileButton = new ToolbarButton("img/gui/vertical_profile.png", Messages.getInstance().get("popup_menu_calculate_vertical_profile_dialog"), SettingsBean.getInstance().isTouchScreenMode());
        this.verticalProfileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.verticalProfileDialogAction();
            }
        });
        toolBar.add(this.verticalProfileButton);
        toolBar.addSeparator();
        this.calculateButton = new ToolbarButton("img/gui/calculate.png", Messages.getInstance().get("main_frame_menu_flight_plan_calculate"), SettingsBean.getInstance().isTouchScreenMode());
        this.calculateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().calculateAction();
            }
        });
        toolBar.add(this.calculateButton);
        toolBar.addSeparator();
        this.wnbButton = new ToolbarButton("img/gui/wnb.png", Messages.getInstance().get("main_frame_menu_weight_and_balance"), SettingsBean.getInstance().isTouchScreenMode());
        this.wnbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.wnbAction();
            }
        });
        toolBar.add(this.wnbButton);
        this.userPointsButton = new ToolbarButton("img/gui/table.png", Messages.getInstance().get("main_frame_menu_flight_plan_user_points"), SettingsBean.getInstance().isTouchScreenMode());
        this.userPointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().userPointsFrameAction();
            }
        });
        toolBar.add(this.userPointsButton);
        this.settingsButton = new ToolbarButton("img/gui/settings.png", Messages.getInstance().get("main_frame_menu_flight_plan_settings"), SettingsBean.getInstance().isTouchScreenMode());
        this.settingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().settingsAction();
            }
        });
        toolBar.add(this.settingsButton);
        if (withMiscButtons) {
            toolBar.addSeparator();
            this.createMiscToolbarButtons(toolBar);
        }
        toolBar.addSeparator();
        this.connectionCombo = new JComboBox();
        this.connectionCombo.setModel(new DefaultComboBoxModel<StringComboBoxItem>(SettingsBean.getInstance().getConnectionValuesCombo()));
        this.connectionCombo.setMaximumSize(new Dimension(120, 20));
        toolBar.add(this.connectionCombo);
        this.connectButton = new ToolbarButton("img/gui/connect.png", Messages.getInstance().get("main_frame_menu_sim_connect"), SettingsBean.getInstance().isTouchScreenMode());
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().simConnectAction();
            }
        });
        toolBar.add(this.connectButton);
        return toolbarWrapper;
    }

    private JMenuBar createMenuBar() {
        this.mainMenuBar = new JMenuBar();
        this.createFileMenu(this.mainMenuBar);
        this.createPlanMenu(this.mainMenuBar);
        this.createToolsMenu(this.mainMenuBar);
        this.createViewMenu(this.mainMenuBar);
        this.createHelpMenu(this.mainMenuBar);
        return this.mainMenuBar;
    }

    private void createFileMenu(JMenuBar mainMenuBar) {
        this.fileMenu = new JMenu(Messages.getInstance().get("main_frame_menu_file"));
        mainMenuBar.add(this.fileMenu);
        JMenuItem newMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_file_new"));
        newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().newAction();
            }
        });
        this.fileMenu.add(newMenuItem);
        JMenuItem loadMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_file_open"));
        loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().loadAction();
            }
        });
        this.fileMenu.add(loadMenuItem);
        JMenuItem saveMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_file_save"));
        saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().saveAction();
            }
        });
        this.fileMenu.add(saveMenuItem);
        JMenuItem saveAsMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_file_save_as"));
        saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.getUIPanel().saveAsAction();
            }
        });
        this.fileMenu.add(saveAsMenuItem);
        JMenuItem exitMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_file_exit"));
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.closeAction();
            }
        });
        this.fileMenu.add(exitMenuItem);
        this.fileMenu.addSeparator();
        this.recentLoadedFilesMenu = new JMenu(Messages.getInstance().get("main_frame_menu_file_recent_files"));
        this.fileMenu.add(this.recentLoadedFilesMenu);
        if (!SettingsBean.getInstance().isOfflineMode()) {
            this.dropboxFilesMenu = new JMenu(Messages.getInstance().get("main_frame_menu_file_dropbox_files"));
            this.fileMenu.add(this.dropboxFilesMenu);
            this.updateDropboxMenu();
        }
    }

    private void createPlanMenu(JMenuBar mainMenuBar) {
        this.planMenu = new JMenu(Messages.getInstance().get("main_frame_menu_flight_plan"));
        mainMenuBar.add(this.planMenu);
        JMenuItem calculateMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_calculate"));
        calculateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().calculateAction();
            }
        });
        this.planMenu.add(calculateMenuItem);
        this.planMenu.addSeparator();
        JMenu routePointsMenu = new JMenu(Messages.getInstance().get("main_frame_menu_flight_plan_route_points"));
        this.planMenu.add(routePointsMenu);
        JMenuItem routePointsAddToDB = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_route_points_add_as_to_user_points"));
        routePointsAddToDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().addPointsToDBAction();
            }
        });
        routePointsMenu.add(routePointsAddToDB);
        JMenuItem routePointsClearAll = new JMenuItem(Messages.getInstance().get("clear_all"));
        routePointsClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().routePointsClearAllAction();
            }
        });
        routePointsMenu.add(routePointsClearAll);
        JMenu vorsMenu = new JMenu(Messages.getInstance().get("main_frame_menu_flight_plan_vors"));
        this.planMenu.add(vorsMenu);
        JMenu weatherMenu = new JMenu(Messages.getInstance().get("main_frame_menu_flight_plan_weather"));
        this.planMenu.add(weatherMenu);
        JMenuItem exportPdf = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_weather_export_pdf"));
        exportPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().exportWeatherAction();
            }
        });
        weatherMenu.add(exportPdf);
        JMenuItem userPointsMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_user_points"));
        userPointsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().userPointsFrameAction();
            }
        });
        this.planMenu.add(userPointsMenuItem);
        JMenuItem vorsAddToDB = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_route_points_add_as_to_user_points"));
        vorsAddToDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().addVorsToDBAction();
            }
        });
        vorsMenu.add(vorsAddToDB);
        JMenuItem vorClearAll = new JMenuItem(Messages.getInstance().get("clear_all"));
        vorClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().vorClearAllAction();
            }
        });
        vorsMenu.add(vorClearAll);
        this.planMenu.addSeparator();
        JMenu exportMenu = new JMenu(Messages.getInstance().get("main_frame_menu_export"));
        this.planMenu.add(exportMenu);
        JMenuItem exportFsxMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_export_to_fsx"));
        exportFsxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().fsxExportAction();
            }
        });
        exportMenu.add(exportFsxMenuItem);
        JMenuItem exportToXplaneFmsMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_xplane_fms"));
        exportToXplaneFmsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().xplaneFmsExportAction();
            }
        });
        exportMenu.add(exportToXplaneFmsMenuItem);
        JMenuItem exportGeMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_google_earth"));
        exportGeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().googleEarthExportAction();
            }
        });
        exportMenu.add(exportGeMenuItem);
        JMenuItem exportPdfMenuItem = new JMenuItem(Messages.getInstance().get("toolbar_tooltip_export_pdf"));
        exportPdfMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().exportPdfAction();
            }
        });
        exportMenu.add(exportPdfMenuItem);
        JMenuItem exportToAppMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_android_app"));
        exportToAppMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SettingsBean.getInstance().isAppExportAvailable()) {
                    MapFrame.this.getUIPanel().androidAppExportAction();
                }
            }
        });
        exportMenu.add(exportToAppMenuItem);
        JMenu importMenu = new JMenu(Messages.getInstance().get("main_frame_menu_import"));
        this.planMenu.add(importMenu);
        JMenuItem importFsxMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_fsx"));
        importFsxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().fsxImportAction();
            }
        });
        importMenu.add(importFsxMenuItem);
        JMenuItem importXplaneMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_xplane_fms"));
        importXplaneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().xplaneImportAction();
            }
        });
        importMenu.add(importXplaneMenuItem);
        JMenuItem importGeMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_google_earth"));
        importGeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().googleEarthImportAction();
            }
        });
        importMenu.add(importGeMenuItem);
        this.planMenu.addSeparator();
        JMenuItem settingsMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_flight_plan_settings"));
        settingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().settingsAction();
            }
        });
        this.planMenu.add(settingsMenuItem);
    }

    private void createViewMenu(JMenuBar mainMenuBar) {
        this.viewMenu = new JMenu(Messages.getInstance().get("main_frame_menu_view"));
        mainMenuBar.add(this.viewMenu);
        JCheckBoxMenuItem gpsModeMenuItem = new JCheckBoxMenuItem(Messages.getInstance().get("gps_mode_button"), this.gpsMap != null);
        gpsModeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.toggleGpsMapConnection();
            }
        });
        this.viewMenu.add(gpsModeMenuItem);
        JCheckBoxMenuItem touchscreenModeMenuItem = new JCheckBoxMenuItem(Messages.getInstance().get("toggle_touch_screen_mode"), SettingsBean.getInstance().isTouchScreenMode());
        touchscreenModeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.toggleTouchScreenMode();
            }
        });
        this.viewMenu.add(touchscreenModeMenuItem);
        JMenuItem fullscreenModeMenuItem = new JMenuItem(Messages.getInstance().get("switch_to_fullscreen_mode"));
        fullscreenModeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.switchToFullScreenMode();
            }
        });
        this.viewMenu.add(fullscreenModeMenuItem);
    }

    private void createToolsMenu(JMenuBar mainMenuBar) {
        this.toolsMenu = new JMenu(Messages.getInstance().get("main_frame_menu_tools"));
        mainMenuBar.add(this.toolsMenu);
        JMenuItem wnbMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_weight_and_balance"));
        wnbMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.wnbAction();
            }
        });
        this.toolsMenu.add(wnbMenuItem);
        this.toolsMenu.addSeparator();
        JMenuItem importFsxDataMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_import_fsx_data"));
        importFsxDataMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().importFsxDataAction();
            }
        });
        this.toolsMenu.add(importFsxDataMenuItem);
        JMenuItem importXplaneDataMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_import_xplane_data"));
        importXplaneDataMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XplaneImportDataStep1Dialog fidDialog = new XplaneImportDataStep1Dialog(MapFrame.this, new SceneryConfigPathsBean());
                fidDialog.setVisible(true);
            }
        });
        this.toolsMenu.add(importXplaneDataMenuItem);
        JMenuItem importAixmMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_import_aixm_data"));
        importAixmMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().importAixmDataAction();
            }
        });
        this.toolsMenu.add(importAixmMenuItem);
        JMenuItem importDataFilesMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_import_data_files_data"));
        importDataFilesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().importDataFilesAction();
            }
        });
        this.toolsMenu.add(importDataFilesMenuItem);
        JMenuItem importOpenAipMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_import_open_aip_data"));
        importOpenAipMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().importOpenAipDataAction();
            }
        });
        this.toolsMenu.add(importOpenAipMenuItem);
        this.toolsMenu.addSeparator();
        JMenuItem importXmlMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_import_xml_data"));
        importXmlMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().importXmlDataAction();
            }
        });
        this.toolsMenu.add(importXmlMenuItem);
        JMenuItem exportXmlMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_export_xml_data"));
        exportXmlMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().exportXmlDataAction();
            }
        });
        this.toolsMenu.add(exportXmlMenuItem);
        this.toolsMenu.addSeparator();
        JMenu simconnectMenu = new JMenu(Messages.getInstance().get("main_frame_menu_sim_connect_menu"));
        this.toolsMenu.add(simconnectMenu);
        this.simConnectMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_sim_connect"));
        this.simConnectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().simConnectAction();
            }
        });
        simconnectMenu.add(this.simConnectMenuItem);
        simconnectMenu.addSeparator();
        JMenuItem importFromCsv = new JMenuItem(Messages.getInstance().get("popup_menu_import_track_from_csv"));
        importFromCsv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimConnectUtil.importUserTrackToCsvAction();
            }
        });
        simconnectMenu.add(importFromCsv);
    }

    private void createHelpMenu(JMenuBar mainMenuBar) {
        this.helpMenu = new JMenu(Messages.getInstance().get("main_frame_menu_help"));
        mainMenuBar.add(this.helpMenu);
        JMenuItem documentationMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_help_documentation"));
        documentationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().documentationAction();
            }
        });
        this.helpMenu.add(documentationMenuItem);
        this.helpMenu.addSeparator();
        if (!SettingsBean.getInstance().isOfflineMode()) {
            JMenuItem feedbackMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_help_feedback"));
            feedbackMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MapFrame.this.getUIPanel().feedbackAction();
                }
            });
            this.helpMenu.add(feedbackMenuItem);
            JMenuItem facebookMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_help_facebook"));
            facebookMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MapFrame.this.getUIPanel().facebookAction();
                }
            });
            this.helpMenu.add(facebookMenuItem);
            JMenuItem youtubeMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_help_youtube"));
            youtubeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MapFrame.this.getUIPanel().youtubeAction();
                }
            });
            this.helpMenu.add(youtubeMenuItem);
            this.helpMenu.addSeparator();
        }
        JMenuItem aboutMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_help_about"));
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.this.getUIPanel().aboutAction();
            }
        });
        this.helpMenu.add(aboutMenuItem);
    }

    public void updateDropboxMenu() {
        this.dropboxFilesMenu.removeAll();
        if (SettingsBean.getInstance().getDropboxBean().isAuthorized()) {
            List<String> files = SettingsBean.getInstance().getDropboxBean().getRootFileList();
            if (files.size() > 0) {
                for (String file : files) {
                    JMenuItem fileMenuItem = new JMenuItem(file);
                    fileMenuItem.addActionListener(new DownloadDropboxFileActionListener(file));
                    this.dropboxFilesMenu.add(fileMenuItem);
                }
            } else {
                JMenuItem noFilesItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_file_dropbox_no_files"));
                noFilesItem.setEnabled(false);
                this.dropboxFilesMenu.add(noFilesItem);
            }
            this.dropboxFilesMenu.add(new JSeparator());
            JMenuItem uploadCurrentPlanMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_file_dropbox_files_manager"));
            uploadCurrentPlanMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DropboxFilesDialog dialog = new DropboxFilesDialog(MapFrame.this);
                    dialog.setVisible(true);
                }
            });
            this.dropboxFilesMenu.add(uploadCurrentPlanMenuItem);
            JMenuItem disconnectFromDropboxMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_file_dropbox_files_disconnect"));
            disconnectFromDropboxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SettingsBean.getInstance().getDropboxBean().disconnect();
                    MapFrame.this.updateDropboxMenu();
                }
            });
            this.dropboxFilesMenu.add(disconnectFromDropboxMenuItem);
        } else {
            JMenuItem connectToDropboxMenuItem = new JMenuItem(Messages.getInstance().get("main_frame_menu_file_dropbox_files_connect"));
            connectToDropboxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DropboxConnectionDialog dialog = new DropboxConnectionDialog(MapFrame.this);
                    dialog.setVisible(true);
                }
            });
            this.dropboxFilesMenu.add(connectToDropboxMenuItem);
        }
    }

    public void hidePanel() {
        this.getUIPanel().hidePanel();
    }

    public void showPanel() {
        this.getUIPanel().showPanel();
    }

    public JMenuItem getSimConnectMenuItem() {
        return this.simConnectMenuItem;
    }

    public void setSimConnectMenuItem(JMenuItem simConnectMenuItem) {
        this.simConnectMenuItem = simConnectMenuItem;
    }

    public String getPreviousTitle() {
        return this.previousTitle;
    }

    public void setPreviousTitle(String previousTitle) {
        this.previousTitle = previousTitle;
    }

    public JMenu getRecentLoadedFilesMenu() {
        return this.recentLoadedFilesMenu;
    }

    public void setRecentLoadedFilesMenu(JMenu recentLoadedFilesMenu) {
        this.recentLoadedFilesMenu = recentLoadedFilesMenu;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public void setFileMenu(JMenu fileMenu) {
        this.fileMenu = fileMenu;
    }

    public JMenu getPlanMenu() {
        return this.planMenu;
    }

    public void setPlanMenu(JMenu planMenu) {
        this.planMenu = planMenu;
    }

    public JMenu getToolsMenu() {
        return this.toolsMenu;
    }

    public void setToolsMenu(JMenu toolsMenu) {
        this.toolsMenu = toolsMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public void setHelpMenu(JMenu helpMenu) {
        this.helpMenu = helpMenu;
    }

    public FlightPlanMainPanel getUIPanel() {
        return this.UIPanel;
    }

    public void toggleUIPanelAction() {
        this.getUIPanel().setVisible(!this.getUIPanel().isVisible());
        this.showUIPanel = this.getUIPanel().isVisible();
        this.updateUIPanelButtonIcon();
        this.setMapViewerBounds();
        this.repaint();
    }

    public void enableUIPanelToggleButton(boolean enable) {
        this.toggleUIPanelButton.setEnabled(enable);
        this.setMapViewerBounds();
    }

    public boolean isShowUIPanel() {
        return this.showUIPanel;
    }

    public void setShowUIPanel(boolean showUIPanel) {
        this.showUIPanel = showUIPanel;
    }

    public void updateUIPanelButtonIcon() {
        if (SettingsBean.getInstance().isTouchScreenMode()) {
            this.toggleUIPanelButton.setIcon(this.getUIPanel().isVisible() ? GraphicsUtil.getResizedIcon("img/gui/hide.png", 1.5) : GraphicsUtil.getResizedIcon("img/gui/show.png", 1.5));
        } else {
            this.toggleUIPanelButton.setIcon(this.getUIPanel().isVisible() ? new ImageIcon("img/gui/hide.png") : new ImageIcon("img/gui/show.png"));
        }
    }

    public JButton getConnectButton() {
        return this.connectButton;
    }

    public void setConnectButton(JButton connectButton) {
        this.connectButton = connectButton;
    }

    private void wnbAction() {
        WeightAndBalanceDialog wnbDialog = new WeightAndBalanceDialog(this);
        wnbDialog.setVisible(true);
    }

    public void setMenuEnabled(boolean enable) {
        this.fileMenu.setEnabled(enable);
        this.planMenu.setEnabled(enable);
        this.toolsMenu.setEnabled(enable);
        this.viewMenu.setEnabled(enable);
        this.helpMenu.setEnabled(enable);
    }

    public void setMapLayersToolbarEnabled(boolean enable) {
        this.showTextButton.setEnabled(enable);
        this.showVorButton.setEnabled(enable);
        this.showNdbButton.setEnabled(enable);
        this.showAirportsButton.setEnabled(enable);
        this.showRunwayExtensionsButton.setEnabled(enable);
        this.showTaxiwaysButton.setEnabled(enable);
        this.showIlsButton.setEnabled(enable);
        this.showMsaButton.setEnabled(enable);
        this.showTerrainButton.setEnabled(enable);
        this.showObstacleButton.setEnabled(enable);
        this.showAirspacesButton.setEnabled(enable);
        this.showVfrPtButton.setEnabled(enable);
        this.showAIfrPtButton.setEnabled(enable);
        this.showIfrRteButton.setEnabled(enable);
        this.showWeatherButton.setEnabled(enable);
        this.showUserPointsButton.setEnabled(enable);
        this.showCitiesButton.setEnabled(enable);
        this.showUserTrackButton.setEnabled(enable);
        this.showMapGridButton.setEnabled(enable);
        this.showMagVarButton.setEnabled(enable);
        this.layersOrderButton.setEnabled(enable);
        this.regionsComboBox.setEnabled(enable);
    }

    public void setToolbarEnabled(boolean enable) {
        this.newButton.setEnabled(enable);
        this.loadButton.setEnabled(enable);
        this.saveButton.setEnabled(enable);
        this.exportButton.setEnabled(enable);
        this.importButton.setEnabled(enable);
        this.searchButton.setEnabled(enable);
        this.calculateButton.setEnabled(enable);
        this.userPointsButton.setEnabled(enable);
        this.settingsButton.setEnabled(enable);
        this.connectButton.setEnabled(enable);
        this.wnbButton.setEnabled(enable);
        this.terrailLayerButton.setEnabled(enable);
        this.removeTerrainLayerButton.setEnabled(enable);
        this.verticalProfileButton.setEnabled(enable);
        this.addRouteButton.setEnabled(enable);
        this.exportPdfButton.setEnabled(enable);
        this.fullscreenButton.setEnabled(enable);
        this.touchScreenButton.setEnabled(enable);
        this.gpsModeButton.setEnabled(enable);
        if (this.aboutButton != null) {
            this.aboutButton.setEnabled(enable);
        }
        if (!SettingsBean.getInstance().isOfflineMode()) {
            if (this.contactButton != null) {
                this.contactButton.setEnabled(enable);
            }
            if (this.facebookButton != null) {
                this.facebookButton.setEnabled(enable);
            }
            if (this.youtubeButton != null) {
                this.youtubeButton.setEnabled(enable);
            }
            this.weatherButton.setEnabled(enable);
            this.weatherMeteoButton.setEnabled(enable);
        }
        this.underCursorTextCheckBox.setEnabled(enable);
    }

    public void setBottomToolbarEnabled(boolean enable) {
        this.alwaysOnTopButton.setEnabled(enable);
        this.calculateInRealTimeButton.setEnabled(enable);
        this.magnifyingGlassButton.setEnabled(enable);
        this.coordsCursorButton.setEnabled(enable);
        this.compassButton.setEnabled(enable);
        this.distanceCirclesButton.setEnabled(enable);
        this.enableMeasurementLineButton.setEnabled(enable);
        this.multipleRulersButton.setEnabled(enable);
        this.mapTypeComboBox.setEnabled(enable);
        this.editMapTypes.setEnabled(enable);
        this.downloadMapButton.setEnabled(enable);
        this.measurementDistanceCombo.setEnabled(enable);
    }

    public ToolbarStateButton getAlwaysOnTopButton() {
        return this.alwaysOnTopButton;
    }

    public void setAlwaysOnTopButton(ToolbarStateButton alwaysOnTopButton) {
        this.alwaysOnTopButton = alwaysOnTopButton;
    }

    public ToolbarStateButton getGpsModeButton() {
        return this.gpsModeButton;
    }

    public void setGpsModeButton(ToolbarStateButton gpsModeButton) {
        this.gpsModeButton = gpsModeButton;
    }

    public ToolbarButton getLayersOrderButton() {
        return this.layersOrderButton;
    }

    public void setLayersOrderButton(ToolbarButton layersOrderButton) {
        this.layersOrderButton = layersOrderButton;
    }

    public void terrainLayerDialogAction() {
        TerrainLayerDialog dialog = new TerrainLayerDialog(this);
        dialog.setVisible(true);
    }

    public void removeTerrainLayerAction() {
        if (MapObjectsBean.getInstance().isTerrainMesh()) {
            TerrainLayerDialog.removeTerrainLayerAction();
            this.updateMap();
        }
        this.getUIPanel().updateUIFilter();
    }

    public void verticalProfileDialogAction() {
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 1) {
            VerticalProfileMainDialog dialog = new VerticalProfileMainDialog(this);
            dialog.setVisible(true);
        }
    }

    public void addRouteAction() {
        new AddRouteDialog().setVisible(true);
    }

    public void mapPriorityAction() {
        MapPriorityDialog dialog = new MapPriorityDialog(this);
        dialog.setVisible(true);
    }

    public List<TileFactoryInfo> getTileFactoriesInfo() {
        if (this.tileFactoriesInfo == null) {
            this.tileFactoriesInfo = new ArrayList<TileFactoryInfo>();
        }
        return this.tileFactoriesInfo;
    }

    public void setTileFactoriesInfo(List<TileFactoryInfo> tileFactoriesInfo) {
        this.tileFactoriesInfo = tileFactoriesInfo;
    }

    public List<ColorTheme> getTileFactoriesThemes() {
        if (this.tileFactoriesThemes == null) {
            this.tileFactoriesThemes = new ArrayList<ColorTheme>();
        }
        return this.tileFactoriesThemes;
    }

    public void setTileFactoriesThemes(List<ColorTheme> tileFactoriesThemes) {
        this.tileFactoriesThemes = tileFactoriesThemes;
    }

    public JCheckBox getUnderCursorTextCheckBox() {
        return this.underCursorTextCheckBox;
    }

    public void setUnderCursorTextCheckBox(JCheckBox underCursorTextCheckBox) {
        this.underCursorTextCheckBox = underCursorTextCheckBox;
    }

    public void setPlaceTempHighlightMode(GpsPlace place) {
        this.setMarkerPlace(place);
        this.getMapViewer().setMapMode(MapMode.PLACE_TEMP_HIGHLIGHT);
        this.updateMap();
    }

    public boolean isCalculationResultPaintDistanceAndTime() {
        return this.mapViewer.isCalculationResultPaintDistanceAndTime();
    }

    public void setCalculationResultPaintDistanceAndTime(boolean calculationResultPaintDistanceAndTime) {
        this.mapViewer.setCalculationResultPaintDistanceAndTime(calculationResultPaintDistanceAndTime);
    }

    public JPanel getMapSouthPanel() {
        return this.mapSouthPanel;
    }

    public void setMapSouthPanel(JPanel mapSouthPanel) {
        this.mapSouthPanel = mapSouthPanel;
    }

    public void toggleShowUserTrackAction() {
        this.showUserTrackButton.toggle();
    }

    public void syncUIWithData() {
        this.getUIPanel().getMeteoMapCollapsablePanel().setVisible(this.isMeteoMap());
    }

    public boolean isMeteoMap() {
        int idx;
        if (this.mapTypeComboBox != null && this.getUIPanel().getMeteoMapCollapsablePanel() != null && (idx = this.mapTypeComboBox.getSelectedIndex()) > 0) {
            return TileFactoryInfoType.METEO.equals((Object)this.getTileFactoriesInfo().get(idx - 1).getType());
        }
        return false;
    }

    public void syncUIWithDataInDB() {
        ElevationFacade elevationFacade = new ElevationFacade(DBUtil.getDataSource());
        this.showMsaButton.setVisible(elevationFacade.getElevationsNumber() > 0L);
        AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
        boolean anyAirports = airportFacade.getAirportsNumber() > 0L;
        this.getUIPanel().getAirportsFilterCollapsablePanel().setVisible(anyAirports);
        MapObjectsBean.getInstance().getAirportFilter().clear();
        this.showAirportsButton.setVisible(anyAirports);
        this.showRunwayExtensionsButton.setVisible(anyAirports);
        this.showTaxiwaysButton.setVisible(airportFacade.getTaxiwaysNumber() > 0L || airportFacade.getRunwaysWithNotNulPosNumber() > 0L);
        this.showIlsButton.setVisible(airportFacade.getIlsNumber() > 0L);
        this.showObstacleButton.setVisible(airportFacade.getIlsNumber() > 0L);
        this.showRunwayExtensionsButton.setVisible(airportFacade.getRunwaysWithNotNulPosNumber() > 0L);
        ObstacleFacade obstacleFacade = new ObstacleFacade(DBUtil.getDataSource());
        boolean anyObstacles = obstacleFacade.getObstaclesNumber() > 0L;
        this.showObstacleButton.setVisible(anyObstacles);
        this.getUIPanel().getObstaclesFilterCollapsablePanel().setVisible(anyObstacles);
        MapObjectsBean.getInstance().getObstacleFilter().clear();
        AirspaceFacade airspaceFacade = new AirspaceFacade(DBUtil.getDataSource());
        boolean anyAirspaces = airspaceFacade.getAirspacesNumber() > 0L;
        this.showAirspacesButton.setVisible(anyAirspaces);
        this.getUIPanel().getAirspacesFilterCollapsablePanel().setVisible(anyAirspaces);
        MapObjectsBean.getInstance().getAirspaceFilter().clear();
        this.showVfrPtButton.setVisible(airportFacade.getVfrPointsNumber() > 0L);
        IfrRouteFacade ifrFacade = new IfrRouteFacade(DBUtil.getDataSource());
        this.showAIfrPtButton.setVisible(ifrFacade.getIfrPointsNumber() > 0L);
        this.showIfrRteButton.setVisible(ifrFacade.getIfrRoutesNumber() > 0L);
        CityFacade cityFacade = new CityFacade(DBUtil.getDataSource());
        this.showCitiesButton.setVisible(cityFacade.getCitiesNumber() > 0L);
        this.getUIPanel().getUserPointsFilterCollapsablePanel().updateUserPointsTags();
        this.getUIPanel().getAirspacesFilterCollapsablePanel().updateAirspacesTypes();
        SettingsBean.getInstance().getRouteCreatorBean().setAirportsIdents(null);
        this.syncUIWithData();
    }

    public void downloadZipWithHgt(String zip) {
        String fileName;
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("save_file"), Messages.getInstance().get("save"));
        chooser.setSelectedFile(new File(UrlUtil.getFilenameFromPath(zip)));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (!new File(fileName = chooser.getSelectedFile().getAbsolutePath()).exists() || GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("save_file"), Messages.getInstance().get("file_saving_dialog_overwrite_question")))) {
            try {
                IOUtil.downloadFile(zip, fileName);
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("popup_menu_download_zip_with_hgt_success"), "", 1);
            }
            catch (IOException e1) {
                log.error(e1, e1);
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("popup_menu_download_zip_with_hgt_error"), "", 0);
            }
        }
    }

    public JComboBox<StringComboBoxItem> getConnectionCombo() {
        return this.connectionCombo;
    }

    public void setConnectionCombo(JComboBox<StringComboBoxItem> connectionCombo) {
        this.connectionCombo = connectionCombo;
    }

    public ToolbarButton getFullscreenButton() {
        return this.fullscreenButton;
    }

    public void setFullscreenButton(ToolbarButton fullscreenButton) {
        this.fullscreenButton = fullscreenButton;
    }

    public ToolbarStateButton getShowWeatherButton() {
        return this.showWeatherButton;
    }

    public JButton getPrevRouteButton() {
        return this.prevRouteButton;
    }

    public JButton getNextRouteButton() {
        return this.nextRouteButton;
    }
}

