/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;

public class MagvarWarningDialog
extends JDialog {
    private static final long serialVersionUID = 9159649316937343948L;
    private JCheckBox dontShowAgainCheckBox;
    private Boolean result = null;

    public MagvarWarningDialog(Window frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MagvarWarningDialog.this.closeWindowAction(null);
            }
        });
        this.setTitle(Messages.getInstance().get("dialog_warning"));
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "South");
        JButton yesButton = new JButton(Messages.getInstance().get("yes"));
        yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagvarWarningDialog.this.closeWindowAction(true);
            }
        });
        buttonPanel.add(yesButton);
        JButton noButton = new JButton(Messages.getInstance().get("no"));
        noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagvarWarningDialog.this.closeWindowAction(false);
            }
        });
        buttonPanel.add(noButton);
        JPanel resultsTablePanel = new JPanel();
        panel.add((Component)resultsTablePanel, "Center");
        GridBagLayout gbl_resultsTablePanel = new GridBagLayout();
        gbl_resultsTablePanel.columnWidths = new int[]{494};
        gbl_resultsTablePanel.rowHeights = new int[]{40, 23};
        gbl_resultsTablePanel.columnWeights = new double[]{0.0};
        gbl_resultsTablePanel.rowWeights = new double[]{0.0, 0.0};
        resultsTablePanel.setLayout(gbl_resultsTablePanel);
        JPanel panel_2 = new JPanel();
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.fill = 1;
        gbc_panel_2.insets = new Insets(0, 0, 5, 0);
        gbc_panel_2.gridx = 0;
        gbc_panel_2.gridy = 0;
        resultsTablePanel.add((Component)panel_2, gbc_panel_2);
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("magvar_warning_dialog_content"));
        panel_2.add(lblNewLabel);
        this.dontShowAgainCheckBox = new JCheckBox(Messages.getInstance().get("dont_show_again"));
        this.dontShowAgainCheckBox.setHorizontalAlignment(0);
        GridBagConstraints gbc_dontShowAgainCheckBox = new GridBagConstraints();
        gbc_dontShowAgainCheckBox.anchor = 11;
        gbc_dontShowAgainCheckBox.fill = 2;
        gbc_dontShowAgainCheckBox.gridx = 0;
        gbc_dontShowAgainCheckBox.gridy = 1;
        resultsTablePanel.add((Component)this.dontShowAgainCheckBox, gbc_dontShowAgainCheckBox);
        JPanel panel_1 = new JPanel();
        panel.add((Component)panel_1, "North");
        panel_1.setLayout(new BorderLayout(0, 0));
        this.setSize(500, 120);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.setModal(true);
    }

    public Boolean getResult() {
        return this.result;
    }

    public void setResult(Boolean result) {
        this.result = result;
    }

    public void closeWindowAction(Boolean result) {
        this.result = result;
        if (result != null) {
            SettingsBean.getInstance().setParamFsxP3dMode(result);
            SettingsBean.getInstance().setParamImportMagvarShowWarning(!this.dontShowAgainCheckBox.isSelected());
        }
        this.setVisible(false);
    }
}

