/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.SegmentLandmark;
import main.java.guru.vfrflight.util.StringUtil;

public class LandmarkInfoDialog
extends JDialog {
    private static final long serialVersionUID = -2665812617996808725L;
    private SegmentLandmark landmark;
    private JTextArea descTextArea;

    public LandmarkInfoDialog(JFrame frame, SegmentLandmark landmark) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                LandmarkInfoDialog.this.closeWindowAction();
            }
        });
        this.landmark = landmark;
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LandmarkInfoDialog.this.okAction();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LandmarkInfoDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(cancelButton);
        JPanel panel_5 = new JPanel();
        panel_3.add((Component)panel_5, "North");
        panel_5.setBorder(new EtchedBorder(1, null, null));
        panel_5.setLayout(new BorderLayout(0, 0));
        JPanel panel_6 = new JPanel();
        panel_6.setBorder(new EmptyBorder(0, 5, 0, 5));
        panel_5.add((Component)panel_6, "Center");
        panel_6.setLayout(new BorderLayout(0, 0));
        this.descTextArea = new JTextArea(StringUtil.nullToEmpty(landmark.getDescription()));
        this.descTextArea.setColumns(50);
        this.descTextArea.setRows(3);
        panel_6.add(this.descTextArea);
        JPanel panel = new JPanel();
        panel_6.add((Component)panel, "North");
        JLabel descLabel = new JLabel(Messages.getInstance().get("landmark_info_dialog_desc"));
        panel.add(descLabel);
        this.setModal(true);
        this.setSize(300, 140);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void okAction() {
        this.landmark.setDescription(StringUtil.isEmpty(this.descTextArea.getText()) ? null : this.descTextArea.getText());
        this.closeWindowAction();
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }
}

