/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.ExtensionFileFilter;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.sql.IntToGpsMap;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.panel.image.ImageViewerPanel;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class ImageLayerFrame
extends JFrame {
    private static final long serialVersionUID = 4352541330703105234L;
    private ImageViewerPanel imagePanel;
    private String filePath;

    public ImageLayerFrame() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                ImageLayerFrame.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_1 = new JPanel();
        this.getContentPane().add(panel_1);
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_1.add((Component)panel_2, "South");
        panel_2.setLayout(new BorderLayout(0, 0));
        JPanel centerPanel = new JPanel();
        panel_2.add((Component)centerPanel, "Center");
        centerPanel.setLayout(new FlowLayout(1, 5, 5));
        JPanel centerPanel_2 = new JPanel();
        centerPanel_2.setBorder(new EtchedBorder(1, null, null));
        JButton centerButton = new JButton(Messages.getInstance().get("map_frame_center"));
        centerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageLayerFrame.this.loadImageAction();
            }
        });
        centerPanel_2.add(centerButton);
        centerPanel.add(centerPanel_2);
        if (SettingsBean.getInstance().isOfflineMode()) {
            JPanel leftPanel = new JPanel();
            panel_2.add((Component)leftPanel, "West");
            JLabel offlineModeLabel = new JLabel(Messages.getInstance().get("map_frame_offline_mode"));
            offlineModeLabel.setFont(new Font("Tahoma", 1, 15));
            offlineModeLabel.setForeground(Color.RED);
            leftPanel.add(offlineModeLabel);
        }
        this.imagePanel = new ImageViewerPanel();
        this.imagePanel.setLayout(null);
        panel_1.add(this.imagePanel);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (SettingsBean.getInstance().getInitMapFrameSize() == null) {
            this.setSize((int)Math.round((double)dim.width * 0.8), (int)Math.round((double)dim.height * 0.8));
        } else {
            this.setSize((int)SettingsBean.getInstance().getInitMapFrameSize().getWidth(), (int)SettingsBean.getInstance().getInitMapFrameSize().getHeight());
        }
        if (SettingsBean.getInstance().getInitMapFramePosition() == null) {
            this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        } else {
            int x = (int)SettingsBean.getInstance().getInitMapFramePosition().getX();
            int y = (int)SettingsBean.getInstance().getInitMapFramePosition().getY();
            if (x > (int)((double)dim.width - this.getSize().getWidth())) {
                x = (int)((double)dim.width - this.getSize().getWidth());
            }
            if (y > (int)((double)dim.height - this.getSize().getHeight())) {
                y = (int)((double)dim.height - this.getSize().getHeight());
            }
            this.setLocation(x, y);
        }
        if (SettingsBean.getInstance().isInitMapFrameFullScreen()) {
            this.setExtendedState(6);
        }
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    public void start() {
        int returnVal;
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("open_file"), Messages.getInstance().get("open"));
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("vfrflight_flight_plans"), VfrUtil.getSupportedImageTypes()));
        if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getFile())) {
            chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getFile()));
        }
        if ((returnVal = chooser.showOpenDialog(MapFrame.getInstance())) == 0 && new File(chooser.getSelectedFile().getPath()).exists()) {
            SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
            this.filePath = chooser.getSelectedFile().getAbsolutePath();
            this.imagePanel.loadImage(this.filePath);
            this.setTitle(this.filePath);
            this.setVisible(true);
            MapFrame.getInstance().hidePanel();
            MapFrame.getInstance().lock();
        }
    }

    private void loadImageAction() {
        ArrayList<IntToGpsMap> map = new ArrayList<IntToGpsMap>();
        map.add(new IntToGpsMap(569.0, 268.0, 54.28308, 19.40553));
        map.add(new IntToGpsMap(491.0, 425.0, 53.90463, 18.88659));
        map.add(new IntToGpsMap(358.0, 83.0, 54.83258, 18.33625));
        map.add(new IntToGpsMap(101.0, 212.0, 54.58872, 16.85275));
        MapFrame.getInstance().updateMap();
        this.closeWindowAction();
    }

    private void closeWindowAction() {
        this.setVisible(false);
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().unlock();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

