/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.ExtensionFileFilter;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.combo.item.ComboBoxItem;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.AirportStart;
import main.java.guru.vfrflight.core.sql.filter.AirportFilter;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FsxUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.StringUtil;

public class FsxExportDialog
extends JDialog {
    private static final long serialVersionUID = 8803292807398680771L;
    private JTextField departureRwyTextField;
    private JComboBox<ComboBoxItem<AirportStart>> departurePositionComboBox;
    private JRadioButton vfrRadioButton;
    private JRadioButton ifrRadioButton;
    private JCheckBox showOnMapCheckbox;

    public FsxExportDialog(JFrame frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FsxExportDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("fsx_export_frame_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_2, "Center");
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{436};
        gbl_panel_2.rowHeights = new int[]{56, 38, 102};
        gbl_panel_2.columnWeights = new double[]{0.0};
        gbl_panel_2.rowWeights = new double[]{0.0, 0.0, 0.0};
        panel_2.setLayout(gbl_panel_2);
        JLabel lblPierwszyIOstatni = new JLabel(Messages.getInstance().get("fsx_export_frame_description"));
        lblPierwszyIOstatni.setVerticalAlignment(1);
        lblPierwszyIOstatni.setHorizontalAlignment(0);
        GridBagConstraints gbc_lblPierwszyIOstatni = new GridBagConstraints();
        gbc_lblPierwszyIOstatni.fill = 1;
        gbc_lblPierwszyIOstatni.insets = new Insets(0, 0, 5, 0);
        gbc_lblPierwszyIOstatni.gridx = 0;
        gbc_lblPierwszyIOstatni.gridy = 0;
        panel_2.add((Component)lblPierwszyIOstatni, gbc_lblPierwszyIOstatni);
        JPanel flightPlanTypePanel = new JPanel();
        flightPlanTypePanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_flightPlanTypePanel = new GridBagConstraints();
        gbc_flightPlanTypePanel.fill = 1;
        gbc_flightPlanTypePanel.insets = new Insets(0, 0, 5, 0);
        gbc_flightPlanTypePanel.gridx = 0;
        gbc_flightPlanTypePanel.gridy = 1;
        panel_2.add((Component)flightPlanTypePanel, gbc_flightPlanTypePanel);
        JLabel rulesLabel = new JLabel(Messages.getInstance().get("fsx_export_frame_flight_plan_type"));
        flightPlanTypePanel.add(rulesLabel);
        this.vfrRadioButton = new JRadioButton("VFR");
        flightPlanTypePanel.add(this.vfrRadioButton);
        this.vfrRadioButton.setSelected(true);
        this.ifrRadioButton = new JRadioButton("IFR");
        flightPlanTypePanel.add(this.ifrRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.vfrRadioButton);
        buttonGroup.add(this.ifrRadioButton);
        JPanel startingPlacePanel = new JPanel();
        startingPlacePanel.setBorder(new CompoundBorder(new EtchedBorder(1, null, null), new EmptyBorder(5, 0, 5, 0)));
        GridBagConstraints gbc_startingPlacePanel = new GridBagConstraints();
        gbc_startingPlacePanel.fill = 1;
        gbc_startingPlacePanel.gridx = 0;
        gbc_startingPlacePanel.gridy = 2;
        panel_2.add((Component)startingPlacePanel, gbc_startingPlacePanel);
        startingPlacePanel.setLayout(new BorderLayout(0, 0));
        JPanel departureDirectionPanel = new JPanel();
        departureDirectionPanel.setBorder(new EmptyBorder(0, 10, 5, 20));
        startingPlacePanel.add((Component)departureDirectionPanel, "North");
        departureDirectionPanel.setLayout(new BorderLayout(0, 0));
        JLabel lblKierunekOdlotuZ = new JLabel(Messages.getInstance().get("fsx_export_frame_departure_direction") + FlightPlanBean.getInstance().getRoute().getPoints().get(0).getName());
        departureDirectionPanel.add((Component)lblKierunekOdlotuZ, "West");
        this.departureRwyTextField = new JTextField();
        departureDirectionPanel.add((Component)this.departureRwyTextField, "East");
        this.departureRwyTextField.setHorizontalAlignment(0);
        this.departureRwyTextField.setText("36");
        this.departureRwyTextField.setColumns(5);
        JPanel parkingPlacePanel = new JPanel();
        startingPlacePanel.add((Component)parkingPlacePanel, "Center");
        GridBagLayout gbl_parkingPlacePanel = new GridBagLayout();
        gbl_parkingPlacePanel.columnWidths = new int[]{172, 70, 170};
        gbl_parkingPlacePanel.rowHeights = new int[]{22, 23};
        gbl_parkingPlacePanel.columnWeights = new double[]{0.0, 0.0, 0.0};
        gbl_parkingPlacePanel.rowWeights = new double[]{0.0, 0.0};
        parkingPlacePanel.setLayout(gbl_parkingPlacePanel);
        this.departurePositionComboBox = new JComboBox();
        GridBagConstraints gbc_departurePositionComboBox = new GridBagConstraints();
        gbc_departurePositionComboBox.anchor = 11;
        gbc_departurePositionComboBox.fill = 2;
        gbc_departurePositionComboBox.insets = new Insets(0, 0, 5, 0);
        gbc_departurePositionComboBox.gridwidth = 2;
        gbc_departurePositionComboBox.gridx = 1;
        gbc_departurePositionComboBox.gridy = 0;
        parkingPlacePanel.add(this.departurePositionComboBox, gbc_departurePositionComboBox);
        this.departurePositionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FsxExportDialog.this.departurePositionChanged();
            }
        });
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("fsx_export_frame_or_parking_spot"));
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.fill = 1;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        parkingPlacePanel.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.showOnMapCheckbox = new JCheckBox(Messages.getInstance().get("fsx_export_frame_show_spot_on_map"));
        GridBagConstraints gbc_showOnMapCheckbox = new GridBagConstraints();
        gbc_showOnMapCheckbox.anchor = 11;
        gbc_showOnMapCheckbox.fill = 2;
        gbc_showOnMapCheckbox.gridx = 2;
        gbc_showOnMapCheckbox.gridy = 1;
        parkingPlacePanel.add((Component)this.showOnMapCheckbox, gbc_showOnMapCheckbox);
        this.showOnMapCheckbox.setHorizontalAlignment(4);
        this.showOnMapCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FsxExportDialog.this.toggleShowOnMapAction();
            }
        });
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_1, "South");
        JButton eksportujButton = new JButton(Messages.getInstance().get("export_button"));
        eksportujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxExportDialog.this.exportAction();
            }
        });
        panel_1.add(eksportujButton);
        JButton anulujButton = new JButton(Messages.getInstance().get("cancel_button"));
        anulujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxExportDialog.this.closeWindowAction();
            }
        });
        panel_1.add(anulujButton);
        this.setSize(462, 301);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.updateValues();
    }

    public void toggleShowOnMapAction() {
        if (this.showOnMapCheckbox.isSelected()) {
            this.centerMapOnDeparturePosition();
        } else {
            this.clearMapFromDepartureMarker();
        }
    }

    public void centerMapOnDeparturePosition() {
        if (this.departurePositionComboBox.getSelectedIndex() > 0) {
            ComboBoxItem selStart = (ComboBoxItem)this.departurePositionComboBox.getSelectedItem();
            GpsPlace point = ((AirportStart)selStart.getValue()).getGpsPlace();
            MapFrame.getInstance().setMarkerPlace(point);
            MapFrame.getInstance().centerOnPoint(point, 3);
            MapFrame.getInstance().updateMap();
        }
    }

    public void clearMapFromDepartureMarker() {
        MapFrame.getInstance().setMarkerPlace(null);
        MapFrame.getInstance().updateMap();
    }

    public void departurePositionChanged() {
        boolean manHeading = this.departurePositionComboBox.getSelectedIndex() == 0;
        this.departureRwyTextField.setEnabled(manHeading);
        this.showOnMapCheckbox.setEnabled(!manHeading);
        if (manHeading) {
            this.showOnMapCheckbox.setSelected(false);
        }
        this.toggleShowOnMapAction();
    }

    public void updateValues() {
        Airport depAirport;
        block6: {
            List<Airport> depAirports;
            GpsPlace depPlace;
            block5: {
                this.departurePositionComboBox.addItem(new ComboBoxItem<Object>("", null));
                depPlace = FlightPlanBean.getInstance().getRoute().getPoints().get(0);
                String depIdent = depPlace.getName();
                AirportFilter criteria = new AirportFilter();
                criteria.setIdent(depIdent);
                AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
                depAirports = airportFacade.findAirportsByCriteria(criteria, true);
                depAirport = null;
                if (depAirports == null || depAirports.size() != 1) break block5;
                double dist = GpsUtil.getDistance(depPlace, depAirports.get(0).getGpsPlace());
                if (!(dist <= 10.0)) break block6;
                depAirport = depAirports.get(0);
                break block6;
            }
            if (depAirports != null && depAirports.size() > 1) {
                for (Airport a : depAirports) {
                    double dist = GpsUtil.getDistance(depPlace, a.getGpsPlace());
                    if (!(dist <= 10.0)) continue;
                    depAirport = a;
                    break;
                }
            }
        }
        if (depAirport == null) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("fsx_plan_export_no_departure_airport_in_db"), "", 0);
        } else {
            List<AirportStart> starts = depAirport.getStarts();
            Collections.sort(starts);
            for (AirportStart st : starts) {
                this.departurePositionComboBox.addItem(new ComboBoxItem<AirportStart>(st.getName(), st));
            }
        }
        this.departurePositionChanged();
    }

    public void closeWindowAction() {
        MapFrame.getInstance().setMarkerPlace(null);
        MapFrame.getInstance().updateMap();
        MapFrame.getInstance().showPanel();
        this.setVisible(false);
    }

    public boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        Integer rwyDir = null;
        try {
            rwyDir = Integer.valueOf(this.departureRwyTextField.getText());
        }
        catch (NumberFormatException e) {
            errors.add(Messages.getInstance().get("fsx_export_frame_invalid_departure_number"));
        }
        if (rwyDir != null && (rwyDir < 1 || rwyDir > 36)) {
            errors.add(Messages.getInstance().get("fsx_export_frame_invalid_departure_value"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public void sendToSimAction() {
        if (this.doValidate()) {
            Random randomGenerator = new Random();
            String tmpPath = "tmp/" + randomGenerator.nextInt(Integer.MAX_VALUE) + ".pln";
            if (this.exportAction(FlightPlanBean.getInstance().getRoute(), new File(tmpPath))) {
                if (SettingsBean.getInstance().isConnectedToSimAndHasData()) {
                    if (SimConnectUtil.sendFlightPlan(SimConnectUtil.initConnection(), tmpPath)) {
                        JOptionPane.showMessageDialog(this, Messages.getInstance().get("fsx_plan_export_success"), "", 1);
                        this.closeWindowAction();
                    } else {
                        JOptionPane.showMessageDialog(this, Messages.getInstance().get("fsx_plan_export_error"), "", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, Messages.getInstance().get("sim_disconnect_error"), "", 0);
                }
            }
        }
    }

    public boolean exportAction(Route route, File file) {
        String fileName = IOUtil.addExtension(file, "pln");
        route.setDepartureRwy(Integer.valueOf(this.departureRwyTextField.getText()));
        ComboBoxItem selStart = (ComboBoxItem)this.departurePositionComboBox.getSelectedItem();
        route.setDeparturePosition((AirportStart)selStart.getValue());
        route.setVfr(this.vfrRadioButton.isSelected());
        SettingsBean.getInstance().setFileOpenPath(file.getPath());
        if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("fsx_export"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
            return FsxUtil.saveFlightPlan(route, fileName);
        }
        return false;
    }

    public void exportAction() {
        if (this.doValidate()) {
            int returnVal;
            JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("fsx_export"), Messages.getInstance().get("save"), SettingsBean.getInstance().getFlightPlansPath());
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("fsx_flight_plans"), new String[]{"PLN"}));
            if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getRoute().getName())) {
                chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getRoute().getName() + ".pln"));
            }
            if ((returnVal = chooser.showOpenDialog(this)) == 0) {
                SettingsBean.getInstance().setFlightPlansPath(chooser.getSelectedFile().getPath());
                if (this.exportAction(FlightPlanBean.getInstance().getRoute(), chooser.getSelectedFile())) {
                    JOptionPane.showMessageDialog(this, Messages.getInstance().get("fsx_plan_export_success"), "", 1);
                    this.closeWindowAction();
                } else {
                    JOptionPane.showMessageDialog(this, Messages.getInstance().get("fsx_plan_export_error"), "", 0);
                }
            }
        }
    }
}

