/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.ExtensionFileFilter;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SceneryConfigPathsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.combo.item.ComboBoxItem;
import main.java.guru.vfrflight.bean.combo.item.NumericComboBoxItem;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.MapRadials;
import main.java.guru.vfrflight.core.PlaneProfile;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.SegmentLandmark;
import main.java.guru.vfrflight.core.SimConnectConfigBean;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.dto.NavaidDTO;
import main.java.guru.vfrflight.core.dto.ObstacleDTO;
import main.java.guru.vfrflight.core.fsx.BglImportBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.sql.TerrainMesh;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.gui.flightplan.AboutDialog;
import main.java.guru.vfrflight.gui.flightplan.AddFromDBDialog;
import main.java.guru.vfrflight.gui.flightplan.AddMultipleMapRadialsDialog;
import main.java.guru.vfrflight.gui.flightplan.CalculationResultDialog;
import main.java.guru.vfrflight.gui.flightplan.FlightGearConnectDialog;
import main.java.guru.vfrflight.gui.flightplan.FsxExportDialog;
import main.java.guru.vfrflight.gui.flightplan.HintDialog;
import main.java.guru.vfrflight.gui.flightplan.ImportOverwriteDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.MeteoDownloadDialog;
import main.java.guru.vfrflight.gui.flightplan.MeteoViewDialog;
import main.java.guru.vfrflight.gui.flightplan.OpenAipImportDialog;
import main.java.guru.vfrflight.gui.flightplan.SearchDialog;
import main.java.guru.vfrflight.gui.flightplan.SettingsDialog;
import main.java.guru.vfrflight.gui.flightplan.VorSearchDialog;
import main.java.guru.vfrflight.gui.flightplan.WeatherDownloadDialog;
import main.java.guru.vfrflight.gui.flightplan.XPConnectDialog;
import main.java.guru.vfrflight.gui.flightplan.XmlExportDialog;
import main.java.guru.vfrflight.gui.flightplan.connect.FsxP3DConnectDialog;
import main.java.guru.vfrflight.gui.flightplan.fsx.FsxImportDataStep1Dialog;
import main.java.guru.vfrflight.gui.flightplan.menu.RecentLoadedMenuActionListener;
import main.java.guru.vfrflight.gui.flightplan.panel.AirportsFilterCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.AirspacesFilterCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.AlternateAirportsCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.InfoCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.MeteoMapCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.ObstaclesFilterCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.PerformanceCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.PointsCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.TerrainLayerFilterCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.UserPointsFilterCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.VorCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.WeatherCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.panel.WindCollapsablePanel;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsDialog;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.swing.panel.CollapsablePanel;
import main.java.guru.vfrflight.gui.swing.panel.GroupPanel;
import main.java.guru.vfrflight.gui.table.PointsDataTable;
import main.java.guru.vfrflight.gui.table.PointsValDataTable;
import main.java.guru.vfrflight.gui.table.VorDataTable;
import main.java.guru.vfrflight.gui.table.VorValDataTable;
import main.java.guru.vfrflight.gui.table.popup.WaypointsTablePopupClickListener;
import main.java.guru.vfrflight.gui.table.waypoints.WaypointsDataTable;
import main.java.guru.vfrflight.gui.table.waypoints.WaypointsDataTableFactory;
import main.java.guru.vfrflight.gui.task.AixmImportTask;
import main.java.guru.vfrflight.gui.task.DataFilesImportTask;
import main.java.guru.vfrflight.gui.task.MeteoDownloadMultiCoreTask;
import main.java.guru.vfrflight.gui.task.MeteoDownloadTask;
import main.java.guru.vfrflight.gui.task.RefreshUserPointsTask;
import main.java.guru.vfrflight.gui.task.XmlImportTask;
import main.java.guru.vfrflight.gui.task.extconnect.flightgear.FlightgearConnectTask;
import main.java.guru.vfrflight.gui.task.extconnect.nmea.GpsConnectTask;
import main.java.guru.vfrflight.gui.task.extconnect.simconnect.SimConnectTask;
import main.java.guru.vfrflight.gui.task.extconnect.xplane.XPConnectTask;
import main.java.guru.vfrflight.gui.task.fsx.BglImportTask;
import main.java.guru.vfrflight.pdf.util.PdfUtil;
import main.java.guru.vfrflight.sql.facade.ElevationFacade;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.AndroidAppUtil;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FlightPlanUtil;
import main.java.guru.vfrflight.util.FlyingAppUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.FsxUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.KmlUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.PlaneProfileUtil;
import main.java.guru.vfrflight.util.SearchUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.XplaneImportUtil;
import main.java.guru.vfrflight.util.metar.MetarDecoderUtil;
import main.java.guru.vfrflight.weather.WeatherUtil;
import main.java.guru.vfrflight.weather.core.Station;
import org.apache.log4j.Logger;

public class FlightPlanMainPanel
extends JPanel {
    private static final long serialVersionUID = -947962607899649932L;
    private static final Logger log = Logger.getLogger(FlightPlanMainPanel.class);
    private boolean isInitialized = false;
    private final MapFrame mapFrame;
    private InfoCollapsablePanel infoCollapsablePanel;
    private PointsCollapsablePanel pointsCollapsablePanel;
    private WindCollapsablePanel windCollapsablePanel;
    private WeatherCollapsablePanel weatherCollapsablePanel;
    private PerformanceCollapsablePanel performanceCollapsablePanel;
    private VorCollapsablePanel vorCollapsablePanel;
    private AirspacesFilterCollapsablePanel airspacesFilterCollapsablePanel;
    private AirportsFilterCollapsablePanel airportsFilterCollapsablePanel;
    private ObstaclesFilterCollapsablePanel obstaclesFilterCollapsablePanel;
    private TerrainLayerFilterCollapsablePanel terrainLayerFilterCollapsablePanel;
    private MeteoMapCollapsablePanel meteoMapCollapsablePanel;
    private AlternateAirportsCollapsablePanel alternateAirportsCollapsablePanel;
    private UserPointsFilterCollapsablePanel userPointsFilterCollapsablePanel;
    private boolean previousWindCollapsablePanelExtended = true;

    public FlightPlanMainPanel(MapFrame mapFrame) {
        this.mapFrame = mapFrame;
        this.setLayout(new BorderLayout(0, 0));
        GroupPanel mapTabPanel = new GroupPanel(Messages.getInstance().get("main_frame_tab_map_title"));
        GroupPanel routeTabPanel = new GroupPanel(Messages.getInstance().get("main_frame_tab_route_title"));
        JPanel tabPanel = new JPanel(new BorderLayout(0, 0));
        tabPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        tabPanel.add((Component)routeTabPanel, "North");
        tabPanel.add((Component)mapTabPanel, "Center");
        JScrollPane scrollPane = new JScrollPane(tabPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add(scrollPane);
        JPanel mainPanelInfoPointsVor = new JPanel();
        routeTabPanel.addToContent(mainPanelInfoPointsVor, "Center");
        mainPanelInfoPointsVor.setLayout(new BorderLayout(0, 0));
        ArrayList<CollapsablePanel> collapsablePanels = new ArrayList<CollapsablePanel>();
        this.infoCollapsablePanel = this.createInfoPanel(true);
        collapsablePanels.add(this.infoCollapsablePanel);
        this.performanceCollapsablePanel = this.createPerformancePanel(false);
        collapsablePanels.add(this.performanceCollapsablePanel);
        this.pointsCollapsablePanel = this.createPointsPanel(false);
        collapsablePanels.add(this.pointsCollapsablePanel);
        this.vorCollapsablePanel = this.createVorPanel(false);
        collapsablePanels.add(this.vorCollapsablePanel);
        this.alternateAirportsCollapsablePanel = this.createAlternateAirportsPanel(false);
        collapsablePanels.add(this.alternateAirportsCollapsablePanel);
        if (!SettingsBean.getInstance().isOfflineMode()) {
            this.weatherCollapsablePanel = this.createWeatherPanel(false);
            collapsablePanels.add(this.weatherCollapsablePanel);
        }
        this.windCollapsablePanel = this.createWindPanel(false);
        collapsablePanels.add(this.windCollapsablePanel);
        this.createCollapsablePanelGroup(mainPanelInfoPointsVor, collapsablePanels);
        this.setVorTable(new VorDataTable());
        this.setPointsTable(new PointsDataTable());
        JPanel mainPanelWeatherWind = new JPanel();
        mapTabPanel.addToContent(mainPanelWeatherWind, "Center");
        mainPanelWeatherWind.setLayout(new BorderLayout(0, 0));
        collapsablePanels = new ArrayList();
        this.obstaclesFilterCollapsablePanel = new ObstaclesFilterCollapsablePanel(false);
        collapsablePanels.add(this.obstaclesFilterCollapsablePanel);
        this.airportsFilterCollapsablePanel = new AirportsFilterCollapsablePanel(false);
        collapsablePanels.add(this.airportsFilterCollapsablePanel);
        this.airspacesFilterCollapsablePanel = new AirspacesFilterCollapsablePanel(false);
        collapsablePanels.add(this.airspacesFilterCollapsablePanel);
        this.terrainLayerFilterCollapsablePanel = new TerrainLayerFilterCollapsablePanel(false);
        collapsablePanels.add(this.terrainLayerFilterCollapsablePanel);
        this.meteoMapCollapsablePanel = new MeteoMapCollapsablePanel(false);
        collapsablePanels.add(this.meteoMapCollapsablePanel);
        this.userPointsFilterCollapsablePanel = new UserPointsFilterCollapsablePanel(false);
        collapsablePanels.add(this.userPointsFilterCollapsablePanel);
        this.createCollapsablePanelGroup(mainPanelWeatherWind, collapsablePanels);
        this.updateData();
        this.setPlaneProfilesCombo(SettingsBean.getInstance().getPlaneProfiles());
        this.setPreferredSize(new Dimension(SettingsBean.getInstance().getParamSidePanelWidth(), 2000));
        this.updateUIFilter();
        this.isInitialized = true;
    }

    private void createCollapsablePanelGroup(JPanel parentPanel, List<CollapsablePanel> panels) {
        for (int i = 0; i < panels.size(); ++i) {
            JPanel panel1 = new JPanel();
            panel1.setLayout(new BorderLayout(0, 0));
            panel1.add((Component)panels.get(i), "North");
            parentPanel.add((Component)panel1, "Center");
            parentPanel = panel1;
        }
    }

    protected ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        log.error("Couldn't find file: " + path);
        return null;
    }

    protected void planeProfileChangedAction() {
        PlaneProfile selected;
        if (this.performanceCollapsablePanel.getProfileCombo().getSelectedItem() != null && (selected = (PlaneProfile)((ComboBoxItem)this.performanceCollapsablePanel.getProfileCombo().getSelectedItem()).getValue()) != null && !selected.equals(PlaneProfile.EMPTY)) {
            FlightPlanBean.getInstance().getRoute().setCruiseAlt(selected.getCruiseAlt());
            FlightPlanBean.getInstance().getRoute().setCruiseSpeed(selected.getCruiseSpeed());
            FlightPlanBean.getInstance().getRoute().setClimbingSpeed(selected.getClimbingSpeed());
            FlightPlanBean.getInstance().getRoute().setDescendingSpeed(selected.getDescendingSpeed());
            FlightPlanBean.getInstance().getRoute().setFuelBurn(selected.getFuelBurn());
            FlightPlanBean.getInstance().getRoute().setQm(selected.getFuelQm());
            FlightPlanBean.getInstance().getRoute().setQmax(selected.getFuelQmax());
            FlightPlanBean.getInstance().getRoute().setNavFuelReserveMin(selected.getNavFuelReserveMin());
            this.updateInfoData();
            this.updateRoutePointsInfoLabel();
            if (SettingsBean.getInstance().isCalculateRouteInRealTime()) {
                this.mapFrame.updateMap();
            } else if (this.mapFrame.getMapViewer().isMultipleRulersMode()) {
                this.mapFrame.getMapViewer().repaint();
            }
        }
    }

    protected void setToPointsAction() {
        if (StringUtil.isEmpty(this.performanceCollapsablePanel.getCruiseAltTextField().getText())) {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_validation_cruise_altitude_empty"), "", 0);
        } else if (FlightPlanBean.getInstance().getRoute().getPoints().size() == 0) {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_validation_no_route_points"), "", 0);
        } else {
            Double cruiseAlt = null;
            try {
                cruiseAlt = Double.valueOf(this.performanceCollapsablePanel.getCruiseAltTextField().getText());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_validation_cruise_altitude_value"), "", 0);
            }
            this.setToPointsAction(cruiseAlt);
        }
    }

    protected void setToPointsAction(Double cruiseAlt) {
        if (cruiseAlt != null) {
            for (int i = 1; i < FlightPlanBean.getInstance().getRoute().getPoints().size() - 1; ++i) {
                FlightPlanBean.getInstance().getRoute().getPoints().get(i).setAlt(cruiseAlt);
            }
            this.updateRoutePoints();
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_set_to_points_success"), "", 1);
        }
    }

    protected void setVorsMouseDragAction() {
        if (this.isInitialized) {
            this.mapFrame.setVorsMouseDrag(this.vorCollapsablePanel.getVorsMouseDragCheckBox().isSelected());
            this.getVorCollapsablePanel().getVorTable().getTable().setEnabled(this.vorCollapsablePanel.getVorsMouseDragCheckBox().isSelected());
            this.vorCollapsablePanel.getNewVorButton().setEnabled(this.vorCollapsablePanel.getVorsMouseDragCheckBox().isSelected());
        }
    }

    protected void weatherStationCenterMapAction() {
        this.weatherCollapsablePanel.getStationsTable().centerMapOnSelectedStation();
    }

    private void calculateFromMetarAction() {
        ArrayList<String> errors = new ArrayList<String>();
        if (MapObjectsBean.getInstance().getStations().size() == 0) {
            errors.add(Messages.getInstance().get("flight_plan_validation_calculate_from_metar_no_stations"));
        } else if (!MapObjectsBean.getInstance().hasMetar()) {
            errors.add(Messages.getInstance().get("flight_plan_validation_calculate_from_metar_no_metars"));
        }
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() == 0) {
            errors.add(Messages.getInstance().get("flight_plan_validation_no_route_points"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this.mapFrame, sb.toString(), Messages.getInstance().get("error"), 0);
        } else {
            GpsPlace center = FlightPlanBean.getInstance().getRoute().getCenter();
            double distanceSum = 0.0;
            int num = 0;
            for (Station st : MapObjectsBean.getInstance().getStations()) {
                if (st.getReport() == null || st.getReport().getMetarData() == null || st.getReport().getMetarData().getDirection() == null || st.getReport().getMetarData().getSpeed() == null) continue;
                distanceSum += this.getMeteoWindDistanceDivider(GpsUtil.getDistance(st.getGpsPlace(), center));
                ++num;
            }
            if (num > 1) {
                double direction = 0.0;
                double speed = 0.0;
                for (Station st : MapObjectsBean.getInstance().getStations()) {
                    if (st.getReport() == null || st.getReport().getMetarData() == null || st.getReport().getMetarData().getDirection() == null || st.getReport().getMetarData().getSpeed() == null) continue;
                    double ratio = (1.0 - this.getMeteoWindDistanceDivider(GpsUtil.getDistance(st.getGpsPlace(), center)) / distanceSum) / (double)(num - 1);
                    double dir = GpsUtil.normalizeDirection(st.getReport().getMetarData().getDirection().shortValue());
                    if (st.getReport().getMetarData().getMinimumDirection() != null && st.getReport().getMetarData().getMaximumDirection() != null) {
                        dir = (dir + GpsUtil.normalizeDirection(st.getReport().getMetarData().getMinimumDirection().shortValue()) + GpsUtil.normalizeDirection(st.getReport().getMetarData().getMaximumDirection().shortValue())) / 3.0;
                    }
                    direction += dir * ratio;
                    speed += st.getReport().getMetarData().getSpeed() * ratio;
                    if (!st.getReport().getMetarData().isGusts()) continue;
                    speed += st.getReport().getMetarData().getGusts() / 10.0 * ratio;
                }
                direction = GpsUtil.denormalizeDirection(direction);
                if (!"kt".equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
                    speed = UnitUtil.recalculateWindSpeed(speed, SettingsBean.getInstance().getParamUnitsWindSpeed(), "kt", false);
                }
                FlightPlanBean.getInstance().getRoute().setWindDirection(direction);
                FlightPlanBean.getInstance().getRoute().setWindSpeed(NumberUtil.roundDouble(speed, 1));
                this.mapFrame.getUIPanel().updateWindData();
                if (SettingsBean.getInstance().isCalculateRouteInRealTime()) {
                    this.updateRoutePointsInfoLabel();
                    this.mapFrame.updateMap();
                } else if (this.mapFrame.getMapViewer().isMultipleRulersMode()) {
                    this.mapFrame.getMapViewer().repaint();
                }
            } else {
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_validation_calculate_from_metar_not_enough_data"), "", 0);
            }
        }
    }

    private double getMeteoWindDistanceDivider(double dist) {
        if (dist <= 20.0) {
            return dist / 20.0;
        }
        if (dist <= 40.0) {
            return Math.pow(dist / 40.0, 2.0);
        }
        if (dist <= 60.0) {
            return Math.pow(dist / 60.0, 3.0);
        }
        if (dist <= 80.0) {
            return Math.pow(dist / 80.0, 4.0);
        }
        return Math.pow(dist / 100.0, 5.0);
    }

    private void clearAllWeatherAction() {
        this.getWeatherCollapsablePanel().getStationsTable().clearData();
        MapObjectsBean.getInstance().getStations().clear();
        this.mapFrame.updateMap();
    }

    public void getMeteoWeatherAction() {
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 1) {
            boolean result = false;
            for (GpsPlace gpsPlace : FlightPlanBean.getInstance().getRoute().getPoints()) {
                if (!WeatherUtil.isMeteoAvailable(gpsPlace)) continue;
                result = true;
                break;
            }
            if (result) {
                MeteoDownloadDialog dialog = new MeteoDownloadDialog(this.mapFrame);
                dialog.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_get_meteo_for_route_no_wps_in_area"), "", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_validation_route_points_points_number"), "", 0);
        }
    }

    public void getMeteoWeatherActionStart(boolean atWPs, boolean middleSements, Integer stepDistance) {
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 1) {
            Thread t = null;
            t = SettingsBean.getInstance().isParamUseMultipleCores() ? new Thread(new MeteoDownloadMultiCoreTask(atWPs, middleSements, stepDistance)) : new Thread(new MeteoDownloadTask(atWPs, middleSements, stepDistance));
            t.start();
        }
    }

    public void getMeteoWeatherActionStop(boolean allSuccessful) {
        if (FlightPlanBean.getInstance().getRoute().getMeteoReports().size() > 0) {
            Collections.sort(FlightPlanBean.getInstance().getRoute().getMeteoReports());
            if (!allSuccessful) {
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_get_meteo_for_route_not_all_successful"), "", 2);
            }
            MeteoViewDialog.getInstance().openWindow(true);
        } else {
            log.error("Couldn't find ANY METEO reports ...");
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_get_meteo_for_route_error"), "", 0);
        }
    }

    public void openMeteoWeatherForPlace(GpsPlace place) {
        FlightPlanBean.getInstance().getRoute().getMeteoReports().clear();
        PleaseWaitDialog.getInstance(this.mapFrame).start();
        if (FlightPlanBean.getInstance().getRoute().addMeteoReport(place, 0.0)) {
            MeteoViewDialog.getInstance().openWindow(false);
        } else {
            log.error("Couldn't find METEO report for " + place);
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_get_meteo_for_place_error"), "", 0);
        }
        PleaseWaitDialog.getInstance().stop();
    }

    public void addSelecteddVorAsNewPoint() {
        List<RoutePlace> selectedPoints = this.getSelectedRows(this.vorCollapsablePanel.getVorTable());
        if (selectedPoints.size() > 0) {
            for (int i = 0; i < selectedPoints.size(); ++i) {
                this.addNewPoint(selectedPoints.get(i), null);
            }
        } else {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("no_vors_selected"), "", 0);
        }
    }

    public void addPointsToDBAction() {
        List<RoutePlace> selectedPoints = this.getSelectedRows(this.pointsCollapsablePanel.getPointsTable());
        if (selectedPoints.size() > 0) {
            this.addPointsVorsToDBAction("PT", selectedPoints);
        } else {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("no_route_points_selected"), "", 0);
        }
    }

    public void addVorsToDBAction() {
        List<RoutePlace> selectedPoints = this.getSelectedRows(this.vorCollapsablePanel.getVorTable());
        if (selectedPoints.size() > 0) {
            this.addPointsVorsToDBAction("VOR", selectedPoints);
        } else {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("no_vors_selected"), "", 0);
        }
    }

    private List<RoutePlace> getSelectedRows(WaypointsDataTable dataTable) {
        ArrayList<RoutePlace> selectedPoints = new ArrayList<RoutePlace>();
        int[] idxs = dataTable.getTable().getSelectedRows();
        if (idxs.length > 0) {
            for (int i = 0; i < idxs.length; ++i) {
                RoutePlace place = dataTable.getPointAtRow(idxs[i]);
                if (place == null) continue;
                selectedPoints.add(place);
            }
        }
        return selectedPoints;
    }

    public void addPointsVorsToDBAction(String pointType, List<RoutePlace> places) {
        ArrayList<UserPoint> points = new ArrayList<UserPoint>();
        for (GpsPlace gpsPlace : places) {
            points.add(gpsPlace.getUserPoint());
        }
        if (points.size() > 0) {
            UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
            int n = userPointFacade.addNewUserPoints(points, true);
            if (n > 0) {
                ArrayList tasksList = new ArrayList(2);
                tasksList.add(new RefreshUserPointsTask());
                try {
                    VfrUtil.executeTaskInFixedPool(tasksList);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                this.mapFrame.updateMap();
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("add_points_to_DB_points_added", String.valueOf(n)), "", 0);
            } else {
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("add_points_to_DB_points_already_in_DB"), "", 2);
            }
        }
    }

    public void setWaypointsTableAction(WaypointsDataTable table) {
        int selRow = this.setPointsTable(table);
        this.updateRoutePoints();
        if (selRow >= 0) {
            this.pointsCollapsablePanel.getPointsTable().selectRow(selRow);
        }
    }

    public int setPointsTable(WaypointsDataTable table) {
        int selRow = -1;
        if (this.pointsCollapsablePanel.getPointsTable() != null) {
            selRow = this.pointsCollapsablePanel.getPointsTable().getTable().getSelectedRow();
            this.pointsCollapsablePanel.getPointsTableWrapper().remove(this.pointsCollapsablePanel.getPointsTable());
        }
        this.pointsCollapsablePanel.setPointsTable(table);
        this.pointsCollapsablePanel.getPointsTable().getTable().addMouseListener(new WaypointsTablePopupClickListener(true));
        this.pointsCollapsablePanel.getPointsTableWrapper().add(this.pointsCollapsablePanel.getPointsTable());
        this.revalidate();
        this.repaint();
        return selRow;
    }

    public boolean hasPointsTableDecimalValues() {
        return this.pointsCollapsablePanel.getPointsTable() instanceof PointsValDataTable;
    }

    public boolean hasVorTableDecimalValues() {
        return this.vorCollapsablePanel.getVorTable() instanceof VorValDataTable;
    }

    public boolean updateWeatherStationsActionStart() {
        WeatherDownloadDialog dialog = new WeatherDownloadDialog(this.mapFrame);
        dialog.setVisible(true);
        return true;
    }

    public void updateWeatherStationsActionFinish(List<Station> stations) {
        this.weatherCollapsablePanel.getStationsTable().clearData();
        for (Station s : stations) {
            Station st = s.clone();
            if (st.getReport() != null && st.getReport().getMetar() != null) {
                s.getReport().setMetarData(MetarDecoderUtil.decodeMetar(st.getReport().getMetar()));
            }
            this.weatherCollapsablePanel.getStationsTable().addStation(st);
        }
        MapObjectsBean.getInstance().getStations().clear();
        MapObjectsBean.getInstance().getStations().addAll(stations);
        this.mapFrame.updateMap();
        PleaseWaitDialog.getInstance().stop();
        this.showPanel();
        if (!this.isVisible()) {
            this.mapFrame.toggleUIPanelAction();
        }
        if (!SettingsBean.getInstance().isDrawWeather()) {
            this.mapFrame.getShowWeatherButton().doClick();
            this.mapFrame.getShowWeatherButton().toggle();
        }
    }

    public void searchVorDmeAction() {
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 0) {
            VorSearchDialog dialog = new VorSearchDialog((Window)this.mapFrame);
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_validation_no_route_points"), "", 0);
        }
    }

    public boolean searchVorDmeAction(double radius, boolean vor, boolean ndb) {
        Set<GpsPlace> vors = null;
        NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 1) {
            FlightPlanBean.getInstance().getRoute().calculateSegments();
            vors = navaidFacade.findInRadius(new ArrayList<LineSegment>(FlightPlanBean.getInstance().getRoute().getSegments()), radius, vor, ndb, false);
        } else {
            vors = navaidFacade.findInRadius(FlightPlanBean.getInstance().getRoute().getPoints().get(0), radius, vor, ndb, false);
        }
        PleaseWaitDialog.getInstance().stop();
        if (vors.size() > 0) {
            FlightPlanBean.getInstance().getRoute().getMapRadials().clear();
            this.vorCollapsablePanel.getVorTable().clearData();
            FlightPlanBean.getInstance().getRoute().getVors().clear();
            for (GpsPlace p : vors) {
                this.vorCollapsablePanel.getVorTable().addPoint(new RoutePlace(p));
                FlightPlanBean.getInstance().getRoute().getVors().add(new RoutePlace(p));
            }
        } else {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("search_vor_action_no_vors"), "", 0);
            return false;
        }
        this.mapFrame.updateMap();
        JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("search_vor_action_result", String.valueOf(vors.size())), "", 1);
        this.showPanel();
        return true;
    }

    public void setVorTableAction(WaypointsDataTable table) {
        int selRow = this.setVorTable(table);
        this.updateVor();
        if (selRow >= 0) {
            this.vorCollapsablePanel.getVorTable().selectRow(selRow);
        }
    }

    public int setVorTable(WaypointsDataTable table) {
        int selRow = -1;
        if (this.vorCollapsablePanel.getVorTable() != null) {
            selRow = this.vorCollapsablePanel.getVorTable().getTable().getSelectedRow();
            this.vorCollapsablePanel.getVorTableWrapper().remove(this.vorCollapsablePanel.getVorTable());
        }
        this.vorCollapsablePanel.setVorTable(table);
        this.vorCollapsablePanel.getVorTable().getTable().addMouseListener(new WaypointsTablePopupClickListener(false));
        this.vorCollapsablePanel.getVorTableWrapper().add(this.vorCollapsablePanel.getVorTable());
        this.vorCollapsablePanel.getVorTable().getTable().setEnabled(this.vorCollapsablePanel.getVorsMouseDragCheckBox().isSelected());
        this.revalidate();
        this.repaint();
        return selRow;
    }

    public boolean doValidateExport() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.pointsCollapsablePanel.getPointsTable().hasCompleteRows()) {
            errors.add(Messages.getInstance().get("flight_plan_validation_route_points_not_complete"));
        } else if (this.pointsCollapsablePanel.getPointsTable().getRowCount() < 2) {
            errors.add(Messages.getInstance().get("flight_plan_validation_route_points_points_number"));
        }
        if (StringUtil.isEmpty(this.performanceCollapsablePanel.getCruiseAltTextField().getText())) {
            errors.add(Messages.getInstance().get("flight_plan_validation_cruise_altitude_empty"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this.mapFrame, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public boolean doValidate(boolean showErrors) {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isEmpty(this.windCollapsablePanel.getWindDirectionTextField().getText())) {
            errors.add(Messages.getInstance().get("flight_plan_validation_wind_direction_empty"));
        } else {
            Double windDir = null;
            try {
                windDir = Double.valueOf(this.windCollapsablePanel.getWindDirectionTextField().getText());
                if (windDir < 0.0 || windDir >= 360.0) {
                    errors.add(Messages.getInstance().get("flight_plan_validation_wind_direction_range"));
                }
            }
            catch (NumberFormatException e) {
                errors.add(Messages.getInstance().get("flight_plan_validation_wind_direction_value"));
            }
        }
        if (StringUtil.isEmpty(this.windCollapsablePanel.getWindSpeedTextField().getText())) {
            errors.add(Messages.getInstance().get("flight_plan_validation_wind_speed_empty"));
        } else {
            Double windSpeed = null;
            try {
                windSpeed = Double.valueOf(this.windCollapsablePanel.getWindSpeedTextField().getText());
                if (windSpeed < 0.0) {
                    errors.add(Messages.getInstance().get("flight_plan_validation_wind_speed_less_than_zero"));
                }
            }
            catch (NumberFormatException e) {
                errors.add(Messages.getInstance().get("flight_plan_validation_wind_speed_value"));
            }
        }
        if (StringUtil.isEmpty(this.performanceCollapsablePanel.getCruiseSpeedTextField().getText())) {
            errors.add(Messages.getInstance().get("flight_plan_validation_cruise_speed_empty"));
        } else {
            Double cruiseSpeed = null;
            try {
                cruiseSpeed = Double.valueOf(this.performanceCollapsablePanel.getCruiseSpeedTextField().getText());
                if (cruiseSpeed <= 0.0) {
                    errors.add(Messages.getInstance().get("flight_plan_validation_cruise_speed_less_than_zero"));
                }
            }
            catch (NumberFormatException e) {
                errors.add(Messages.getInstance().get("flight_plan_validation_cruise_speed_value"));
            }
        }
        if (!StringUtil.isEmpty(this.performanceCollapsablePanel.getCruiseAltTextField().getText())) {
            try {
                Double.valueOf(this.performanceCollapsablePanel.getCruiseAltTextField().getText());
            }
            catch (NumberFormatException e) {
                errors.add(Messages.getInstance().get("flight_plan_validation_cruise_altitude_value"));
            }
        }
        if (!StringUtil.isEmpty(this.performanceCollapsablePanel.getFuelBurnTextField().getText())) {
            Double fuelBurn = null;
            try {
                fuelBurn = Double.valueOf(this.performanceCollapsablePanel.getFuelBurnTextField().getText());
                if (fuelBurn <= 0.0) {
                    errors.add(Messages.getInstance().get("flight_plan_validation_fuel_burn_less_than_zero"));
                }
            }
            catch (NumberFormatException e) {
                errors.add(Messages.getInstance().get("flight_plan_validation_fuel_burn_empty"));
            }
        }
        Double Qmax = null;
        if (!StringUtil.isEmpty(this.performanceCollapsablePanel.getFuelQMaxTextField().getText())) {
            try {
                Qmax = Double.valueOf(this.performanceCollapsablePanel.getFuelQMaxTextField().getText());
                if (Qmax <= 0.0) {
                    errors.add(Messages.getInstance().get("flight_plan_validation_fuel_less_than_zero"));
                }
            }
            catch (NumberFormatException e) {
                errors.add(Messages.getInstance().get("flight_plan_validation_fuel_value"));
            }
        }
        Double Qm = null;
        if (!StringUtil.isEmpty(this.performanceCollapsablePanel.getFuelQMTextField().getText())) {
            try {
                Qm = Double.valueOf(this.performanceCollapsablePanel.getFuelQMTextField().getText());
                if (Qm < 0.0) {
                    errors.add(Messages.getInstance().get("flight_plan_validation_unusable_fuel_less_than_zero"));
                } else if (Qmax != null && Qm > Qmax) {
                    errors.add(Messages.getInstance().get("flight_plan_validation_unusable_fuel_gt_than_fuel"));
                }
            }
            catch (NumberFormatException e) {
                errors.add(Messages.getInstance().get("flight_plan_validation_unusable_fuel_value"));
            }
        }
        if (!this.pointsCollapsablePanel.getPointsTable().hasCompleteRows()) {
            errors.add(Messages.getInstance().get("flight_plan_validation_route_points_not_complete"));
        } else if (this.pointsCollapsablePanel.getPointsTable().getRowCount() < 2) {
            errors.add(Messages.getInstance().get("flight_plan_validation_route_points_points_number"));
        }
        if (!this.vorCollapsablePanel.getVorTable().hasCompleteRows()) {
            errors.add(Messages.getInstance().get("flight_plan_validation_vor_not_complete"));
        }
        if (errors.size() > 0 && showErrors) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this.mapFrame, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public void updateData() {
        this.updateInfoData();
        this.updateRoutePoints();
        this.updateAlternateAirports();
        this.updateVor();
        this.updateWindData();
        this.updateStationsData();
    }

    public void updateStationsData() {
        if (this.weatherCollapsablePanel != null && this.weatherCollapsablePanel.getStationsTable() != null) {
            this.weatherCollapsablePanel.getStationsTable().setData(MapObjectsBean.getInstance().getStations());
        }
    }

    public void updateRoutePoints() {
        List<RoutePlace> points = FlightPlanBean.getInstance().getRoute().getPoints();
        for (int i = 0; i < points.size(); ++i) {
            if (points.get(i).getAlt() != null) continue;
            points.get(i).setAlt(FlightPlanBean.getInstance().getRoute().getCruiseAlt());
        }
        this.pointsCollapsablePanel.getPointsTable().setData(points);
        int selRow = FlightPlanBean.getInstance().getSelectedPoint();
        if (selRow >= 0) {
            this.pointsCollapsablePanel.getPointsTable().selectRow(selRow);
        }
        this.updateRoutePointsInfoLabel();
        if (SettingsBean.getInstance().calculateRouteInRealTime()) {
            FlightPlanBean.getInstance().getRoute().calculate();
        }
    }

    public void updateAlternateAirports() {
        this.alternateAirportsCollapsablePanel.getAlternateAirportsTable().setData(FlightPlanBean.getInstance().getRoute().getAlternateAirports());
    }

    public void updateRoutePointsInfoLabel() {
        String distanceTimeLabel = null;
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 1) {
            if (SettingsBean.getInstance().calculateRouteInRealTime() && FlightPlanBean.getInstance().getRoute().getTotalTime() != null) {
                FlightPlanBean.getInstance().getRoute().calculate();
            } else {
                FlightPlanBean.getInstance().getRoute().calculateSegments();
            }
            double distance = 0.0;
            for (LineSegment lineSegment : FlightPlanBean.getInstance().getRoute().getSegments()) {
                distance += lineSegment.getDistance().doubleValue();
            }
            distanceTimeLabel = (double)Math.round(distance * 10.0) / 10.0 + " " + SettingsBean.getInstance().getParamUnitsDistance() + " / ";
            if (SettingsBean.getInstance().calculateRouteInRealTime() && FlightPlanBean.getInstance().getRoute().getTotalTime() != null) {
                this.pointsCollapsablePanel.getInfoDistanceTimeLabel().setText(Messages.getInstance().get("main_frame_tab_route_points_distance_time"));
                distanceTimeLabel = distanceTimeLabel + FormatUtil.formatTime(FlightPlanBean.getInstance().getRoute().getTotalTime());
            } else if (FlightPlanBean.getInstance().getRoute().getCruiseSpeed() != null) {
                this.pointsCollapsablePanel.getInfoDistanceTimeLabel().setText(Messages.getInstance().get("main_frame_tab_route_points_distance_time_without_wind"));
                double speedNM = FlightPlanBean.getInstance().getRoute().getCruiseSpeed();
                if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                    speedNM = UnitUtil.recalculateSpeed(FlightPlanBean.getInstance().getRoute().getCruiseSpeed(), SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
                }
                double distanceNM = distance;
                if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                    distanceNM = UnitUtil.recalculateDistance(distance, SettingsBean.getInstance().getParamUnitsDistance(), "nm", false);
                }
                long timeSec = Math.round(distanceNM / speedNM * 3600.0);
                distanceTimeLabel = distanceTimeLabel + FormatUtil.formatTime(timeSec);
            } else {
                distanceTimeLabel = distanceTimeLabel + "---";
            }
        }
        this.mapFrame.getMapViewer().setInfoDistanceTimeValueLabel(distanceTimeLabel);
        if (distanceTimeLabel == null) {
            distanceTimeLabel = "--- / ---";
        }
        this.pointsCollapsablePanel.getInfoDistanceTimeValueLabel().setText(distanceTimeLabel);
    }

    public void updateVor() {
        List<RoutePlace> points = FlightPlanBean.getInstance().getRoute().getVors();
        this.vorCollapsablePanel.getVorTable().setData(points);
        int selRow = FlightPlanBean.getInstance().getSelectedVor();
        if (selRow >= 0) {
            this.vorCollapsablePanel.getVorTable().selectRow(selRow);
        }
        this.vorCollapsablePanel.getVorsMouseDragCheckBox().setSelected(this.isInitialized ? this.mapFrame.isVorsMouseDrag() : false);
    }

    public void updateWindData() {
        if (FlightPlanBean.getInstance().getRoute().getWindDirection() != null) {
            this.windCollapsablePanel.getWindDirectionTextField().setText(FormatUtil.formattedCourse(FlightPlanBean.getInstance().getRoute().getWindDirection(), false));
        } else {
            this.windCollapsablePanel.getWindDirectionTextField().setText("");
        }
        if (FlightPlanBean.getInstance().getRoute().getWindSpeed() != null) {
            this.windCollapsablePanel.getWindSpeedTextField().setText(FlightPlanBean.getInstance().getRoute().getWindSpeed().toString());
        } else {
            this.windCollapsablePanel.getWindSpeedTextField().setText("");
        }
        this.updateWindCanvas();
    }

    public void updateWindCanvas() {
        try {
            this.windCollapsablePanel.getWindCanvas().setWind(Double.valueOf(this.windCollapsablePanel.getWindDirectionTextField().getText()));
            FlightPlanBean.getInstance().getRoute().setWindDirection(Double.valueOf(this.windCollapsablePanel.getWindDirectionTextField().getText()));
        }
        catch (NumberFormatException e) {
            this.windCollapsablePanel.getWindDirectionTextField().setText("0");
            this.windCollapsablePanel.getWindCanvas().setWind(0.0);
        }
        if (SettingsBean.getInstance().calculateRouteInRealTime()) {
            this.updateRoutePointsInfoLabel();
        }
    }

    public void updateInfoData() {
        if (FlightPlanBean.getInstance().getRoute().getCruiseSpeed() != null) {
            this.performanceCollapsablePanel.getCruiseSpeedTextField().setText(FlightPlanBean.getInstance().getRoute().getCruiseSpeed().toString());
        } else {
            this.performanceCollapsablePanel.getCruiseSpeedTextField().setText("");
        }
        if (FlightPlanBean.getInstance().getRoute().getClimbingSpeed() != null) {
            this.performanceCollapsablePanel.getClimbingSpeedTextField().setText(FlightPlanBean.getInstance().getRoute().getClimbingSpeed().toString());
        } else {
            this.performanceCollapsablePanel.getClimbingSpeedTextField().setText("");
        }
        if (FlightPlanBean.getInstance().getRoute().getDescendingSpeed() != null) {
            this.performanceCollapsablePanel.getDescendingSpeedTextField().setText(FlightPlanBean.getInstance().getRoute().getDescendingSpeed().toString());
        } else {
            this.performanceCollapsablePanel.getDescendingSpeedTextField().setText("");
        }
        if (FlightPlanBean.getInstance().getRoute().getCruiseAlt() != null) {
            this.performanceCollapsablePanel.getCruiseAltTextField().setText(String.valueOf(Math.round(FlightPlanBean.getInstance().getRoute().getCruiseAlt())));
        } else {
            this.performanceCollapsablePanel.getCruiseAltTextField().setText("");
        }
        if (FlightPlanBean.getInstance().getRoute().getFuelBurn() != null) {
            this.performanceCollapsablePanel.getFuelBurnTextField().setText(FlightPlanBean.getInstance().getRoute().getFuelBurn().toString());
        } else {
            this.performanceCollapsablePanel.getFuelBurnTextField().setText("");
        }
        if (FlightPlanBean.getInstance().getRoute().getNavFuelReserveMin() != null) {
            this.performanceCollapsablePanel.getNavFuelReserveTextField().setText(FlightPlanBean.getInstance().getRoute().getNavFuelReserveMin().toString());
        } else {
            this.performanceCollapsablePanel.getNavFuelReserveTextField().setText("");
        }
        if (FlightPlanBean.getInstance().getRoute().getName() != null) {
            this.infoCollapsablePanel.getRouteNameTextField().setText(FlightPlanBean.getInstance().getRoute().getName());
        } else {
            this.infoCollapsablePanel.getRouteNameTextField().setText("");
        }
        if (FlightPlanBean.getInstance().getRoute().getDescription() != null) {
            this.infoCollapsablePanel.getRouteDescTextArea().setText(FlightPlanBean.getInstance().getRoute().getDescription());
        } else {
            this.infoCollapsablePanel.getRouteDescTextArea().setText("");
        }
        if (FlightPlanBean.getInstance().getRoute().getQmax() != null) {
            this.performanceCollapsablePanel.getFuelQMaxTextField().setText(FlightPlanBean.getInstance().getRoute().getQmax().toString());
        } else {
            this.performanceCollapsablePanel.getFuelQMaxTextField().setText("");
        }
        if (FlightPlanBean.getInstance().getRoute().getQm() != null) {
            this.performanceCollapsablePanel.getFuelQMTextField().setText(FlightPlanBean.getInstance().getRoute().getQm().toString());
        } else {
            this.performanceCollapsablePanel.getFuelQMTextField().setText("");
        }
    }

    public void clearAllData() {
        this.mapFrame.setDialogTitle("VfrFlight");
        FlightPlanBean.getInstance().clear();
        this.performanceCollapsablePanel.getProfileCombo().setSelectedIndex(0);
        this.updateData();
        this.mapFrame.updateMap();
    }

    public void newAction() {
        this.newAction(true);
    }

    public void newAction(boolean warning) {
        if (FlightPlanBean.getInstance().getRoute().isEmpty() || GuiUtil.showConfirmationDialog(this.mapFrame, Messages.getInstance().get("dialog_warning"), Messages.getInstance().get("dialog_all_data_will_be_lost"))) {
            this.clearAllData();
        }
    }

    public void loadAction() {
        if (FlightPlanBean.getInstance().getRoute().isEmpty() || GuiUtil.showConfirmationDialog(this.mapFrame, Messages.getInstance().get("dialog_warning"), Messages.getInstance().get("dialog_all_data_will_be_lost"))) {
            int returnVal;
            JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("open_file"), Messages.getInstance().get("open"), SettingsBean.getInstance().getVfrFilesPath());
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("vfrflight_flight_plans"), new String[]{"VFR"}));
            if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getFile())) {
                chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getFile()));
            }
            if ((returnVal = chooser.showOpenDialog(this.mapFrame)) == 0 && new File(chooser.getSelectedFile().getPath()).exists()) {
                SettingsBean.getInstance().setVfrFilesPath(chooser.getSelectedFile().getPath());
                this.loadAction(chooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    public void loadAction(String fileName) {
        this.loadAction(fileName, true);
    }

    public void loadAction(String fileName, boolean addToRecentFiles) {
        if (new File(fileName).exists()) {
            this.clearAllData();
            FlightPlanBean.getInstance().setFile(fileName);
            this.mapFrame.setDialogTitle("VfrFlight: " + fileName);
            Route route = FlightPlanUtil.load(FlightPlanBean.getInstance().getFile());
            if (route != null) {
                FlightPlanBean.getInstance().setRoute(route);
                this.updateData();
                this.mapFrame.updateMap();
                if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 0) {
                    this.mapFrame.centerMap();
                }
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_loading_success"), "", 1);
                if (addToRecentFiles) {
                    this.addRecentLoadedFile(fileName);
                }
            } else {
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_loading_error"), "", 0);
            }
        } else {
            if (addToRecentFiles) {
                this.removeRecentLoadedFile(fileName);
                this.updateRecentLoadedFilesSubmenu();
            }
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("loading_error_nofile"), "", 0);
        }
    }

    public void addRecentLoadedFile(String fileName) {
        this.removeRecentLoadedFile(fileName);
        SettingsBean.getInstance().getRecentLoadedFiles().add(fileName);
        this.updateRecentLoadedFilesSubmenu();
    }

    public void removeRecentLoadedFile(String fileName) {
        if (SettingsBean.getInstance().getRecentLoadedFiles().contains(fileName)) {
            SettingsBean.getInstance().getRecentLoadedFiles().remove(SettingsBean.getInstance().getRecentLoadedFiles().indexOf(fileName));
        }
    }

    public void fsxImportAction() {
        if (GuiUtil.showConfirmationDialog(this.mapFrame, Messages.getInstance().get("dialog_warning"), Messages.getInstance().get("dialog_all_data_will_be_lost"))) {
            JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("import"), Messages.getInstance().get("fsx_import"), SettingsBean.getInstance().getFlightPlansPath());
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("fsx_flight_plans"), new String[]{"PLN"}));
            int returnVal = chooser.showOpenDialog(this.mapFrame);
            if (returnVal == 0) {
                this.clearAllData();
                SettingsBean.getInstance().setFlightPlansPath(chooser.getSelectedFile().getPath());
                if (FsxUtil.loadFlightPlan(chooser.getSelectedFile())) {
                    this.updateData();
                    this.mapFrame.updateMap();
                    this.mapFrame.centerMap();
                    JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("fsx_plan_import_succesful"), "", 1);
                } else {
                    JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("fsx_plan_import_error"), "", 0);
                }
            }
        }
    }

    public void saveAction() {
        if (FlightPlanBean.getInstance().getFile() != null) {
            if (FlightPlanUtil.save(FlightPlanBean.getInstance().getRoute(), FlightPlanBean.getInstance().getFile())) {
                this.addRecentLoadedFile(FlightPlanBean.getInstance().getFile());
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_saving_success"), "", 1);
            } else {
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_saving_error"), "", 0);
            }
        } else {
            this.saveAsAction();
        }
    }

    public void saveAsAction() {
        String fileName;
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("save_file"), Messages.getInstance().get("save"), SettingsBean.getInstance().getVfrFilesPath());
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("vfrflight_flight_plans"), new String[]{"VFR"}));
        if (StringUtil.isEmpty(FlightPlanBean.getInstance().getFile()) && !StringUtil.isEmpty(FlightPlanBean.getInstance().getRoute().getName())) {
            chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getRoute().getName() + ".vfr"));
        } else if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getFile())) {
            chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getFile()));
        }
        int returnVal = chooser.showOpenDialog(this.mapFrame);
        if (returnVal == 0 && (!new File(fileName = IOUtil.addExtension(chooser.getSelectedFile(), "vfr")).exists() || GuiUtil.showConfirmationDialog(this.mapFrame, Messages.getInstance().get("save_file"), Messages.getInstance().get("file_saving_dialog_overwrite_question")))) {
            FlightPlanBean.getInstance().setFile(fileName);
            this.mapFrame.setDialogTitle("VfrFlight: " + fileName);
            SettingsBean.getInstance().setVfrFilesPath(chooser.getSelectedFile().getPath());
            this.saveAction();
        }
    }

    public void fsxExportAction() {
        if (this.doValidateExport()) {
            FsxExportDialog dialog = new FsxExportDialog(this.mapFrame);
            dialog.setVisible(true);
            this.hidePanel();
        }
    }

    public Route getRoute() {
        Route route = new Route();
        if (!StringUtil.isEmpty(this.windCollapsablePanel.getWindDirectionTextField().getText())) {
            try {
                route.setWindDirection(Double.valueOf(this.windCollapsablePanel.getWindDirectionTextField().getText()));
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), e);
            }
        }
        if (!StringUtil.isEmpty(this.windCollapsablePanel.getWindSpeedTextField().getText())) {
            try {
                route.setWindSpeed(Double.valueOf(this.windCollapsablePanel.getWindSpeedTextField().getText()));
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), e);
            }
        }
        if (!StringUtil.isEmpty(this.performanceCollapsablePanel.getCruiseSpeedTextField().getText())) {
            try {
                route.setCruiseSpeed(Double.valueOf(this.performanceCollapsablePanel.getCruiseSpeedTextField().getText()));
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), e);
            }
        }
        if (!StringUtil.isEmpty(this.performanceCollapsablePanel.getCruiseAltTextField().getText())) {
            try {
                route.setCruiseAlt(Double.valueOf(this.performanceCollapsablePanel.getCruiseAltTextField().getText()));
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), e);
            }
        }
        route.setName(this.infoCollapsablePanel.getRouteNameTextField().getText());
        route.setDescription(this.infoCollapsablePanel.getRouteDescTextArea().getText());
        if (!(StringUtil.isEmpty(this.performanceCollapsablePanel.getFuelBurnTextField().getText()) || StringUtil.isEmpty(this.performanceCollapsablePanel.getFuelQMaxTextField().getText()) || StringUtil.isEmpty(this.performanceCollapsablePanel.getFuelQMTextField().getText()))) {
            try {
                route.setFuelBurn(Double.valueOf(this.performanceCollapsablePanel.getFuelBurnTextField().getText()));
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), e);
            }
            try {
                route.setQmax(Double.valueOf(this.performanceCollapsablePanel.getFuelQMaxTextField().getText()));
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), e);
            }
            try {
                route.setQm(Double.valueOf(this.performanceCollapsablePanel.getFuelQMTextField().getText()));
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), e);
            }
        }
        route.setPoints(this.pointsCollapsablePanel.getPointsTable().getData());
        route.setVors(this.vorCollapsablePanel.getVorTable().getData());
        return route;
    }

    public void saveBeanPointsData(boolean saveHistory) {
        FlightPlanBean.getInstance().getRoute().setPoints(this.pointsCollapsablePanel.getPointsTable().getData());
        if (this.isInitialized) {
            this.mapFrame.updateMap();
        }
    }

    public void saveBeanVorData(boolean saveHistory) {
        FlightPlanBean.getInstance().getRoute().setVors(this.vorCollapsablePanel.getVorTable().getData());
        if (this.isInitialized) {
            this.mapFrame.updateMap();
        }
    }

    public void selectPointsTableRow(int i) {
        this.pointsCollapsablePanel.getPointsTable().selectRow(i);
    }

    public void selectVorTableRow(int i) {
        this.vorCollapsablePanel.getVorTable().selectRow(i);
    }

    public void addNewPoint(GpsPlace point, Integer index) {
        if (point.getAlt() == null && !StringUtil.isEmpty(this.performanceCollapsablePanel.getCruiseAltTextField().getText())) {
            try {
                Double alt = Double.valueOf(StringUtil.emptyToZero(this.performanceCollapsablePanel.getCruiseAltTextField().getText()));
                point.setAlt(alt);
            }
            catch (NumberFormatException alt) {}
        } else if (point.getAlt() == null) {
            point.setAlt(0.0);
        }
        if (StringUtil.isEmpty(point.getName())) {
            point.setName(VfrUtil.getNextNameFromPoints("WP", FlightPlanBean.getInstance().getRoute().getPoints()));
        }
        this.pointsCollapsablePanel.getPointsTable().addPoint(new RoutePlace(point), index);
        this.updateRoutePointsInfoLabel();
        if (index != null) {
            double indexSegmentLen = FlightPlanBean.getInstance().getRoute().getSegments().get(index - 1).getDistance();
            double nextIndexSegmentLen = FlightPlanBean.getInstance().getRoute().getSegments().get(index).getDistance();
            double divRatio = indexSegmentLen / (indexSegmentLen + nextIndexSegmentLen);
            for (int i = 0; i < FlightPlanBean.getInstance().getRoute().getLandmarks().size(); ++i) {
                SegmentLandmark landmark = FlightPlanBean.getInstance().getRoute().getLandmarks().get(i);
                if (landmark.getSegmentIndex() >= index) {
                    landmark.setSegmentIndex(landmark.getSegmentIndex() + 1);
                } else if (landmark.getSegmentIndex() == index - 1) {
                    if (landmark.getPosition() >= divRatio) {
                        landmark.setPosition((landmark.getPosition() - divRatio) / (1.0 - divRatio));
                        landmark.setSegmentIndex(landmark.getSegmentIndex() + 1);
                    } else {
                        landmark.setPosition(landmark.getPosition() / divRatio);
                    }
                }
                FlightPlanBean.getInstance().getRoute().getLandmarks().set(i, landmark);
            }
        }
        this.mapFrame.updateMap();
    }

    public void addNewVor(GpsPlace vor) {
        if (StringUtil.isEmpty(vor.getName())) {
            vor.setName(VfrUtil.getNextNameFromPoints("VOR", FlightPlanBean.getInstance().getRoute().getVors()));
        }
        this.vorCollapsablePanel.getVorTable().addPoint(new RoutePlace(vor));
    }

    public void cruiseSpeedChanged() {
        try {
            Double cruiseSpeed = Double.valueOf(this.performanceCollapsablePanel.getCruiseSpeedTextField().getText());
            if (!cruiseSpeed.equals(FlightPlanBean.getInstance().getRoute().getCruiseSpeed())) {
                FlightPlanBean.getInstance().getRoute().setCruiseSpeed(cruiseSpeed);
                this.updateRoutePointsInfoLabel();
            }
        }
        catch (NumberFormatException e) {
            this.performanceCollapsablePanel.getCruiseSpeedTextField().setText("");
            FlightPlanBean.getInstance().getRoute().setCruiseSpeed(null);
        }
        if (SettingsBean.getInstance().isCalculateRouteInRealTime()) {
            this.updateRoutePointsInfoLabel();
            this.mapFrame.updateMap();
        } else if (this.mapFrame.getMapViewer().isMultipleRulersMode()) {
            this.mapFrame.getMapViewer().repaint();
        }
    }

    protected void descendSpeedChanged() {
        try {
            Double descendSpeed = Double.valueOf(this.performanceCollapsablePanel.getDescendingSpeedTextField().getText());
            if (!descendSpeed.equals(FlightPlanBean.getInstance().getRoute().getDescendingSpeed())) {
                FlightPlanBean.getInstance().getRoute().setDescendingSpeed(descendSpeed);
                this.updateRoutePointsInfoLabel();
            }
        }
        catch (NumberFormatException e) {
            this.performanceCollapsablePanel.getDescendingSpeedTextField().setText("");
            FlightPlanBean.getInstance().getRoute().setDescendingSpeed(null);
        }
        if (SettingsBean.getInstance().isCalculateRouteInRealTime()) {
            this.updateRoutePointsInfoLabel();
            this.mapFrame.updateMap();
        } else if (this.mapFrame.getMapViewer().isMultipleRulersMode()) {
            this.mapFrame.getMapViewer().repaint();
        }
    }

    protected void climbSpeedChanged() {
        try {
            Double climbingSpeed = Double.valueOf(this.performanceCollapsablePanel.getClimbingSpeedTextField().getText());
            if (!climbingSpeed.equals(FlightPlanBean.getInstance().getRoute().getClimbingSpeed())) {
                FlightPlanBean.getInstance().getRoute().setClimbingSpeed(climbingSpeed);
                this.updateRoutePointsInfoLabel();
            }
        }
        catch (NumberFormatException e) {
            this.performanceCollapsablePanel.getClimbingSpeedTextField().setText("");
            FlightPlanBean.getInstance().getRoute().setClimbingSpeed(null);
        }
        if (SettingsBean.getInstance().isCalculateRouteInRealTime()) {
            this.updateRoutePointsInfoLabel();
            this.mapFrame.updateMap();
        } else if (this.mapFrame.getMapViewer().isMultipleRulersMode()) {
            this.mapFrame.getMapViewer().repaint();
        }
    }

    public void cruiseAltChanged() {
        try {
            Double cruiseAlt = Double.valueOf(this.performanceCollapsablePanel.getCruiseAltTextField().getText());
            if (!cruiseAlt.equals(FlightPlanBean.getInstance().getRoute().getCruiseAlt())) {
                FlightPlanBean.getInstance().getRoute().setCruiseAlt(cruiseAlt);
            }
        }
        catch (NumberFormatException e) {
            this.performanceCollapsablePanel.getCruiseAltTextField().setText("");
            FlightPlanBean.getInstance().getRoute().setCruiseAlt(null);
        }
    }

    public void fuelBurnChanged() {
        try {
            Double fuelBurn = Double.valueOf(this.performanceCollapsablePanel.getFuelBurnTextField().getText());
            if (!fuelBurn.equals(FlightPlanBean.getInstance().getRoute().getFuelBurn())) {
                FlightPlanBean.getInstance().getRoute().setFuelBurn(fuelBurn);
            }
        }
        catch (NumberFormatException e) {
            this.performanceCollapsablePanel.getFuelBurnTextField().setText("");
            FlightPlanBean.getInstance().getRoute().setFuelBurn(null);
        }
        if (this.mapFrame.getMapViewer().isMultipleRulersMode()) {
            this.mapFrame.getMapViewer().repaint();
        }
    }

    public void navFuelReserveMinChanged() {
        try {
            Integer navFuelReserveMin = Integer.valueOf(this.performanceCollapsablePanel.getNavFuelReserveTextField().getText());
            if (!navFuelReserveMin.equals(FlightPlanBean.getInstance().getRoute().getNavFuelReserveMin())) {
                FlightPlanBean.getInstance().getRoute().setNavFuelReserveMin(navFuelReserveMin);
            }
        }
        catch (NumberFormatException e) {
            this.performanceCollapsablePanel.getNavFuelReserveTextField().setText("");
            FlightPlanBean.getInstance().getRoute().setNavFuelReserveMin(null);
        }
    }

    public void routeNameChanged() {
        FlightPlanBean.getInstance().getRoute().setName(this.infoCollapsablePanel.getRouteNameTextField().getText());
    }

    public void routeNameAutoSetAction() {
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() < 2) {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_validation_route_points_points_number"), "", 0);
        } else {
            String name = FlightPlanBean.getInstance().getRoute().getPoints().get(0).getName() + " " + FlightPlanBean.getInstance().getRoute().getPoints().get(FlightPlanBean.getInstance().getRoute().getPoints().size() - 1).getName();
            this.infoCollapsablePanel.getRouteNameTextField().setText(name);
            this.routeNameChanged();
            if (StringUtil.isEmpty(this.infoCollapsablePanel.getRouteDescTextArea().getText())) {
                SimpleDateFormat df = new SimpleDateFormat("dd MMMM yyyy HH:mm:ss");
                this.infoCollapsablePanel.getRouteDescTextArea().setText(Messages.getInstance().get("creation_date", df.format(Calendar.getInstance().getTime())));
                this.routeDescChanged();
            }
        }
    }

    public void routeDescChanged() {
        FlightPlanBean.getInstance().getRoute().setDescription(this.infoCollapsablePanel.getRouteDescTextArea().getText());
    }

    public void updateWindDirection(Double direction) {
        this.windCollapsablePanel.getWindDirectionTextField().setText(String.valueOf(Math.round(direction)));
        this.windDirectionChanged();
    }

    public void windDirectionChanged() {
        try {
            double windDirection = GpsUtil.normalizeCourse(Double.valueOf(this.windCollapsablePanel.getWindDirectionTextField().getText()));
            this.windCollapsablePanel.getWindDirectionTextField().setText(FormatUtil.formattedCourse(windDirection, false));
            FlightPlanBean.getInstance().getRoute().setWindDirection(windDirection);
        }
        catch (NumberFormatException e) {
            this.windCollapsablePanel.getWindDirectionTextField().setText("");
            FlightPlanBean.getInstance().getRoute().setWindDirection(null);
        }
        this.updateWindCanvas();
        if (this.isInitialized) {
            this.mapFrame.updateMap();
        }
    }

    public void fuelQMaxChanged() {
        try {
            Double qmax = Double.valueOf(this.performanceCollapsablePanel.getFuelQMaxTextField().getText());
            if (!qmax.equals(FlightPlanBean.getInstance().getRoute().getQmax())) {
                FlightPlanBean.getInstance().getRoute().setQmax(qmax);
            }
        }
        catch (NumberFormatException e) {
            this.performanceCollapsablePanel.getFuelQMaxTextField().setText("");
            FlightPlanBean.getInstance().getRoute().setQmax(null);
        }
    }

    public void fuelQMChanged() {
        try {
            Double qm = Double.valueOf(this.performanceCollapsablePanel.getFuelQMTextField().getText());
            if (!qm.equals(FlightPlanBean.getInstance().getRoute().getQm())) {
                FlightPlanBean.getInstance().getRoute().setQm(qm);
            }
        }
        catch (NumberFormatException e) {
            this.performanceCollapsablePanel.getFuelQMTextField().setText("");
            FlightPlanBean.getInstance().getRoute().setQm(null);
        }
    }

    public void windSpeedChanged() {
        try {
            Double windSpeed = Double.valueOf(this.windCollapsablePanel.getWindSpeedTextField().getText());
            FlightPlanBean.getInstance().getRoute().setWindSpeed(windSpeed);
            this.updateWindCanvas();
            if (this.isInitialized) {
                this.mapFrame.updateMap();
            }
        }
        catch (NumberFormatException e) {
            this.windCollapsablePanel.getWindSpeedTextField().setText("");
            FlightPlanBean.getInstance().getRoute().setWindSpeed(null);
        }
    }

    public void setPlaneProfilesCombo(List<PlaneProfile> profiles) {
        this.performanceCollapsablePanel.getProfileCombo().removeAllItems();
        this.performanceCollapsablePanel.getProfileCombo().addItem(new ComboBoxItem<PlaneProfile>("", PlaneProfile.EMPTY));
        for (PlaneProfile profile : profiles) {
            this.performanceCollapsablePanel.getProfileCombo().addItem(new ComboBoxItem<PlaneProfile>(profile.getName(), profile));
        }
    }

    private boolean isProfileData() {
        if (FlightPlanBean.getInstance().getRoute().getCruiseAlt() != null) {
            return true;
        }
        if (FlightPlanBean.getInstance().getRoute().getClimbingSpeed() != null) {
            return true;
        }
        if (FlightPlanBean.getInstance().getRoute().getDescendingSpeed() != null) {
            return true;
        }
        if (FlightPlanBean.getInstance().getRoute().getCruiseSpeed() != null) {
            return true;
        }
        if (FlightPlanBean.getInstance().getRoute().getFuelBurn() != null) {
            return true;
        }
        if (FlightPlanBean.getInstance().getRoute().getQmax() != null) {
            return true;
        }
        if (FlightPlanBean.getInstance().getRoute().getQm() != null) {
            return true;
        }
        return FlightPlanBean.getInstance().getRoute().getNavFuelReserveMin() != null;
    }

    private void saveNewProfileAction() {
        if (this.isProfileData()) {
            String name = null;
            while ((name = JOptionPane.showInputDialog(this.mapFrame, (Object)Messages.getInstance().get("profile_save_name"))) != null && StringUtil.isEmpty(name)) {
            }
            if (name != null) {
                PlaneProfile profile = new PlaneProfile(name);
                profile.setCruiseAlt(FlightPlanBean.getInstance().getRoute().getCruiseAlt());
                profile.setCruiseSpeed(FlightPlanBean.getInstance().getRoute().getCruiseSpeed());
                profile.setClimbingSpeed(FlightPlanBean.getInstance().getRoute().getClimbingSpeed());
                profile.setDescendingSpeed(FlightPlanBean.getInstance().getRoute().getDescendingSpeed());
                profile.setCruiseSpeed(FlightPlanBean.getInstance().getRoute().getCruiseSpeed());
                profile.setFuelBurn(FlightPlanBean.getInstance().getRoute().getFuelBurn());
                profile.setFuelQm(FlightPlanBean.getInstance().getRoute().getQm());
                profile.setFuelQmax(FlightPlanBean.getInstance().getRoute().getQmax());
                profile.setNavFuelReserveMin(FlightPlanBean.getInstance().getRoute().getNavFuelReserveMin());
                SettingsBean.getInstance().getPlaneProfiles().add(profile);
                this.setPlaneProfilesCombo(SettingsBean.getInstance().getPlaneProfiles());
                this.performanceCollapsablePanel.getProfileCombo().setSelectedIndex(SettingsBean.getInstance().getPlaneProfiles().size());
                PlaneProfileUtil.saveProfiles(SettingsBean.getInstance().getPlaneProfiles(), "conf/profiles.xml");
            }
        }
    }

    private void deleteProfileAction() {
        if (this.performanceCollapsablePanel.getProfileCombo().getSelectedIndex() > 0 && GuiUtil.showConfirmationDialog(this.mapFrame, Messages.getInstance().get("delete"), Messages.getInstance().get("are_you_sure"))) {
            int sel = this.performanceCollapsablePanel.getProfileCombo().getSelectedIndex() - 1;
            SettingsBean.getInstance().getPlaneProfiles().remove(sel);
            this.setPlaneProfilesCombo(SettingsBean.getInstance().getPlaneProfiles());
            this.performanceCollapsablePanel.getProfileCombo().setSelectedIndex(sel);
            PlaneProfileUtil.saveProfiles(SettingsBean.getInstance().getPlaneProfiles(), "conf/profiles.xml");
        }
    }

    private void updateProfileAction() {
        if (this.isProfileData()) {
            if (this.performanceCollapsablePanel.getProfileCombo().getSelectedIndex() == 0) {
                this.saveNewProfileAction();
            } else {
                PlaneProfile profile = SettingsBean.getInstance().getPlaneProfiles().get(this.performanceCollapsablePanel.getProfileCombo().getSelectedIndex() - 1);
                profile.setCruiseAlt(FlightPlanBean.getInstance().getRoute().getCruiseAlt());
                profile.setCruiseSpeed(FlightPlanBean.getInstance().getRoute().getCruiseSpeed());
                profile.setClimbingSpeed(FlightPlanBean.getInstance().getRoute().getClimbingSpeed());
                profile.setDescendingSpeed(FlightPlanBean.getInstance().getRoute().getDescendingSpeed());
                profile.setFuelBurn(FlightPlanBean.getInstance().getRoute().getFuelBurn());
                profile.setFuelQm(FlightPlanBean.getInstance().getRoute().getQm());
                profile.setFuelQmax(FlightPlanBean.getInstance().getRoute().getQmax());
                profile.setNavFuelReserveMin(FlightPlanBean.getInstance().getRoute().getNavFuelReserveMin());
                int sel = this.performanceCollapsablePanel.getProfileCombo().getSelectedIndex();
                this.setPlaneProfilesCombo(SettingsBean.getInstance().getPlaneProfiles());
                this.performanceCollapsablePanel.getProfileCombo().setSelectedIndex(sel);
                PlaneProfileUtil.saveProfiles(SettingsBean.getInstance().getPlaneProfiles(), "conf/profiles.xml");
            }
        }
    }

    public void userPointsFrameAction() {
        UserPointsDialog userPointsFrame = new UserPointsDialog(this.mapFrame);
        userPointsFrame.setVisible(true);
    }

    public void routePointsClearAllAction() {
        FlightPlanBean.getInstance().getRoute().getLandmarks().clear();
        this.pointsCollapsablePanel.getPointsTable().clearData();
        FlightPlanBean.getInstance().getRoute().getPoints().clear();
        this.updateRoutePointsInfoLabel();
    }

    public void vorClearAllAction() {
        FlightPlanBean.getInstance().getRoute().getMapRadials().clear();
        this.vorCollapsablePanel.getVorTable().clearData();
        FlightPlanBean.getInstance().getRoute().getVors().clear();
        this.updateRoutePointsInfoLabel();
    }

    public void simConnectAction() {
        if (SettingsBean.getInstance().getExtConnectTask() == null) {
            this.doConnectAction();
        } else {
            this.doDisconnectAction();
            new HintDialog((Window)this.mapFrame, 1);
        }
    }

    public void doConnectAction() {
        JDialog dialog;
        boolean doConnect = false;
        StringComboBoxItem val = (StringComboBoxItem)this.mapFrame.getConnectionCombo().getSelectedItem();
        if ("fsx_p3d".equals(val.getValue())) {
            dialog = new FsxP3DConnectDialog();
            dialog.setVisible(true);
            if (!((FsxP3DConnectDialog)dialog).isCancelled()) {
                SettingsBean.getInstance().setExtConnectTask(new SimConnectTask(SettingsBean.getInstance().getSimConnectConfigBean(), SettingsBean.getInstance().getFsxP3DConnectConfigBean()));
                doConnect = true;
            }
        } else if ("xplane".equals(val.getValue())) {
            dialog = new XPConnectDialog();
            dialog.setVisible(true);
            if (!((XPConnectDialog)dialog).isCancelled()) {
                SettingsBean.getInstance().setExtConnectTask(new XPConnectTask(SettingsBean.getInstance().getSimConnectConfigBean(), SettingsBean.getInstance().getXpConnectConfigBean()));
                doConnect = true;
            }
        } else if ("flightgear".equals(val.getValue())) {
            dialog = new FlightGearConnectDialog();
            dialog.setVisible(true);
            if (!((FlightGearConnectDialog)dialog).isCancelled()) {
                SettingsBean.getInstance().setExtConnectTask(new FlightgearConnectTask(SettingsBean.getInstance().getSimConnectConfigBean(), SettingsBean.getInstance().getFlightGearConnectConfigBean()));
                doConnect = true;
            }
        } else if ("gps".equals(val.getValue())) {
            SimConnectConfigBean bean = SettingsBean.getInstance().getSimConnectConfigBean();
            bean.setNmeaLogInsteadOfGps(false);
            bean.setNmeaLogFile(null);
            GpsConnectTask connectTask = new GpsConnectTask(SettingsBean.getInstance().getSimConnectConfigBean());
            connectTask.setOutputFile("nmea-out-" + System.currentTimeMillis() + ".log");
            SettingsBean.getInstance().setExtConnectTask(connectTask);
            doConnect = true;
        } else if ("nmea_log".equals(val.getValue())) {
            int returnVal;
            JFileChooser chooser = GuiUtil.getFileChooser("", Messages.getInstance().get("open"));
            chooser.setFileFilter(new ExtensionFileFilter("Log files", new String[]{"LOG"}));
            if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getFile())) {
                chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getFile()));
            }
            if ((returnVal = chooser.showOpenDialog(this.mapFrame)) == 0 && new File(chooser.getSelectedFile().getPath()).exists()) {
                SimConnectConfigBean bean = SettingsBean.getInstance().getSimConnectConfigBean();
                bean.setNmeaLogInsteadOfGps(true);
                bean.setNmeaLogFile(chooser.getSelectedFile().getPath());
                GpsConnectTask connectTask = new GpsConnectTask(bean);
                SettingsBean.getInstance().setExtConnectTask(connectTask);
                doConnect = true;
            }
        }
        if (doConnect) {
            Thread t = new Thread(SettingsBean.getInstance().getExtConnectTask());
            t.start();
            this.mapFrame.getSimConnectMenuItem().setText(Messages.getInstance().get("main_frame_menu_sim_disconnect"));
            this.mapFrame.getConnectButton().setToolTipText(Messages.getInstance().get("main_frame_menu_sim_disconnect"));
            this.mapFrame.getConnectButton().setIcon(new ImageIcon("img/gui/disconnect.png"));
            this.mapFrame.getConnectionCombo().setEnabled(false);
            this.mapFrame.setDialogTitle(this.mapFrame.getTitle());
            this.mapFrame.getMapViewer().repaint();
        }
    }

    public void doDisconnectAction() {
        boolean simConnectTask = SettingsBean.getInstance().getExtConnectTask() instanceof SimConnectTask;
        if (SettingsBean.getInstance().getExtConnectTask() != null) {
            SettingsBean.getInstance().getExtConnectTask().setRunning(false);
        }
        SettingsBean.getInstance().setExtConnectTask(null);
        SettingsBean.getInstance().getSimConnectConfigBean().setVectorTo(null);
        SettingsBean.getInstance().getSimConnectConfigBean().setVectorInfoPos(null);
        if (simConnectTask && SimConnectUtil.getInstance().getUserTrack().size() > 0) {
            SimConnectUtil.getInstance().findGroundAltitudeOffset();
        }
        this.mapFrame.getSimConnectMenuItem().setText(Messages.getInstance().get("main_frame_menu_sim_connect"));
        this.mapFrame.getConnectButton().setToolTipText(Messages.getInstance().get("main_frame_menu_sim_connect"));
        this.mapFrame.getConnectButton().setIcon(new ImageIcon("img/gui/connect.png"));
        this.mapFrame.getConnectionCombo().setEnabled(true);
        this.mapFrame.setTitle(this.mapFrame.getPreviousTitle());
        this.mapFrame.updateMap();
    }

    public void importFsxBglAction() {
        if (GuiUtil.showConfirmationDialog(this.mapFrame, Messages.getInstance().get("dialog_warning"), Messages.getInstance().get("dialog_airspace_fsx_p3d_data_will_be_lost"))) {
            JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("import"), Messages.getInstance().get("fsx_import"));
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("bgl_files"), new String[]{"BGL"}));
            int returnVal = chooser.showOpenDialog(this.mapFrame);
            if (returnVal == 0) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                BglImportBean importBean = new BglImportBean();
                importBean.setSelectiveTruncate(true);
                importBean.setImportAirports(false);
                importBean.setImportBoundaries(true);
                importBean.setImportFrequencies(false);
                importBean.setImportGeopol(true);
                importBean.setImportIls(false);
                importBean.setImportNavaids(false);
                importBean.setImportRoutes(false);
                importBean.setImportRunways(false);
                importBean.setImportStarts(false);
                importBean.setImportWaypoints(false);
                Thread t = new Thread(new BglImportTask(importBean, chooser.getSelectedFile().getAbsolutePath()));
                t.start();
            }
        }
    }

    public void importAixmDataAction() {
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("import"), Messages.getInstance().get("import"));
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("aixm_files"), new String[]{"XML"}));
        int returnVal = chooser.showOpenDialog(this.mapFrame);
        if (returnVal == 0 && new File(chooser.getSelectedFile().getPath()).exists()) {
            ImportOverwriteDialog dialog = new ImportOverwriteDialog((Window)this.mapFrame);
            dialog.setVisible(true);
            if (dialog.getEraseAndOverwrite() != null) {
                boolean overwriteData = dialog.getEraseAndOverwrite();
                String filename = chooser.getSelectedFile().getAbsolutePath();
                new Thread(new AixmImportTask(filename, overwriteData)).start();
            }
        }
    }

    public void importDataActionFinish(boolean result) {
        if (result) {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("import_success"), "", 1);
        } else {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("import_error"), "", 0);
        }
    }

    public void exportDataActionFinish(boolean result) {
        if (result) {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("export_success"), "", 1);
        } else {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("export_error"), "", 0);
        }
    }

    public void importXmlDataAction() {
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("import"), Messages.getInstance().get("import"));
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("xml_files"), new String[]{"XML"}));
        int returnVal = chooser.showOpenDialog(this.mapFrame);
        if (returnVal == 0 && new File(chooser.getSelectedFile().getPath()).exists()) {
            ImportOverwriteDialog dialog = new ImportOverwriteDialog((Window)this.mapFrame);
            dialog.setVisible(true);
            if (dialog.getEraseAndOverwrite() != null) {
                boolean overwriteData = dialog.getEraseAndOverwrite();
                String filename = chooser.getSelectedFile().getAbsolutePath();
                new Thread(new XmlImportTask(filename, overwriteData)).start();
            }
        }
    }

    public void exportXmlDataAction() {
        XmlExportDialog dialog = new XmlExportDialog((Window)this.mapFrame);
        dialog.setVisible(true);
    }

    public void importFsxDataAction() {
        if (VfrUtil.isWindows()) {
            new HintDialog((Window)this.mapFrame, 0);
            FsxImportDataStep1Dialog fidDialog = new FsxImportDataStep1Dialog(this.mapFrame, new SceneryConfigPathsBean());
            fidDialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("main_frame_import_fsx_data_os_error"), "", 0);
        }
    }

    public void newPtsAction() {
        GpsPlace place = VfrUtil.getGpsPlaceFromWindowsClipboard();
        if (place == null) {
            this.pointsCollapsablePanel.getPointsTable().addRow();
        } else {
            RoutePlace fromClipboard = new RoutePlace(place);
            fromClipboard.setAlt(0.0);
            if (fromClipboard.getName() == null) {
                fromClipboard.setName(VfrUtil.getNextNameFromPoints("WP", FlightPlanBean.getInstance().getRoute().getPoints()));
            }
            this.pointsCollapsablePanel.getPointsTable().addPoint(fromClipboard);
        }
        this.pointsCollapsablePanel.getPointsTable().scrollToBottom();
    }

    public void newVorAction() {
        GpsPlace place = VfrUtil.getGpsPlaceFromWindowsClipboard();
        if (place == null) {
            this.vorCollapsablePanel.getVorTable().addRow();
        } else {
            RoutePlace fromClipboard = new RoutePlace(place);
            if (fromClipboard.getName() == null) {
                fromClipboard.setName(VfrUtil.getNextNameFromPoints("VOR", FlightPlanBean.getInstance().getRoute().getVors()));
            }
            this.vorCollapsablePanel.getVorTable().addPoint(fromClipboard);
        }
        this.vorCollapsablePanel.getVorTable().scrollToBottom();
    }

    public void delPtsAction() {
        if (this.pointsCollapsablePanel.getPointsTable().getTable().getSelectedRow() >= 0) {
            int[] idxs = this.pointsCollapsablePanel.getPointsTable().getTable().getSelectedRows();
            for (int q = 0; q < idxs.length; ++q) {
                this.delPtsAction(idxs[q] - q);
            }
            this.updateRoutePointsInfoLabel();
            this.mapFrame.updateMap();
        }
    }

    public void delPtsAction(int idx) {
        this.pointsCollapsablePanel.getPointsTable().removeRow(idx);
        this.saveBeanPointsData(false);
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 1) {
            for (int i = 0; i < FlightPlanBean.getInstance().getRoute().getLandmarks().size(); ++i) {
                SegmentLandmark landmark = FlightPlanBean.getInstance().getRoute().getLandmarks().get(i);
                if (landmark.getSegmentIndex() >= idx - 1) {
                    int didx = landmark.getSegmentIndex() - 1;
                    if (didx < 0) {
                        didx = 0;
                    }
                    landmark.setSegmentIndex(didx);
                }
                FlightPlanBean.getInstance().getRoute().getLandmarks().set(i, landmark);
            }
        } else {
            FlightPlanBean.getInstance().getRoute().getLandmarks().clear();
        }
    }

    public void delVorAction() {
        if (this.vorCollapsablePanel.getVorTable().getTable().getSelectedRow() >= 0) {
            int[] idxs = this.vorCollapsablePanel.getVorTable().getTable().getSelectedRows();
            for (int q = 0; q < idxs.length; ++q) {
                this.delVorAction(idxs[q] - q);
            }
        }
    }

    public void delVorAction(int idx) {
        boolean findEmpty = false;
        for (int i = 0; i < FlightPlanBean.getInstance().getRoute().getMapRadials().size(); ++i) {
            MapRadials mapRadials = FlightPlanBean.getInstance().getRoute().getMapRadials().get(i);
            Integer mridx = null;
            for (int w = 0; w < mapRadials.getVorIdxs().size(); ++w) {
                if (mapRadials.getVorIdxs().get(w) == idx) {
                    mridx = w;
                    continue;
                }
                if (mapRadials.getVorIdxs().get(w) <= idx) continue;
                mapRadials.getVorIdxs().set(w, mapRadials.getVorIdxs().get(w) - 1);
            }
            if (mridx == null) continue;
            mapRadials.getVorIdxs().remove(mridx);
            if (mapRadials.getVorIdxs().size() != 0) continue;
            findEmpty = true;
        }
        if (findEmpty) {
            Iterator<MapRadials> iterator = FlightPlanBean.getInstance().getRoute().getMapRadials().iterator();
            while (iterator.hasNext()) {
                MapRadials radials = iterator.next();
                if (radials.getVorIdxs().size() != 0) continue;
                iterator.remove();
            }
        }
        this.vorCollapsablePanel.getVorTable().removeRow(idx);
        this.saveBeanVorData(false);
    }

    public void downPtsAction() {
        int selectedRow = this.pointsCollapsablePanel.getPointsTable().getTable().getSelectedRow();
        if (selectedRow < this.pointsCollapsablePanel.getPointsTable().getTable().getRowCount() - 1) {
            this.pointsCollapsablePanel.getPointsTable().getModel().moveRowDown(this.pointsCollapsablePanel.getPointsTable().getTable().getSelectedRow());
            this.pointsCollapsablePanel.getPointsTable().getTable().getSelectionModel().setSelectionInterval(selectedRow + 1, selectedRow + 1);
            this.saveBeanPointsData(true);
        }
    }

    public void upPtsAction() {
        int selectedRow = this.pointsCollapsablePanel.getPointsTable().getTable().getSelectedRow();
        if (selectedRow > 0) {
            this.pointsCollapsablePanel.getPointsTable().getModel().moveRowUp(this.pointsCollapsablePanel.getPointsTable().getTable().getSelectedRow());
            this.pointsCollapsablePanel.getPointsTable().getTable().getSelectionModel().setSelectionInterval(selectedRow - 1, selectedRow - 1);
            this.saveBeanPointsData(true);
        }
    }

    public void getMsaAction() {
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() < 2) {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_validation_route_points_points_number"), "", 0);
        } else {
            ElevationFacade elevationFacade = new ElevationFacade(DBUtil.getDataSource());
            Integer msa = elevationFacade.calculateMsa(this.mapFrame.getMapViewer(), FlightPlanBean.getInstance().getRoute().getSegments());
            if (msa != null) {
                if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 2) {
                    if (GuiUtil.showConfirmationDialog(this.mapFrame, "", Messages.getInstance().get("flight_plan_minimum_safe_altitude_is_question", msa + UnitUtil.getAltitudeUnit()))) {
                        this.setToPointsAction((double)msa);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_minimum_safe_altitude_is", msa + UnitUtil.getAltitudeUnit()), "", 1);
                }
            } else {
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_minimum_safe_altitude_error"), "", 0);
            }
        }
    }

    public void copyAllPtsAction() {
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (RoutePlace place : FlightPlanBean.getInstance().getRoute().getPoints()) {
                sb.append(place.getName());
                sb.append(" ");
            }
            StringUtil.copyToClipboard(sb.toString().trim());
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("flight_plan_copied_all_to_clipboard"), "", 1);
        }
    }

    public void reversePtsAction() {
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 1) {
            int i;
            ArrayList<RoutePlace> points = new ArrayList<RoutePlace>();
            ArrayList<SegmentLandmark> landmarks = new ArrayList<SegmentLandmark>();
            for (i = FlightPlanBean.getInstance().getRoute().getPoints().size() - 1; i >= 0; --i) {
                points.add(FlightPlanBean.getInstance().getRoute().getPoints().get(i));
            }
            for (i = 0; i < FlightPlanBean.getInstance().getRoute().getLandmarks().size(); ++i) {
                SegmentLandmark landmark = FlightPlanBean.getInstance().getRoute().getLandmarks().get(i);
                landmark.setPosition(1.0 - landmark.getPosition());
                landmark.setSegmentIndex(points.size() - 2 - landmark.getSegmentIndex());
                landmarks.add(landmark);
            }
            FlightPlanBean.getInstance().getRoute().setPoints(points);
            FlightPlanBean.getInstance().getRoute().setLandmarks(landmarks);
            FlightPlanBean.getInstance().getRoute().calculateSegments();
            this.updateRoutePoints();
            this.mapFrame.updateMap();
        }
    }

    public void duplicatePtsAction() {
        int selectedRow = this.pointsCollapsablePanel.getPointsTable().getTable().getSelectedRow();
        if (selectedRow >= 0) {
            this.pointsCollapsablePanel.getPointsTable().duplicateRow(this.pointsCollapsablePanel.getPointsTable().getTable().getSelectedRow());
            this.pointsCollapsablePanel.getPointsTable().getTable().getSelectionModel().setSelectionInterval(selectedRow + 1, selectedRow + 1);
            for (int i = 0; i < FlightPlanBean.getInstance().getRoute().getLandmarks().size(); ++i) {
                SegmentLandmark landmark = FlightPlanBean.getInstance().getRoute().getLandmarks().get(i);
                if (landmark.getSegmentIndex() >= selectedRow) {
                    int didx = landmark.getSegmentIndex() + 1;
                    landmark.setSegmentIndex(didx);
                }
                FlightPlanBean.getInstance().getRoute().getLandmarks().set(i, landmark);
            }
            this.saveBeanPointsData(true);
            this.updateRoutePointsInfoLabel();
        }
    }

    protected void xplaneImportAction() {
        if (GuiUtil.showConfirmationDialog(this.mapFrame, Messages.getInstance().get("dialog_warning"), Messages.getInstance().get("dialog_all_data_will_be_lost"))) {
            JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("import"), Messages.getInstance().get("import_button"));
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("fms_files"), new String[]{"FMS"}));
            int returnVal = chooser.showOpenDialog(this.mapFrame);
            if (returnVal == 0) {
                this.clearAllData();
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                if (XplaneImportUtil.loadFms(chooser.getSelectedFile())) {
                    this.updateData();
                    this.mapFrame.updateMap();
                    this.mapFrame.centerMap();
                    JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("import_success"), "", 1);
                } else {
                    JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("import_error"), "", 0);
                }
            }
        }
    }

    protected void googleEarthImportAction() {
        if (GuiUtil.showConfirmationDialog(this.mapFrame, Messages.getInstance().get("dialog_warning"), Messages.getInstance().get("dialog_all_data_will_be_lost"))) {
            JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("import"), Messages.getInstance().get("google_earth_import"));
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("kml_files"), new String[]{"KML"}));
            int returnVal = chooser.showOpenDialog(this.mapFrame);
            if (returnVal == 0) {
                this.clearAllData();
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                if (KmlUtil.loadKml(chooser.getSelectedFile())) {
                    this.updateData();
                    this.mapFrame.updateMap();
                    this.mapFrame.centerMap();
                    JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("google_earth_import_succesful"), "", 1);
                } else {
                    JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("google_earth_import_error"), "", 0);
                }
            }
        }
    }

    protected void googleEarthExportAction() {
        if (this.doValidateExport()) {
            int returnVal;
            JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("google_earth_export"), Messages.getInstance().get("save"));
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("kml_files"), new String[]{"KML"}));
            if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getRoute().getName())) {
                chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getRoute().getName() + ".kml"));
            }
            if ((returnVal = chooser.showOpenDialog(this.mapFrame)) == 0) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "kml");
                if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(this.mapFrame, Messages.getInstance().get("google_earth_export"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                    if (KmlUtil.saveKml(FlightPlanBean.getInstance().getRoute(), fileName)) {
                        JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("google_earth_export_success"), "", 1);
                    } else {
                        JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("google_earth_export_error"), "", 0);
                    }
                }
            }
        }
    }

    public void updateRecentLoadedFilesSubmenu() {
        this.mapFrame.getRecentLoadedFilesMenu().removeAll();
        if (SettingsBean.getInstance().getRecentLoadedFiles().size() > 0) {
            for (int i = SettingsBean.getInstance().getRecentLoadedFiles().size() - 1; i >= 0; --i) {
                String item = (String)SettingsBean.getInstance().getRecentLoadedFiles().get(i);
                JMenuItem menuItem = new JMenuItem(item);
                menuItem.addActionListener(new RecentLoadedMenuActionListener(item));
                this.mapFrame.getRecentLoadedFilesMenu().add(menuItem);
            }
        } else {
            JMenuItem menuItem = new JMenuItem(Messages.getInstance().get("recent_loaded_files_submenu_empty"));
            menuItem.setEnabled(false);
            this.mapFrame.getRecentLoadedFilesMenu().add(menuItem);
        }
    }

    public void exportPdfAction() {
        if (this.doValidate(true)) {
            FlightPlanBean.getInstance().getRoute().calculate();
            CalculationResultDialog resultFrame = new CalculationResultDialog();
            resultFrame.updateData();
            resultFrame.exportPdfAction(false);
        }
    }

    public void xplaneFmsExportAction() {
        if (this.doValidate(true)) {
            JFileChooser chooser = GuiUtil.getFileChooser("", Messages.getInstance().get("export_button"));
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("fms_files"), new String[]{"FMS"}));
            int returnVal = chooser.showOpenDialog(this.mapFrame);
            if (returnVal == 0) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "fms");
                if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(this.mapFrame, "", Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                    if (XplaneImportUtil.exportFms(fileName, FlightPlanBean.getInstance().getRoute())) {
                        JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("export_success"), "", 1);
                    } else {
                        JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("export_error"), "", 0);
                    }
                }
            }
        }
    }

    public void androidAppExportAction() {
        if (this.doValidate(true)) {
            JFileChooser chooser = GuiUtil.getFileChooser("", Messages.getInstance().get("export_button"));
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("txt_files"), new String[]{"TXT"}));
            int returnVal = chooser.showOpenDialog(this.mapFrame);
            if (returnVal == 0) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "txt");
                if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(this.mapFrame, "", Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                    if (AndroidAppUtil.export(fileName, FlightPlanBean.getInstance().getRoute())) {
                        JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("export_success"), "", 1);
                    } else {
                        JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("export_error"), "", 0);
                    }
                }
            }
        }
    }

    public void flyingAppExportAction() {
        Set<ObstacleDTO> obstacles;
        FlyingAppUtil.exportAirports(MapObjectsBean.getInstance().getAirports(null), "tmp/airports.txt");
        FlyingAppUtil.exportCities(MapObjectsBean.getInstance().getCities(null), "tmp/cities.txt");
        FlyingAppUtil.exportVfrPoints(MapObjectsBean.getInstance().getVfrPoints(null), "tmp/vfr_points.txt");
        if (MapObjectsBean.getInstance().getAirspaces() != null) {
            HashSet<AirspaceAreaDTO> airspaces = new HashSet<AirspaceAreaDTO>();
            for (AirspaceAreaDTO area : MapObjectsBean.getInstance().getAirspaces()) {
                if (!MapObjectsBean.getInstance().getAirspaceFilter().checkDisplayAirspaceArea(area)) continue;
                airspaces.add(area);
            }
            FlyingAppUtil.exportAirspaces(airspaces, this.mapFrame.getMapViewer(), "tmp/airspaces.txt");
        }
        if (MapObjectsBean.getInstance().getTerrainMesh() != null && MapObjectsBean.getInstance().getTerrainMesh().length > 0) {
            FlyingAppUtil.exportTerrain(new HashSet<TerrainMesh>(Arrays.asList(MapObjectsBean.getInstance().getTerrainMesh())), "tmp/terrain.txt");
        }
        if ((obstacles = MapObjectsBean.getInstance().getObstacles(null)).size() > 0) {
            FlyingAppUtil.exportObstacles(obstacles, "tmp/obstacles.txt");
        }
        if (SimConnectUtil.getInstance().getUserTrack() != null && SimConnectUtil.getInstance().getUserTrack().size() > 0) {
            FlyingAppUtil.exportUserTrack(SimConnectUtil.getInstance().getUserTrack(), "tmp/user_track.txt");
        }
        Set<NavaidDTO> navaids = MapObjectsBean.getInstance().getVors(null);
        navaids.addAll(MapObjectsBean.getInstance().getNdbs(null));
        if (navaids.size() > 0) {
            HashSet<NavaidDTO> newNavaids = new HashSet<NavaidDTO>();
            for (NavaidDTO navaid : navaids) {
                if ("TACAN".equals(navaid.getType()) || "DME".equals(navaid.getType()) || "NDB".equals(navaid.getType())) continue;
                newNavaids.add(navaid);
            }
            FlyingAppUtil.exportNavaids(newNavaids, "tmp/navaids.txt");
        }
        if (this.doValidate(true)) {
            String fileName = "tmp/route.txt";
            if (FlyingAppUtil.exportFlightPlan(fileName, FlightPlanBean.getInstance().getRoute())) {
                log.info("Exported route to " + fileName);
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("export_success"), "", 1);
            } else {
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("export_error"), "", 0);
            }
        }
    }

    public void calculateAction() {
        if (this.doValidate(true)) {
            FlightPlanBean.getInstance().unselectAll();
            FlightPlanBean.getInstance().getRoute().calculate();
            this.hidePanel();
            this.mapFrame.lockPoints();
            this.mapFrame.setOnCalculatedFrame(true);
            this.mapFrame.updateMap();
            CalculationResultDialog resultFrame = new CalculationResultDialog();
            resultFrame.updateData();
            resultFrame.setVisible(true);
        }
    }

    public void exportWeatherAction() {
        if (MapObjectsBean.getInstance().getStations().size() > 0) {
            int returnVal;
            JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("save_as_pdf"), Messages.getInstance().get("save"));
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("pdf_files"), new String[]{"PDF"}));
            if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getRoute().getName())) {
                chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getRoute().getName() + ".pdf"));
            }
            if ((returnVal = chooser.showOpenDialog(this.mapFrame)) == 0) {
                FlightPlanBean.getInstance().unselectAll();
                this.mapFrame.updateMap();
                String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "pdf");
                if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(this.mapFrame, Messages.getInstance().get("save_as_pdf"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                    SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                    if (PdfUtil.generatePageWithText(fileName, WeatherUtil.stationsReportsToArrayString(MapObjectsBean.getInstance().getStations()))) {
                        JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("pdf_export_success"), "", 1);
                    } else {
                        JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("pdf_export_error"), "", 0);
                    }
                }
            }
        }
    }

    public void lockForMeteo() {
        this.infoCollapsablePanel.setVisible(false);
        this.performanceCollapsablePanel.setVisible(false);
        this.pointsCollapsablePanel.setVisible(false);
        this.vorCollapsablePanel.setVisible(false);
        if (this.weatherCollapsablePanel != null) {
            this.weatherCollapsablePanel.setVisible(false);
        }
        this.previousWindCollapsablePanelExtended = this.windCollapsablePanel.isExpanded();
        this.windCollapsablePanel.setExpanded(true);
        this.airspacesFilterCollapsablePanel.setVisible(false);
        this.mapFrame.setMenuEnabled(false);
        this.mapFrame.setToolbarEnabled(false);
        this.mapFrame.setBottomToolbarEnabled(false);
        this.mapFrame.getLayersOrderButton().setEnabled(false);
    }

    public void unlockForMeteo() {
        this.infoCollapsablePanel.setVisible(true);
        this.performanceCollapsablePanel.setVisible(true);
        this.pointsCollapsablePanel.setVisible(true);
        this.vorCollapsablePanel.setVisible(true);
        if (this.weatherCollapsablePanel != null) {
            this.weatherCollapsablePanel.setVisible(true);
        }
        this.windCollapsablePanel.setExpanded(this.previousWindCollapsablePanelExtended);
        this.airspacesFilterCollapsablePanel.setVisible(true);
        this.mapFrame.setMenuEnabled(true);
        this.mapFrame.setToolbarEnabled(true);
        this.mapFrame.setBottomToolbarEnabled(true);
        this.mapFrame.getLayersOrderButton().setEnabled(true);
    }

    public void search() {
        String query = null;
        while ((query = JOptionPane.showInputDialog(this.mapFrame, (Object)Messages.getInstance().get("popup_menu_search_label"))) != null && query.length() < 3) {
        }
        if (query != null) {
            List<GpsPlace> results = SearchUtil.search(query);
            if (results.size() == 0) {
                JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("search_dialog_no_results"), "", 0);
            } else if (results.size() == 1) {
                this.mapFrame.centerOnPoint(results.get(0), 7);
                this.mapFrame.setPlaceTempHighlightMode(results.get(0));
            } else {
                SearchDialog searchDialog = new SearchDialog(this.mapFrame, query, results);
                searchDialog.setVisible(true);
            }
        }
    }

    public void hidePanel() {
        this.setVisible(false);
        this.mapFrame.enableUIPanelToggleButton(false);
        this.mapFrame.updateUIPanelButtonIcon();
        this.mapFrame.setMenuEnabled(false);
        this.mapFrame.setToolbarEnabled(false);
        this.mapFrame.setBottomToolbarEnabled(false);
    }

    public void showPanel() {
        this.setVisible(this.mapFrame.isShowUIPanel());
        this.mapFrame.enableUIPanelToggleButton(true);
        this.mapFrame.updateUIPanelButtonIcon();
        this.mapFrame.setMenuEnabled(true);
        this.mapFrame.setToolbarEnabled(true);
        this.mapFrame.setBottomToolbarEnabled(true);
    }

    public void settingsAction() {
        SettingsDialog dialog = new SettingsDialog(this.mapFrame);
        dialog.setVisible(true);
    }

    public void aboutAction() {
        AboutDialog about = new AboutDialog(this.mapFrame);
        about.setVisible(true);
    }

    public void feedbackAction() {
        String lang = SettingsBean.getInstance().getParamLanguage() <= 1 ? SettingsBean.getInstance().getLanguageCode().toLowerCase() : "EN".toLowerCase();
        UrlUtil.openUrlInBrowser("http://vfrflight.org/{lang}/contact.php".replaceAll("\\{lang\\}", lang));
    }

    public void documentationAction() {
        String lang = SettingsBean.getInstance().getParamLanguage() <= 1 ? SettingsBean.getInstance().getLanguageCode().toLowerCase() : "EN".toLowerCase();
        UrlUtil.openUrlInBrowser("http://vfrflight.org/{lang}/documentation.html".replaceAll("\\{lang\\}", lang));
    }

    public void facebookAction() {
        UrlUtil.openUrlInBrowser("http://www.facebook.com/vfrflight");
    }

    public void youtubeAction() {
        UrlUtil.openUrlInBrowser("https://www.youtube.com/user/lukaszkulasek/videos");
    }

    public WeatherCollapsablePanel getWeatherCollapsablePanel() {
        return this.weatherCollapsablePanel;
    }

    public void setWeatherCollapsablePanel(WeatherCollapsablePanel weatherCollapsablePanel) {
        this.weatherCollapsablePanel = weatherCollapsablePanel;
    }

    private InfoCollapsablePanel createInfoPanel(boolean expanded) {
        InfoCollapsablePanel infoCollapsablePanel = new InfoCollapsablePanel(expanded);
        infoCollapsablePanel.getRouteNameTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.routeNameChanged();
            }
        });
        infoCollapsablePanel.getRouteDescTextArea().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.routeDescChanged();
            }
        });
        infoCollapsablePanel.getRouteNameAutoSetButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.routeNameAutoSetAction();
            }
        });
        return infoCollapsablePanel;
    }

    private PerformanceCollapsablePanel createPerformancePanel(boolean expanded) {
        PerformanceCollapsablePanel performanceCollapsablePanel = new PerformanceCollapsablePanel(expanded);
        performanceCollapsablePanel.getProfileCombo().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.planeProfileChangedAction();
            }
        });
        performanceCollapsablePanel.getProfileUpdateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.updateProfileAction();
            }
        });
        performanceCollapsablePanel.getProfileSaveNewButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.saveNewProfileAction();
            }
        });
        performanceCollapsablePanel.getProfileDeleteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.deleteProfileAction();
            }
        });
        performanceCollapsablePanel.getCruiseSpeedTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.cruiseSpeedChanged();
            }
        });
        performanceCollapsablePanel.getClimbingSpeedTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.climbSpeedChanged();
            }
        });
        performanceCollapsablePanel.getDescendingSpeedTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.descendSpeedChanged();
            }
        });
        performanceCollapsablePanel.getFuelBurnTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.fuelBurnChanged();
            }
        });
        performanceCollapsablePanel.getNavFuelReserveTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.navFuelReserveMinChanged();
            }
        });
        performanceCollapsablePanel.getSetToPointsButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.setToPointsAction();
            }
        });
        performanceCollapsablePanel.getCruiseAltTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.cruiseAltChanged();
            }
        });
        performanceCollapsablePanel.getFuelQMaxTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.fuelQMaxChanged();
            }
        });
        performanceCollapsablePanel.getFuelQMTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.fuelQMChanged();
            }
        });
        return performanceCollapsablePanel;
    }

    private AlternateAirportsCollapsablePanel createAlternateAirportsPanel(boolean expanded) {
        return new AlternateAirportsCollapsablePanel(expanded);
    }

    private PointsCollapsablePanel createPointsPanel(boolean expanded) {
        PointsCollapsablePanel pointsCollapsablePanel = new PointsCollapsablePanel(expanded);
        pointsCollapsablePanel.getNewPtsButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlightPlanMainPanel.this.newPtsAction();
            }
        });
        pointsCollapsablePanel.getNewPtsFromDBButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddFromDBDialog dialog = new AddFromDBDialog(FlightPlanMainPanel.this.mapFrame, false, true);
                dialog.setVisible(true);
            }
        });
        pointsCollapsablePanel.getDelPtsButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlightPlanMainPanel.this.delPtsAction();
            }
        });
        pointsCollapsablePanel.getDuplPtsButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.duplicatePtsAction();
            }
        });
        pointsCollapsablePanel.getDownPtsButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlightPlanMainPanel.this.downPtsAction();
            }
        });
        pointsCollapsablePanel.getClearAllButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GuiUtil.showConfirmationDialog(FlightPlanMainPanel.this.mapFrame, "", Messages.getInstance().get("are_you_sure"))) {
                    FlightPlanMainPanel.this.routePointsClearAllAction();
                }
            }
        });
        pointsCollapsablePanel.getUpPtsButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.upPtsAction();
            }
        });
        pointsCollapsablePanel.getMsaPtsButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.getMsaAction();
            }
        });
        pointsCollapsablePanel.getTableTypeComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlightPlanMainPanel.this.pointsPanelTableTypeChanged();
            }
        });
        pointsCollapsablePanel.getReverseRouteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.reversePtsAction();
            }
        });
        pointsCollapsablePanel.getCopyAllButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.copyAllPtsAction();
            }
        });
        return pointsCollapsablePanel;
    }

    public void pointsPanelTableTypeChanged() {
        NumericComboBoxItem sel = (NumericComboBoxItem)this.pointsCollapsablePanel.getTableTypeComboBox().getSelectedItem();
        if (sel != null) {
            this.setWaypointsTableAction(WaypointsDataTableFactory.newPointsTable(sel.getValue()));
        }
    }

    private VorCollapsablePanel createVorPanel(boolean expanded) {
        VorCollapsablePanel vorCollapsablePanel = new VorCollapsablePanel(expanded);
        vorCollapsablePanel.getVorsMouseDragCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.setVorsMouseDragAction();
            }
        });
        vorCollapsablePanel.getNewVorButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.newVorAction();
            }
        });
        vorCollapsablePanel.getNewVorFromDBButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddFromDBDialog dialog = new AddFromDBDialog(FlightPlanMainPanel.this.mapFrame, true, true);
                dialog.setVisible(true);
            }
        });
        vorCollapsablePanel.getDelVorButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.delVorAction();
            }
        });
        vorCollapsablePanel.getBtnNewButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GuiUtil.showConfirmationDialog(FlightPlanMainPanel.this.mapFrame, "", Messages.getInstance().get("are_you_sure"))) {
                    FlightPlanMainPanel.this.vorClearAllAction();
                }
            }
        });
        vorCollapsablePanel.getSearchVorButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlightPlanMainPanel.this.searchVorDmeAction();
            }
        });
        vorCollapsablePanel.getAddMultipleMapRadialsButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlightPlanMainPanel.this.addMultipleMapRadialsAction();
            }
        });
        vorCollapsablePanel.getClearMapRadialsButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlightPlanMainPanel.this.deletaAllMapRadialsAction();
            }
        });
        vorCollapsablePanel.getNewVorButton().setEnabled(vorCollapsablePanel.getVorsMouseDragCheckBox().isSelected());
        vorCollapsablePanel.getTableTypeComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlightPlanMainPanel.this.vorPanelTableTypeChanged();
            }
        });
        return vorCollapsablePanel;
    }

    public void vorPanelTableTypeChanged() {
        NumericComboBoxItem sel = (NumericComboBoxItem)this.vorCollapsablePanel.getTableTypeComboBox().getSelectedItem();
        if (sel != null) {
            this.setVorTableAction(WaypointsDataTableFactory.newVorTable(sel.getValue()));
        }
    }

    protected void deletaAllMapRadialsAction() {
        FlightPlanBean.getInstance().getRoute().getMapRadials().clear();
        this.mapFrame.updateMap();
    }

    protected void addMultipleMapRadialsAction() {
        if (FlightPlanBean.getInstance().getRoute().getOnlyVors().size() > 0 && (FlightPlanBean.getInstance().getRoute().getPoints().size() > 0 || FlightPlanBean.getInstance().getRoute().getAlternateAirports().size() > 0)) {
            AddMultipleMapRadialsDialog dialog = new AddMultipleMapRadialsDialog(this.mapFrame);
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this.mapFrame, Messages.getInstance().get("add_map_radials_dialog_no_vor_or_no_points_alternates_error"), "", 0);
        }
    }

    private WeatherCollapsablePanel createWeatherPanel(boolean expanded) {
        WeatherCollapsablePanel weatherCollapsablePanel = new WeatherCollapsablePanel(expanded);
        weatherCollapsablePanel.getUpdateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.updateWeatherStationsActionStart();
            }
        });
        weatherCollapsablePanel.getWeatherCenterMapButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.weatherStationCenterMapAction();
            }
        });
        weatherCollapsablePanel.getMeteoButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.getMeteoWeatherAction();
            }
        });
        weatherCollapsablePanel.getClearAllButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.clearAllWeatherAction();
            }
        });
        return weatherCollapsablePanel;
    }

    private WindCollapsablePanel createWindPanel(boolean expanded) {
        WindCollapsablePanel windCollapsablePanel = new WindCollapsablePanel(expanded);
        windCollapsablePanel.getWindDirectionTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    FlightPlanMainPanel.this.windDirectionChanged();
                }
            }
        });
        windCollapsablePanel.getWindDirectionTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.windDirectionChanged();
            }
        });
        windCollapsablePanel.getWindSpeedTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FlightPlanMainPanel.this.windSpeedChanged();
            }
        });
        windCollapsablePanel.getWindSpeedTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    FlightPlanMainPanel.this.windSpeedChanged();
                }
            }
        });
        windCollapsablePanel.getCalculateFromMetarButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlightPlanMainPanel.this.calculateFromMetarAction();
            }
        });
        return windCollapsablePanel;
    }

    public AirspacesFilterCollapsablePanel getAirspacesFilterCollapsablePanel() {
        return this.airspacesFilterCollapsablePanel;
    }

    public void setAirspacesFilterCollapsablePanel(AirspacesFilterCollapsablePanel airspaceCollapsablePanel) {
        this.airspacesFilterCollapsablePanel = airspaceCollapsablePanel;
    }

    public VorCollapsablePanel getVorCollapsablePanel() {
        return this.vorCollapsablePanel;
    }

    public void setVorCollapsablePanel(VorCollapsablePanel vorCollapsablePanel) {
        this.vorCollapsablePanel = vorCollapsablePanel;
    }

    public PerformanceCollapsablePanel getPerformanceCollapsablePanel() {
        return this.performanceCollapsablePanel;
    }

    public void setPerformanceCollapsablePanel(PerformanceCollapsablePanel performanceCollapsablePanel) {
        this.performanceCollapsablePanel = performanceCollapsablePanel;
    }

    public AirportsFilterCollapsablePanel getAirportsFilterCollapsablePanel() {
        return this.airportsFilterCollapsablePanel;
    }

    public void setAirportsFilterCollapsablePanel(AirportsFilterCollapsablePanel airportsFilterCollapsablePanel) {
        this.airportsFilterCollapsablePanel = airportsFilterCollapsablePanel;
    }

    public ObstaclesFilterCollapsablePanel getObstaclesFilterCollapsablePanel() {
        return this.obstaclesFilterCollapsablePanel;
    }

    public void setObstaclesFilterCollapsablePanel(ObstaclesFilterCollapsablePanel obstaclesFilterCollapsablePanel) {
        this.obstaclesFilterCollapsablePanel = obstaclesFilterCollapsablePanel;
    }

    public void copyPointsToClipboardAction(boolean decimalFormat) {
        if (FlightPlanBean.getInstance().getRoute().getPoints().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (GpsPlace gpsPlace : FlightPlanBean.getInstance().getRoute().getPoints()) {
                sb.append(decimalFormat ? FormatUtil.formatDecimalGps(gpsPlace) : FormatUtil.formatAixmGpsLat(gpsPlace.getLat().getValue()) + "," + FormatUtil.formatAixmGpsLon(gpsPlace.getLon().getValue()));
                sb.append(Constants.EOL);
            }
            StringUtil.copyToClipboard(sb.toString().trim());
        }
    }

    public TerrainLayerFilterCollapsablePanel getTerrainLayerFilterCollapsablePanel() {
        return this.terrainLayerFilterCollapsablePanel;
    }

    public void setTerrainLayerFilterCollapsablePanel(TerrainLayerFilterCollapsablePanel terrainLayerFilterCollapsablePanel) {
        this.terrainLayerFilterCollapsablePanel = terrainLayerFilterCollapsablePanel;
    }

    public MeteoMapCollapsablePanel getMeteoMapCollapsablePanel() {
        return this.meteoMapCollapsablePanel;
    }

    public void setMeteoMapCollapsablePanel(MeteoMapCollapsablePanel meteoMapCollapsablePanel) {
        this.meteoMapCollapsablePanel = meteoMapCollapsablePanel;
    }

    public AlternateAirportsCollapsablePanel getAlternateAirportsCollapsablePanel() {
        return this.alternateAirportsCollapsablePanel;
    }

    public void setAlternateAirportsCollapsablePanel(AlternateAirportsCollapsablePanel alternateAirportsCollapsablePanel) {
        this.alternateAirportsCollapsablePanel = alternateAirportsCollapsablePanel;
    }

    public UserPointsFilterCollapsablePanel getUserPointsFilterCollapsablePanel() {
        return this.userPointsFilterCollapsablePanel;
    }

    public void setUserPointsFilterCollapsablePanel(UserPointsFilterCollapsablePanel userPointsFilterCollapsablePanel) {
        this.userPointsFilterCollapsablePanel = userPointsFilterCollapsablePanel;
    }

    public void updateUIFilter() {
        if (MapObjectsBean.getInstance().getTerrainMesh() != null && MapObjectsBean.getInstance().getTerrainMesh().length > 0) {
            this.getTerrainLayerFilterCollapsablePanel().setVisible(true);
        } else {
            this.getTerrainLayerFilterCollapsablePanel().setVisible(false);
        }
    }

    public void importDataFilesAction() {
        if (GuiUtil.showConfirmationDialog(this.mapFrame, "", Messages.getInstance().get("import_data_files_are_you_sure"))) {
            new Thread(new DataFilesImportTask()).start();
        }
    }

    public void importOpenAipDataAction() {
        OpenAipImportDialog dialog = new OpenAipImportDialog((Window)this.mapFrame);
        dialog.setVisible(true);
    }
}

