/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.util.bean.FlightGearConnectConfigBean;

public class FlightGearConnectDialog
extends JDialog {
    private static final long serialVersionUID = 5783160832543353969L;
    private IntegerTextField portTextField;
    private boolean cancelled = false;

    public FlightGearConnectDialog() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FlightGearConnectDialog.this.closeWindowAction(true);
            }
        });
        this.setAlwaysOnTop(true);
        this.setResizable(true);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel_3.add((Component)buttonPanel, "South");
        JButton closeButton = new JButton(Messages.getInstance().get("close_button"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlightGearConnectDialog.this.closeWindowAction(true);
            }
        });
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlightGearConnectDialog.this.connectAction();
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.add(closeButton);
        JPanel panel_5 = new JPanel();
        panel_3.add((Component)panel_5, "Center");
        panel_5.setBorder(new EtchedBorder(1, null, null));
        panel_5.setLayout(new BorderLayout(0, 0));
        JPanel panel_6 = new JPanel();
        panel_5.add((Component)panel_6, "North");
        JLabel infoLabel = new JLabel(Messages.getInstance().get("flightgear_dialog_info"));
        panel_6.add(infoLabel);
        JPanel contentPanel = new JPanel();
        panel_5.add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel xplaneIpPanel = new JPanel();
        contentPanel.add((Component)xplaneIpPanel, "North");
        JLabel portLabel = new JLabel(Messages.getInstance().get("flightgear_dialog_port"));
        xplaneIpPanel.add(portLabel);
        this.portTextField = new IntegerTextField(1);
        this.portTextField.setHorizontalAlignment(0);
        xplaneIpPanel.add(this.portTextField);
        this.portTextField.setColumns(7);
        this.updateData();
        this.setSize(500, 200);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void updateData() {
        FlightGearConnectConfigBean configBean = SettingsBean.getInstance().getFlightGearConnectConfigBean();
        this.portTextField.setValue(configBean.getPort());
    }

    protected void connectAction() {
        if (this.doValidate()) {
            FlightGearConnectConfigBean configBean = SettingsBean.getInstance().getFlightGearConnectConfigBean();
            configBean.setPort(this.portTextField.getValue());
            this.closeWindowAction(false);
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.portTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("xpconnect_dialog_port_empty"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void closeWindowAction(boolean cancelled) {
        this.cancelled = cancelled;
        this.setVisible(false);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

