/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.util.StringUtil;

public class FatalExceptionDialog
extends JDialog {
    private static final long serialVersionUID = -7924207311982846549L;
    private boolean closeApplication = true;

    public FatalExceptionDialog(final String exceptionInformation) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FatalExceptionDialog.this.closeWindowAction();
            }
        });
        this.setAlwaysOnTop(true);
        this.setResizable(true);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel_3.add((Component)buttonPanel, "South");
        JButton copyButton = new JButton(Messages.getInstance().get("copy_to_clipboard"));
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringUtil.copyToClipboard(exceptionInformation);
            }
        });
        buttonPanel.add(copyButton);
        JButton closeButton = new JButton(Messages.getInstance().get("fatal_exception_dialog_close_application"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FatalExceptionDialog.this.closeWindowAction();
            }
        });
        JButton ignoreButton = new JButton(Messages.getInstance().get("fatal_exception_dialog_ignore"));
        ignoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FatalExceptionDialog.this.ignoreAction();
            }
        });
        buttonPanel.add(ignoreButton);
        buttonPanel.add(closeButton);
        JPanel panel_5 = new JPanel();
        panel_3.add((Component)panel_5, "Center");
        panel_5.setBorder(new EtchedBorder(1, null, null));
        panel_5.setLayout(new BorderLayout(0, 0));
        JPanel altitudePanel = new JPanel();
        altitudePanel.setBorder(new CompoundBorder(new EmptyBorder(0, 10, 0, 10), new EtchedBorder(1, null, null)));
        panel_5.add((Component)altitudePanel, "Center");
        altitudePanel.setLayout(new BorderLayout(0, 0));
        JTextArea tagsTextArea = new JTextArea(exceptionInformation);
        tagsTextArea.setEditable(false);
        tagsTextArea.setLineWrap(true);
        JScrollPane scroll = new JScrollPane(tagsTextArea);
        scroll.setVerticalScrollBarPolicy(20);
        altitudePanel.add(scroll);
        JPanel panel_6 = new JPanel();
        panel_5.add((Component)panel_6, "North");
        JLabel tagsLabel = new JLabel(Messages.getInstance().get("fatal_exception_dialog"));
        panel_6.add(tagsLabel);
        this.setSize(700, 450);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    protected void ignoreAction() {
        this.closeApplication = false;
        this.closeWindowAction();
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    public boolean isCloseApplication() {
        return this.closeApplication;
    }
}

