/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.EngineLossBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.gui.AutoDownloadFrame;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.swing.panel.file.HgtFileChooserPanel;
import main.java.guru.vfrflight.gui.swing.textfield.DecimalTextField;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.gui.task.EngineLossTask;
import main.java.guru.vfrflight.gui.task.HgtFilesDownloaderTask;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.EngineLoss;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.bean.HgtZipFilesToDownload;

public class EngineLossRangeDialog
extends JDialog
implements AutoDownloadFrame {
    private static final long serialVersionUID = -6104527410842843253L;
    private GpsPlace point;
    private IntegerTextField samplesNumTextField;
    private DecimalTextField speedOfBestGlideTextField;
    private DecimalTextField liftToDragRatioTextField;
    private IntegerTextField altitudeTextField;
    private HgtFileChooserPanel hgtPathPanel;
    private JLabel aglLabel;
    private final Double windSpeed;
    private final Double windDirection;

    public EngineLossRangeDialog(JFrame frame, GpsPlace point) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                EngineLossRangeDialog.this.closeWindowAction();
            }
        });
        this.windSpeed = FlightPlanBean.getInstance().getRoute().getWindSpeed();
        this.windDirection = FlightPlanBean.getInstance().getRoute().getWindDirection();
        this.point = point.clone();
        MapFrame.getInstance().setMarkerPlace(point.clone());
        MapFrame.getInstance().updateMap();
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        EngineLossBean engineLossBean = SettingsBean.getInstance().getEngineLossBean();
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineLossRangeDialog.this.okAction();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineLossRangeDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(cancelButton);
        JPanel contentPanel = new JPanel();
        panel_3.add((Component)contentPanel, "North");
        contentPanel.setBorder(new EtchedBorder(1, null, null));
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel nPanel = new JPanel();
        this.hgtPathPanel = new HgtFileChooserPanel(Messages.getInstance().get("terrain_layer_dialog_path_to_hgt_files"), Messages.getInstance().get("hgt_files"), "HGT", false, 22);
        nPanel.add(this.hgtPathPanel);
        this.hgtPathPanel.setChosenPath(SettingsBean.getInstance().getTerrainLayerBean().getPathToHgtFiles());
        this.hgtPathPanel.getAutoDownloadButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EngineLossRangeDialog.this.autoDownloadAction();
            }
        });
        contentPanel.add((Component)nPanel, "North");
        JPanel centerPanel = new JPanel();
        contentPanel.add((Component)centerPanel, "South");
        JLabel speedOfBestGlideLabel = new JLabel(Messages.getInstance().get("engine_loss_range_dialog_best_glide_speed") + UnitUtil.getSpeedUnit());
        centerPanel.add(speedOfBestGlideLabel);
        this.speedOfBestGlideTextField = new DecimalTextField(1);
        centerPanel.add(this.speedOfBestGlideTextField);
        this.speedOfBestGlideTextField.setHorizontalAlignment(0);
        this.speedOfBestGlideTextField.setValue(engineLossBean.getSpeedOfBestGlide());
        this.speedOfBestGlideTextField.setColumns(5);
        JLabel numberOfSamplesLabel = new JLabel(Messages.getInstance().get("engine_loss_range_dialog_number_of_samples"));
        centerPanel.add(numberOfSamplesLabel);
        this.samplesNumTextField = new IntegerTextField(1);
        this.samplesNumTextField.setValue(engineLossBean.getSamplesNum());
        centerPanel.add(this.samplesNumTextField);
        this.samplesNumTextField.setHorizontalAlignment(0);
        this.samplesNumTextField.setColumns(7);
        JPanel sPanel = new JPanel();
        contentPanel.add((Component)sPanel, "Center");
        JLabel altitudeLabel = new JLabel(Messages.getInstance().get("engine_loss_range_dialog_amsl") + UnitUtil.getAltitudeUnit());
        sPanel.add(altitudeLabel);
        this.altitudeTextField = new IntegerTextField(1);
        this.altitudeTextField.setHorizontalAlignment(0);
        this.altitudeTextField.setValue(engineLossBean.getAmsl());
        this.altitudeTextField.setColumns(5);
        sPanel.add(this.altitudeTextField);
        JLabel liftToDragRatioLabel = new JLabel(Messages.getInstance().get("engine_loss_range_dialog_lift_to_drag_ratio"));
        sPanel.add(liftToDragRatioLabel);
        this.liftToDragRatioTextField = new DecimalTextField(1);
        this.liftToDragRatioTextField.setValue(engineLossBean.getLiftToDragRatio());
        sPanel.add(this.liftToDragRatioTextField);
        this.liftToDragRatioTextField.setHorizontalAlignment(0);
        this.liftToDragRatioTextField.setColumns(5);
        this.aglLabel = new JLabel();
        sPanel.add(this.aglLabel);
        JPanel infoPanel = new JPanel();
        panel_3.add((Component)infoPanel, "Center");
        infoPanel.setLayout(new BorderLayout(0, 0));
        JPanel disclaimerPanel = new JPanel();
        disclaimerPanel.setBackground(new Color(255, 102, 51));
        disclaimerPanel.setBorder(new MatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
        infoPanel.add(disclaimerPanel);
        JLabel disclaimerLabel = new JLabel(Messages.getInstance().get("engine_loss_range_dialog_disclaimer"));
        disclaimerPanel.add(disclaimerLabel);
        JPanel windPanel = new JPanel();
        windPanel.setBorder(new EtchedBorder(1, null, null));
        infoPanel.add((Component)windPanel, "North");
        JLabel windLabel = new JLabel(StringUtil.formatWind(this.windDirection, this.windSpeed));
        windPanel.add(windLabel);
        this.setModal(true);
        this.setSize(475, 330);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    protected void autoDownloadAction() {
        if (this.doValidate()) {
            GpsArea selectionArea = this.getArea();
            HgtZipFilesToDownload files = ElevationsUtil.getHgtFilesToDownloadForArea(selectionArea, this.hgtPathPanel.getChosenPath(), SettingsBean.getInstance().getHgtZipFilesMappings());
            if (files != null && files.getFilename() != null && files.getFilename().size() > 0) {
                double sizeInMb = NumberUtil.roundDouble((double)files.getSize() / 1024.0 / 1024.0, 2);
                if (GuiUtil.showConfirmationDialog(this, "", Messages.getInstance().get("terrain_layer_dialog_autodownload_confirm", String.valueOf(files.getFilename().size()), String.valueOf(sizeInMb)))) {
                    this.setVisible(false);
                    MapFrame.getInstance().lock();
                    PleaseWaitDialog.getInstance().start(true);
                    HgtFilesDownloaderTask task = new HgtFilesDownloaderTask(this, files.getFilename(), this.hgtPathPanel.getChosenPath());
                    new Thread(task).start();
                }
            } else {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("terrain_layer_dialog_autodownload_nofiles_to_download_error"), Messages.getInstance().get("error"), 0);
            }
        }
    }

    protected GpsArea getArea() {
        if (this.doValidate()) {
            this.point.setAlt(UnitUtil.recalculateAltitudeIfNeeded(this.altitudeTextField.getValue().doubleValue(), "ft"));
            EngineLoss engineLoss = new EngineLoss(this.samplesNumTextField.getValue(), this.liftToDragRatioTextField.getValue(), UnitUtil.recalculateSpeedIfNeeded(this.speedOfBestGlideTextField.getValue(), "kt"), UnitUtil.recalculateWindSpeedIfNeeded(this.windSpeed, "kt"), this.windDirection);
            return engineLoss.getMaximumRangeArea(this.point);
        }
        JOptionPane.showMessageDialog(this, Messages.getInstance().get("engine_loss_range_dialog_amsl_is_empty"), Messages.getInstance().get("error"), 0);
        return null;
    }

    private void okAction() {
        if (this.doValidate()) {
            this.point.setAlt(UnitUtil.recalculateAltitudeIfNeeded(this.altitudeTextField.getValue().doubleValue(), "ft"));
            EngineLoss engineLoss = new EngineLoss(this.samplesNumTextField.getValue(), this.liftToDragRatioTextField.getValue(), UnitUtil.recalculateSpeedIfNeeded(this.speedOfBestGlideTextField.getValue(), "kt"), UnitUtil.recalculateWindSpeedIfNeeded(this.windSpeed, "kt"), this.windDirection);
            EngineLossTask task = new EngineLossTask(this, engineLoss, this.hgtPathPanel.getChosenPath());
            task.setPlace(this.point);
            new Thread(task).start();
            this.closeWindowAction();
        }
    }

    public void calculationsFinished(List<LineSegment> result) {
        if (result != null) {
            MapObjectsBean.getInstance().setEngineLossSegments(result.toArray(new LineSegment[result.size()]));
            MapFrame.getInstance().updateMap();
        } else {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("terrain_layer_dialog_no_elevations_found"), "", 0);
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.altitudeTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("engine_loss_range_dialog_amsl_is_empty"));
        }
        if (this.samplesNumTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("engine_loss_range_dialog_samples_num_is_empty"));
        }
        if (this.speedOfBestGlideTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("engine_loss_range_dialog_best_glide_speed_is_empty"));
        }
        if (this.liftToDragRatioTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("engine_loss_range_dialog_ltd_ratio_is_empty"));
        }
        if (StringUtil.isEmpty(this.hgtPathPanel.getChosenPath())) {
            errors.add(Messages.getInstance().get("engine_loss_range_dialog_hgt_path_is_empty"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void closeWindowAction() {
        EngineLossBean engineLossBean = SettingsBean.getInstance().getEngineLossBean();
        engineLossBean.setAmsl(this.altitudeTextField.getValue());
        engineLossBean.setSamplesNum(this.samplesNumTextField.getValue());
        engineLossBean.setSpeedOfBestGlide(this.speedOfBestGlideTextField.getValue());
        engineLossBean.setLiftToDragRatio(this.liftToDragRatioTextField.getValue());
        MapFrame.getInstance().setMarkerPlace(null);
        MapFrame.getInstance().updateMap();
        SettingsBean.getInstance().getTerrainLayerBean().setPathToHgtFiles(this.hgtPathPanel.getChosenPath());
        this.setVisible(false);
    }

    public GpsPlace getPoint() {
        return this.point;
    }

    public void setPoint(GpsPlace point) {
        this.point = point;
    }

    @Override
    public void autoDownloadActionFinish() {
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().unlock();
        this.setVisible(true);
        JOptionPane.showMessageDialog(this, Messages.getInstance().get("terrain_layer_dialog_autodownload_success"), Messages.getInstance().get("success"), 1);
    }
}

