/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.util.DropboxUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.StringUtil;

public class DropboxFilesDialog
extends JDialog {
    private static final long serialVersionUID = 2110195912575918488L;
    private JTextField textField;
    private JList<String> filesList;

    public DropboxFilesDialog(JFrame parent) {
        super(parent);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                DropboxFilesDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("dropbox_files_manager_title"));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EtchedBorder(1, null, null));
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel filenamePanel = new JPanel();
        filenamePanel.setBorder(new EtchedBorder(1, null, null));
        contentPanel.add((Component)filenamePanel, "South");
        JLabel label = new JLabel(Messages.getInstance().get("dropbox_files_manager_upload_filename_label"));
        filenamePanel.add(label);
        this.textField = new JTextField();
        filenamePanel.add(this.textField);
        this.textField.setColumns(20);
        JButton uploadButton = new JButton(Messages.getInstance().get("dropbox_files_manager_upload_current_flight_plan"));
        filenamePanel.add(uploadButton);
        uploadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                DropboxFilesDialog.this.uploadFileAction();
            }
        });
        JPanel filesListPanel = new JPanel();
        filesListPanel.setBorder(new CompoundBorder(new EmptyBorder(10, 100, 10, 100), new EtchedBorder(1, null, null)));
        contentPanel.add((Component)filesListPanel, "Center");
        filesListPanel.setLayout(new BorderLayout(0, 0));
        JPanel jlistButtonPanel = new JPanel();
        filesListPanel.add((Component)jlistButtonPanel, "South");
        JButton deleteButton = new JButton(Messages.getInstance().get("delete_selected_button"));
        jlistButtonPanel.add(deleteButton);
        JPanel jlistPanel = new JPanel();
        filesListPanel.add((Component)jlistPanel, "Center");
        jlistPanel.setLayout(new BorderLayout(0, 0));
        this.filesList = new JList();
        this.filesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DropboxFilesDialog.this.filesList.getSelectedValue() != null && !e.getValueIsAdjusting()) {
                    DropboxFilesDialog.this.textField.setText(((String)DropboxFilesDialog.this.filesList.getSelectedValue()).toString());
                }
            }
        });
        JScrollPane pane = new JScrollPane(this.filesList, 22, 31);
        jlistPanel.add(pane);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                DropboxFilesDialog.this.deleteSelectedAction();
            }
        });
        JPanel panel = new JPanel();
        contentPanel.add((Component)panel, "North");
        JLabel filesTitleLabel = new JLabel(Messages.getInstance().get("dropbox_files_manager_files_list_title"));
        panel.add(filesTitleLabel);
        JPanel buttonBarPanel = new JPanel();
        buttonBarPanel.setBorder(new EtchedBorder(1, null, null));
        this.getContentPane().add((Component)buttonBarPanel, "South");
        buttonBarPanel.setLayout(new FlowLayout(1, 5, 5));
        JButton closeButton = new JButton(Messages.getInstance().get("close_button"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                DropboxFilesDialog.this.closeWindowAction();
            }
        });
        buttonBarPanel.add(closeButton);
        this.setModal(true);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.updateList();
        this.setPreferredSize(new Dimension(450, 300));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
    }

    private void updateList() {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        List<String> files = SettingsBean.getInstance().getDropboxBean().getRootFileList();
        for (String s : files) {
            listModel.addElement(s);
        }
        this.filesList.setModel(listModel);
    }

    private void deleteSelectedAction() {
        String filename = this.filesList.getSelectedValue();
        if (filename == null) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("dropbox_files_manager_no_file_selected"), Messages.getInstance().get("error"), 0);
        } else if (GuiUtil.showConfirmationDialog(this, "", Messages.getInstance().get("are_you_sure"))) {
            if (DropboxUtil.deleteFile(filename)) {
                this.updateList();
                this.textField.setText("");
                MapFrame.getInstance().updateDropboxMenu();
            } else {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("dropbox_delete_error"), Messages.getInstance().get("error"), 0);
            }
        }
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void uploadFileAction() {
        if (StringUtil.isEmpty(this.textField.getText())) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("dropbox_files_manager_name_empty"), Messages.getInstance().get("error"), 0);
        } else if (!SettingsBean.getInstance().getDropboxBean().fileExists(this.textField.getText()) || GuiUtil.showConfirmationDialog(MapFrame.getInstance(), Messages.getInstance().get("save_file"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
            if (DropboxUtil.uploadFlightPlan(FlightPlanBean.getInstance().getRoute(), this.textField.getText())) {
                this.updateList();
                this.textField.setText("");
                MapFrame.getInstance().updateDropboxMenu();
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("dropbox_upload_successful"), "", 1);
            } else {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("dropbox_upload_error"), Messages.getInstance().get("error"), 0);
            }
        }
    }
}

