/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UrlUtil;

public class DropboxConnectionDialog
extends JDialog {
    private static final long serialVersionUID = 2110195912575918488L;
    private JTextField codeTextField;
    private JLabel infoLabel;
    private String authorizationUrl;

    public DropboxConnectionDialog(JFrame parent) {
        super(parent);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                DropboxConnectionDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("dropbox_connection_dialog_title"));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EtchedBorder(1, null, null));
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout(new FlowLayout(1, 5, 5));
        JLabel codeLabel = new JLabel(Messages.getInstance().get("dropbox_connection_dialog_code"));
        contentPanel.add(codeLabel);
        this.codeTextField = new JTextField();
        this.codeTextField.setHorizontalAlignment(0);
        contentPanel.add(this.codeTextField);
        this.codeTextField.setColumns(40);
        JButton copyFromClipboardButton = new JButton(Messages.getInstance().get("paste_from_clipboard_button"));
        copyFromClipboardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DropboxConnectionDialog.this.copyFromClipboardAction();
            }
        });
        contentPanel.add(copyFromClipboardButton);
        JPanel buttonBarPanel = new JPanel();
        buttonBarPanel.setBorder(new EtchedBorder(1, null, null));
        this.getContentPane().add((Component)buttonBarPanel, "South");
        JButton closeButton = new JButton(Messages.getInstance().get("ok_button"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                DropboxConnectionDialog.this.authorizeAction();
            }
        });
        buttonBarPanel.setLayout(new FlowLayout(1, 5, 5));
        buttonBarPanel.add(closeButton);
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(new EtchedBorder(1, null, null));
        this.getContentPane().add((Component)infoPanel, "North");
        infoPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        infoPanel.add((Component)panel, "Center");
        this.infoLabel = new JLabel();
        panel.add(this.infoLabel);
        JPanel panel_1 = new JPanel();
        infoPanel.add((Component)panel_1, "South");
        JButton openUrlButton = new JButton(Messages.getInstance().get("dropbox_connection_dialog_open_url"));
        panel_1.add(openUrlButton);
        JPanel infoTextPanel = new JPanel();
        infoPanel.add((Component)infoTextPanel, "North");
        JLabel informationLabel = new JLabel(Messages.getInstance().get("dropbox_connection_dialog_information"));
        infoTextPanel.add(informationLabel);
        openUrlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UrlUtil.openUrlInBrowser(DropboxConnectionDialog.this.authorizationUrl);
            }
        });
        this.setModal(true);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.setPreferredSize(new Dimension(620, 200));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        this.updateData();
    }

    protected void copyFromClipboardAction() {
        this.codeTextField.setText(StringUtil.pasteFromClipboard());
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void authorizeAction() {
        if (StringUtil.isEmpty(this.codeTextField.getText())) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("dropbox_connection_dialog_code_is_empty"), Messages.getInstance().get("error"), 0);
        } else if (SettingsBean.getInstance().getDropboxBean().authorize(this.codeTextField.getText())) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("dropbox_connection_dialog_auth_successful"), "", 1);
            MapFrame.getInstance().updateDropboxMenu();
            this.closeWindowAction();
        } else {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("dropbox_connection_dialog_auth_error"), Messages.getInstance().get("error"), 0);
        }
    }

    private void updateData() {
        this.authorizationUrl = SettingsBean.getInstance().getDropboxBean().getAuthorizationUrl();
        this.infoLabel.setText("<html><a href=\"" + this.authorizationUrl + "\">" + this.authorizationUrl + "</a></html>");
    }
}

