/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.filter.DrawAtAltitudeTextField;
import main.java.guru.vfrflight.util.UnitUtil;

public class DrawAirspacesAtAltitudeDialog
extends JFrame {
    private static final long serialVersionUID = 3539190450483562073L;
    private DrawAtAltitudeTextField altTextField;
    private JSlider slider;
    private boolean suppressSliderValueChange = false;

    public DrawAirspacesAtAltitudeDialog() {
        this.setType(Window.Type.UTILITY);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                DrawAirspacesAtAltitudeDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel altPanel = new JPanel();
        altPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)altPanel, "North");
        altPanel.add(new JLabel("@"));
        this.altTextField = new DrawAtAltitudeTextField(this);
        this.altTextField.setHorizontalAlignment(0);
        altPanel.add(this.altTextField);
        this.altTextField.setColumns(7);
        JLabel altLabel = new JLabel(SettingsBean.getInstance().getParamUnitsAltitude());
        altPanel.add(altLabel);
        JPanel infoPanel = new JPanel();
        panel_3.add((Component)infoPanel, "Center");
        this.slider = new JSlider();
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setBorder(new EtchedBorder(1, null, null));
        this.slider.setValue(0);
        int max = 40000;
        if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            max = (int)Math.round(UnitUtil.recalculateAltitude(max, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false) / 1000.0) * 1000;
        }
        this.slider.setMaximum(40000);
        this.slider.setMinimum(0);
        this.slider.setMajorTickSpacing(10000);
        this.slider.setMinorTickSpacing(1000);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                DrawAirspacesAtAltitudeDialog.this.changeSliderAction();
            }
        });
        infoPanel.setLayout(new BorderLayout(0, 0));
        this.slider.setOrientation(1);
        infoPanel.add(this.slider);
        MapFrame.getInstance().hidePanel();
        MapFrame.getInstance().lock();
        this.setSize(100, 550);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width - this.getSize().width * 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void changeSliderAction() {
        if (!this.suppressSliderValueChange && this.slider != null) {
            this.altTextField.setValue(this.slider.getValue());
        }
    }

    private void closeWindowAction() {
        MapObjectsBean.getInstance().getAirspaceFilter().setDrawAtAltitude(null);
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().unlock();
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }

    public void setSliderValue(Integer value) {
        this.suppressSliderValueChange = true;
        this.slider.setValue(value != null ? value : 0);
        this.suppressSliderValueChange = false;
    }
}

