/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.combo.NumericComboBox;
import main.java.guru.vfrflight.bean.combo.item.NumericComboBoxItem;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.core.map.MapMode;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.SelectionModeDialog;
import main.java.guru.vfrflight.gui.swing.panel.file.FileChooserPanel;
import main.java.guru.vfrflight.gui.task.DownloadMapToHddTask;

public class DownloadMapToHddDialog
extends SelectionModeDialog
implements KeyListener {
    private static final long serialVersionUID = 6694730531966855448L;
    private static final boolean WITH_RANDOM_DELAY = true;
    private RotatedGpsArea selectionArea;
    private NumericComboBox zoomFromComboBox;
    private NumericComboBox zoomToComboBox;
    private FileChooserPanel outputDirectoryPanel;

    public DownloadMapToHddDialog(JFrame frame, int mapZoom) {
        super(frame);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                DownloadMapToHddDialog.this.closeWindowAction();
                MapFrame.getInstance().updateMap();
                DownloadMapToHddDialog.this.setVisible(false);
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel titleSelectionPanel = new JPanel();
        panel_3.add((Component)titleSelectionPanel, "North");
        titleSelectionPanel.setLayout(new BorderLayout(0, 0));
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(1, null, null), "", 4, 2, null, null), new EmptyBorder(0, 10, 0, 10)));
        titleSelectionPanel.add(infoPanel);
        infoPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new EmptyBorder(10, 10, 10, 10));
        infoPanel.add((Component)panel_2, "Center");
        JLabel label = new JLabel(Messages.getInstance().get("download_map_to_hdd_dialog_info_label"));
        panel_2.add(label);
        label.setHorizontalAlignment(0);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)buttonPanel, "South");
        JButton startButton = new JButton(Messages.getInstance().get("ok_button"));
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DownloadMapToHddDialog.this.okAction();
            }
        });
        buttonPanel.add(startButton);
        JButton clearButton = new JButton(Messages.getInstance().get("clear_selection"));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DownloadMapToHddDialog.this.clearAction();
            }
        });
        buttonPanel.add(clearButton);
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DownloadMapToHddDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(cancelButton);
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        contentPanel.add((Component)panel, "North");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        panel.add((Component)panel_1, "North");
        JLabel zoomFromLabel = new JLabel(Messages.getInstance().get("download_map_to_hdd_dialog_zoom_from"));
        panel_1.add(zoomFromLabel);
        NumericComboBoxItem[] zoomValues = this.createZoomValues();
        this.zoomFromComboBox = new NumericComboBox(zoomValues);
        this.zoomFromComboBox.setSelectedValue(mapZoom);
        panel_1.add(this.zoomFromComboBox);
        JLabel zoomToLabel = new JLabel(Messages.getInstance().get("download_map_to_hdd_dialog_zoom_to"));
        panel_1.add(zoomToLabel);
        this.zoomToComboBox = new NumericComboBox(zoomValues);
        this.zoomToComboBox.setSelectedValue(mapZoom);
        panel_1.add(this.zoomToComboBox);
        this.outputDirectoryPanel = new FileChooserPanel(Messages.getInstance().get("download_map_to_hdd_dialog_output_dir"), false);
        panel.add((Component)this.outputDirectoryPanel, "Center");
        this.setPreferredSize(new Dimension(500, 280));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        MapFrame.getInstance().getMapViewer().setSelectionModeDialog(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                boolean keyHandled = false;
                if (e.getID() == 401) {
                    DownloadMapToHddDialog.this.keyReleased(e);
                }
                return keyHandled;
            }
        });
        this.init();
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private NumericComboBoxItem[] createZoomValues() {
        int minZoom = MapFrame.getInstance().getMapViewer().getTileFactory().getInfo().getMinimumZoomLevel();
        int maxZoom = MapFrame.getInstance().getMapViewer().getTileFactory().getInfo().getMaximumZoomLevel();
        ArrayList<NumericComboBoxItem> values = new ArrayList<NumericComboBoxItem>();
        for (int i = minZoom; i <= maxZoom; ++i) {
            values.add(new NumericComboBoxItem(String.valueOf(i), i));
        }
        return values.toArray(new NumericComboBoxItem[values.size()]);
    }

    private void init() {
        MapFrame.getInstance().getMapViewer().setMapMode(MapMode.RECTANGLE_DRAW);
        MapFrame.getInstance().getMapViewer().setDrawSelectionMode(true);
        MapFrame.getInstance().getMapViewer().setAllowRotationInRectangleDrawMode(true);
        if (this.selectionArea != null) {
            MapFrame.getInstance().getMapViewer().setRotatedSelectionArea(this.selectionArea);
            MapFrame.getInstance().getMapViewer().repaint();
        }
    }

    private void closeWindowAction() {
        MapFrame.getInstance().getMapViewer().setMapMode(MapMode.DEFAULT);
        MapFrame.getInstance().getMapViewer().setAllowRotationInRectangleDrawMode(false);
        MapFrame.getInstance().getMapViewer().setSelectionModeDialog(null);
        MapFrame.getInstance().getMapViewer().setDrawSelectionMode(false);
        this.setVisible(false);
    }

    private void clearAction() {
        MapFrame.getInstance().getMapViewer().setRotatedSelectionArea(null);
        this.selectionArea = null;
        MapFrame.getInstance().updateMap();
    }

    private void okAction() {
        if (this.doValidate()) {
            new Thread(new DownloadMapToHddTask(this, MapFrame.getInstance().getMapViewer(), this.selectionArea.getRectangleOver(), this.outputDirectoryPanel.getChosenPath(), this.zoomFromComboBox.getSelectedValue(), this.zoomToComboBox.getSelectedValue(), true)).start();
        }
    }

    public void downloadFinishedAction(boolean wasInterrupted) {
        if (!wasInterrupted) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("download_map_to_hdd_dialog_download_success"), "", 1);
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.selectionArea == null) {
            errors.add(Messages.getInstance().get("terrain_layer_dialog_no_area_selected"));
        }
        if (this.zoomFromComboBox.getSelectedValue() >= this.zoomToComboBox.getSelectedValue()) {
            errors.add(Messages.getInstance().get("download_map_to_hdd_dialog_invalid_zoom_range"));
        }
        if (!this.outputDirectoryPanel.isPathSelected()) {
            errors.add(Messages.getInstance().get("download_map_to_hdd_dialog_output_directory_is_empty"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    @Override
    public void selectionChanged(GpsArea area) {
        this.selectionArea = new RotatedGpsArea(area);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 37) {
            MapFrame.getInstance().getMapViewer().moveMap(-100, 0);
        } else if (e.getKeyCode() == 40) {
            MapFrame.getInstance().getMapViewer().moveMap(0, 100);
        } else if (e.getKeyCode() == 39) {
            MapFrame.getInstance().getMapViewer().moveMap(100, 0);
        } else if (e.getKeyCode() == 38) {
            MapFrame.getInstance().getMapViewer().moveMap(0, -100);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public RotatedGpsArea getSelectionArea() {
        return this.selectionArea;
    }

    public void setSelectionArea(RotatedGpsArea selectionArea) {
        this.selectionArea = selectionArea;
    }

    @Override
    public void rotatedSelectionChanged(RotatedGpsArea area) {
        this.selectionArea = area;
    }

    @Override
    public boolean isRotationEnabled() {
        return true;
    }
}

