/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.ExtensionFileFilter;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.gui.flightplan.AddMapRadialsCalculationDialog;
import main.java.guru.vfrflight.gui.flightplan.HintDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.PdfRegionDialog;
import main.java.guru.vfrflight.gui.flightplan.PdfSettingsDialog;
import main.java.guru.vfrflight.gui.swing.PositiveDigitsFilter;
import main.java.guru.vfrflight.gui.table.AlternatesResultDataTable;
import main.java.guru.vfrflight.gui.table.FuelDataTable;
import main.java.guru.vfrflight.gui.table.ResultDataTable;
import main.java.guru.vfrflight.gui.table.VorResultDataTable;
import main.java.guru.vfrflight.gui.task.CreatePdfTask;
import main.java.guru.vfrflight.sql.facade.ElevationFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class CalculationResultDialog
extends JFrame {
    private static final long serialVersionUID = -4455090335630982624L;
    private ResultDataTable resultDataTable;
    private VorResultDataTable vorDataTable;
    private JTextField totalTimeAndDistanceTextField;
    private JTextField magvarTextField;
    private FuelDataTable fuelDataTable;
    private JPanel vorTabPanel;
    private JTabbedPane tabbedPane;
    private JPanel routeTabPanel;
    public static final int TAB_ROUTE = 0;
    public static final int TAB_VOR = 1;
    public static final int TAB_ALTERNATE_AIRPORTS = 2;
    private JCheckBox minuteIntervalsCheckbox;
    private JTextField minuteIntervalValueTextField;
    private JPanel panel_3;
    private JCheckBox drawOnMapCheckbox;
    private JCheckBox showDistancesCheckBox;
    private JTextField kzmaxTextField;
    private JTextField msaTextField;
    private JButton selectVorButton;
    private JCheckBox includeVorNameCheckBox;
    private JPanel panel_4;
    private JCheckBox alwaysOnTopCheckBox;
    private JPanel panel_5;
    private JPanel panel_6;
    private JPanel panel_7;
    private JCheckBox segmentDistanceAndTimeCheckBox;
    private boolean windowClosing = false;
    private JButton configurePdfButton;

    public CalculationResultDialog() {
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                CalculationResultDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("calculation_result_frame_title"));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.tabbedPane = new JTabbedPane(1);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.routeTabPanel = new JPanel();
        this.tabbedPane.addTab(Messages.getInstance().get("calculation_result_frame_route_tab"), null, this.routeTabPanel, null);
        GridBagLayout gbl_routeTabPanel = new GridBagLayout();
        gbl_routeTabPanel.columnWidths = new int[]{270, 356};
        gbl_routeTabPanel.rowHeights = new int[]{265, 120, 70};
        gbl_routeTabPanel.columnWeights = new double[]{0.0, 0.0};
        gbl_routeTabPanel.rowWeights = new double[]{0.0, 0.0, 0.0};
        this.routeTabPanel.setLayout(gbl_routeTabPanel);
        ResultDataTable table = new ResultDataTable();
        table.setData(FlightPlanBean.getInstance().getRoute().getSegments());
        this.resultDataTable = table;
        GridBagConstraints gbc_table = new GridBagConstraints();
        gbc_table.gridwidth = 2;
        gbc_table.fill = 1;
        gbc_table.insets = new Insets(0, 0, 5, 0);
        gbc_table.gridx = 0;
        gbc_table.gridy = 0;
        this.routeTabPanel.add((Component)this.resultDataTable, gbc_table);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.anchor = 17;
        gbc_panel_1.fill = 1;
        gbc_panel_1.insets = new Insets(0, 0, 5, 0);
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 1;
        this.routeTabPanel.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{120, 100};
        gbl_panel_1.rowHeights = new int[]{20, 20, 20, 20};
        gbl_panel_1.columnWeights = new double[]{0.0, 0.0};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0};
        panel_1.setLayout(gbl_panel_1);
        JLabel totalTimeAndDistanceLabel = new JLabel(Messages.getInstance().get("calculation_result_frame_flight_duration_and_distance"));
        GridBagConstraints gbc_totalTimeAndDistanceLabel = new GridBagConstraints();
        gbc_totalTimeAndDistanceLabel.fill = 2;
        gbc_totalTimeAndDistanceLabel.insets = new Insets(0, 0, 5, 5);
        gbc_totalTimeAndDistanceLabel.gridx = 0;
        gbc_totalTimeAndDistanceLabel.gridy = 0;
        panel_1.add((Component)totalTimeAndDistanceLabel, gbc_totalTimeAndDistanceLabel);
        this.totalTimeAndDistanceTextField = new JTextField();
        this.totalTimeAndDistanceTextField.setHorizontalAlignment(0);
        this.totalTimeAndDistanceTextField.setEditable(false);
        GridBagConstraints gbc_totalTimeAndDistanceTextField = new GridBagConstraints();
        gbc_totalTimeAndDistanceTextField.fill = 2;
        gbc_totalTimeAndDistanceTextField.anchor = 11;
        gbc_totalTimeAndDistanceTextField.insets = new Insets(0, 0, 5, 0);
        gbc_totalTimeAndDistanceTextField.gridx = 1;
        gbc_totalTimeAndDistanceTextField.gridy = 0;
        panel_1.add((Component)this.totalTimeAndDistanceTextField, gbc_totalTimeAndDistanceTextField);
        this.totalTimeAndDistanceTextField.setColumns(12);
        JLabel magvarLabel = new JLabel(Messages.getInstance().get("calculation_result_frame_magvar"));
        GridBagConstraints gbc_magvarLabel = new GridBagConstraints();
        gbc_magvarLabel.fill = 2;
        gbc_magvarLabel.insets = new Insets(0, 0, 5, 5);
        gbc_magvarLabel.gridx = 0;
        gbc_magvarLabel.gridy = 1;
        panel_1.add((Component)magvarLabel, gbc_magvarLabel);
        this.magvarTextField = new JTextField();
        this.magvarTextField.setHorizontalAlignment(0);
        this.magvarTextField.setEditable(false);
        GridBagConstraints gbc_magvarTextField = new GridBagConstraints();
        gbc_magvarTextField.fill = 2;
        gbc_magvarTextField.anchor = 11;
        gbc_magvarTextField.insets = new Insets(0, 0, 5, 0);
        gbc_magvarTextField.gridx = 1;
        gbc_magvarTextField.gridy = 1;
        panel_1.add((Component)this.magvarTextField, gbc_magvarTextField);
        this.magvarTextField.setColumns(12);
        JLabel label = new JLabel(Messages.getInstance().get("calculation_result_frame_total_kzmax"));
        label.setToolTipText(Messages.getInstance().get("calculation_result_frame_total_kzmax_tooltip"));
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.fill = 2;
        gbc_label.insets = new Insets(0, 0, 0, 5);
        gbc_label.gridx = 0;
        gbc_label.gridy = 2;
        panel_1.add((Component)label, gbc_label);
        this.kzmaxTextField = new JTextField();
        this.kzmaxTextField.setToolTipText(Messages.getInstance().get("calculation_result_frame_total_kzmax_tooltip"));
        this.kzmaxTextField.setHorizontalAlignment(0);
        this.kzmaxTextField.setEditable(false);
        this.kzmaxTextField.setColumns(12);
        GridBagConstraints gbc_kzmaxTextField = new GridBagConstraints();
        gbc_kzmaxTextField.fill = 2;
        gbc_kzmaxTextField.anchor = 11;
        gbc_kzmaxTextField.gridx = 1;
        gbc_kzmaxTextField.gridy = 2;
        panel_1.add((Component)this.kzmaxTextField, gbc_kzmaxTextField);
        JLabel msaLabel = new JLabel(Messages.getInstance().get("calculation_result_frame_total_msa") + UnitUtil.getAltitudeUnit());
        msaLabel.setToolTipText(Messages.getInstance().get("calculation_result_frame_total_msa_tooltip"));
        GridBagConstraints gbc_msa_label = new GridBagConstraints();
        gbc_msa_label.fill = 2;
        gbc_msa_label.insets = new Insets(0, 0, 0, 5);
        gbc_msa_label.gridx = 0;
        gbc_msa_label.gridy = 3;
        panel_1.add((Component)msaLabel, gbc_msa_label);
        this.msaTextField = new JTextField();
        this.msaTextField.setToolTipText(Messages.getInstance().get("calculation_result_frame_total_msa_tooltip"));
        this.msaTextField.setHorizontalAlignment(0);
        this.msaTextField.setEditable(false);
        this.msaTextField.setColumns(12);
        GridBagConstraints gbc_msaTextField = new GridBagConstraints();
        gbc_msaTextField.fill = 2;
        gbc_msaTextField.anchor = 11;
        gbc_msaTextField.gridx = 1;
        gbc_msaTextField.gridy = 3;
        panel_1.add((Component)this.msaTextField, gbc_msaTextField);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.anchor = 13;
        gbc_panel.fill = 1;
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 1;
        this.routeTabPanel.add((Component)panel, gbc_panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel.add((Component)panel_2, "South");
        panel_2.setBorder(new EtchedBorder(1, null, null));
        panel_2.setLayout(new BorderLayout(0, 0));
        this.panel_6 = new JPanel();
        this.panel_6.setBorder(null);
        panel_2.add((Component)this.panel_6, "North");
        this.minuteIntervalsCheckbox = new JCheckBox(Messages.getInstance().get("show"));
        this.minuteIntervalsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalculationResultDialog.this.updateMinuteIntervalsAction();
            }
        });
        this.panel_6.add(this.minuteIntervalsCheckbox);
        this.minuteIntervalValueTextField = new JTextField("5");
        this.minuteIntervalValueTextField.setHorizontalAlignment(0);
        this.minuteIntervalValueTextField.setColumns(2);
        this.minuteIntervalValueTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                CalculationResultDialog.this.updateMinuteIntervalsAction();
            }
        });
        this.minuteIntervalValueTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    CalculationResultDialog.this.updateMinuteIntervalsAction();
                }
            }
        });
        this.panel_6.add(this.minuteIntervalValueTextField);
        ((AbstractDocument)this.minuteIntervalValueTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter(2));
        this.panel_6.add(new JLabel(Messages.getInstance().get("calculation_result_frame_minute_intervals")));
        this.panel_7 = new JPanel();
        this.panel_7.setBorder(null);
        panel_2.add((Component)this.panel_7, "South");
        this.segmentDistanceAndTimeCheckBox = new JCheckBox(Messages.getInstance().get("calculation_result_frame_segment_distance_and_time"), MapFrame.getInstance().isCalculationResultPaintDistanceAndTime());
        this.segmentDistanceAndTimeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalculationResultDialog.this.toggleSegmentDistanceAndTimeAction();
            }
        });
        this.panel_7.add(this.segmentDistanceAndTimeCheckBox);
        this.fuelDataTable = new FuelDataTable();
        panel.add((Component)this.fuelDataTable, "North");
        this.panel_5 = new JPanel();
        panel.add((Component)this.panel_5, "Center");
        this.panel_5.setLayout(new BorderLayout(0, 0));
        JPanel lowerPanel = new JPanel();
        lowerPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_lowerPanel = new GridBagConstraints();
        gbc_lowerPanel.gridwidth = 2;
        gbc_lowerPanel.fill = 1;
        gbc_lowerPanel.gridx = 0;
        gbc_lowerPanel.gridy = 2;
        this.routeTabPanel.add((Component)lowerPanel, gbc_lowerPanel);
        lowerPanel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        lowerPanel.add((Component)buttonPanel, "Center");
        buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        JButton exportPdfButton = new JButton(Messages.getInstance().get("save_as_pdf"));
        exportPdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalculationResultDialog.this.exportPdfAction(true);
            }
        });
        buttonPanel.add(exportPdfButton);
        JPanel savingOptionsPanel = new JPanel();
        lowerPanel.add((Component)savingOptionsPanel, "North");
        this.configurePdfButton = new JButton(Messages.getInstance().get("calculation_result_frame_configure_map_in_pdf"));
        this.configurePdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalculationResultDialog.this.configurePdfAction();
            }
        });
        savingOptionsPanel.add(this.configurePdfButton);
        JButton configurePdfDialog = new JButton(Messages.getInstance().get("calculation_result_frame_configure_pdf"));
        configurePdfDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PdfSettingsDialog dialog = new PdfSettingsDialog((Window)CalculationResultDialog.this);
                dialog.setVisible(true);
            }
        });
        savingOptionsPanel.add(configurePdfDialog);
        this.vorTabPanel = new JPanel();
        this.tabbedPane.addTab(Messages.getInstance().get("calculation_result_frame_vor_tab"), null, this.vorTabPanel, null);
        GridBagLayout gbl_vorTabPanel = new GridBagLayout();
        gbl_vorTabPanel.columnWidths = new int[]{626};
        gbl_vorTabPanel.rowHeights = new int[]{401, 33};
        gbl_vorTabPanel.columnWeights = new double[]{0.0};
        gbl_vorTabPanel.rowWeights = new double[]{0.0, 0.0};
        this.vorTabPanel.setLayout(gbl_vorTabPanel);
        this.vorDataTable = new VorResultDataTable(FlightPlanBean.getInstance().getRoute());
        GridBagConstraints gbc_vorDataTable = new GridBagConstraints();
        gbc_vorDataTable.fill = 1;
        gbc_vorDataTable.insets = new Insets(0, 0, 5, 0);
        gbc_vorDataTable.gridx = 0;
        gbc_vorDataTable.gridy = 0;
        this.vorTabPanel.add((Component)this.vorDataTable, gbc_vorDataTable);
        this.panel_3 = new JPanel();
        this.panel_3.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_panel_3 = new GridBagConstraints();
        gbc_panel_3.anchor = 11;
        gbc_panel_3.fill = 2;
        gbc_panel_3.gridx = 0;
        gbc_panel_3.gridy = 1;
        this.vorTabPanel.add((Component)this.panel_3, gbc_panel_3);
        this.drawOnMapCheckbox = new JCheckBox(Messages.getInstance().get("calculation_result_frame_draw_radials_on_map"));
        this.drawOnMapCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalculationResultDialog.this.drawVorOnMapToggleAction();
            }
        });
        this.panel_3.setLayout(new FlowLayout(1, 5, 5));
        this.panel_3.add(this.drawOnMapCheckbox);
        this.showDistancesCheckBox = new JCheckBox(Messages.getInstance().get("calculation_result_frame_show_radials_distances"));
        this.showDistancesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalculationResultDialog.this.showDistancesToggleAction();
            }
        });
        this.selectVorButton = new JButton(Messages.getInstance().get("calculation_result_frame_select_vor"));
        this.selectVorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalculationResultDialog.this.selectVorAction();
            }
        });
        this.panel_3.add(this.selectVorButton);
        this.panel_3.add(this.showDistancesCheckBox);
        this.includeVorNameCheckBox = new JCheckBox(Messages.getInstance().get("calculation_result_frame_include_vor_name"));
        this.includeVorNameCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalculationResultDialog.this.toggleIncludeVorNameAction();
            }
        });
        this.panel_3.add(this.includeVorNameCheckBox);
        this.panel_4 = new JPanel();
        this.getContentPane().add((Component)this.panel_4, "South");
        this.alwaysOnTopCheckBox = new JCheckBox(Messages.getInstance().get("window_always_on_top"), this.isAlwaysOnTop());
        this.alwaysOnTopCheckBox.setHorizontalAlignment(0);
        this.alwaysOnTopCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalculationResultDialog.this.alwaysOnTopAction();
            }
        });
        this.panel_4.setLayout(new BorderLayout(0, 0));
        this.panel_4.add(this.alwaysOnTopCheckBox);
        JPanel alternateAirportsTabPanel = new JPanel();
        this.tabbedPane.addTab(Messages.getInstance().get("calculation_result_frame_alternate_airports_tab"), null, alternateAirportsTabPanel, null);
        GridBagLayout gbl_alternatesTabPanel = new GridBagLayout();
        gbl_alternatesTabPanel.columnWidths = new int[]{626};
        gbl_alternatesTabPanel.rowHeights = new int[]{401, 33};
        gbl_alternatesTabPanel.columnWeights = new double[]{0.0};
        gbl_alternatesTabPanel.rowWeights = new double[]{0.0, 0.0};
        alternateAirportsTabPanel.setLayout(gbl_alternatesTabPanel);
        AlternatesResultDataTable alternatesDataTable = new AlternatesResultDataTable(FlightPlanBean.getInstance().getRoute());
        GridBagConstraints gbc_alternatesDataTable = new GridBagConstraints();
        gbc_alternatesDataTable.fill = 1;
        gbc_alternatesDataTable.insets = new Insets(0, 0, 5, 0);
        gbc_alternatesDataTable.gridx = 0;
        gbc_alternatesDataTable.gridy = 0;
        alternateAirportsTabPanel.add((Component)alternatesDataTable, gbc_alternatesDataTable);
        if (FlightPlanBean.getInstance().getRoute().getVors().size() > 0) {
            this.tabbedPane.setEnabledAt(1, true);
        } else {
            this.tabbedPane.setEnabledAt(1, false);
        }
        if (FlightPlanBean.getInstance().getRoute().getAlternateAirports().size() > 0) {
            this.tabbedPane.setEnabledAt(2, true);
        } else {
            this.tabbedPane.setEnabledAt(2, false);
        }
        MapFrame.getInstance().setPaintVorRadials(this.drawOnMapCheckbox.isSelected());
        MapFrame.getInstance().setPaintVorDistances(this.showDistancesCheckBox.isSelected());
        MapFrame.getInstance().setPaintVorNames(this.includeVorNameCheckBox.isSelected());
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.setPreferredSize(new Dimension(637, 525));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
    }

    private void configurePdfAction() {
        this.setVisible(false);
        PdfRegionDialog dialog = new PdfRegionDialog(MapFrame.getInstance(), this, FlightPlanBean.getInstance().getRoute().getPdfMapRegion(), 0);
        dialog.setVisible(true);
    }

    protected void toggleSegmentDistanceAndTimeAction() {
        MapFrame.getInstance().setCalculationResultPaintDistanceAndTime(this.segmentDistanceAndTimeCheckBox.isSelected());
        MapFrame.getInstance().updateMap();
    }

    private void alwaysOnTopAction() {
        this.setAlwaysOnTop(this.alwaysOnTopCheckBox.isSelected());
    }

    public void updateMinuteIntervalsAction() {
        if (!this.windowClosing) {
            boolean fillWithDefaultValue = false;
            int minuteInterval = 5;
            try {
                minuteInterval = Integer.valueOf(this.minuteIntervalValueTextField.getText());
                if (minuteInterval < 1) {
                    fillWithDefaultValue = true;
                }
            }
            catch (NumberFormatException e) {
                fillWithDefaultValue = true;
            }
            if (fillWithDefaultValue) {
                minuteInterval = 5;
                this.minuteIntervalValueTextField.setText(String.valueOf(minuteInterval));
            }
            if (this.minuteIntervalsCheckbox.isSelected()) {
                FlightPlanBean.getInstance().getRoute().calculateMinuteIntervals(minuteInterval);
            } else {
                FlightPlanBean.getInstance().getRoute().clearMinuteIntervals();
            }
            MapFrame.getInstance().updateMap();
        }
    }

    private void drawVorOnMapToggleAction() {
        if (!this.drawOnMapCheckbox.isSelected()) {
            this.showDistancesCheckBox.setSelected(false);
            this.includeVorNameCheckBox.setSelected(false);
        }
        this.showDistancesCheckBox.setEnabled(this.drawOnMapCheckbox.isSelected());
        this.includeVorNameCheckBox.setEnabled(this.drawOnMapCheckbox.isSelected());
        this.selectVorButton.setEnabled(this.drawOnMapCheckbox.isSelected());
        MapFrame.getInstance().setPaintVorRadials(this.drawOnMapCheckbox.isSelected());
        if (this.drawOnMapCheckbox.isSelected()) {
            this.selectVorAction();
        } else {
            MapFrame.getInstance().updateMap();
        }
    }

    private void selectVorAction() {
        AddMapRadialsCalculationDialog dialog = new AddMapRadialsCalculationDialog(MapFrame.getInstance());
        dialog.setVisible(true);
        if (dialog.isCancelled()) {
            this.selectVorButton.setEnabled(false);
            this.showDistancesCheckBox.setSelected(false);
            this.showDistancesCheckBox.setEnabled(false);
            this.drawOnMapCheckbox.setSelected(false);
            this.includeVorNameCheckBox.setSelected(false);
            this.includeVorNameCheckBox.setEnabled(false);
        } else {
            MapFrame.getInstance().updateMap();
        }
    }

    private void showDistancesToggleAction() {
        MapFrame.getInstance().setPaintVorDistances(this.showDistancesCheckBox.isSelected());
        MapFrame.getInstance().updateMap();
    }

    private void toggleIncludeVorNameAction() {
        MapFrame.getInstance().setPaintVorNames(this.includeVorNameCheckBox.isSelected());
        MapFrame.getInstance().updateMap();
    }

    public void closeWindowAction() {
        this.windowClosing = true;
        FlightPlanBean.getInstance().getRoute().clearMinuteIntervals();
        FlightPlanBean.getInstance().getCalculationDialogDrawRadialsVors().clear();
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().unlockPoints();
        MapFrame.getInstance().setOnCalculatedFrame(false);
        MapFrame.getInstance().setPaintVorRadials(false);
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }

    public void updateData() {
        if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getRoute().getName())) {
            this.setTitle("VfrFlight: " + FlightPlanBean.getInstance().getRoute().getName());
        }
        if (FlightPlanBean.getInstance().getRoute().getPdfMapRegion() == null) {
            RotatedGpsArea pdfMapRegion = new RotatedGpsArea(GpsUtil.getRectangleOverVertices(new ArrayList<GpsVertex>(FlightPlanBean.getInstance().getRoute().getPoints())));
            FlightPlanBean.getInstance().getRoute().setPdfMapRegion(pdfMapRegion);
            FlightPlanBean.getInstance().getRoute().setPdfMapZoom(MapFrame.getInstance().getMapViewer().getZoom());
        }
        this.updateInfoPanel();
        this.updateFuelTable();
        this.selectVorButton.setEnabled(false);
        this.drawOnMapCheckbox.setSelected(false);
        this.showDistancesCheckBox.setSelected(false);
        this.showDistancesCheckBox.setEnabled(false);
        this.includeVorNameCheckBox.setSelected(false);
        this.includeVorNameCheckBox.setEnabled(false);
    }

    public void updateInfoPanel() {
        String totalDistTxt = String.valueOf(NumberUtil.roundDouble(FlightPlanBean.getInstance().getRoute().getTotalDistance(), 1)) + SettingsBean.getInstance().getParamUnitsDistance();
        String totalTimeTxt = FormatUtil.formatTime(FlightPlanBean.getInstance().getRoute().getTotalTime());
        this.totalTimeAndDistanceTextField.setText(totalDistTxt + " / " + totalTimeTxt);
        this.magvarTextField.setText(String.valueOf(NumberUtil.roundDouble(FlightPlanBean.getInstance().getRoute().getMagvarFromCenter(), 1)));
        this.kzmaxTextField.setText(String.valueOf(Math.round(FlightPlanBean.getInstance().getRoute().getKzmax())));
        ElevationFacade elevationFacade = new ElevationFacade(DBUtil.getDataSource());
        Integer msa = elevationFacade.calculateMsa(MapFrame.getInstance().getMapViewer(), FlightPlanBean.getInstance().getRoute().getSegments());
        if (msa != null) {
            this.msaTextField.setText(String.valueOf(msa));
        } else {
            this.msaTextField.setText(Messages.getInstance().get("not_available"));
        }
    }

    public void updateFuelTable() {
        this.fuelDataTable.setValues(FlightPlanBean.getInstance().getRoute().getFuelValues());
    }

    public void exportPdfAction(boolean fromCalculationDialog) {
        int returnVal;
        if (!FlightPlanBean.getInstance().getRoute().isMapResolutionAndAreaSelected()) {
            new HintDialog((Window)this, 3);
        }
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("save_as_pdf"), Messages.getInstance().get("save"), SettingsBean.getInstance().getPdfFilesPath());
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("pdf_files"), new String[]{"PDF"}));
        if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getRoute().getName())) {
            chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getRoute().getName() + ".pdf"));
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
            SettingsBean.getInstance().setPdfFilesPath(chooser.getSelectedFile().getPath());
            FlightPlanBean.getInstance().unselectAll();
            MapFrame.getInstance().updateMap();
            String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "pdf");
            if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("save_as_pdf"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                PdfConfigBean configBean = SettingsBean.getInstance().getPdfConfigBean();
                configBean.setMapRegion(FlightPlanBean.getInstance().getRoute().getPdfMapRegion());
                configBean.setMapZoom(FlightPlanBean.getInstance().getRoute().getPdfMapZoom());
                configBean.setMagvar(FlightPlanBean.getInstance().getRoute().getMagvarFromCenter());
                Thread t = new Thread(new CreatePdfTask(this, fileName, FlightPlanBean.getInstance().getRoute(), configBean, MapObjectsBean.getInstance().getStations(), fromCalculationDialog));
                t.start();
            }
        }
    }

    public void createFlightPlanPdfFinish(boolean result, String fileName, boolean fromCalculationDialog) {
        if (result) {
            if (JOptionPane.showConfirmDialog(fromCalculationDialog ? this : MapFrame.getInstance(), Messages.getInstance().get("pdf_export_success"), "", 0) == 0) {
                IOUtil.openFileInDesktop(fileName);
            }
        } else {
            JOptionPane.showMessageDialog(fromCalculationDialog ? this : MapFrame.getInstance(), Messages.getInstance().get("pdf_export_error"), "", 0);
        }
    }
}

