/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.ExtensionFileFilter;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.table.NavaidsRow;
import main.java.guru.vfrflight.core.table.RunwayRow;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.pdf.util.PdfUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;

public class AirportInfoSavePdfDialog
extends JDialog {
    private static final long serialVersionUID = -4444570042504346193L;
    private Airport airport;
    private final List<RunwayRow> runways;
    private final List<NavaidsRow> navaids;
    private final Double magvar;
    private JCheckBox runwaysTableCheckBox;
    private JCheckBox navaidsInfoCheckBox;
    private JCheckBox frequenciesCheckBox;

    public AirportInfoSavePdfDialog(Window frame, Airport airport, Double magvar, List<RunwayRow> runways, List<NavaidsRow> navaids) {
        super(frame);
        this.setType(Window.Type.UTILITY);
        this.setResizable(false);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AirportInfoSavePdfDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("airport_info_save_pdf_dialog_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        panel_3.add((Component)panel, "Center");
        this.runwaysTableCheckBox = new JCheckBox(Messages.getInstance().get("airport_info_save_pdf_dialog_include_runways"), true);
        panel.add(this.runwaysTableCheckBox);
        this.navaidsInfoCheckBox = new JCheckBox(Messages.getInstance().get("airport_info_save_pdf_dialog_include_navaids"), true);
        panel.add(this.navaidsInfoCheckBox);
        this.frequenciesCheckBox = new JCheckBox(Messages.getInstance().get("airport_info_save_pdf_dialog_include_frequencies"), true);
        panel.add(this.frequenciesCheckBox);
        JPanel panel_1 = new JPanel();
        panel_3.add((Component)panel_1, "South");
        JButton savePdfButton = new JButton(Messages.getInstance().get("save"));
        panel_1.add(savePdfButton);
        savePdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AirportInfoSavePdfDialog.this.saveAsPdfAction();
            }
        });
        this.setModal(true);
        this.setSize(425, 90);
        this.setLocation(frame.getLocation().x + (frame.getWidth() - this.getSize().width) / 2, frame.getLocation().y + (frame.getHeight() - this.getSize().height) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.airport = airport;
        this.runways = runways;
        this.navaids = navaids;
        this.magvar = magvar;
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void saveAsPdfAction() {
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("save_as_pdf"), Messages.getInstance().get("save"), SettingsBean.getInstance().getPdfFilesPath());
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("pdf_files"), new String[]{"PDF"}));
        chooser.setSelectedFile(new File(this.airport.getIdent() + ".pdf"));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            SettingsBean.getInstance().setPdfFilesPath(chooser.getSelectedFile().getPath());
            FlightPlanBean.getInstance().unselectAll();
            MapFrame.getInstance().updateMap();
            String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "pdf");
            if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("save_as_pdf"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                if (PdfUtil.createAirportInfoPdf(fileName, this.airport, this.magvar, this.runways, this.navaids, this.runwaysTableCheckBox.isSelected(), this.navaidsInfoCheckBox.isSelected(), this.frequenciesCheckBox.isSelected())) {
                    JOptionPane.showMessageDialog(this, Messages.getInstance().get("pdf_export_success"), "", 1);
                } else {
                    JOptionPane.showMessageDialog(this, Messages.getInstance().get("pdf_export_error"), "", 0);
                }
                this.closeWindowAction();
            }
        }
    }
}

