/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.gui.flightplan.AirportInfoSavePdfDialog;
import main.java.guru.vfrflight.gui.flightplan.HintDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.AirportInfoDataTable;
import main.java.guru.vfrflight.gui.table.AirportInfoFreqDataTable;
import main.java.guru.vfrflight.gui.table.AirportInfoNavaidsDataTable;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class AirportInfoDialog
extends JDialog {
    private static final long serialVersionUID = 1128367340311205503L;
    private JLabel infoLabel;
    private AirportInfoDataTable runwaysTable;
    private AirportInfoNavaidsDataTable navaidsTable;
    private Airport airport;
    private Double magvar;

    public AirportInfoDialog(JFrame frame, Airport airport) {
        super(frame);
        this.setTitle("VfrFlight: " + airport.getIdentOrName());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AirportInfoDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        Integer elev = airport.getElev();
        if (elev != null && !"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            elev = (int)Math.round(UnitUtil.recalculateAltitude(elev.intValue(), "ft", "m", false));
        }
        this.magvar = this.getMagvar(airport);
        String txt = "";
        if (airport.getName() != null) {
            txt = txt + airport.getName() + " ";
        }
        if (airport.getIdent() != null) {
            txt = txt + "[" + airport.getIdent() + "], ";
        }
        if (elev != null) {
            txt = txt + Messages.getInstance().get("airport_info_dialog_elevation") + " " + elev + UnitUtil.getAltitudeUnit() + ", ";
        }
        txt = txt + Messages.getInstance().get("airport_info_dialog_magvar") + " " + (this.magvar != null ? String.valueOf((double)Math.round(this.magvar * 10.0) / 10.0) + "\u00b0" : Messages.getInstance().get("not_available"));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel tabPanel = new JPanel();
        panel.add(tabPanel);
        tabPanel.setLayout(new BorderLayout(0, 0));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabPanel.add(tabbedPane);
        JPanel mainTabPanel = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("airport_info_dialog_tab_main"), null, mainTabPanel, null);
        mainTabPanel.setLayout(new BorderLayout(0, 0));
        this.runwaysTable = new AirportInfoDataTable(airport.getRunways(), this.magvar);
        mainTabPanel.add((Component)this.runwaysTable, "Center");
        JPanel panel_1 = new JPanel();
        mainTabPanel.add((Component)panel_1, "North");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_1.add((Component)panel_2, "North");
        this.infoLabel = new JLabel(txt);
        panel_2.add(this.infoLabel);
        JPanel panel_3 = new JPanel();
        panel_1.add((Component)panel_3, "South");
        JLabel lblKliknijDwukrotnie = new JLabel(Messages.getInstance().get("airport_info_dialog_double_click"));
        panel_3.add(lblKliknijDwukrotnie);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)buttonPanel, "South");
        JButton anulujButton = new JButton(Messages.getInstance().get("close_button"));
        anulujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirportInfoDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(anulujButton);
        JButton saveAsPdfButton = new JButton(Messages.getInstance().get("save_as_pdf"));
        saveAsPdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirportInfoDialog.this.saveAsPdfAction();
            }
        });
        buttonPanel.add(saveAsPdfButton);
        JPanel navaidsTabPanel = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("airport_info_dialog_tab_navaids"), null, navaidsTabPanel, null);
        navaidsTabPanel.setLayout(new BorderLayout(0, 0));
        JPanel Panel_5 = new JPanel();
        navaidsTabPanel.add((Component)Panel_5, "North");
        Panel_5.setLayout(new FlowLayout(1, 5, 5));
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("airport_info_dialog_double_click"));
        Panel_5.add(lblNewLabel);
        this.navaidsTable = new AirportInfoNavaidsDataTable(airport.getGpsPlace(), this.magvar);
        navaidsTabPanel.add((Component)this.navaidsTable, "Center");
        JPanel freqTabPanel = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("airport_info_dialog_tab_freq"), null, freqTabPanel, null);
        freqTabPanel.setLayout(new BorderLayout(0, 0));
        AirportInfoFreqDataTable freqTable = new AirportInfoFreqDataTable(airport.getFrequencies());
        freqTabPanel.add((Component)freqTable, "Center");
        this.setPreferredSize(new Dimension(600, 380));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        MapFrame.getInstance().lock();
        MapFrame.getInstance().hidePanel();
        this.airport = airport;
        new HintDialog((Window)MapFrame.getInstance(), 2);
    }

    private void closeWindowAction() {
        if (!MapFrame.getInstance().isOnCalculatedFrame()) {
            MapFrame.getInstance().showPanel();
            MapFrame.getInstance().unlock();
        } else {
            MapFrame.getInstance().setPopupEnabled(true);
        }
        MapFrame.getInstance().setMarkerPlace(null);
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }

    private void saveAsPdfAction() {
        AirportInfoSavePdfDialog dialog = new AirportInfoSavePdfDialog(this, this.airport, this.magvar, this.runwaysTable.getRows(), this.navaidsTable.getRows());
        dialog.setVisible(true);
    }

    private Double getMagvar(Airport airport) {
        if (airport.getMagvar() == null) {
            Double magvar = null;
            for (Ils ils : airport.getAllIls()) {
                if (ils.getMagvar() == null) continue;
                magvar = ils.getMagvar();
                break;
            }
            if (magvar == null) {
                GpsPlace airportCenter = new GpsPlace(new GpsCoord(airport.getLat()), new GpsCoord(airport.getLon()));
                magvar = VfrUtil.getMagneticDeclination(airportCenter);
            }
            return magvar;
        }
        return airport.getMagvar();
    }
}

