/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.AddWithAlignObject;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.combo.item.NumericComboBoxItem;
import main.java.guru.vfrflight.core.dto.IlsDTO;
import main.java.guru.vfrflight.core.dto.RunwayDTO;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.map.MapObject;
import main.java.guru.vfrflight.core.sql.type.MapObjectType;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.PositiveDecimalFilter;
import main.java.guru.vfrflight.gui.swing.PositiveDigitsFilter;
import main.java.guru.vfrflight.gui.swing.panel.AlignCanvas;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class AddWithAlignDialog
extends JDialog {
    private static final long serialVersionUID = 6541984834499873988L;
    private final MapObject object;
    private AlignCanvas alignCanvas;
    private JTextField distanceTextField;
    private JTextField altitudeTextField;
    private JTextField directionTextField;
    private JRadioButton trueRadioButton;
    private JRadioButton magneticRadioButton;
    private Double magVar;
    private JTextField pitchTextField;
    private JCheckBox indirectCheckBox;
    private JCheckBox showInMapCheckbox;
    private JComboBox<NumericComboBoxItem> runwaysCombo;
    private List<AddWithAlignObject> objectsList = new ArrayList<AddWithAlignObject>();
    private int totalIlsCount = 0;

    public AddWithAlignDialog(JFrame frame, MapObject object) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AddWithAlignDialog.this.closeWindowAction();
            }
        });
        this.object = object;
        if (object.getPosition() != null) {
            this.magVar = object.getPosition().getMagvar();
        }
        if (this.magVar == null) {
            this.magVar = VfrUtil.getMagneticDeclination(object.getPosition());
        }
        List<Object> runwaysList = new ArrayList();
        if (this.isAirportType() && object.getId() != null) {
            AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
            runwaysList = airportFacade.getRunwaysByAirportId(object.getId(), true);
            for (RunwayDTO runwayDTO : runwaysList) {
                if (runwayDTO.getIls() == null) continue;
                this.totalIlsCount += runwayDTO.getIls().size();
            }
        }
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel contentPanel = new JPanel();
        panel_3.add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BorderLayout(0, 0));
        this.alignCanvas = new AlignCanvas(this, object.getPosition(), object.getType(), this.getContentPane().getBackground());
        contentPanel.add(this.alignCanvas);
        JPanel jPanel = new JPanel();
        contentPanel.add((Component)jPanel, "North");
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        panel.setBorder(new EtchedBorder(1, null, null));
        jPanel.add((Component)panel, "South");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel distancePanel = new JPanel();
        panel.add((Component)distancePanel, "North");
        JLabel distanceLabel = new JLabel(Messages.getInstance().get("add_new_with_align_distance") + UnitUtil.getDistanceUnit());
        distancePanel.add(distanceLabel);
        this.distanceTextField = new JTextField();
        distancePanel.add(this.distanceTextField);
        this.distanceTextField.setText("");
        this.distanceTextField.setHorizontalAlignment(0);
        this.distanceTextField.setColumns(5);
        ((AbstractDocument)this.distanceTextField.getDocument()).setDocumentFilter(new PositiveDecimalFilter());
        this.distanceTextField.setColumns(5);
        JPanel panel_5 = new JPanel();
        panel_5.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_5, "South");
        panel_5.setLayout(new BorderLayout(0, 0));
        JPanel altitudePanel = new JPanel();
        panel_5.add((Component)altitudePanel, "North");
        JLabel altitudeLabel = new JLabel(Messages.getInstance().get("add_new_with_align_altitude") + UnitUtil.getAltitudeUnit());
        altitudePanel.add(altitudeLabel);
        this.altitudeTextField = new JTextField();
        altitudePanel.add(this.altitudeTextField);
        this.altitudeTextField.setText("");
        this.altitudeTextField.setHorizontalAlignment(0);
        this.altitudeTextField.setColumns(5);
        ((AbstractDocument)this.altitudeTextField.getDocument()).setDocumentFilter(new PositiveDecimalFilter());
        this.altitudeTextField.setColumns(5);
        if (this.isAirportType()) {
            JPanel panel_6 = new JPanel();
            panel_5.add((Component)panel_6, "South");
            JLabel pitchLabel = new JLabel(Messages.getInstance().get("add_new_with_align_pitch"));
            panel_6.add(pitchLabel);
            this.pitchTextField = new JTextField();
            this.pitchTextField.setHorizontalAlignment(0);
            this.pitchTextField.setText("3.0");
            panel_6.add(this.pitchTextField);
            ((AbstractDocument)this.pitchTextField.getDocument()).setDocumentFilter(new PositiveDecimalFilter());
            this.pitchTextField.setColumns(5);
            JLabel degreesLabel = new JLabel("[\u00b0]");
            panel_6.add(degreesLabel);
            JButton calculatePitchButton = new JButton(Messages.getInstance().get("add_new_with_align_calculate"));
            calculatePitchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddWithAlignDialog.this.calculateAltitudeByPitchAction();
                }
            });
            panel_6.add(calculatePitchButton);
        }
        JPanel panel_4 = new JPanel();
        panel_4.setBorder(new EtchedBorder(1, null, null));
        jPanel.add((Component)panel_4, "Center");
        panel_4.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_4.add((Component)panel_2, "South");
        this.trueRadioButton = new JRadioButton(Messages.getInstance().get("add_new_with_align_true"));
        panel_2.add(this.trueRadioButton);
        this.magneticRadioButton = new JRadioButton(Messages.getInstance().get("add_new_with_align_magnetic"));
        panel_2.add(this.magneticRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.trueRadioButton);
        buttonGroup.add(this.magneticRadioButton);
        JPanel panel_7 = new JPanel();
        panel_4.add((Component)panel_7, "Center");
        panel_7.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        panel_7.add((Component)panel_1, "Center");
        JLabel directionLabel = new JLabel(Messages.getInstance().get("add_new_with_align_radial"));
        panel_1.add(directionLabel);
        this.directionTextField = new JTextField();
        this.directionTextField.setText("000");
        this.directionTextField.setHorizontalAlignment(0);
        this.directionTextField.setColumns(5);
        ((AbstractDocument)this.directionTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter(3));
        panel_1.add(this.directionTextField);
        this.indirectCheckBox = new JCheckBox(Messages.getInstance().get("add_new_with_align_indirect"), false);
        this.indirectCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddWithAlignDialog.this.directionChanged();
            }
        });
        panel_1.add(this.indirectCheckBox);
        JPanel panel_6 = new JPanel();
        panel_7.add((Component)panel_6, "North");
        panel_6.setLayout(new BorderLayout(0, 0));
        if (this.isAirportType() && runwaysList.size() > 0) {
            JPanel panel_8 = new JPanel();
            panel_6.setBorder(new EtchedBorder(1, null, null));
            panel_6.add((Component)panel_8, "Center");
            JPanel showInMapPanel = new JPanel();
            panel_6.add((Component)showInMapPanel, "South");
            this.showInMapCheckbox = new JCheckBox(Messages.getInstance().get("add_new_with_align_show_in_map"));
            this.showInMapCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    AddWithAlignDialog.this.updateMapPreview();
                }
            });
            showInMapPanel.add(this.showInMapCheckbox);
            panel_8.add(new JLabel(Messages.getInstance().get("add_new_with_align_from_position")));
            this.runwaysCombo = new JComboBox();
            ArrayList<NumericComboBoxItem> ilsCombo = new ArrayList<NumericComboBoxItem>(runwaysList.size() * 2 + this.totalIlsCount + 1);
            ilsCombo.add(new NumericComboBoxItem(Messages.getInstance().get("add_new_with_align_airport_center", object.getName()), 0));
            for (int i = 0; i < runwaysList.size(); ++i) {
                if (((RunwayDTO)runwaysList.get(i)).getPrimaryThresholdPosition() == null || ((RunwayDTO)runwaysList.get(i)).getSecondaryThresholdPosition() == null) continue;
                ilsCombo.add(new NumericComboBoxItem(Messages.getInstance().get("add_new_with_align_runway_threshold", ((RunwayDTO)runwaysList.get(i)).getPrimaryInfo()), ilsCombo.size() - 1));
                this.objectsList.add(new AddWithAlignObject(((RunwayDTO)runwaysList.get(i)).getPrimaryThresholdPosition(), ((RunwayDTO)runwaysList.get(i)).getElev(), ((RunwayDTO)runwaysList.get(i)).getPrimaryHeading(), null));
                IlsDTO ils = ((RunwayDTO)runwaysList.get(i)).getPrimaryRwyIls();
                if (ils != null) {
                    ilsCombo.add(new NumericComboBoxItem("   " + ils.getInfo(), ilsCombo.size() - 1));
                    this.objectsList.add(new AddWithAlignObject(ils.getGpsPlace(), ((RunwayDTO)runwaysList.get(i)).getElev(), ils.getHeading(), ils.getPitch()));
                }
                ilsCombo.add(new NumericComboBoxItem(Messages.getInstance().get("add_new_with_align_runway_threshold", ((RunwayDTO)runwaysList.get(i)).getSecondaryInfo()), ilsCombo.size() - 1));
                this.objectsList.add(new AddWithAlignObject(((RunwayDTO)runwaysList.get(i)).getSecondaryThresholdPosition(), ((RunwayDTO)runwaysList.get(i)).getElev(), ((RunwayDTO)runwaysList.get(i)).getSecondaryHeading(), null));
                ils = ((RunwayDTO)runwaysList.get(i)).getSecondaryRwyIls();
                if (ils == null) continue;
                ilsCombo.add(new NumericComboBoxItem("   " + ils.getInfo(), ilsCombo.size() - 1));
                this.objectsList.add(new AddWithAlignObject(ils.getGpsPlace(), ((RunwayDTO)runwaysList.get(i)).getElev(), ils.getHeading(), ils.getPitch()));
            }
            this.runwaysCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    AddWithAlignDialog.this.objectsListChanged();
                }
            });
            this.runwaysCombo.setModel(new DefaultComboBoxModel<NumericComboBoxItem>(ilsCombo.toArray(new NumericComboBoxItem[ilsCombo.size()])));
            panel_8.add(this.runwaysCombo);
        }
        this.directionTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    AddWithAlignDialog.this.directionChanged();
                }
            }
        });
        this.directionTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                AddWithAlignDialog.this.directionChanged();
            }
        });
        if (this.magVar == null) {
            this.trueRadioButton.setSelected(true);
            this.trueRadioButton.setEnabled(false);
            this.magneticRadioButton.setEnabled(false);
        } else {
            this.magneticRadioButton.setSelected(true);
            this.trueRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    double direction = AddWithAlignDialog.this.alignCanvas.getDirection();
                    if (AddWithAlignDialog.this.indirectCheckBox.isSelected()) {
                        direction -= 180.0;
                    }
                    AddWithAlignDialog.this.directionTextField.setText(String.valueOf(FormatUtil.formattedCourse(direction + AddWithAlignDialog.this.getMagVar(), false)));
                    AddWithAlignDialog.this.directionChanged();
                }
            });
            this.magneticRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    double direction = AddWithAlignDialog.this.alignCanvas.getDirection();
                    if (AddWithAlignDialog.this.indirectCheckBox.isSelected()) {
                        direction -= 180.0;
                    }
                    AddWithAlignDialog.this.directionTextField.setText(String.valueOf(FormatUtil.formattedCourse(direction - AddWithAlignDialog.this.getMagVar(), false)));
                    AddWithAlignDialog.this.directionChanged();
                }
            });
        }
        JPanel buttonPanel = new JPanel();
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        buttonPanel.add(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddWithAlignDialog.this.addAction();
            }
        });
        this.setModal(true);
        this.setSize(300, 450);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void updateMapPreview() {
        if (this.showInMapCheckbox.isSelected()) {
            NumericComboBoxItem selIls = (NumericComboBoxItem)this.runwaysCombo.getSelectedItem();
            if (selIls.getValue() == 0) {
                MapFrame.getInstance().setMarkerPlace(this.object.getPosition());
            } else {
                MapFrame.getInstance().setMarkerPlace(this.objectsList.get(selIls.getValue() - 1).getPosition());
            }
            MapFrame.getInstance().centerOnPoint(MapFrame.getInstance().getMarkerPlace(), 5);
        } else {
            MapFrame.getInstance().setMarkerPlace(null);
        }
        MapFrame.getInstance().updateMap();
    }

    protected void objectsListChanged() {
        NumericComboBoxItem selIls = (NumericComboBoxItem)this.runwaysCombo.getSelectedItem();
        if (selIls.getValue() == 0) {
            this.directionTextField.setEnabled(true);
            this.indirectCheckBox.setEnabled(true);
            if (this.magVar != null) {
                this.trueRadioButton.setEnabled(true);
                this.magneticRadioButton.setEnabled(true);
            }
            this.alignCanvas.setEnabled(true);
        } else {
            AddWithAlignObject object = this.objectsList.get(selIls.getValue() - 1);
            this.directionTextField.setEnabled(false);
            this.indirectCheckBox.setEnabled(false);
            this.trueRadioButton.setEnabled(false);
            this.magneticRadioButton.setEnabled(false);
            this.trueRadioButton.setSelected(true);
            this.indirectCheckBox.setSelected(true);
            this.alignCanvas.setEnabled(false);
            if (object.getPitch() != null) {
                this.pitchTextField.setText(String.valueOf(NumberUtil.roundDouble(object.getPitch(), 2)));
            } else {
                this.pitchTextField.setText("");
            }
            this.directionChanged(object.getDirection());
        }
        this.updateMapPreview();
    }

    protected void calculateAltitudeByPitchAction() {
        if (!StringUtil.isEmpty(this.distanceTextField.getText()) && !StringUtil.isEmpty(this.pitchTextField.getText())) {
            Double distance = null;
            Double pitch = null;
            try {
                distance = Double.valueOf(this.distanceTextField.getText());
                pitch = Double.valueOf(this.pitchTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (distance != null && pitch != null) {
                distance = UnitUtil.recalculateDistance(distance, SettingsBean.getInstance().getParamUnitsDistance(), SettingsBean.getInstance().getParamUnitsAltitude(), false);
                double alt = Math.tan(Math.toRadians(pitch)) * distance;
                NumericComboBoxItem selRwyIls = null;
                if (this.isIncludeRunways()) {
                    selRwyIls = (NumericComboBoxItem)this.runwaysCombo.getSelectedItem();
                }
                if (!this.isIncludeRunways() || selRwyIls.getValue() == 0) {
                    if (this.object.getPosition().getAlt() != null) {
                        alt += this.object.getPosition().getAlt().doubleValue();
                    }
                } else if (selRwyIls.getValue() > 0 && this.objectsList.get(selRwyIls.getValue() - 1).getElevation() != null) {
                    alt += UnitUtil.recalculateAltitude(this.objectsList.get(selRwyIls.getValue() - 1).getElevation().intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
                }
                this.altitudeTextField.setText(String.valueOf(NumberUtil.roundDouble(alt)));
            }
        } else {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("add_new_with_align_distance_and_pitch_empty"), Messages.getInstance().get("error"), 0);
        }
    }

    private void directionChanged() {
        this.directionChanged(null);
    }

    private void directionChanged(Double direction) {
        try {
            if (direction == null) {
                direction = Double.valueOf(this.directionTextField.getText());
            }
            this.directionTextField.setText(FormatUtil.formattedCourse(direction, false));
            this.alignCanvas.setDirection(this.indirectCheckBox.isSelected() ? GpsUtil.normalizeCourse(direction + 180.0) : GpsUtil.normalizeCourse(direction));
            this.alignCanvas.repaint();
        }
        catch (NumberFormatException e) {
            this.directionTextField.setText("");
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isEmpty(this.directionTextField.getText())) {
            errors.add(Messages.getInstance().get("add_new_with_align_direction_empty"));
        }
        if (StringUtil.isEmpty(this.distanceTextField.getText())) {
            errors.add(Messages.getInstance().get("add_new_with_align_distance_empty"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void closeWindowAction() {
        MapFrame.getInstance().setMarkerPlace(null);
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }

    private void addAction() {
        if (this.doValidate()) {
            Double direction = null;
            Double distance = null;
            Double altitude = null;
            NumericComboBoxItem selRwyIls = null;
            if (this.isIncludeRunways()) {
                selRwyIls = (NumericComboBoxItem)this.runwaysCombo.getSelectedItem();
            }
            if (!this.isIncludeRunways() || selRwyIls.getValue() == 0) {
                try {
                    direction = Double.valueOf(this.directionTextField.getText());
                    if (this.indirectCheckBox.isSelected()) {
                        direction = GpsUtil.normalizeCourse(direction + 180.0);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                direction = this.objectsList.get(selRwyIls.getValue() - 1).getDirection() + 180.0;
            }
            try {
                distance = Double.valueOf(this.distanceTextField.getText());
                if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                    distance = UnitUtil.recalculateDistance(distance, SettingsBean.getInstance().getParamUnitsDistance(), "nm", false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                altitude = Double.valueOf(this.altitudeTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (direction != null && distance != null) {
                if (this.magneticRadioButton.isSelected()) {
                    direction = GpsUtil.normalizeCourse(direction + this.magVar);
                }
                if (this.isIncludeRunways() && selRwyIls.getValue() > 0) {
                    this.object.setPosition(this.objectsList.get(selRwyIls.getValue() - 1).getPosition());
                }
                GpsPlace newPlace = GpsUtil.getPointPositionByDistanceAndBearing(this.object.getPosition(), direction, distance);
                double newDistance = GpsUtil.getDistance(this.object.getPosition(), newPlace);
                if (!NumberUtil.doubleEqualsDouble(distance, newDistance)) {
                    newPlace = GpsUtil.getPointPositionByDistanceAndBearing(this.object.getPosition(), direction, distance - (newDistance - distance));
                }
                if (altitude != null) {
                    newPlace.setAlt(altitude);
                }
                MapFrame.getInstance().getUIPanel().addNewPoint(newPlace, null);
                MapFrame.getInstance().centerOnPoint(newPlace, false);
                this.closeWindowAction();
            }
        }
    }

    public JTextField getDistanceTextField() {
        return this.distanceTextField;
    }

    public void setDistanceTextField(JTextField distanceTextField) {
        this.distanceTextField = distanceTextField;
    }

    public JTextField getDirectionTextField() {
        return this.directionTextField;
    }

    public JCheckBox getIndirectCheckBox() {
        return this.indirectCheckBox;
    }

    public void setIndirectCheckBox(JCheckBox indirectCheckBox) {
        this.indirectCheckBox = indirectCheckBox;
    }

    public void setDirectionTextField(JTextField directionTextField) {
        this.directionTextField = directionTextField;
    }

    public Double getMagVar() {
        return this.magVar;
    }

    public JRadioButton getMagneticRadioButton() {
        return this.magneticRadioButton;
    }

    public void setMagneticRadioButton(JRadioButton magneticRadioButton) {
        this.magneticRadioButton = magneticRadioButton;
    }

    private boolean isAirportType() {
        return this.object != null && MapObjectType.AIRPORT.equals((Object)this.object.getType());
    }

    private boolean isIncludeRunways() {
        return this.isAirportType() && this.object.getId() != null && this.objectsList.size() > 0;
    }
}

