/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.gui.swing.panel.JCoordsPanel;
import main.java.guru.vfrflight.gui.task.RefreshUserPointsTask;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UserPointsUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class AddUserPointDialog
extends JDialog {
    private static final long serialVersionUID = 9053118458620666793L;
    private JTextField nameTextField;
    private JTextArea tagsTextArea;
    private JCoordsPanel coordinatesPanel;
    private UserPoint userPoint;
    private boolean pointSaved = false;

    public AddUserPointDialog(Window frame, UserPoint userPoint) {
        super(frame);
        this.userPoint = userPoint == null ? new UserPoint() : userPoint;
        this.setType(Window.Type.UTILITY);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AddUserPointDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("add_user_point_dialog_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        contentPanel.add((Component)panel, "North");
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("add_user_point_dialog_name"));
        panel.add(lblNewLabel);
        this.nameTextField = new JTextField(StringUtil.nullToEmpty(this.userPoint.getName()));
        this.nameTextField.setHorizontalAlignment(0);
        panel.add(this.nameTextField);
        this.nameTextField.setColumns(20);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EmptyBorder(0, 5, 0, 5));
        contentPanel.add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        this.tagsTextArea = new JTextArea(UserPointsUtil.getParsedTags(StringUtil.nullToEmpty(this.userPoint.getTags())));
        this.tagsTextArea.setColumns(10);
        this.tagsTextArea.setBorder(new EtchedBorder(1, null, null));
        this.tagsTextArea.setLineWrap(true);
        JScrollPane scroll = new JScrollPane(this.tagsTextArea);
        scroll.setVerticalScrollBarPolicy(20);
        panel_1.add((Component)scroll, "Center");
        GpsPlace place = null;
        if (this.userPoint != null) {
            place = this.userPoint.getGpsPlace();
        }
        this.coordinatesPanel = new JCoordsPanel(null, place, false);
        panel_1.add((Component)this.coordinatesPanel, "South");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddUserPointDialog.this.saveAction();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddUserPointDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(cancelButton);
        this.setModal(true);
        this.setSize(450, 250);
        this.setLocation(frame.getLocation().x + (frame.getWidth() - this.getSize().width) / 2, frame.getLocation().y + (frame.getHeight() - this.getSize().height) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    protected void saveAction() {
        if (this.doValidate()) {
            this.userPoint.setName(this.nameTextField.getText());
            this.userPoint.setTags(this.tagsTextArea.getText());
            GpsPlace place = this.coordinatesPanel.getValue();
            this.userPoint.setLat(place.getLatVal());
            this.userPoint.setLon(place.getLonVal());
            if (!StringUtil.isEmpty(this.userPoint.getTags())) {
                this.userPoint.setTags(UserPointsUtil.parsedTags(this.userPoint.getTags()));
            }
            UserPointFacade facade = new UserPointFacade(DBUtil.getDataSource());
            if (this.userPoint.getId() != null) {
                facade.deleteUserPointById(this.userPoint.getId());
            }
            facade.insertUserPoint(this.userPoint);
            this.pointSaved = true;
            VfrUtil.setLayerVisibilityAction(new RefreshUserPointsTask());
            this.closeWindowAction();
        }
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isEmpty(this.nameTextField.getText())) {
            errors.add(Messages.getInstance().get("add_user_point_dialog_name_empty"));
        }
        errors.addAll(this.coordinatesPanel.getValidationErrors());
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public boolean isPointSaved() {
        return this.pointSaved;
    }
}

