/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.SearchResultDataTable;

public class AddRouteListDialog
extends JDialog {
    private static final long serialVersionUID = 5404456842245803732L;
    private SearchResultDataTable resultTable;
    private List<GpsPlace> resultTableData;
    private GpsPlace selectedPoint = null;
    private boolean skipPoint = false;

    public AddRouteListDialog(String pointId, List<GpsPlace> results) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AddRouteListDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("add_route_list_dialog_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "South");
        JButton eksportujButton = new JButton(Messages.getInstance().get("add_button"));
        eksportujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddRouteListDialog.this.addAction();
            }
        });
        buttonPanel.add(eksportujButton);
        JButton showOnMapButton = new JButton(Messages.getInstance().get("show_on_map_button"));
        showOnMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddRouteListDialog.this.showOnMapAction();
            }
        });
        buttonPanel.add(showOnMapButton);
        JButton anulujButton = new JButton(Messages.getInstance().get("cancel_button"));
        anulujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRouteListDialog.this.cancelAction();
            }
        });
        JButton skipButton = new JButton(Messages.getInstance().get("skip_button"));
        skipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddRouteListDialog.this.skipAction();
            }
        });
        buttonPanel.add(skipButton);
        buttonPanel.add(anulujButton);
        JPanel resultsTablePanel = new JPanel();
        panel.add((Component)resultsTablePanel, "Center");
        resultsTablePanel.setLayout(new BorderLayout(0, 0));
        this.resultTable = new SearchResultDataTable();
        resultsTablePanel.add(this.resultTable);
        JPanel panel_1 = new JPanel();
        panel.add((Component)panel_1, "North");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_3 = new JPanel();
        panel_1.add((Component)panel_3, "South");
        JLabel infoLabel = new JLabel(Messages.getInstance().get("add_route_list_dialog_add_point_as", pointId));
        panel_3.add(infoLabel);
        this.setModal(true);
        this.resultTable.setData(results);
        this.resultTableData = results;
        this.setSize(500, 380);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    public void showOnMapAction() {
        int idx = this.resultTable.getTable().getSelectedRow();
        if (idx >= 0) {
            this.resultTable.showPointOnMap(idx);
        }
    }

    private void closeWindowAction() {
        if (FlightPlanBean.getInstance().getRoute().removePhantomPoints()) {
            MapFrame.getInstance().updateMap();
        }
        this.setVisible(false);
    }

    private void skipAction() {
        this.skipPoint = true;
        this.closeWindowAction();
    }

    private void cancelAction() {
        this.closeWindowAction();
    }

    private void addAction() {
        int idx = this.resultTable.getTable().getSelectedRow();
        if (idx >= 0) {
            this.selectedPoint = this.resultTableData.get(idx);
            this.closeWindowAction();
        }
    }

    public GpsPlace getSelectedPoint() {
        return this.selectedPoint;
    }

    public void setSelectedPoint(GpsPlace selectedPoint) {
        this.selectedPoint = selectedPoint;
    }

    public boolean isSkipPoint() {
        return this.skipPoint;
    }

    public void setSkipPoint(boolean skipPoint) {
        this.skipPoint = skipPoint;
    }
}

