/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.AddRouteListDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.CityFacade;
import main.java.guru.vfrflight.sql.facade.IfrRouteFacade;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class AddRouteDialog
extends JDialog {
    private static final long serialVersionUID = 2006086811427452389L;
    private JTextField queryTextField;

    public AddRouteDialog() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AddRouteDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("add_route_frame_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        this.queryTextField = new JTextField();
        this.queryTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    AddRouteDialog.this.searchAction();
                } else if (27 == e.getKeyCode()) {
                    AddRouteDialog.this.closeWindowAction();
                }
            }
        });
        panel_3.add(this.queryTextField);
        this.queryTextField.setColumns(45);
        JButton searchButton = new JButton(Messages.getInstance().get("search_button"));
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddRouteDialog.this.searchAction();
            }
        });
        panel_3.add(searchButton);
        this.setModal(true);
        this.setPreferredSize(new Dimension(605, 64));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void searchAction() {
        if (this.queryTextField.getText() != null && this.queryTextField.getText().length() > 2) {
            AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
            UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
            IfrRouteFacade ifrRouteFacade = new IfrRouteFacade(DBUtil.getDataSource());
            CityFacade cityFacade = new CityFacade(DBUtil.getDataSource());
            NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
            String[] query = StringUtil.splitCsvLine(' ', this.queryTextField.getText());
            for (int i = 0; i < query.length; ++i) {
                String searchFor = query[i].trim();
                if (searchFor.length() <= 0) continue;
                ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
                if (searchFor.matches("^([A-Z0-9]{4})$")) {
                    results.addAll(airportFacade.findAirportsByIdent(searchFor));
                    results.addAll(userPointFacade.getUserPointsByName(searchFor));
                    if (results.size() == 0) {
                        JOptionPane.showMessageDialog(this, Messages.getInstance().get("add_route_dialog_no_airports_found") + " " + searchFor, "", 0);
                    }
                } else if (searchFor.matches("^([A-Z0-9]{5})$")) {
                    results.addAll(airportFacade.findVfrPoints(searchFor));
                    results.addAll(ifrRouteFacade.findIfrPoints(searchFor, false));
                    results.addAll(userPointFacade.getUserPointsByName(searchFor));
                    if (results.size() == 0) {
                        JOptionPane.showMessageDialog(this, Messages.getInstance().get("add_route_dialog_no_airports_points_found") + " " + searchFor, "", 0);
                    }
                } else if (searchFor.matches("^([A-Z]{3})$")) {
                    results.addAll(navaidFacade.findVorById(searchFor));
                    if (results.size() == 0) {
                        JOptionPane.showMessageDialog(this, Messages.getInstance().get("add_route_dialog_no_vors_found") + " " + searchFor, "", 0);
                    }
                } else {
                    results.addAll(cityFacade.getCities(searchFor, false));
                    results.addAll(userPointFacade.getUserPointsByName(searchFor));
                    if (results.size() == 0) {
                        JOptionPane.showMessageDialog(this, Messages.getInstance().get("add_route_dialog_no_cities_found") + " " + searchFor, "", 0);
                    }
                }
                if (results.size() <= 0) continue;
                GpsPlace selectedPoint = null;
                if (results.size() > 1) {
                    AddRouteListDialog routeList = new AddRouteListDialog(searchFor, results);
                    routeList.setVisible(true);
                    if (routeList.getSelectedPoint() != null) {
                        selectedPoint = routeList.getSelectedPoint();
                    } else if (!routeList.isSkipPoint()) {
                        break;
                    }
                } else {
                    selectedPoint = (GpsPlace)results.get(0);
                }
                if (selectedPoint == null) continue;
                if (selectedPoint.getAlt() != null && !"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                    selectedPoint.setAlt(Double.valueOf(Math.round(UnitUtil.recalculateAltitude(selectedPoint.getAlt(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false))));
                }
                MapFrame.getInstance().getUIPanel().addNewPoint(selectedPoint, null);
                MapFrame.getInstance().centerMap();
            }
            this.closeWindowAction();
        }
    }
}

