/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.AlternateAirport;
import main.java.guru.vfrflight.core.MapRadials;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.SegmentLandmark;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.list.ToggleableListSelectionModel;
import main.java.guru.vfrflight.gui.swing.DecimalFilter;
import main.java.guru.vfrflight.gui.swing.list.MapRadialsListModel;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class AddMultipleMapRadialsDialog
extends JDialog {
    private static final long serialVersionUID = 6487648471510667007L;
    private JTextField altitudeTextField;
    private JCheckBox chckbxDrawDistances;
    private JCheckBox drawRadialCheckBox;
    private JList<String> list;
    private JCheckBox waypointsCheckBox;
    private JCheckBox vfrLandmarksCheckBox;
    private JCheckBox alternatesCheckBox;

    public AddMultipleMapRadialsDialog(JFrame frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AddMultipleMapRadialsDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("add_map_radials_dialog_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[]{214};
        gbl_panel_3.rowHeights = new int[]{130, 70, 65, 23};
        gbl_panel_3.columnWeights = new double[]{0.0};
        gbl_panel_3.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
        panel_3.setLayout(gbl_panel_3);
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddMultipleMapRadialsDialog.this.addRadialsAction();
            }
        });
        JPanel vorSelectionPanel = new JPanel();
        vorSelectionPanel.setBorder(new EmptyBorder(0, 30, 0, 30));
        GridBagConstraints gbc_vorSelectionPanel = new GridBagConstraints();
        gbc_vorSelectionPanel.fill = 1;
        gbc_vorSelectionPanel.insets = new Insets(0, 0, 5, 0);
        gbc_vorSelectionPanel.gridx = 0;
        gbc_vorSelectionPanel.gridy = 0;
        panel_3.add((Component)vorSelectionPanel, gbc_vorSelectionPanel);
        vorSelectionPanel.setLayout(new BorderLayout(0, 0));
        this.list = new JList();
        this.list.setSelectionModel(new ToggleableListSelectionModel());
        vorSelectionPanel.add(this.list, "Center");
        this.list.setModel(new MapRadialsListModel(FlightPlanBean.getInstance().getRoute().getOnlyVors()));
        JPanel panel_1 = new JPanel();
        vorSelectionPanel.add((Component)panel_1, "North");
        JLabel lblSelectVors = new JLabel(Messages.getInstance().get("add_map_radials_dialog_select_vors"));
        panel_1.add(lblSelectVors);
        lblSelectVors.setHorizontalAlignment(0);
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_checkboxPanel = new GridBagConstraints();
        gbc_checkboxPanel.fill = 1;
        gbc_checkboxPanel.insets = new Insets(0, 0, 5, 0);
        gbc_checkboxPanel.gridx = 0;
        gbc_checkboxPanel.gridy = 1;
        panel_3.add((Component)checkboxPanel, gbc_checkboxPanel);
        checkboxPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        checkboxPanel.add((Component)panel_2, "North");
        this.waypointsCheckBox = new JCheckBox(Messages.getInstance().get("add_map_radials_dialog_create_at_waypoints"));
        this.waypointsCheckBox.setEnabled(FlightPlanBean.getInstance().getRoute().getPoints().size() > 0);
        panel_2.add(this.waypointsCheckBox);
        JPanel panel_4 = new JPanel();
        checkboxPanel.add((Component)panel_4, "Center");
        this.vfrLandmarksCheckBox = new JCheckBox(Messages.getInstance().get("add_map_radials_dialog_create_at_vfr_landmarks"));
        this.vfrLandmarksCheckBox.setEnabled(FlightPlanBean.getInstance().getRoute().getLandmarks().size() > 0);
        panel_4.add(this.vfrLandmarksCheckBox);
        JPanel panel_5 = new JPanel();
        checkboxPanel.add((Component)panel_5, "South");
        this.alternatesCheckBox = new JCheckBox(Messages.getInstance().get("add_map_radials_dialog_create_at_alternate_airports"));
        this.alternatesCheckBox.setEnabled(FlightPlanBean.getInstance().getRoute().getAlternateAirports().size() > 0);
        panel_5.add(this.alternatesCheckBox);
        JPanel panel = new JPanel();
        panel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 1;
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 2;
        panel_3.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{30, 91, 72, 30};
        gbl_panel.rowHeights = new int[]{23, 20, 20};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0};
        gbl_panel.rowWeights = new double[]{0.0, 0.0};
        panel.setLayout(gbl_panel);
        this.chckbxDrawDistances = new JCheckBox(Messages.getInstance().get("add_map_radials_dialog_draw_distances"));
        this.chckbxDrawDistances.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddMultipleMapRadialsDialog.this.toggleDrawDistancesAction();
            }
        });
        this.drawRadialCheckBox = new JCheckBox(Messages.getInstance().get("add_map_radials_dialog_draw_radial_lines"));
        GridBagConstraints gbc_drawRadialCheckBox = new GridBagConstraints();
        gbc_drawRadialCheckBox.anchor = 11;
        gbc_drawRadialCheckBox.fill = 2;
        gbc_drawRadialCheckBox.gridwidth = 2;
        gbc_drawRadialCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_drawRadialCheckBox.gridx = 1;
        gbc_drawRadialCheckBox.gridy = 0;
        panel.add((Component)this.drawRadialCheckBox, gbc_drawRadialCheckBox);
        GridBagConstraints gbc_chckbxDrawDistances = new GridBagConstraints();
        gbc_chckbxDrawDistances.anchor = 11;
        gbc_chckbxDrawDistances.fill = 2;
        gbc_chckbxDrawDistances.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxDrawDistances.gridwidth = 2;
        gbc_chckbxDrawDistances.gridx = 1;
        gbc_chckbxDrawDistances.gridy = 1;
        panel.add((Component)this.chckbxDrawDistances, gbc_chckbxDrawDistances);
        JLabel lblAltitude = new JLabel(Messages.getInstance().get("altitude") + UnitUtil.getAltitudeUnit());
        GridBagConstraints gbc_lblAltitude = new GridBagConstraints();
        gbc_lblAltitude.fill = 2;
        gbc_lblAltitude.insets = new Insets(0, 0, 0, 5);
        gbc_lblAltitude.gridx = 1;
        gbc_lblAltitude.gridy = 2;
        panel.add((Component)lblAltitude, gbc_lblAltitude);
        this.altitudeTextField = new JTextField();
        this.altitudeTextField.setHorizontalAlignment(0);
        this.altitudeTextField.setEnabled(false);
        GridBagConstraints gbc_altitudeTextField = new GridBagConstraints();
        gbc_altitudeTextField.insets = new Insets(0, 0, 0, 5);
        gbc_altitudeTextField.anchor = 11;
        gbc_altitudeTextField.fill = 2;
        gbc_altitudeTextField.gridx = 2;
        gbc_altitudeTextField.gridy = 2;
        panel.add((Component)this.altitudeTextField, gbc_altitudeTextField);
        this.altitudeTextField.setColumns(10);
        ((AbstractDocument)this.altitudeTextField.getDocument()).setDocumentFilter(new DecimalFilter());
        GridBagConstraints gbc_okButton = new GridBagConstraints();
        gbc_okButton.anchor = 11;
        gbc_okButton.gridx = 0;
        gbc_okButton.gridy = 3;
        panel_3.add((Component)okButton, gbc_okButton);
        this.setModal(true);
        this.setSize(240, 365);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        int[] idxs = this.list.getSelectedIndices();
        if (idxs.length == 0) {
            errors.add(Messages.getInstance().get("add_map_radials_dialog_no_vors_selected"));
        }
        if (!(this.waypointsCheckBox.isSelected() || this.vfrLandmarksCheckBox.isSelected() || this.alternatesCheckBox.isSelected())) {
            errors.add(Messages.getInstance().get("add_map_radials_dialog_no_types_selected"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void toggleDrawDistancesAction() {
        this.altitudeTextField.setEnabled(this.chckbxDrawDistances.isSelected());
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void addRadialsAction() {
        if (this.doValidate()) {
            double dist;
            MapRadials r;
            MapRadials mapRadials = new MapRadials();
            mapRadials.setDrawRadial(this.drawRadialCheckBox.isSelected());
            mapRadials.setIncludeDistance(this.chckbxDrawDistances.isSelected());
            int[] idxs = this.list.getSelectedIndices();
            block0: for (int i = 0; i < idxs.length; ++i) {
                int idx = -1;
                for (int q = 0; q < FlightPlanBean.getInstance().getRoute().getVors().size(); ++q) {
                    if (FlightPlanBean.getInstance().getRoute().getVors().get(q).isNdb() || ++idx != idxs[i]) continue;
                    mapRadials.getVorIdxs().add(q);
                    continue block0;
                }
            }
            Route route = FlightPlanBean.getInstance().getRoute();
            ArrayList<MapRadialResult> resultList = new ArrayList<MapRadialResult>();
            if (this.waypointsCheckBox.isSelected()) {
                double totalDist = 0.0;
                for (int i = 0; i < route.getPoints().size(); ++i) {
                    r = mapRadials.clone();
                    r.setName(route.getPoints().get(i).getName());
                    r.setPos(route.getPoints().get(i).getPoint().clone());
                    resultList.add(new MapRadialResult(totalDist, r));
                    if (i >= route.getPoints().size() - 1) continue;
                    totalDist += GpsUtil.getDistance(route.getPoints().get(i).getPoint(), route.getPoints().get(i + 1).getPoint());
                }
            }
            if (this.vfrLandmarksCheckBox.isSelected()) {
                boolean setNames = route.calculate();
                for (SegmentLandmark landmark : route.getLandmarks()) {
                    r = mapRadials.clone();
                    RouteSegment segment = route.getSegments().get(landmark.getSegmentIndex());
                    GpsPlace pos = GpsUtil.getPointPositionByDistanceAndBearing(segment.getFrom(), segment.getCourse(), segment.getDistance() * landmark.getPosition());
                    pos = GpsUtil.getGpsPlaceOnSegment(MapFrame.getInstance().getMapViewer(), segment, pos);
                    if (setNames) {
                        String legName = StringUtil.nullToEmpty(segment.getFrom().getName()) + " => " + StringUtil.nullToEmpty(segment.getTo().getName());
                        String time = FormatUtil.formatTimeLandmark((int)Math.round((double)segment.getT() * landmark.getPosition()), SettingsBean.getInstance().isParamIncludeSecondsInTimeCalculations());
                        r.setName(legName + " (" + time + ")");
                    }
                    if (segment.getFrom().getAlt() != null && segment.getTo().getAlt() != null) {
                        pos.setAlt(segment.getFrom().getAlt() + (segment.getTo().getAlt() - segment.getFrom().getAlt()) * landmark.getPosition());
                    }
                    r.setPos(pos);
                    dist = 0.0;
                    for (int i = 0; i < landmark.getSegmentIndex(); ++i) {
                        dist += route.getSegments().get(i).getDistance().doubleValue();
                    }
                    resultList.add(new MapRadialResult(dist += segment.getDistance() * landmark.getPosition(), r));
                }
            }
            if (this.alternatesCheckBox.isSelected()) {
                for (AlternateAirport a : route.getAlternateAirports()) {
                    MapRadials r2 = mapRadials.clone();
                    r2.setName(a.getIdent());
                    r2.setPos(a.getGpsPlace().clone());
                    resultList.add(new MapRadialResult(null, r2));
                }
            }
            Collections.sort(resultList);
            for (MapRadialResult res : resultList) {
                MapRadials r3 = res.getMapRadial();
                boolean found = false;
                for (MapRadials rad : FlightPlanBean.getInstance().getRoute().getMapRadials()) {
                    dist = GpsUtil.getDistance(r3.getPos(), rad.getPos());
                    if (!(dist <= 0.1)) continue;
                    found = true;
                }
                if (found) continue;
                FlightPlanBean.getInstance().getRoute().getMapRadials().add(r3);
            }
            MapFrame.getInstance().updateMap();
            this.closeWindowAction();
        }
    }

    private class MapRadialResult
    implements Comparable<MapRadialResult> {
        private final Double distance;
        private final MapRadials mapRadial;

        public MapRadialResult(Double distance, MapRadials mapRadial) {
            this.distance = distance;
            this.mapRadial = mapRadial;
        }

        public Double getDistance() {
            return this.distance;
        }

        public MapRadials getMapRadial() {
            return this.mapRadial;
        }

        @Override
        public int compareTo(MapRadialResult r) {
            if (this.distance == null && r.getDistance() == null) {
                return 0;
            }
            if (this.distance != null && r.getDistance() == null) {
                return -1;
            }
            if (this.distance == null && r.getDistance() != null) {
                return 1;
            }
            return this.distance.compareTo(r.getDistance());
        }
    }
}

