/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.core.MapRadials;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.list.ToggleableListSelectionModel;
import main.java.guru.vfrflight.gui.swing.DecimalFilter;
import main.java.guru.vfrflight.gui.swing.list.MapRadialsListModel;
import main.java.guru.vfrflight.util.UnitUtil;
import org.hsqldb.lib.StringUtil;

public class AddMapRadialsDialog
extends JDialog {
    private static final long serialVersionUID = 2006086811427452389L;
    private JTextField altitudeTextField;
    private JCheckBox chckbxDrawDistances;
    private JCheckBox drawRadialCheckBox;
    private GpsPlace point;
    private JList<String> list;
    private Integer radialIndex;
    private JTextField nameTextField;

    public AddMapRadialsDialog(JFrame frame, MapRadials radial, Integer radialIndex) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AddMapRadialsDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        String title = "VfrFlight: ";
        title = radialIndex == null ? title + Messages.getInstance().get("add_map_radials_dialog_title") : title + Messages.getInstance().get("edit_map_radials_dialog_title");
        this.setTitle(title);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[]{214};
        gbl_panel_3.rowHeights = new int[]{130, 38, 65, 23};
        gbl_panel_3.columnWeights = new double[]{0.0};
        gbl_panel_3.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
        panel_3.setLayout(gbl_panel_3);
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddMapRadialsDialog.this.addRadialsAction();
            }
        });
        JPanel vorSelectionPanel = new JPanel();
        vorSelectionPanel.setBorder(new EmptyBorder(0, 30, 0, 30));
        GridBagConstraints gbc_vorSelectionPanel = new GridBagConstraints();
        gbc_vorSelectionPanel.fill = 1;
        gbc_vorSelectionPanel.insets = new Insets(0, 0, 5, 0);
        gbc_vorSelectionPanel.gridx = 0;
        gbc_vorSelectionPanel.gridy = 0;
        panel_3.add((Component)vorSelectionPanel, gbc_vorSelectionPanel);
        vorSelectionPanel.setLayout(new BorderLayout(0, 0));
        this.list = new JList();
        this.list.setSelectionModel(new ToggleableListSelectionModel());
        this.list.setModel(new MapRadialsListModel(FlightPlanBean.getInstance().getRoute().getOnlyVors()));
        JScrollPane scrollPane = new JScrollPane(20, 31);
        scrollPane.setViewportView(this.list);
        vorSelectionPanel.add((Component)scrollPane, "Center");
        JPanel panel_1 = new JPanel();
        vorSelectionPanel.add((Component)panel_1, "North");
        JLabel lblSelectVors = new JLabel(Messages.getInstance().get("add_map_radials_dialog_select_vors"));
        panel_1.add(lblSelectVors);
        lblSelectVors.setHorizontalAlignment(0);
        JPanel namePanel = new JPanel();
        namePanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_namePanel = new GridBagConstraints();
        gbc_namePanel.fill = 1;
        gbc_namePanel.insets = new Insets(0, 0, 5, 0);
        gbc_namePanel.gridx = 0;
        gbc_namePanel.gridy = 1;
        panel_3.add((Component)namePanel, gbc_namePanel);
        JLabel nameLabel = new JLabel(Messages.getInstance().get("name"));
        namePanel.add(nameLabel);
        this.nameTextField = new JTextField();
        namePanel.add(this.nameTextField);
        this.nameTextField.setColumns(15);
        JPanel panel = new JPanel();
        panel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 1;
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 2;
        panel_3.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{30, 91, 72, 30};
        gbl_panel.rowHeights = new int[]{23, 20, 20};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0};
        gbl_panel.rowWeights = new double[]{0.0, 0.0};
        panel.setLayout(gbl_panel);
        this.chckbxDrawDistances = new JCheckBox(Messages.getInstance().get("add_map_radials_dialog_draw_distances"));
        this.chckbxDrawDistances.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddMapRadialsDialog.this.toggleDrawDistancesAction();
            }
        });
        this.drawRadialCheckBox = new JCheckBox(Messages.getInstance().get("add_map_radials_dialog_draw_radial_lines"));
        GridBagConstraints gbc_drawRadialCheckBox = new GridBagConstraints();
        gbc_drawRadialCheckBox.anchor = 11;
        gbc_drawRadialCheckBox.fill = 2;
        gbc_drawRadialCheckBox.gridwidth = 2;
        gbc_drawRadialCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_drawRadialCheckBox.gridx = 1;
        gbc_drawRadialCheckBox.gridy = 0;
        panel.add((Component)this.drawRadialCheckBox, gbc_drawRadialCheckBox);
        GridBagConstraints gbc_chckbxDrawDistances = new GridBagConstraints();
        gbc_chckbxDrawDistances.anchor = 11;
        gbc_chckbxDrawDistances.fill = 2;
        gbc_chckbxDrawDistances.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxDrawDistances.gridwidth = 2;
        gbc_chckbxDrawDistances.gridx = 1;
        gbc_chckbxDrawDistances.gridy = 1;
        panel.add((Component)this.chckbxDrawDistances, gbc_chckbxDrawDistances);
        JLabel lblAltitude = new JLabel(Messages.getInstance().get("altitude") + UnitUtil.getAltitudeUnit());
        GridBagConstraints gbc_lblAltitude = new GridBagConstraints();
        gbc_lblAltitude.fill = 2;
        gbc_lblAltitude.insets = new Insets(0, 0, 0, 5);
        gbc_lblAltitude.gridx = 1;
        gbc_lblAltitude.gridy = 2;
        panel.add((Component)lblAltitude, gbc_lblAltitude);
        this.altitudeTextField = new JTextField();
        this.altitudeTextField.setHorizontalAlignment(0);
        this.altitudeTextField.setEnabled(false);
        GridBagConstraints gbc_altitudeTextField = new GridBagConstraints();
        gbc_altitudeTextField.insets = new Insets(0, 0, 0, 5);
        gbc_altitudeTextField.anchor = 11;
        gbc_altitudeTextField.fill = 2;
        gbc_altitudeTextField.gridx = 2;
        gbc_altitudeTextField.gridy = 2;
        panel.add((Component)this.altitudeTextField, gbc_altitudeTextField);
        this.altitudeTextField.setColumns(10);
        ((AbstractDocument)this.altitudeTextField.getDocument()).setDocumentFilter(new DecimalFilter());
        GridBagConstraints gbc_okButton = new GridBagConstraints();
        gbc_okButton.anchor = 11;
        gbc_okButton.gridx = 0;
        gbc_okButton.gridy = 3;
        panel_3.add((Component)okButton, gbc_okButton);
        this.list.setBorder(this.nameTextField.getBorder());
        this.setModal(true);
        this.setSize(240, 320);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.point = radial.getPos();
        if (radialIndex != null) {
            this.radialIndex = radialIndex;
            this.updateData();
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        int[] idxs = this.list.getSelectedIndices();
        if (idxs.length == 0) {
            errors.add(Messages.getInstance().get("add_map_radials_dialog_no_vors_selected"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void updateData() {
        MapRadials mapRadials = FlightPlanBean.getInstance().getRoute().getMapRadials().get(this.radialIndex);
        this.chckbxDrawDistances.setSelected(mapRadials.isIncludeDistance());
        this.drawRadialCheckBox.setSelected(mapRadials.isDrawRadial());
        if (mapRadials.isIncludeDistance() && mapRadials.getPos().getAlt() != null) {
            this.altitudeTextField.setText(Double.toString(mapRadials.getPos().getAlt()));
        }
        if (!StringUtil.isEmpty(mapRadials.getName())) {
            this.nameTextField.setText(mapRadials.getName());
        }
        int[] idxs = new int[mapRadials.getVorIdxs().size()];
        for (int i = 0; i < mapRadials.getVorIdxs().size(); ++i) {
            int vorIdx = -1;
            for (int q = 0; q <= mapRadials.getVorIdxs().get(i); ++q) {
                if (FlightPlanBean.getInstance().getRoute().getVors().get(q).isNdb()) continue;
                ++vorIdx;
            }
            idxs[i] = vorIdx;
        }
        this.list.setSelectedIndices(idxs);
        this.toggleDrawDistancesAction();
    }

    private void toggleDrawDistancesAction() {
        this.altitudeTextField.setEnabled(this.chckbxDrawDistances.isSelected());
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void addRadialsAction() {
        if (this.doValidate()) {
            if (this.chckbxDrawDistances.isSelected()) {
                if (this.altitudeTextField.getText() != null) {
                    try {
                        this.point.setAlt(Double.parseDouble(this.altitudeTextField.getText()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                this.point.setAlt(0.0);
            }
            MapRadials mapRadials = new MapRadials(this.point);
            if (!StringUtil.isEmpty(this.nameTextField.getText())) {
                mapRadials.setName(this.nameTextField.getText());
            }
            mapRadials.setDrawRadial(this.drawRadialCheckBox.isSelected());
            mapRadials.setIncludeDistance(this.chckbxDrawDistances.isSelected());
            int[] idxs = this.list.getSelectedIndices();
            block2: for (int i = 0; i < idxs.length; ++i) {
                int idx = -1;
                for (int q = 0; q < FlightPlanBean.getInstance().getRoute().getVors().size(); ++q) {
                    if (FlightPlanBean.getInstance().getRoute().getVors().get(q).isNdb() || ++idx != idxs[i]) continue;
                    mapRadials.getVorIdxs().add(q);
                    continue block2;
                }
            }
            if (this.radialIndex == null) {
                FlightPlanBean.getInstance().getRoute().getMapRadials().add(mapRadials);
            } else {
                FlightPlanBean.getInstance().getRoute().getMapRadials().set(this.radialIndex, mapRadials);
            }
            this.closeWindowAction();
            MapFrame.getInstance().updateMap();
        }
    }
}

