/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.list.ToggleableListSelectionModel;
import main.java.guru.vfrflight.gui.swing.list.MapRadialsListModel;

public class AddMapRadialsCalculationDialog
extends JDialog {
    private static final long serialVersionUID = -3716513572614524063L;
    private JList<String> list;
    private Integer radialIndex;
    private boolean cancelled = false;

    public AddMapRadialsCalculationDialog(JFrame frame) {
        super(frame);
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AddMapRadialsCalculationDialog.this.cancelled = true;
                AddMapRadialsCalculationDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        String title = "VfrFlight: ";
        title = this.radialIndex == null ? title + Messages.getInstance().get("add_map_radials_dialog_title") : title + Messages.getInstance().get("edit_map_radials_dialog_title");
        this.setTitle(title);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel listPanel = new JPanel();
        this.getContentPane().add((Component)listPanel, "Center");
        GridBagLayout gbl_listPanel = new GridBagLayout();
        gbl_listPanel.columnWidths = new int[]{158};
        gbl_listPanel.rowHeights = new int[]{14, 151};
        gbl_listPanel.columnWeights = new double[]{0.0};
        gbl_listPanel.rowWeights = new double[]{0.0, 0.0};
        listPanel.setLayout(gbl_listPanel);
        JLabel lblSelectVors = new JLabel(Messages.getInstance().get("add_map_radials_dialog_select_vors"));
        GridBagConstraints gbc_lblSelectVors = new GridBagConstraints();
        gbc_lblSelectVors.anchor = 11;
        gbc_lblSelectVors.fill = 2;
        gbc_lblSelectVors.insets = new Insets(0, 0, 5, 0);
        gbc_lblSelectVors.gridx = 0;
        gbc_lblSelectVors.gridy = 0;
        listPanel.add((Component)lblSelectVors, gbc_lblSelectVors);
        lblSelectVors.setHorizontalAlignment(0);
        this.list = new JList();
        GridBagConstraints gbc_list = new GridBagConstraints();
        gbc_list.fill = 1;
        gbc_list.gridx = 0;
        gbc_list.gridy = 1;
        listPanel.add(this.list, gbc_list);
        this.list.setModel(new MapRadialsListModel(FlightPlanBean.getInstance().getRoute().getOnlyVors()));
        this.list.setSelectionModel(new ToggleableListSelectionModel());
        JPanel buttonPanel = new JPanel();
        this.getContentPane().add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        buttonPanel.add(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddMapRadialsCalculationDialog.this.addRadialsAction();
            }
        });
        this.setModal(true);
        this.setPreferredSize(new Dimension(200, 244));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.updateData();
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        int[] idxs = this.list.getSelectedIndices();
        if (idxs.length == 0) {
            errors.add(Messages.getInstance().get("add_map_radials_dialog_no_vors_selected"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void updateData() {
        List<GpsPlace> selectedVors = FlightPlanBean.getInstance().getCalculationDialogDrawRadialsVors();
        if (selectedVors.size() > 0) {
            MapRadialsListModel model = (MapRadialsListModel)this.list.getModel();
            int[] idxs = new int[selectedVors.size()];
            for (int i = 0; i < selectedVors.size(); ++i) {
                GpsPlace vor = selectedVors.get(i);
                int idx = model.getVorIndex(vor);
                if (idx < 0) continue;
                idxs[i] = idx;
            }
            this.list.setSelectedIndices(idxs);
        }
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void addRadialsAction() {
        if (this.doValidate()) {
            MapRadialsListModel model = (MapRadialsListModel)this.list.getModel();
            int[] idxs = this.list.getSelectedIndices();
            FlightPlanBean.getInstance().getCalculationDialogDrawRadialsVors().clear();
            FlightPlanBean.getInstance().getCalculationDialogDrawRadialsVors().addAll(model.getVors(idxs));
            this.closeWindowAction();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

