/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.comparator.MatchComparator;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.SearchResultDataTable;
import main.java.guru.vfrflight.util.SearchUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class AddFromDBDialog
extends JDialog {
    private static final long serialVersionUID = -5062874276487759070L;
    private JTextField queryTextField;
    private SearchResultDataTable resultTable;
    private JRadioButton airportRadio;
    private JRadioButton cityRadio;
    private JRadioButton navaidRadio;
    private JRadioButton historyRadio;
    private boolean acceptOnePoint = false;
    private List<GpsPlace> resultTableData;
    private boolean navaidMode = false;

    public AddFromDBDialog(JFrame frame, boolean navaidMode) {
        this(frame, navaidMode, false);
    }

    public AddFromDBDialog(JFrame frame, boolean navaidMode, boolean acceptOnePoint) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AddFromDBDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "South");
        JButton eksportujButton = new JButton(Messages.getInstance().get("add_button"));
        eksportujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddFromDBDialog.this.addAction();
            }
        });
        buttonPanel.add(eksportujButton);
        JButton showOnMapButton = new JButton(Messages.getInstance().get("show_on_map_button"));
        showOnMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddFromDBDialog.this.showOnMapAction();
            }
        });
        buttonPanel.add(showOnMapButton);
        JButton anulujButton = new JButton(Messages.getInstance().get("close_button"));
        anulujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddFromDBDialog.this.cancelAction();
            }
        });
        buttonPanel.add(anulujButton);
        JPanel resultsTablePanel = new JPanel();
        panel.add((Component)resultsTablePanel, "Center");
        resultsTablePanel.setLayout(new BorderLayout(0, 0));
        this.resultTable = new SearchResultDataTable();
        resultsTablePanel.add(this.resultTable);
        JPanel panel_1 = new JPanel();
        panel.add((Component)panel_1, "North");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_1.add((Component)panel_2, "North");
        panel_2.setLayout(new FlowLayout(1, 5, 5));
        this.airportRadio = new JRadioButton(Messages.getInstance().get("add_from_db_frame_airport"));
        this.airportRadio.setSelected(true);
        panel_2.add(this.airportRadio);
        this.cityRadio = new JRadioButton(Messages.getInstance().get("add_from_db_frame_city"));
        panel_2.add(this.cityRadio);
        this.navaidRadio = new JRadioButton(Messages.getInstance().get("add_from_db_frame_vor_ndb"));
        panel_2.add(this.navaidRadio);
        this.historyRadio = new JRadioButton(Messages.getInstance().get("add_from_db_frame_user_points"));
        panel_2.add(this.historyRadio);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.airportRadio);
        buttonGroup.add(this.cityRadio);
        buttonGroup.add(this.navaidRadio);
        buttonGroup.add(this.historyRadio);
        JPanel panel_3 = new JPanel();
        panel_1.add((Component)panel_3, "South");
        this.queryTextField = new JTextField();
        this.queryTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    AddFromDBDialog.this.searchAction();
                }
            }
        });
        panel_3.add(this.queryTextField);
        this.queryTextField.setColumns(35);
        JButton searchButton = new JButton(Messages.getInstance().get("search_button"));
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddFromDBDialog.this.searchAction();
            }
        });
        panel_3.add(searchButton);
        this.setSize(500, 380);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.updateTitles();
        this.openWindow(navaidMode, acceptOnePoint);
    }

    public void closeWindowAction() {
        MapFrame.getInstance().unlock();
        if (FlightPlanBean.getInstance().getRoute().removePhantomPoints() || FlightPlanBean.getInstance().getRoute().removePhantomVors()) {
            MapFrame.getInstance().updateMap();
        }
        MapFrame.getInstance().showPanel();
        this.setVisible(false);
    }

    public void cancelAction() {
        this.closeWindowAction();
    }

    public void showOnMapAction() {
        int idx = this.resultTable.getTable().getSelectedRow();
        if (idx >= 0) {
            this.resultTable.showPointOnMap(idx);
        }
    }

    public void searchAction() {
        this.resultTableData = new ArrayList<GpsPlace>();
        if (this.airportRadio.isSelected()) {
            this.resultTableData.addAll(SearchUtil.searchInAirports(this.queryTextField.getText()));
        } else if (this.cityRadio.isSelected()) {
            this.resultTableData.addAll(SearchUtil.searchInCities(this.queryTextField.getText()));
        } else if (this.navaidRadio.isSelected()) {
            this.resultTableData.addAll(SearchUtil.searchInNavaids(this.queryTextField.getText(), "VOR"));
            this.resultTableData.addAll(SearchUtil.searchInNavaids(this.queryTextField.getText(), "VOR-DME"));
            this.resultTableData.addAll(SearchUtil.searchInNavaids(this.queryTextField.getText(), "NDB"));
            if (!this.navaidMode) {
                this.resultTableData.addAll(SearchUtil.searchInNavaids(this.queryTextField.getText(), "DME"));
            }
        } else if (!this.navaidMode) {
            this.resultTableData.addAll(SearchUtil.searchInUserPoints(this.queryTextField.getText()));
        }
        Collections.sort(this.resultTableData, new MatchComparator(this.queryTextField.getText()));
        this.resultTable.setData(this.resultTableData);
        if (this.resultTable.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("no_results"), "", 0);
        }
    }

    public void addAction() {
        int idx = this.resultTable.getTable().getSelectedRow();
        if (idx >= 0) {
            GpsPlace place = this.resultTableData.get(idx);
            if (place.getAlt() != null && !"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                place.setAlt(Double.valueOf(Math.round(UnitUtil.recalculateAltitude(place.getAlt(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false))));
            }
            if (this.navaidMode) {
                MapFrame.getInstance().getUIPanel().addNewVor(place);
            } else {
                MapFrame.getInstance().getUIPanel().addNewPoint(place, null);
            }
            if (MapFrame.getInstance().getUIPanel().getRoute().getPoints().size() > 0) {
                MapFrame.getInstance().centerMap();
            }
            if (this.acceptOnePoint) {
                this.closeWindowAction();
            }
        }
    }

    public void setNavaidMode(boolean navaidMode) {
        this.navaidMode = navaidMode;
        if (navaidMode) {
            this.airportRadio.setEnabled(false);
            this.cityRadio.setEnabled(false);
            this.navaidRadio.setSelected(true);
        } else {
            this.airportRadio.setEnabled(true);
            this.cityRadio.setEnabled(true);
            this.airportRadio.setSelected(true);
        }
        this.updateTitles();
        this.resultTable.setNavaidMode(navaidMode);
    }

    public void updateTitles() {
        if (this.navaidMode) {
            this.setTitle("VfrFlight: " + Messages.getInstance().get("add_from_db_frame_title_vor"));
            this.historyRadio.setText(Messages.getInstance().get("add_from_db_frame_user_vors"));
        } else {
            this.setTitle("VfrFlight: " + Messages.getInstance().get("add_from_db_frame_title_point"));
            this.historyRadio.setText(Messages.getInstance().get("add_from_db_frame_user_points"));
        }
    }

    public void openWindow(boolean navaidMode, boolean acceptOnePoint) {
        MapFrame.getInstance().hidePanel();
        this.acceptOnePoint = acceptOnePoint;
        MapFrame.getInstance().lock();
        this.setNavaidMode(navaidMode);
    }
}

