/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.comparator.AirportNameComparator;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.filter.AirportFilter;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.AlternatesSearchResultDataTable;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.util.DBUtil;

public class AddAlternateFromDBDialog
extends JDialog {
    private static final long serialVersionUID = -2125652860899897271L;
    private JTextField queryTextField;
    private AlternatesSearchResultDataTable resultTable;

    public AddAlternateFromDBDialog(JFrame frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AddAlternateFromDBDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.setTitle("VfrFlight: " + Messages.getInstance().get("add_alternate_from_db_frame_title"));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "South");
        JButton eksportujButton = new JButton(Messages.getInstance().get("add_button"));
        eksportujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddAlternateFromDBDialog.this.addAction();
            }
        });
        buttonPanel.add(eksportujButton);
        JButton showOnMapButton = new JButton(Messages.getInstance().get("show_on_map_button"));
        showOnMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddAlternateFromDBDialog.this.showOnMapAction();
            }
        });
        buttonPanel.add(showOnMapButton);
        JButton anulujButton = new JButton(Messages.getInstance().get("close_button"));
        anulujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddAlternateFromDBDialog.this.cancelAction();
            }
        });
        buttonPanel.add(anulujButton);
        JPanel resultsTablePanel = new JPanel();
        panel.add((Component)resultsTablePanel, "Center");
        resultsTablePanel.setLayout(new BorderLayout(0, 0));
        this.resultTable = new AlternatesSearchResultDataTable();
        resultsTablePanel.add(this.resultTable);
        JPanel panel_3 = new JPanel();
        panel.add((Component)panel_3, "North");
        this.queryTextField = new JTextField();
        this.queryTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    AddAlternateFromDBDialog.this.searchAction();
                }
            }
        });
        panel_3.add(this.queryTextField);
        this.queryTextField.setColumns(35);
        JButton searchButton = new JButton(Messages.getInstance().get("search_button"));
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AddAlternateFromDBDialog.this.searchAction();
            }
        });
        panel_3.add(searchButton);
        MapFrame.getInstance().lock();
        MapFrame.getInstance().hidePanel();
        this.setSize(500, 380);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    public void closeWindowAction() {
        MapFrame.getInstance().unlock();
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().setMarkerPlace(null);
        MapFrame.getInstance().updateMap();
        MapFrame.getInstance().showPanel();
        this.setVisible(false);
    }

    public void cancelAction() {
        this.closeWindowAction();
    }

    public void showOnMapAction() {
        int idx = this.resultTable.getTable().getSelectedRow();
        if (idx >= 0) {
            this.resultTable.showPointOnMap(idx);
        }
    }

    public void searchAction() {
        AirportFilter criteria = new AirportFilter();
        criteria.setIdent(this.queryTextField.getText());
        criteria.setName(this.queryTextField.getText());
        criteria.setExactMatch(false);
        criteria.setOrStatement(true);
        criteria.setIgnoreCase(true);
        AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
        List<Airport> resultTableData = airportFacade.findAirportsByCriteria(criteria, true);
        Collections.sort(resultTableData, new AirportNameComparator());
        this.resultTable.setData(resultTableData);
        if (this.resultTable.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("no_results"), "", 0);
        }
    }

    public void addAction() {
        int idx = this.resultTable.getTable().getSelectedRow();
        if (idx >= 0) {
            Airport a = this.resultTable.getAirports().get(idx);
            MapFrame.getInstance().getUIPanel().getAlternateAirportsCollapsablePanel().markAirportAsAlternate(a.getId());
        }
    }
}

