/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RecursiveTask;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.util.GpsUtil;

public class MaxElevationTask
extends RecursiveTask<Elevation> {
    private static final long serialVersionUID = 902544942485405735L;
    private final GpsPlace point;
    private final Elevation[] elevations;
    private final double elevationMaxGridSize;
    private List<Elevation> excludeList;

    public MaxElevationTask(GpsPlace point, Elevation[] elevations, double elevationMaxGridSize, List<Elevation> excludeList) {
        this.point = point;
        this.elevations = elevations;
        this.elevationMaxGridSize = elevationMaxGridSize;
        this.excludeList = excludeList;
    }

    @Override
    public Elevation compute() {
        if (this.excludeList == null) {
            this.excludeList = new ArrayList<Elevation>();
        }
        Elevation resultElev = null;
        double d = 0.0;
        double dist = Double.MAX_VALUE;
        for (int i = 0; i < this.elevations.length; ++i) {
            if (this.excludeList.contains(this.elevations[i]) || !((d = GpsUtil.getDistance(this.point, this.elevations[i].getGpsPlace())) <= this.elevationMaxGridSize) || !(d < dist)) continue;
            dist = d;
            resultElev = this.elevations[i];
        }
        return resultElev;
    }
}

