/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RecursiveTask;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.gui.concurrent.bean.VerticalProfileResultBean;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class CalculateVerticalProfileForSegmentTask
extends RecursiveTask<VerticalProfileResultBean> {
    private static final long serialVersionUID = -1729707443425844470L;
    private final int index;
    private final GpsPlace[] points;
    private final double elevationMaxGridSize;
    private Elevation[] elevations;

    public CalculateVerticalProfileForSegmentTask(int index, List<GpsPlace> points, Elevation[] elevations, double elevationMaxGridSize) {
        this.index = index;
        this.points = points.toArray(new GpsPlace[points.size()]);
        this.elevations = elevations;
        this.elevationMaxGridSize = elevationMaxGridSize;
    }

    @Override
    public VerticalProfileResultBean compute() {
        Elevation[] result = new Elevation[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            ArrayList<Elevation> excludeList = new ArrayList<Elevation>();
            Elevation resultElev1 = VfrUtil.findMaxElevation(this.points[i], this.elevations, this.elevationMaxGridSize, excludeList);
            if (resultElev1 == null) continue;
            double dist1 = GpsUtil.getDistance(this.points[i], resultElev1.getGpsPlace());
            excludeList.add(resultElev1);
            Elevation resultElev2 = VfrUtil.findMaxElevation(this.points[i], this.elevations, this.elevationMaxGridSize, excludeList);
            if (resultElev2 == null) continue;
            double dist2 = GpsUtil.getDistance(this.points[i], resultElev2.getGpsPlace());
            double sum = dist1 + dist2;
            short elev = (short)Math.round((1.0 - dist1 / sum) * (double)resultElev1.getElev().shortValue() + (1.0 - dist2 / sum) * (double)resultElev2.getElev().shortValue());
            result[i] = new Elevation(this.points[i].getLat().getValue(), this.points[i].getLon().getValue(), elev);
        }
        return new VerticalProfileResultBean(this.index, result);
    }
}

