/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.callable;

import java.util.List;
import java.util.concurrent.Callable;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.weather.WeatherUtil;
import main.java.guru.vfrflight.weather.core.Station;

public class WeatherDownloadCallable
implements Callable<List<Station>> {
    private final LineSegment segment;
    private final boolean metar;
    private final boolean taf;
    private final int maxDistance;

    public WeatherDownloadCallable(LineSegment segment, boolean metar, boolean taf, int maxDistance) {
        this.segment = segment;
        this.metar = metar;
        this.taf = taf;
        this.maxDistance = maxDistance;
    }

    @Override
    public List<Station> call() throws Exception {
        return WeatherUtil.getStationsOnPath(this.segment.getFrom(), this.segment.getTo(), this.maxDistance, this.metar, this.taf);
    }
}

