/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.callable;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import org.apache.log4j.Logger;

public class CalculateVerticalSegmentCallable
implements Callable<List<Elevation>> {
    private static final Logger log = Logger.getLogger(CalculateVerticalSegmentCallable.class);
    private final LineSegment segment;
    private final int scale;
    private final int width;
    private final int index;
    private final String pathToDir;
    private final boolean findMaxValue;
    private final double elevationMaxGridSize;

    public CalculateVerticalSegmentCallable(LineSegment segment, int index, String pathToDir, double elevationMaxGridSize, boolean findMaxValue, int width, int scale) {
        this.segment = segment;
        this.width = width;
        this.scale = scale;
        this.index = index;
        this.pathToDir = pathToDir;
        this.findMaxValue = findMaxValue;
        this.elevationMaxGridSize = elevationMaxGridSize;
    }

    @Override
    public List<Elevation> call() throws Exception {
        log.debug("Working on segment " + this.index);
        double expandValue = 8.326394671107411E-4 * (double)this.scale;
        List<GpsArea> areas = null;
        Elevation[] elevations = null;
        elevations = ElevationsUtil.loadElevationsFromHgtFiles(this.pathToDir, this.scale, this.findMaxValue, this.segment.getRectangleOver(), true);
        if (elevations.length > 0) {
            areas = GpsUtil.divideSegmentToAreas(this.segment, this.width, expandValue);
            return VfrUtil.calculateVerticalProfileForSegmentMultiCore(this.segment, this.elevationMaxGridSize, this.width, ElevationsUtil.getElevationsInAreasMultiCore(elevations, areas.toArray(new GpsArea[areas.size()])), this.scale);
        }
        return new ArrayList<Elevation>();
    }
}

