/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.transform;

import java.awt.geom.Point2D;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.util.GpsUtil;

public class Mercator {
    private static final double R_MAJOR = 6378137.0;
    private static final double R_MINOR = 6356752.3142;
    private static final double R_RATIO = 0.996647189328169;
    private static final double ECCENT = Math.sqrt(0.006694380004260925);
    private static final double COM = 0.5 * ECCENT;

    public static GpsPlace getGpsPlace(double x, double y) {
        return new GpsPlace(Mercator.getLatDegrees(y), Mercator.getLonDegrees(x));
    }

    public static Point2D getMercPoint(GpsPlace place) {
        return Mercator.getMercPoint(place.getLat().getValue(), place.getLon().getValue());
    }

    public static Point2D getMercPoint(double latDegrees, double lonDegrees) {
        return new GpsPoint(Mercator.getX(lonDegrees), Mercator.getY(latDegrees));
    }

    public static double getX(double lonDegrees) {
        return 6378137.0 * Math.toRadians(lonDegrees);
    }

    public static double getLonDegrees(double x) {
        return Math.toDegrees(x / 6378137.0);
    }

    public static double getY(double latDegrees) {
        latDegrees = GpsUtil.normalizeLatitude(latDegrees);
        double phi = Math.toRadians(latDegrees);
        double con = ECCENT * Math.sin(phi);
        con = Math.pow((1.0 - con) / (1.0 + con), COM);
        double ts = Math.tan(0.5 * (1.5707963267948966 - phi)) / con;
        return 0.0 - 6378137.0 * Math.log(ts);
    }

    public static double getLatDegrees(double y) {
        double ts = Math.exp(-y / 6378137.0);
        double phi = 1.5707963267948966 - 2.0 * Math.atan(ts);
        double dphi = 1.0;
        for (int i = 0; Math.abs(dphi) > 1.0E-9 && i < 15; ++i) {
            double con = ECCENT * Math.sin(phi);
            dphi = 1.5707963267948966 - 2.0 * Math.atan(ts * Math.pow((1.0 - con) / (1.0 + con), COM)) - phi;
            phi += dphi;
        }
        return Math.toDegrees(phi);
    }
}

