/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.transform;

import java.awt.geom.Point2D;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.org.jdesktop.swingx.mapviewer.util.MercatorUtils;

public class JXMapViewerMercator {
    private static final double RADIUS = 6367444.6570999995;

    public static GpsPlace getGpsPlace(double x, double y) {
        return new GpsPlace(JXMapViewerMercator.getLatDegrees(y), JXMapViewerMercator.getLonDegrees(x));
    }

    public static Point2D getMercPoint(GpsPlace place) {
        return JXMapViewerMercator.getMercPoint(place.getLat().getValue(), place.getLon().getValue());
    }

    public static Point2D getMercPoint(double latDegrees, double lonDegrees) {
        return new GpsPoint(JXMapViewerMercator.getX(lonDegrees), JXMapViewerMercator.getY(latDegrees));
    }

    public static double getX(double lonDegrees) {
        return MercatorUtils.longToX(lonDegrees, 6367444.6570999995);
    }

    public static double getLonDegrees(double x) {
        return MercatorUtils.xToLong((int)Math.round(x), 6367444.6570999995);
    }

    public static double getY(double latDegrees) {
        return MercatorUtils.latToY(latDegrees, 6367444.6570999995);
    }

    public static double getLatDegrees(double y) {
        return MercatorUtils.yToLat((int)Math.round(y), 6367444.6570999995);
    }
}

