/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.transform;

import java.awt.geom.Point2D;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.transform.Mercator;

public class ImageToMapTransform {
    private double cellWidth;
    private double cellHeight;
    private double mercatorOffsetX;
    private double mercatorOffsetY;

    public ImageToMapTransform(GpsPlace place1, int x1, int y1, GpsPlace place2, int x2, int y2) {
        Point2D mercator1Pt = Mercator.getMercPoint(place1);
        Point2D mercator2Pt = Mercator.getMercPoint(place2);
        this.cellWidth = Math.abs(mercator1Pt.getX() - mercator2Pt.getX()) / (double)Math.abs(x1 - x2);
        this.cellHeight = Math.abs(mercator1Pt.getY() - mercator2Pt.getY()) / (double)Math.abs(y1 - y2);
        this.mercatorOffsetX = (mercator1Pt.getX() - (double)x1 * this.cellWidth + (mercator2Pt.getX() - (double)x2 * this.cellWidth)) / 2.0;
        this.mercatorOffsetY = (mercator1Pt.getY() + (double)y1 * this.cellHeight + (mercator2Pt.getY() + (double)y2 * this.cellHeight)) / 2.0;
    }

    public double getLat(int y) {
        return Mercator.getLatDegrees(this.mercatorOffsetY - (double)y * this.cellHeight);
    }

    public double getLon(int x) {
        return Mercator.getLonDegrees(this.mercatorOffsetX + (double)x * this.cellWidth);
    }

    public GpsArea getCellArea(int x, int y) {
        double mercX = this.mercatorOffsetX + (double)x * this.cellWidth;
        double mercY = this.mercatorOffsetY - (double)y * this.cellHeight;
        double maxLat = Mercator.getLatDegrees(mercY - this.cellHeight / 2.0);
        double minLon = Mercator.getLonDegrees(mercX - this.cellWidth / 2.0);
        GpsPlace topLeft = new GpsPlace(maxLat, minLon);
        double minLat = Mercator.getLatDegrees(mercY + this.cellHeight / 2.0);
        double maxLon = Mercator.getLonDegrees(mercX + this.cellWidth / 2.0);
        GpsPlace bottomRight = new GpsPlace(minLat, maxLon);
        return new GpsArea(topLeft, bottomRight);
    }
}

