/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import main.java.guru.vfrflight.core.sql.entity.Taxiway;
import main.java.guru.vfrflight.util.FormatUtil;

@XmlType(name="", propOrder={"name", "posFrom", "posTo", "width"})
public class TaxiwayXml
implements Serializable {
    private static final long serialVersionUID = -5570215823107110538L;
    private String posFrom;
    private String posTo;
    private Double width;
    private String name;

    public TaxiwayXml() {
    }

    public TaxiwayXml(Taxiway t) {
        this.name = t.getName();
        this.posFrom = FormatUtil.formatAixmGpsLat(t.getFromLat()) + "," + FormatUtil.formatAixmGpsLon(t.getFromLon());
        this.posTo = FormatUtil.formatAixmGpsLat(t.getToLat()) + "," + FormatUtil.formatAixmGpsLon(t.getToLon());
        this.width = t.getWidth();
    }

    @XmlAttribute(name="name", required=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="posFrom", required=true)
    public String getPosFrom() {
        return this.posFrom;
    }

    public void setPosFrom(String posFrom) {
        this.posFrom = posFrom;
    }

    @XmlElement(name="posTo", required=true)
    public String getPosTo() {
        return this.posTo;
    }

    public void setPosTo(String posTo) {
        this.posTo = posTo;
    }

    @XmlElement(name="width", required=true)
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }
}

