/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.entity.xml.IlsXml;
import main.java.guru.vfrflight.core.sql.type.RunwayDesignator;
import main.java.guru.vfrflight.core.sql.type.RunwayOperations;
import main.java.guru.vfrflight.core.sql.type.Surface;
import main.java.guru.vfrflight.util.FormatUtil;

@XmlType(name="", propOrder={"pos", "surface", "operations", "length", "width", "number", "designator", "secondaryDesignator", "elev", "heading", "magvar", "desc", "Ils"})
public class RunwayXml
implements Serializable {
    private static final long serialVersionUID = -4405614603963172956L;
    private String pos;
    private Surface surface;
    private RunwayOperations operations;
    private Double length;
    private Double width;
    private Integer number;
    private RunwayDesignator designator;
    private RunwayDesignator secondaryDesignator;
    private Integer elev;
    private Double heading;
    private Double magvar;
    private String desc;
    @XmlElement(name="Ils", required=false)
    private IlsWrapper Ils;

    public RunwayXml() {
    }

    public RunwayXml(Runway r) {
        if (r.getLat() != null && r.getLon() != null) {
            this.pos = FormatUtil.formatAixmGpsLat(r.getLat()) + "," + FormatUtil.formatAixmGpsLon(r.getLon());
        }
        this.surface = r.getSurface();
        this.operations = r.getOperations();
        this.length = r.getLength();
        this.width = r.getWidth();
        this.number = r.getNumber();
        this.designator = r.getDesignator();
        this.secondaryDesignator = r.getSecondaryDesignator();
        this.elev = r.getElev();
        this.heading = r.getHeading();
        this.magvar = r.getMagvar();
        this.desc = r.getDesc();
        if (r.getIls() != null && r.getIls().size() > 0) {
            this.setIls(r.getIls());
        }
    }

    @XmlElement(name="pos", required=false)
    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    @XmlElement(name="surface", required=false)
    public Surface getSurface() {
        return this.surface;
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
    }

    @XmlElement(name="operations", required=false)
    public RunwayOperations getOperations() {
        return this.operations;
    }

    public void setOperations(RunwayOperations operations) {
        this.operations = operations;
    }

    @XmlElement(name="length", required=true)
    public Double getLength() {
        return this.length;
    }

    public void setLength(Double length) {
        this.length = length;
    }

    @XmlElement(name="width", required=false)
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    @XmlElement(name="number", required=false)
    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    @XmlElement(name="designator", required=false)
    public RunwayDesignator getDesignator() {
        return this.designator;
    }

    public void setDesignator(RunwayDesignator designator) {
        this.designator = designator;
    }

    @XmlElement(name="secondaryDesignator", required=false)
    public RunwayDesignator getSecondaryDesignator() {
        return this.secondaryDesignator;
    }

    public void setSecondaryDesignator(RunwayDesignator secondaryDesignator) {
        this.secondaryDesignator = secondaryDesignator;
    }

    @XmlElement(name="elev", required=true)
    public Integer getElev() {
        return this.elev;
    }

    public void setElev(Integer elev) {
        this.elev = elev;
    }

    @XmlElement(name="heading", required=false)
    public Double getHeading() {
        return this.heading;
    }

    public void setHeading(Double heading) {
        this.heading = heading;
    }

    @XmlElement(name="magvar", required=false)
    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }

    @XmlElement(name="desc", required=false)
    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setIls(List<Ils> ils) {
        if (this.Ils == null) {
            this.Ils = new IlsWrapper();
        }
        if (ils != null) {
            ArrayList<IlsXml> list = new ArrayList<IlsXml>(ils.size());
            for (Ils a : ils) {
                list.add(new IlsXml(a));
            }
            this.Ils.setIls(list);
        }
    }

    @XmlTransient
    public List<Ils> getIls() {
        ArrayList<Ils> list = new ArrayList<Ils>();
        if (this.Ils != null) {
            for (IlsXml a : this.Ils.getIls()) {
                list.add(new Ils(a));
            }
        }
        return list;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class IlsWrapper {
        private List<IlsXml> Ils;

        public List<IlsXml> getIls() {
            if (this.Ils == null) {
                this.Ils = new ArrayList<IlsXml>();
            }
            return this.Ils;
        }

        public void setIls(List<IlsXml> Ils2) {
            this.Ils = Ils2;
        }
    }
}

