/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import main.java.guru.vfrflight.core.sql.entity.Obstacle;
import main.java.guru.vfrflight.util.FormatUtil;

@XmlType(name="", propOrder={"name", "desc", "pos", "amslInFt", "heightInFt", "group", "illuminated"})
public class ObstacleXml
implements Serializable {
    private static final long serialVersionUID = 8140793939576222318L;
    private String name;
    private String desc;
    private String pos;
    private Boolean group;
    private Boolean illuminated;
    private Integer heightInFt;
    private Integer amslInFt;

    public ObstacleXml() {
    }

    public ObstacleXml(Obstacle o) {
        this.name = o.getName();
        this.desc = o.getDesc();
        this.pos = FormatUtil.formatAixmGpsLat(o.getLat()) + "," + FormatUtil.formatAixmGpsLon(o.getLon());
        this.heightInFt = o.getAgl();
        this.amslInFt = o.getAmsl();
        this.group = o.getGrp();
        this.illuminated = o.getLgt();
    }

    @XmlElement(name="name", required=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="desc", required=false)
    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    @XmlElement(name="pos", required=true)
    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    @XmlElement(name="group", required=false)
    public Boolean getGroup() {
        return this.group;
    }

    public void setGroup(Boolean group) {
        this.group = group;
    }

    @XmlElement(name="illuminated", required=false)
    public Boolean getIlluminated() {
        return this.illuminated;
    }

    public void setIlluminated(Boolean illuminated) {
        this.illuminated = illuminated;
    }

    @XmlElement(name="heightInFt", required=false)
    public Integer getHeightInFt() {
        return this.heightInFt;
    }

    public void setHeightInFt(Integer heightInFt) {
        this.heightInFt = heightInFt;
    }

    @XmlElement(name="amslInFt", required=true)
    public Integer getAmslInFt() {
        return this.amslInFt;
    }

    public void setAmslInFt(Integer amslInFt) {
        this.amslInFt = amslInFt;
    }
}

