/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity.xml;

import java.io.Serializable;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.util.FormatUtil;

@XmlType(name="", propOrder={"ident", "name", "remark", "type", "pos", "elevationInFt", "frequency", "magvar"})
public class NavaidXml
implements Serializable {
    private static final long serialVersionUID = -791058012753938966L;
    private String ident;
    private String name;
    private String remark;
    private String type;
    private String pos;
    private Integer elevationInFt;
    private Double frequency;
    private Double magvar;

    public NavaidXml() {
    }

    public NavaidXml(Navaid n) {
        this.ident = n.getIdent();
        this.name = n.getName();
        this.remark = n.getRemark();
        this.type = n.getType();
        this.pos = FormatUtil.formatAixmGpsLat(n.getLat()) + "," + FormatUtil.formatAixmGpsLon(n.getLon());
        this.elevationInFt = n.getAlt();
        if (n.getFreq() != null) {
            this.frequency = n.isNdb() ? (double)n.getFreq().intValue() / 10.0 : (double)n.getFreq().intValue() / 1000.0;
        }
        this.magvar = n.getMagvar();
    }

    @XmlAttribute(name="ident", required=true)
    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = ident;
    }

    @XmlElement(name="name", required=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="remark", required=false)
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @XmlAttribute(name="type", required=false)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElement(name="elevationInFt", required=false)
    public Integer getElevationInFt() {
        return this.elevationInFt;
    }

    public void setElevationInFt(Integer elevationInFt) {
        this.elevationInFt = elevationInFt;
    }

    @XmlElement(name="frequency", required=false)
    public Double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Double frequency) {
        this.frequency = frequency;
    }

    @XmlElement(name="magvar", required=false)
    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }

    @XmlElement(name="pos", required=true)
    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    @Transient
    public boolean isNdb() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals("NDB");
    }
}

