/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.util.FormatUtil;

@XmlType(name="", propOrder={"name", "pos", "ident", "elev", "heading", "frequency", "magvar", "width", "pitch", "gs", "dme"})
public class IlsXml
implements Serializable {
    private static final long serialVersionUID = -510920045182195164L;
    private String pos;
    private String name;
    private String ident;
    private Integer elev;
    private Double heading;
    private Double frequency;
    private Double magvar;
    private Double width;
    private Double pitch;
    private Boolean gs;
    private Boolean dme;

    public IlsXml() {
    }

    public IlsXml(Ils i) {
        this.pos = FormatUtil.formatAixmGpsLat(i.getLat()) + "," + FormatUtil.formatAixmGpsLon(i.getLon());
        this.name = i.getName();
        this.ident = i.getIdent();
        this.elev = i.getAlt();
        this.heading = i.getHeading();
        this.frequency = i.getFrequency();
        this.magvar = i.getMagvar();
        this.width = i.getWidth();
        this.pitch = i.getPitch();
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="pos", required=true)
    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    @XmlAttribute(name="ident", required=true)
    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = ident;
    }

    @XmlElement(name="elev", required=true)
    public Integer getElev() {
        return this.elev;
    }

    public void setElev(Integer elev) {
        this.elev = elev;
    }

    @XmlElement(name="heading", required=true)
    public Double getHeading() {
        return this.heading;
    }

    public void setHeading(Double heading) {
        this.heading = heading;
    }

    @XmlElement(name="frequency", required=true)
    public Double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Double frequency) {
        this.frequency = frequency;
    }

    @XmlElement(name="magvar", required=true)
    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }

    @XmlElement(name="width", required=false)
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    @XmlElement(name="pitch", required=false)
    public Double getPitch() {
        return this.pitch;
    }

    public void setPitch(Double pitch) {
        this.pitch = pitch;
    }

    @XmlElement(name="gs", required=false)
    public Boolean getGs() {
        return this.gs;
    }

    public void setGs(Boolean gs) {
        this.gs = gs;
    }

    @XmlElement(name="dme", required=false)
    public Boolean getDme() {
        return this.dme;
    }

    public void setDme(Boolean dme) {
        this.dme = dme;
    }
}

