/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.entity.xml.AirspaceAreaVertexXml;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.core.sql.type.AltitudeType;
import main.java.guru.vfrflight.util.FormatUtil;

@XmlType(name="", propOrder={"name", "type", "bottomAlt", "bottomAltType", "topAlt", "topAltType", "circleCenterPos", "circleRadius", "vertices", "verticesList", "remark"})
public class AirspaceAreaXml
implements Serializable {
    private static final long serialVersionUID = -9203693083868961201L;
    private String name;
    private String remark;
    private Integer bottomAlt;
    private Integer topAlt;
    private AltitudeType bottomAltType;
    private AltitudeType topAltType;
    private Double circleRadius;
    private String circleCenterPos;
    private AirspaceType type;
    private String verticesList;
    @XmlElement(name="vertices", required=false)
    private VerticesWrapper vertices;

    public AirspaceAreaXml() {
    }

    public AirspaceAreaXml(AirspaceArea a) {
        this.name = a.getName();
        this.type = a.getType();
        this.bottomAlt = a.getBottomAltitude();
        this.bottomAltType = a.getBottomAltitudeType();
        this.topAlt = a.getTopAltitude();
        this.topAltType = a.getTopAltitudeType();
        if (a.getCircleCenterLat() != null && a.getCircleCenterLon() != null) {
            this.circleCenterPos = FormatUtil.formatAixmGpsLat(a.getCircleCenterLat()) + "," + FormatUtil.formatAixmGpsLon(a.getCircleCenterLon());
        }
        this.circleRadius = a.getRadius();
        this.remark = a.getRemark();
        if (a.getVertices().size() > 0) {
            this.setVertices(a.getVertices());
        }
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="remark", required=false)
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @XmlElement(name="bottomAlt", required=false)
    public Integer getBottomAlt() {
        return this.bottomAlt;
    }

    public void setBottomAlt(Integer bottomAlt) {
        this.bottomAlt = bottomAlt;
    }

    @XmlElement(name="topAlt", required=false)
    public Integer getTopAlt() {
        return this.topAlt;
    }

    public void setTopAlt(Integer topAlt) {
        this.topAlt = topAlt;
    }

    @XmlElement(name="bottomAltType", required=false)
    public AltitudeType getBottomAltType() {
        return this.bottomAltType;
    }

    public void setBottomAltType(AltitudeType bottomAltType) {
        this.bottomAltType = bottomAltType;
    }

    @XmlElement(name="topAltType", required=false)
    public AltitudeType getTopAltType() {
        return this.topAltType;
    }

    public void setTopAltType(AltitudeType topAltType) {
        this.topAltType = topAltType;
    }

    @XmlElement(name="circleRadius", required=false)
    public Double getCircleRadius() {
        return this.circleRadius;
    }

    public void setCircleRadius(Double circleRadius) {
        this.circleRadius = circleRadius;
    }

    @XmlElement(name="circleCenterPos", required=false)
    public String getCircleCenterPos() {
        return this.circleCenterPos;
    }

    public void setCircleCenterPos(String circleCenterPos) {
        this.circleCenterPos = circleCenterPos;
    }

    @XmlAttribute(name="type", required=true)
    public AirspaceType getType() {
        return this.type;
    }

    public void setType(AirspaceType type) {
        this.type = type;
    }

    @XmlElement(name="verticesList", required=false)
    public String getVerticesList() {
        return this.verticesList;
    }

    public void setVerticesList(String verticesList) {
        this.verticesList = verticesList;
    }

    public void setVertices(List<AirspaceAreaVertex> vertices) {
        if (this.vertices == null) {
            this.vertices = new VerticesWrapper();
        }
        if (vertices != null) {
            ArrayList<AirspaceAreaVertexXml> list = new ArrayList<AirspaceAreaVertexXml>(vertices.size());
            for (AirspaceAreaVertex a : vertices) {
                list.add(new AirspaceAreaVertexXml(a));
            }
            this.vertices.setVertices(list);
        }
    }

    @XmlTransient
    public List<AirspaceAreaVertex> getVertices() {
        ArrayList<AirspaceAreaVertex> list = new ArrayList<AirspaceAreaVertex>();
        if (this.vertices != null) {
            for (AirspaceAreaVertexXml a : this.vertices.getVertices()) {
                list.add(new AirspaceAreaVertex(a));
            }
        }
        return list;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AirspaceAreaXml [name=");
        builder.append(this.name);
        builder.append(", remark=");
        builder.append(this.remark);
        builder.append(", bottomAlt=");
        builder.append(this.bottomAlt);
        builder.append(", topAlt=");
        builder.append(this.topAlt);
        builder.append(", bottomAltType=");
        builder.append((Object)this.bottomAltType);
        builder.append(", topAltType=");
        builder.append((Object)this.topAltType);
        builder.append(", circleRadius=");
        builder.append(this.circleRadius);
        builder.append(", circleCenterPos=");
        builder.append(this.circleCenterPos);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", verticesList=");
        builder.append(this.verticesList);
        builder.append(", vertices=");
        builder.append(this.vertices);
        builder.append("]");
        return builder.toString();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class VerticesWrapper {
        private List<AirspaceAreaVertexXml> vertex;

        public List<AirspaceAreaVertexXml> getVertices() {
            if (this.vertex == null) {
                this.vertex = new ArrayList<AirspaceAreaVertexXml>();
            }
            return this.vertex;
        }

        public void setVertices(List<AirspaceAreaVertexXml> vertices) {
            this.vertex = vertices;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.vertex);
            return builder.toString();
        }
    }
}

