/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.AirportFreq;
import main.java.guru.vfrflight.core.sql.entity.AirportStart;
import main.java.guru.vfrflight.core.sql.entity.Apron;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.entity.TaxiName;
import main.java.guru.vfrflight.core.sql.entity.Taxiway;
import main.java.guru.vfrflight.core.sql.entity.xml.AirportFreqXml;
import main.java.guru.vfrflight.core.sql.entity.xml.AirportStartXml;
import main.java.guru.vfrflight.core.sql.entity.xml.ApronXml;
import main.java.guru.vfrflight.core.sql.entity.xml.RunwayXml;
import main.java.guru.vfrflight.core.sql.entity.xml.TaxiNameXml;
import main.java.guru.vfrflight.core.sql.entity.xml.TaxiwayXml;
import main.java.guru.vfrflight.core.sql.type.AirportType;
import main.java.guru.vfrflight.util.FormatUtil;

@XmlType(name="", propOrder={"ident", "type", "elev", "pos", "name", "mainRwy", "mainLength", "magvar", "ils", "mountainous", "vor", "ndb", "heli", "hardened", "Frequencies", "Starts", "Taxiways", "TaxiNames", "Aprons", "Runways"})
public class AirportXml
implements Serializable {
    private static final long serialVersionUID = 7052775298755496233L;
    private String ident;
    private String name;
    private AirportType type;
    private String pos;
    private Integer mainRwy;
    private Integer mainLength;
    private Integer elev;
    private Double magvar;
    private Boolean ils;
    private Boolean mountainous;
    private Boolean vor;
    private Boolean ndb;
    private Boolean heli;
    private Boolean hardened;
    @XmlElement(name="Frequencies", required=false)
    private FrequencyWrapper Frequencies;
    @XmlElement(name="Starts", required=false)
    private StartWrapper Starts;
    @XmlElement(name="Taxiways", required=false)
    private TaxiwayWrapper Taxiways;
    @XmlElement(name="TaxiNames", required=false)
    private TaxiNameWrapper TaxiNames;
    @XmlElement(name="Aprons", required=false)
    private ApronWrapper Aprons;
    @XmlElement(name="Runways", required=false)
    private RunwayWrapper Runways;

    public AirportXml() {
    }

    public AirportXml(Airport a) {
        this.ident = a.getIdent();
        this.name = a.getName();
        this.type = a.getType();
        this.pos = FormatUtil.formatAixmGpsLat(a.getLat()) + "," + FormatUtil.formatAixmGpsLon(a.getLon());
        this.mainRwy = a.getMainRwy();
        this.mainLength = a.getMainLength();
        this.elev = a.getElev();
        this.magvar = a.getMagvar();
        this.ils = a.getIls();
        this.mountainous = a.getMountainous();
        this.vor = a.getVor();
        this.ndb = a.getNdb();
        this.heli = a.getHeli();
        this.hardened = a.getHardened();
        if (a.getFrequencies() != null && a.getFrequencies().size() > 0) {
            this.setFrequencies(a.getFrequencies());
        }
        if (a.getStarts() != null && a.getStarts().size() > 0) {
            this.setStarts(a.getStarts());
        }
        if (a.getTaxiways() != null && a.getTaxiways().size() > 0) {
            this.setTaxiways(a.getTaxiways());
        }
        if (a.getTaxiNames() != null && a.getTaxiNames().size() > 0) {
            this.setTaxiNames(a.getTaxiNames());
        }
        if (a.getAprons() != null && a.getAprons().size() > 0) {
            this.setAprons(a.getAprons());
        }
        if (a.getRunways() != null && a.getRunways().size() > 0) {
            this.setRunways(a.getRunways());
        }
    }

    @XmlElement(name="name", required=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="ident", required=true)
    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = ident;
    }

    @XmlAttribute(name="type", required=false)
    public AirportType getType() {
        return this.type;
    }

    public void setType(AirportType type) {
        this.type = type;
    }

    @XmlElement(name="pos", required=false)
    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    @XmlElement(name="mainRwy", required=false)
    public Integer getMainRwy() {
        return this.mainRwy;
    }

    public void setMainRwy(Integer mainRwy) {
        this.mainRwy = mainRwy;
    }

    @XmlElement(name="mainLength", required=false)
    public Integer getMainLength() {
        return this.mainLength;
    }

    public void setMainLength(Integer mainLength) {
        this.mainLength = mainLength;
    }

    @XmlAttribute(name="elev", required=false)
    public Integer getElev() {
        return this.elev;
    }

    public void setElev(Integer elev) {
        this.elev = elev;
    }

    @XmlElement(name="magvar", required=false)
    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }

    @XmlElement(name="ils", required=false)
    public Boolean getIls() {
        return this.ils;
    }

    public void setIls(Boolean ils) {
        this.ils = ils;
    }

    @XmlElement(name="mountainous", required=false)
    public Boolean getMountainous() {
        return this.mountainous;
    }

    public void setMountainous(Boolean mountainous) {
        this.mountainous = mountainous;
    }

    @XmlElement(name="vor", required=false)
    public Boolean getVor() {
        return this.vor;
    }

    public void setVor(Boolean vor) {
        this.vor = vor;
    }

    @XmlElement(name="ndb", required=false)
    public Boolean getNdb() {
        return this.ndb;
    }

    public void setNdb(Boolean ndb) {
        this.ndb = ndb;
    }

    @XmlElement(name="heli", required=false)
    public Boolean getHeli() {
        return this.heli;
    }

    public void setHeli(Boolean heli) {
        this.heli = heli;
    }

    @XmlElement(name="hardened", required=false)
    public Boolean getHardened() {
        return this.hardened;
    }

    public void setHardened(Boolean hardened) {
        this.hardened = hardened;
    }

    public void setFrequencies(List<AirportFreq> frequencies) {
        if (this.Frequencies == null) {
            this.Frequencies = new FrequencyWrapper();
        }
        if (frequencies != null) {
            ArrayList<AirportFreqXml> list = new ArrayList<AirportFreqXml>(frequencies.size());
            for (AirportFreq a : frequencies) {
                list.add(new AirportFreqXml(a));
            }
            this.Frequencies.setFrequencies(list);
        }
    }

    @XmlTransient
    public List<AirportFreq> getFrequencies() {
        ArrayList<AirportFreq> list = new ArrayList<AirportFreq>();
        if (this.Frequencies != null) {
            for (AirportFreqXml a : this.Frequencies.getFrequencies()) {
                list.add(new AirportFreq(a));
            }
        }
        return list;
    }

    public void setStarts(List<AirportStart> starts) {
        if (this.Starts == null) {
            this.Starts = new StartWrapper();
        }
        if (starts != null) {
            ArrayList<AirportStartXml> list = new ArrayList<AirportStartXml>(starts.size());
            for (AirportStart a : starts) {
                list.add(new AirportStartXml(a));
            }
            this.Starts.setStart(list);
        }
    }

    @XmlTransient
    public List<AirportStart> getStarts() {
        ArrayList<AirportStart> list = new ArrayList<AirportStart>();
        if (this.Starts != null) {
            for (AirportStartXml a : this.Starts.getStart()) {
                list.add(new AirportStart(a));
            }
        }
        return list;
    }

    public void setTaxiways(List<Taxiway> taxiways) {
        if (this.Taxiways == null) {
            this.Taxiways = new TaxiwayWrapper();
        }
        if (taxiways != null) {
            ArrayList<TaxiwayXml> list = new ArrayList<TaxiwayXml>(taxiways.size());
            for (Taxiway a : taxiways) {
                list.add(new TaxiwayXml(a));
            }
            this.Taxiways.setTaxiway(list);
        }
    }

    @XmlTransient
    public List<Taxiway> getTaxiways() {
        ArrayList<Taxiway> list = new ArrayList<Taxiway>();
        if (this.Taxiways != null) {
            for (TaxiwayXml a : this.Taxiways.getTaxiway()) {
                list.add(new Taxiway(a));
            }
        }
        return list;
    }

    public void setTaxiNames(List<TaxiName> taxiNames) {
        if (this.TaxiNames == null) {
            this.TaxiNames = new TaxiNameWrapper();
        }
        if (taxiNames != null) {
            ArrayList<TaxiNameXml> list = new ArrayList<TaxiNameXml>(taxiNames.size());
            for (TaxiName a : taxiNames) {
                list.add(new TaxiNameXml(a));
            }
            this.TaxiNames.setTaxiName(list);
        }
    }

    @XmlTransient
    public List<TaxiName> getTaxiNames() {
        ArrayList<TaxiName> list = new ArrayList<TaxiName>();
        if (this.TaxiNames != null) {
            for (TaxiNameXml a : this.TaxiNames.getTaxiName()) {
                list.add(new TaxiName(a));
            }
        }
        return list;
    }

    public void setAprons(List<Apron> aprons) {
        if (this.Aprons == null) {
            this.Aprons = new ApronWrapper();
        }
        if (aprons != null) {
            ArrayList<ApronXml> list = new ArrayList<ApronXml>(aprons.size());
            for (Apron a : aprons) {
                list.add(new ApronXml(a));
            }
            this.Aprons.setApron(list);
        }
    }

    @XmlTransient
    public List<Apron> getAprons() {
        ArrayList<Apron> list = new ArrayList<Apron>();
        if (this.Aprons != null) {
            for (ApronXml a : this.Aprons.getApron()) {
                list.add(new Apron(a));
            }
        }
        return list;
    }

    public void setRunways(List<Runway> runways) {
        if (this.Runways == null) {
            this.Runways = new RunwayWrapper();
        }
        if (runways != null) {
            ArrayList<RunwayXml> list = new ArrayList<RunwayXml>(runways.size());
            for (Runway a : runways) {
                list.add(new RunwayXml(a));
            }
            this.Runways.setRunway(list);
        }
    }

    @XmlTransient
    public List<Runway> getRunways() {
        ArrayList<Runway> list = new ArrayList<Runway>();
        if (this.Runways != null) {
            for (RunwayXml a : this.Runways.getRunway()) {
                list.add(new Runway(a));
            }
        }
        return list;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RunwayWrapper {
        private List<RunwayXml> Runway;

        public List<RunwayXml> getRunway() {
            if (this.Runway == null) {
                this.Runway = new ArrayList<RunwayXml>();
            }
            return this.Runway;
        }

        public void setRunway(List<RunwayXml> Runways) {
            this.Runway = Runways;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ApronWrapper {
        private List<ApronXml> Apron;

        public List<ApronXml> getApron() {
            if (this.Apron == null) {
                this.Apron = new ArrayList<ApronXml>();
            }
            return this.Apron;
        }

        public void setApron(List<ApronXml> Aprons) {
            this.Apron = Aprons;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class TaxiNameWrapper {
        private List<TaxiNameXml> TaxiName;

        public List<TaxiNameXml> getTaxiName() {
            if (this.TaxiName == null) {
                this.TaxiName = new ArrayList<TaxiNameXml>();
            }
            return this.TaxiName;
        }

        public void setTaxiName(List<TaxiNameXml> Taxiways) {
            this.TaxiName = Taxiways;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class TaxiwayWrapper {
        private List<TaxiwayXml> Taxiway;

        public List<TaxiwayXml> getTaxiway() {
            if (this.Taxiway == null) {
                this.Taxiway = new ArrayList<TaxiwayXml>();
            }
            return this.Taxiway;
        }

        public void setTaxiway(List<TaxiwayXml> Taxiways) {
            this.Taxiway = Taxiways;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class StartWrapper {
        private List<AirportStartXml> Start;

        public List<AirportStartXml> getStart() {
            if (this.Start == null) {
                this.Start = new ArrayList<AirportStartXml>();
            }
            return this.Start;
        }

        public void setStart(List<AirportStartXml> Starts) {
            this.Start = Starts;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class FrequencyWrapper {
        private List<AirportFreqXml> Frequency;

        public List<AirportFreqXml> getFrequencies() {
            if (this.Frequency == null) {
                this.Frequency = new ArrayList<AirportFreqXml>();
            }
            return this.Frequency;
        }

        public void setFrequencies(List<AirportFreqXml> Frequency) {
            this.Frequency = Frequency;
        }
    }
}

