/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import main.java.guru.vfrflight.core.sql.entity.AirportStart;
import main.java.guru.vfrflight.core.sql.type.RunwayDesignator;
import main.java.guru.vfrflight.util.FormatUtil;

@XmlType(name="", propOrder={"name", "pos", "elev", "number", "designator", "direction"})
public class AirportStartXml
implements Serializable {
    private static final long serialVersionUID = -7271973051398798832L;
    private String name;
    private String pos;
    private RunwayDesignator designator;
    private Double direction;
    private Integer number;
    private Integer elev;

    public AirportStartXml() {
    }

    public AirportStartXml(AirportStart a) {
        this.name = a.getName();
        this.pos = FormatUtil.formatAixmGpsLat(a.getLat()) + "," + FormatUtil.formatAixmGpsLon(a.getLon());
        this.designator = a.getDesignator();
        this.direction = a.getHeading();
        this.number = a.getNumber();
        this.elev = a.getElev();
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="pos", required=true)
    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    @XmlElement(name="designator", required=false)
    public RunwayDesignator getDesignator() {
        return this.designator;
    }

    public void setDesignator(RunwayDesignator designator) {
        this.designator = designator;
    }

    @XmlElement(name="direction", required=true)
    public Double getDirection() {
        return this.direction;
    }

    public void setDirection(Double direction) {
        this.direction = direction;
    }

    @XmlElement(name="number", required=false)
    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    @XmlElement(name="elev", required=false)
    public Integer getElev() {
        return this.elev;
    }

    public void setElev(Integer elev) {
        this.elev = elev;
    }
}

