/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Route;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.core.sql.entity.xml.IfrPointXml;
import main.java.guru.vfrflight.core.sql.type.WaypointType;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;

@Entity
@Table(name="WAYPOINTS")
public class Waypoint
implements Serializable {
    private static final long serialVersionUID = -8641543210092892714L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE waypoints ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), ident VARCHAR(128), type VARCHAR(9), lat DECIMAL(18,15), lon DECIMAL(18,15), PRIMARY KEY (id))";
    public static final String SELECT_QUERY = "SELECT id, ident, type, lat, lon FROM waypoints ";
    public static final String DROP_QUERY = "DROP TABLE waypoints ";
    private Integer id;
    private String ident;
    private WaypointType type;
    private Double lat;
    private Double lon;
    private String region;
    private List<Route> routes;

    public Waypoint() {
    }

    public Waypoint(String ident, WaypointType type, Double lat, Double lon) {
        this.ident = ident;
        this.type = type;
        this.lat = lat;
        this.lon = lon;
    }

    public Waypoint(IfrPointXml v) {
        GpsPlace place;
        String[] coords;
        this.ident = v.getIdent();
        this.type = v.getType();
        if (v.getPos() != null && (coords = v.getPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.lat = place.getLat().getValue();
            this.lon = place.getLon().getValue();
        }
    }

    public Waypoint(UserPoint p) {
        this(p.getName(), null, p.getLat(), p.getLon());
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="IDENT", length=128)
    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = StringUtil.shortenString(ident, 128);
    }

    @Column(name="TYPE", length=9)
    @Enumerated(value=EnumType.STRING)
    public WaypointType getType() {
        return this.type;
    }

    public void setType(WaypointType type) {
        this.type = type;
    }

    @Column(name="LAT", nullable=false, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Column(name="LON", nullable=false, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Transient
    public GpsPlace getGpsPlace() {
        return new GpsPlace(new GpsCoord(this.getLat()), new GpsCoord(this.getLon()), this.getIdent());
    }

    @Transient
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @Transient
    public List<Route> getRoutes() {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>();
        }
        return this.routes;
    }

    public void setRoutes(List<Route> routes) {
        this.routes = routes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Waypoint [id=");
        builder.append(this.id);
        builder.append(", ident=");
        builder.append(this.ident);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", region=");
        builder.append(this.region);
        builder.append("]");
        return builder.toString();
    }
}

