/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.dto.VfrPointDTO;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.core.sql.entity.xml.VfrPointXml;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;

@Entity
@Table(name="VFR_POINTS")
public class VfrPoint
implements Serializable {
    private static final long serialVersionUID = -3976633440318660212L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE vfr_points ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(128), remark VARCHAR(512), lat DECIMAL(18,15), lon DECIMAL(18,15), PRIMARY KEY (id))";
    public static final String DROP_QUERY = "DROP TABLE vfr_points ";
    private Integer id;
    private String name;
    private String remark;
    private Double lat;
    private Double lon;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public VfrPoint(VfrPointDTO point) {
        this.lat = point.getPosition().getLatitude();
        this.lon = point.getPosition().getLongitude();
        this.name = point.getName();
    }

    public VfrPoint(Double lat, Double lon, String name) {
        this.lat = lat;
        this.lon = lon;
        this.name = name;
    }

    public VfrPoint() {
    }

    public VfrPoint(VfrPointXml v) {
        GpsPlace place;
        String[] coords;
        this.name = v.getName();
        this.remark = v.getRemark();
        if (v.getPos() != null && (coords = v.getPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.lat = place.getLat().getValue();
            this.lon = place.getLon().getValue();
        }
    }

    public VfrPoint(UserPoint p) {
        this.name = p.getName();
        this.lat = p.getLat();
        this.lon = p.getLon();
    }

    @Column(name="NAME", length=128)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 128);
    }

    @Column(name="REMARK", length=512)
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = StringUtil.shortenString(remark, 512);
    }

    @Column(name="LAT", nullable=false, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Column(name="LON", nullable=false, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VfrPoint [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append("]");
        return builder.toString();
    }

    @Transient
    public GpsPlace getGpsPlace() {
        return new GpsPlace(new GpsCoord(this.lat), new GpsCoord(this.lon), this.name);
    }
}

