/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.sql.LatLonObject;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UserPointsUtil;

@Entity
@Table(name="USER_POINTS")
public class UserPoint
implements Serializable,
LatLonObject {
    private static final long serialVersionUID = 6913135991367904747L;
    public static final String TAGS_DELIMITER = ";;";
    public static final String CREATE_QUERY = "CREATE CACHED TABLE user_points ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(256), tags VARCHAR(1024), lat DECIMAL(18,15), lon DECIMAL(18,15), PRIMARY KEY (id))";
    private Integer id;
    private String name;
    private String tags;
    private Double lat;
    private Double lon;

    public UserPoint clone() {
        UserPoint p = new UserPoint();
        p.setId(this.id);
        p.setName(this.name);
        p.setTags(this.tags);
        p.setLat(this.lat);
        p.setLon(this.lon);
        return p;
    }

    public UserPoint() {
    }

    public UserPoint(String name, String tags, Double lat, Double lon) {
        this.name = name;
        this.tags = tags;
        this.lat = lat;
        this.lon = lon;
    }

    public UserPoint(GpsPlace place) {
        this.name = place.getName();
        this.lat = place.getLatVal();
        this.lon = place.getLonVal();
    }

    @Column(name="NAME", length=256)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 256);
    }

    @Column(name="TAGS", length=1024)
    public String getTags() {
        return this.tags;
    }

    @Transient
    public String getParsedTags() {
        return UserPointsUtil.getParsedTags(this.tags);
    }

    public void setTags(String tags) {
        this.tags = StringUtil.shortenString(tags, 1024);
    }

    @Override
    @Column(name="LAT", nullable=false, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Override
    @Column(name="LON", nullable=false, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Transient
    public String getLatHem() {
        return !NumberUtil.doubleLessThanZero(this.lat) ? "N" : "S";
    }

    @Transient
    public String getLonHem() {
        return !NumberUtil.doubleLessThanZero(this.lon) ? "E" : "W";
    }

    @Transient
    public GpsPlace getGpsPlace() {
        if (this.lat == null || this.lon == null) {
            return null;
        }
        GpsPlace place = new GpsPlace(new GpsCoord(this.getLat()), new GpsCoord(this.getLon()), this.getName());
        place.setLatHemisphere(this.getLatHem());
        place.setLonHemisphere(this.getLonHem());
        place.setDesc(this.getName());
        return place;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UserPoint [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append("]");
        return builder.toString();
    }

    @Transient
    public RoutePlace getRoutePlace() {
        return new RoutePlace(this.getGpsPlace());
    }
}

