/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.xml.TaxiwayXml;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;

@Entity
@Table(name="TAXIWAYS")
public class Taxiway
implements Serializable {
    private static final long serialVersionUID = -6418713167044986910L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE taxiways ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), airport_id INTEGER, from_lat DECIMAL(18,15), from_lon DECIMAL(18,15), to_lat DECIMAL(18,15), to_lon DECIMAL(18,15), width DECIMAL(10,2), name VARCHAR(16), PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))";
    public static final String DROP_QUERY = "DROP TABLE taxiways ";
    private Integer id;
    private Airport airport;
    private Double fromLat;
    private Double fromLon;
    private Double toLat;
    private Double toLon;
    private Double width;
    private String name;

    public Taxiway() {
    }

    public Taxiway(TaxiwayXml a) {
        GpsPlace place;
        String[] coords;
        this.width = a.getWidth();
        this.name = a.getName();
        if (a.getPosFrom() != null && (coords = a.getPosFrom().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.fromLat = place.getLat().getValue();
            this.fromLon = place.getLon().getValue();
        }
        if (a.getPosTo() != null && (coords = a.getPosTo().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.toLat = place.getLat().getValue();
            this.toLon = place.getLon().getValue();
        }
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="AIRPORT_ID")
    public Airport getAirport() {
        return this.airport;
    }

    public void setAirport(Airport airport) {
        this.airport = airport;
    }

    @Column(name="WIDTH", precision=10, scale=2)
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    @Column(name="FROM_LAT", nullable=true, precision=18, scale=15)
    public Double getFromLat() {
        return this.fromLat;
    }

    public void setFromLat(Double fromLat) {
        this.fromLat = fromLat;
    }

    @Column(name="FROM_LON", nullable=true, precision=18, scale=15)
    public Double getFromLon() {
        return this.fromLon;
    }

    public void setFromLon(Double fromLon) {
        this.fromLon = fromLon;
    }

    @Column(name="TO_LAT", nullable=true, precision=18, scale=15)
    public Double getToLat() {
        return this.toLat;
    }

    public void setToLat(Double toLat) {
        this.toLat = toLat;
    }

    @Column(name="TO_LON", nullable=true, precision=18, scale=15)
    public Double getToLon() {
        return this.toLon;
    }

    public void setToLon(Double toLon) {
        this.toLon = toLon;
    }

    @Column(name="NAME")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 16);
    }

    @Transient
    public GpsPlace getFrom() {
        return new GpsPlace(this.fromLat, this.fromLon);
    }

    @Transient
    public GpsPlace getTo() {
        return new GpsPlace(this.toLat, this.toLon);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Taxiway [id=");
        builder.append(this.id);
        builder.append(", airport=");
        builder.append(this.airport);
        builder.append(", fromLat=");
        builder.append(this.fromLat);
        builder.append(", fromLon=");
        builder.append(this.fromLon);
        builder.append(", toLat=");
        builder.append(this.toLat);
        builder.append(", toLon=");
        builder.append(this.toLon);
        builder.append(", width=");
        builder.append(this.width);
        builder.append("]");
        return builder.toString();
    }
}

