/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Taxiway;
import main.java.guru.vfrflight.core.sql.entity.xml.TaxiNameXml;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;

@Entity
@Table(name="TAXI_NAMES")
public class TaxiName
implements Serializable {
    private static final long serialVersionUID = 7250074228693195997L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE taxi_names ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), airport_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), name VARCHAR(16), PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))";
    public static final String DROP_QUERY = "DROP TABLE taxiways ";
    private Integer id;
    private Airport airport;
    private Double lat;
    private Double lon;
    private String name;

    public TaxiName() {
    }

    public TaxiName(TaxiNameXml a) {
        GpsPlace place;
        String[] coords;
        if (a.getPos() != null && (coords = a.getPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.lat = place.getLat().getValue();
            this.lon = place.getLon().getValue();
        }
        this.name = a.getName();
    }

    public TaxiName(Taxiway taxiway) {
        this.setLat((taxiway.getFromLat() + taxiway.getToLat()) / 2.0);
        this.setLon((taxiway.getFromLon() + taxiway.getToLon()) / 2.0);
        this.setName(taxiway.getName());
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="AIRPORT_ID")
    public Airport getAirport() {
        return this.airport;
    }

    public void setAirport(Airport airport) {
        this.airport = airport;
    }

    @Column(name="LAT", nullable=true, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Column(name="LON", nullable=true, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Column(name="NAME")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 16);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaxiName [id=");
        builder.append(this.id);
        builder.append(", airport=");
        builder.append(this.airport);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    @Transient
    public GpsPlace getGpsPlace() {
        return new GpsPlace(this.lat, this.lon);
    }
}

