/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.core.sql.entity.xml.RunwayXml;
import main.java.guru.vfrflight.core.sql.type.RunwayDesignator;
import main.java.guru.vfrflight.core.sql.type.RunwayOperations;
import main.java.guru.vfrflight.core.sql.type.Surface;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.StringUtil;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="RUNWAYS")
public class Runway
implements Serializable {
    private static final long serialVersionUID = 7045640074977595492L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE runways ( id INTEGER, airport_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), elev INTEGER, surface VARCHAR(24), operations VARCHAR(18), length DECIMAL(10,2), width DECIMAL(10,2), number INTEGER, designator CHAR(1), secondary_designator CHAR(1), heading DECIMAL(5,2), magvar DECIMAL(5,2), desc VARCHAR(32), PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))";
    public static final String DROP_QUERY = "DROP TABLE runways ";
    public static final String ID_SEQ_CREATE_QUERY = "CREATE SEQUENCE runways_id_seq START WITH 1 INCREMENT BY 1";
    public static final String ID_SEQ_DROP_QUERY = "DROP SEQUENCE runways_id_seq";
    private Integer id;
    private Airport airport;
    private Double lat;
    private Double lon;
    private Double magvar;
    private Integer elev;
    private Surface surface;
    private RunwayOperations operations;
    private Double length;
    private Double width;
    private Integer number;
    private RunwayDesignator designator;
    private RunwayDesignator secondaryDesignator;
    private Double heading;
    private List<Ils> ils;
    private String desc;

    public Runway() {
    }

    public Runway(RunwayXml r) {
        GpsPlace place;
        String[] coords;
        if (r.getPos() != null && (coords = r.getPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.lat = place.getLat().getValue();
            this.lon = place.getLon().getValue();
        }
        this.magvar = r.getMagvar();
        this.elev = r.getElev();
        this.surface = r.getSurface();
        this.operations = r.getOperations();
        this.length = r.getLength();
        this.width = r.getWidth();
        this.number = r.getNumber();
        this.designator = r.getDesignator();
        this.secondaryDesignator = r.getSecondaryDesignator();
        this.heading = r.getHeading();
        this.desc = r.getDesc();
        if (r.getIls() != null && r.getIls().size() > 0) {
            this.setIls(r.getIls());
        }
    }

    @Id
    @GenericGenerator(name="generator", strategy="sequence-identity", parameters={@Parameter(name="sequence", value="runways_id_seq")})
    @GeneratedValue(generator="generator")
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="AIRPORT_ID")
    public Airport getAirport() {
        return this.airport;
    }

    public void setAirport(Airport airport) {
        this.airport = airport;
    }

    @Column(name="LAT", nullable=true, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Column(name="LON", nullable=true, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Column(name="ELEV")
    public Integer getElev() {
        return this.elev;
    }

    public void setElev(Integer elev) {
        this.elev = elev;
    }

    @Column(name="SURFACE")
    @Enumerated(value=EnumType.STRING)
    public Surface getSurface() {
        return this.surface;
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
    }

    @Column(name="OPERATIONS")
    @Enumerated(value=EnumType.STRING)
    public RunwayOperations getOperations() {
        return this.operations;
    }

    public void setOperations(RunwayOperations operations) {
        this.operations = operations;
    }

    @Column(name="LENGTH", precision=10, scale=2)
    public Double getLength() {
        return this.length;
    }

    public void setLength(Double length) {
        this.length = length;
    }

    @Column(name="WIDTH", precision=10, scale=2)
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    @Column(name="NUMBER")
    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    @Column(name="DESIGNATOR")
    @Enumerated(value=EnumType.STRING)
    public RunwayDesignator getDesignator() {
        return this.designator;
    }

    public void setDesignator(RunwayDesignator designator) {
        this.designator = designator;
    }

    @Column(name="HEADING", precision=5, scale=2)
    public Double getHeading() {
        return this.heading;
    }

    @Transient
    public Double getSecondaryHeading() {
        Double hdg = null;
        if (this.heading != null && (hdg = Double.valueOf((this.heading - 180.0) % 360.0)) <= 0.0) {
            hdg = hdg + 360.0;
        }
        return hdg;
    }

    public void setHeading(Double heading) {
        this.heading = heading;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="runway")
    public List<Ils> getIls() {
        if (this.ils == null) {
            this.ils = new ArrayList<Ils>();
        }
        return this.ils;
    }

    public void setIls(List<Ils> ils) {
        this.ils = ils;
    }

    @Column(name="SECONDARY_DESIGNATOR")
    @Enumerated(value=EnumType.STRING)
    public RunwayDesignator getSecondaryDesignator() {
        return this.secondaryDesignator;
    }

    public void setSecondaryDesignator(RunwayDesignator secondaryDesignator) {
        this.secondaryDesignator = secondaryDesignator;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Runway [id=");
        builder.append(this.id);
        builder.append(", airport.id=");
        if (this.airport != null) {
            builder.append(this.airport.getId());
        }
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", elev=");
        builder.append(this.elev);
        builder.append(", surface=");
        builder.append((Object)this.surface);
        builder.append(", length=");
        builder.append(this.length);
        builder.append(", width=");
        builder.append(this.width);
        builder.append(", number=");
        builder.append(this.number);
        builder.append(", designator=");
        builder.append((Object)this.designator);
        builder.append(", secondaryDesignator=");
        builder.append((Object)this.secondaryDesignator);
        builder.append(", heading=");
        builder.append(this.heading);
        builder.append(", magvar=");
        builder.append(this.magvar);
        if (this.ils != null) {
            builder.append(", ils=");
            builder.append(this.ils);
        }
        builder.append("]");
        return builder.toString();
    }

    @Transient
    public String getPrimaryName() {
        String name = null;
        if (this.number != null) {
            name = String.valueOf(this.number);
            if (this.designator != null) {
                name = name + this.designator.toString();
            }
        }
        return name;
    }

    @Transient
    public String getSecondaryName() {
        String name = null;
        if (this.number != null) {
            int num = this.number - 18;
            if (num == 0) {
                num = 36;
            } else if (num < 0) {
                num += 36;
            }
            name = String.valueOf(num);
            if (this.secondaryDesignator != null) {
                name = name + this.secondaryDesignator.toString();
            }
        }
        return name;
    }

    @Transient
    public boolean hasIls() {
        return this.ils != null && this.ils.size() > 0;
    }

    @Column(name="DESC")
    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = StringUtil.shortenString(desc, 32);
    }

    @Column(name="MAGVAR", nullable=true, precision=5, scale=2)
    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }

    @Transient
    public GpsPlace getGpsPlace() {
        return new GpsPlace(this.lat, this.lon);
    }

    @Transient
    public Double getTrueHeading() {
        if (this.heading == null || this.magvar == null) {
            return null;
        }
        return GpsUtil.normalizeCourse(this.heading + this.magvar);
    }

    @Transient
    public Double getTrueSecondaryHeading() {
        if (this.heading == null || this.magvar == null) {
            return null;
        }
        return GpsUtil.normalizeCourse(this.getSecondaryHeading() + this.magvar);
    }

    @Transient
    public boolean hasSkewedIls() {
        if (this.heading == null || this.magvar == null || !this.hasIls()) {
            return false;
        }
        boolean singleIls = this.getIls().size() == 1;
        for (Ils ils : this.getIls()) {
            if (ils.getHeading() == null || !GpsUtil.hasSkewedRunway(this.getTrueHeading(), this.getTrueSecondaryHeading(), ils.getHeading(), singleIls)) continue;
            return true;
        }
        return false;
    }
}

