/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.xml.IfrRouteXml;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;

@Entity
@Table(name="ROUTES")
public class Route
implements Serializable {
    private static final long serialVersionUID = -7557549230301287971L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE routes ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(64), from_lat DECIMAL(18,15), from_lon DECIMAL(18,15), to_lat DECIMAL(18,15), to_lon DECIMAL(18,15), remark VARCHAR(512), PRIMARY KEY (id))";
    public static final String SELECT_QUERY = "SELECT id, waypoint_id, previous_id, next_id, name, type FROM routes ";
    public static final String DROP_QUERY = "DROP TABLE routes ";
    private Integer id;
    private String name;
    private String previousIdent;
    private String previousRegion;
    private String nextIdent;
    private String nextRegion;
    private String remark;
    private Double fromLat;
    private Double fromLon;
    private Double toLat;
    private Double toLon;

    public Route() {
    }

    public Route(IfrRouteXml v) {
        GpsPlace place;
        String[] coords;
        this.name = v.getName();
        if (v.getFrom() != null && (coords = v.getFrom().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.fromLat = place.getLat().getValue();
            this.fromLon = place.getLon().getValue();
        }
        if (v.getTo() != null && (coords = v.getTo().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.toLat = place.getLat().getValue();
            this.toLon = place.getLon().getValue();
        }
        this.remark = v.getRemark();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="NAME", length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 64);
    }

    @Column(name="FROM_LAT", nullable=false, precision=18, scale=15)
    public Double getFromLat() {
        return this.fromLat;
    }

    public void setFromLat(Double fromLat) {
        this.fromLat = fromLat;
    }

    @Column(name="FROM_LON", nullable=false, precision=18, scale=15)
    public Double getFromLon() {
        return this.fromLon;
    }

    public void setFromLon(Double fromLon) {
        this.fromLon = fromLon;
    }

    @Column(name="TO_LAT", nullable=false, precision=18, scale=15)
    public Double getToLat() {
        return this.toLat;
    }

    public void setToLat(Double toLat) {
        this.toLat = toLat;
    }

    @Column(name="TO_LON", nullable=false, precision=18, scale=15)
    public Double getToLon() {
        return this.toLon;
    }

    public void setToLon(Double toLon) {
        this.toLon = toLon;
    }

    @Transient
    public String getPreviousIdent() {
        return this.previousIdent;
    }

    public void setPreviousIdent(String previousIdent) {
        this.previousIdent = previousIdent;
    }

    @Transient
    public String getPreviousRegion() {
        return this.previousRegion;
    }

    public void setPreviousRegion(String previousRegion) {
        this.previousRegion = previousRegion;
    }

    @Transient
    public String getNextIdent() {
        return this.nextIdent;
    }

    public void setNextIdent(String nextIdent) {
        this.nextIdent = nextIdent;
    }

    @Transient
    public String getNextRegion() {
        return this.nextRegion;
    }

    public void setNextRegion(String nextRegion) {
        this.nextRegion = nextRegion;
    }

    @Transient
    public GpsPlace getGpsPlace() {
        if (this.fromLat != null && this.fromLon != null) {
            return new GpsPlace(this.fromLat, this.fromLon);
        }
        return null;
    }

    @Transient
    public GpsArea getRectangleOver() {
        return new GpsArea(new GpsPlace(this.fromLat, this.fromLon), new GpsPlace(this.toLat, this.toLon));
    }

    @Column(name="REMARK", length=512)
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = StringUtil.shortenString(remark, 512);
    }

    @Transient
    public LineSegment getSegment() {
        return new LineSegment(new GpsPlace(this.fromLat, this.fromLon), new GpsPlace(this.toLat, this.toLon));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Route [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", previousIdent=");
        builder.append(this.previousIdent);
        builder.append(", previousRegion=");
        builder.append(this.previousRegion);
        builder.append(", nextIdent=");
        builder.append(this.nextIdent);
        builder.append(", nextRegion=");
        builder.append(this.nextRegion);
        builder.append(", fromLat=");
        builder.append(this.fromLat);
        builder.append(", fromLon=");
        builder.append(this.fromLon);
        builder.append(", toLat=");
        builder.append(this.toLat);
        builder.append(", toLon=");
        builder.append(this.toLon);
        builder.append("]");
        return builder.toString();
    }
}

