/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.LatLonObject;
import main.java.guru.vfrflight.core.sql.entity.xml.ObstacleXml;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;

@Entity
@Table(name="OBSTACLES")
public class Obstacle
implements Serializable,
LatLonObject {
    private static final long serialVersionUID = -1351693796628671206L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE obstacles ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(64), desc VARCHAR(128), lat DECIMAL(18,15), lon DECIMAL(18,15), agl INTEGER, amsl INTEGER, grp BOOLEAN, lgt BOOLEAN, PRIMARY KEY (id))";
    public static final String DROP_QUERY = "DROP TABLE obstacles ";
    private Integer id;
    private String name;
    private String desc;
    private Double lat;
    private Double lon;
    private Boolean grp;
    private Boolean lgt;
    private Integer agl;
    private Integer amsl;

    public Obstacle() {
    }

    public Obstacle(ObstacleXml o) {
        GpsPlace place;
        String[] coords;
        this.name = o.getName();
        this.desc = o.getDesc();
        this.grp = o.getGroup();
        this.lgt = o.getIlluminated();
        this.agl = o.getHeightInFt();
        this.amsl = o.getAmslInFt();
        if (o.getPos() != null && (coords = o.getPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.lat = place.getLat().getValue();
            this.lon = place.getLon().getValue();
        }
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="NAME", length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 64);
    }

    @Column(name="DESC", length=128)
    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = StringUtil.shortenString(desc, 128);
    }

    @Override
    @Column(name="LAT", nullable=false, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Override
    @Column(name="LON", nullable=false, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Column(name="AGL")
    public Integer getAgl() {
        return this.agl;
    }

    public void setAgl(Integer agl) {
        this.agl = agl;
    }

    @Column(name="AMSL")
    public Integer getAmsl() {
        return this.amsl;
    }

    public void setAmsl(Integer amsl) {
        this.amsl = amsl;
    }

    @Column(name="LGT", nullable=true)
    public Boolean getLgt() {
        return this.lgt;
    }

    public void setLgt(Boolean lgt) {
        this.lgt = lgt;
    }

    @Transient
    public boolean isLgt() {
        if (this.lgt == null) {
            return false;
        }
        return this.lgt;
    }

    @Column(name="GRP", nullable=true)
    public Boolean getGrp() {
        return this.grp;
    }

    public void setGrp(Boolean grp) {
        this.grp = grp;
    }

    @Transient
    public boolean isGrp() {
        if (this.grp == null) {
            return false;
        }
        return this.grp;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Obstacle [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", desc=");
        builder.append(this.desc);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", grp=");
        builder.append(this.grp);
        builder.append(", lgt=");
        builder.append(this.lgt);
        builder.append(", agl=");
        builder.append(this.agl);
        builder.append(", amsl=");
        builder.append(this.amsl);
        builder.append("]");
        return builder.toString();
    }
}

